
	;  file = save2new.asm
	;  part of The Hyper-Space Library (r)

	;  written by Terrance Hodgins, March, 1990

		page	60,132
		title	save2new

	;  copyright (C) 1990 by Terrance E. Hodgins,
	;  dba Semi-Intelligent Systems (r).  All rights reserved.
	;
	;  Semi-Intelligent Systems, and The Hyper-Space Library,
	;  are registered trademarks of Semi-Intelligent Systems.


	;  Disclaimer of Warranty
	;
	;  TERRANCE E. HODGINS, AND SEMI-INTELLIGENT
	;  SYSTEMS, EXCLUDE ANY AND ALL IMPLIED WARRANTIES,
	;  INCLUDING WARRANTIES OF MERCHANTABILITY AND
	;  FITNESS FOR A PARTICULAR PURPOSE.
	;
	;  NEITHER TERRANCE E. HODGINS, NOR SEMI-INTELLIGENT
	;  SYSTEMS, MAKE ANY WARRANTY OF REPRESENTATION,
	;  EITHER EXPRESS OR IMPLIED, WITH RESPECT TO THIS
	;  PROGRAM, ITS QUALITY, PERFORMANCE,
	;  MERCHANTABILITY, OR FITNESS FOR A PARTICULAR
	;  PURPOSE.
	;
	;  NEITHER TERRANCE E. HODGINS, NOR SEMI-INTELLIGENT
	;  SYSTEMS, SHALL HAVE ANY LIABILITY FOR SPECIAL,
	;  INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
	;  OF OR RESULTING FROM THE USE OR MODIFICATION OF
	;  THIS PROGRAM.
	;
	;  THE USE OF THE 80286 LOADALL INSTRUCTION IS
	;  INHERENTLY DANGEROUS, AND CAN RESULT IN PROGRAM
	;  CRASHES, OR RUN-AWAY PROGRAMS, WHICH CAN ALTER,
	;  DAMAGE, OR DESTROY COMPUTER DATA, AND WHICH CAN
	;  DAMAGE OR DESTROY COMPUTER HARDWARE.
	;  USE ONLY AT YOUR OWN RISK.


		.model	small,c
		.286p

		; subroutines:
		public	save2new


		; variables:
		public	new_Reg_Buf

		public	newMSW, newDead, newTR, newFlagWord

		public	newIP, newLDT, newDS, newSS, newCS, newES

		public	newDI, newSI, newBP, newSP

		public	newBX, newDX, newCX, newAX

		public	newESDC, newCSDC, newSSDC, newDSDC

		public	newGDTR, newLDTDC, newIDTR, newTSSDC

		extrn	flip3:near
		extrn	wseg2abs:near


		.code

;	------------------------------------------------------


	; save the original state of the machine,
	; in a new table, for a base-line setup, to then
	; change before a loadall.

save2new	proc	near
		pusha
		push	es
		push	ds

		mov	newAX,ax
		mov	newCX,cx
		mov	newDX,dx
		mov	newBX,bx

		mov	newBP,bp

		; SP must be done later, when stack is emptier

		mov	newSI,si
		mov	newDI,di

		mov	newES,es
		mov	newCS,cs
		mov	newSS,ss
		mov	newDS,ds

		; now convert the segment values to 24-bit absolute
		; addresses, and put them in the descriptor caches.
		mov	ax,es
		mov	di,offset newESDC
		call	wseg2abs

		mov	ax,cs
		mov	di,offset newCSDC
		call	wseg2abs

		mov	ax,ss
		mov	di,offset newSSDC
		call	wseg2abs

		mov	ax,ds
		mov	di,offset newDSDC
		call	wseg2abs

		; save flags.  We want to save a flags word with the
		; interrupts turned off, because this is the state
		; that the machine will be in immediately after the
		; loadall, and we don't want an interrupt horning in then.
		cli
		cld
		nop
		nop
		pushf
		pop	newFlagWord
		sti

		; save machine status word.  In real mode, this is usually 0.
		smsw	ax
		and	ax,0Fh		; only the lowest 4 bits are used
		mov	newMSW,ax

		; save current data in the Global Descriptor Table Register
		sgdt	qword ptr gdtr_n
		mov	si,offset gdtr_n	; ptr to temp buffer
		mov	di,offset newGDTR	; ptr to dest for fixed data
		call	flip3			; flip around word order

		; save current data in the Interrupt Descriptor Table Register
		sidt	qword ptr idtr_n
		mov	si,offset idtr_n	; ptr to temp buffer
		mov	di,offset newIDTR	; ptr to dest for fixed data
		call	flip3			; flip around word order

		pop	ds
		pop	es
		popa
		mov	newSP,sp	; save sp with 1 return addr on stack
		ret
save2new	endp


;	-----------------------------------------------------
;	-----------------------------------------------------


		.data


;	LOADALL Register Load Table for saving and restoring the
;	original machine state.

new_Reg_Buf	dw	3 dup (0)	; unused
newMSW		dw	0
newDead		dw	7 dup (0)	; unused
newTR		dw	0
newFlagWord	dw	0
newIP		dw	0
newLDT		dw	0

newDS		dw	0
newSS		dw	0
newCS		dw	0
newES		dw	0

newDI		dw	0
newSI		dw	0
newBP		dw	0
newSP		dw	0

newBX		dw	0
newDX		dw	0
newCX		dw	0
newAX		dw	0

newESDC		dw	0,	9200h,	0FFFFh
newCSDC		dw	0,	9200h,	0FFFFh
newSSDC		dw	0,	9200h,	0FFFFh
newDSDC		dw	0,	9200h,	0FFFFh

newGDTR		dw	0,	0,	0
newLDTDC	dw	0000h,	0FF0Eh,	88h
newIDTR		dw	0,	0,	0
newTSSDC	dw	0100h,	0FF0Eh,	800h


; temporary buffers for the data from the sgdt and sidt instructions.
gdtr_n		dq	0
idtr_n		dq	0


		end

