; CPU identification code for Intel platforms
; By Dave Navarro, Jr.  (dave@powerbasic.com or 73002.3506@compuserve.com)
; donated to the Public Domain
;
; I have cannibalized a lot of public domain source code to get all CPU
; types in here.  I have been told that it does not work in a DOS box
; under Windows, but I haven't tested this myself.  It does work fine in
; an OS/2 VDM.
;
; Returns in AX:
;            20 for NEC V20
;            30 for NEC V30
;            86 for 8086
;            88 for 8088
;            186 for 80186 or 80188
;            286 for 80286
;            386 for 80386
;            486 for 80486
;            586 for Pentium

Code    Segment Byte
        Assume  CS: Code

Count   =       7
OpIncDX equ     42H                     ; inc DX opcode
OpNop   equ     90H                     ; nop opcode

        Public  CpuID

CpuID Proc   Far
        push    DS                      ;
        push    CS                      ;
        pop     DS                      ;
        pushf                           ; save flags

        xor     AX, AX                  ; clear AX
        push    AX                      ; push it on stack
        popf                            ; put it in the flags register
        pushf                           ; push them back
        pop     AX                      ; get value back from flags
        and     AX, 8000h               ; chips below 286 wont clear hi bits
        cmp     AX, 8000h               ; All bits set?
        jne     Test286                 ; no, check for 286
        jmp     Test_808x               ; yes, so check for NEC, 808x, 8018x
Test286:
        mov     AX, 7000h               ; else see if set other flag bits
        push    AX                      ; to distinguish 286 from 386/486 chip
        popf                            ;
        pushf                           ;
        pop     AX                      ;
        and     AX, 7000h               ; bits 12-14 can't be set on 286
        jz      Found_286               ; if zero, then it's a 286
Found_386:
.386                                    ; use 386 mnemonics
        mov     EBX, ESP                ; Zero lower 2 bits of ESP
        and     ESP, 0FFFFFFFCh         ; to avoid AC fault on 486
        pushfd                          ; push EFLAGS register
        pop     EAX                     ; EAX = EFLAGS
        mov     ECX, EAX                ; ECX = EFLAGS
        xor     EAX, 40000h             ; Toggle AC bit (bit 18) in EFLAGS
        push    EAX                     ; push new value
        popfd                           ; put it in EFLAGS
        pushfd                          ; push EFLAGS
        pop     EAX                     ; EAX = EFLAGS
        and     EAX, 40000h             ; Isolate bit 18 in EAX
        and     ECX, 40000h             ; Isolate bit 18 in ECX
        cmp     EAX, ECX                ; Are they the same?
        mov     AX, 386                 ; assume we have a 386
        je      not486                  ; Yes, it's a 386
        push    ECX                     ; restore EFLAGS
        popfd                           ;  to the original
        mov     ESP, EBX                ; restore ESP

        pushfd                          ; push EFLAGS
        pop     EAX                     ; pop EAX
        mov     EBX, EAX                ; copy EFLAGS to EBX
        xor     EAX, 200000h            ; toggle bit 21
        push    EAX                     ; push EAX
        popfd                           ; pop EFLAGS
        pushfd                          ; push EFLAGS
        pop     EAX                     ; pop EAX
        push    EBX                     ; restore the original
        popfd                           ;  EFLAGS value
        and     EAX, 200000h            ; isolate bit 21
        and     EBX, 200000h            ; isolate bit 21
        cmp     EAX, EBX                ; do they equal?
        mov     AX, 486                 ; assume they do
        je      Exit                    ; yes, it's a 486
        mov     AX, 586                 ; no, it's a pentium
        jmp     Short Exit              ;
not486:
        push    ECX                     ;
        popfd                           ;
        mov     ESP, EBX                ;
.8086                                   ; back to 8086 mnemonics
        jmp     short Exit              ; exit
Found_286:
        mov     AX, 286                 ; we have a 286
        jmp     short Exit              ;
Test_808x:
        mov     AX, 0FFFFh              ; can we shift left more than 32 times
        mov     CL, 21h                 ; 8018x chips wont allow this
        shl     AX, CL                  ; but 808x chips will shift AX to 0
        jnz     Found_186               ;
Test_86:
        call    PreFetchQueue           ; find length of PFQ
                                        ; result returned in DX
        sti                             ; interrupts must be allowed
        xor     SI, SI                  ; clear offset address
        mov     CX, -1                  ; load 64k in CX for size of loop
        rep     lods Byte Ptr ES: [SI]  ; only  NEC can rep w/ segment override
        jcxz    short Test_NEC          ; if CX got to 0 then we have a NEC
        mov     BX, 86                  ; assume an 8086
        cmp     DX, 4                   ; was PIQ = 4, then have an 8088
        ja      Found_8086              ; if more than 4 have 8086
        mov     BX, 88                  ; else we have 8088
Found_8086:
        mov     AX, BX                  ; get value back from BX
        jmp     short Exit              ;
Test_NEC:
        mov     BX, 30                  ; assume a V30
        cmp     DX, 4                   ; if PIQ = 4, then have a V20
        ja      Found_NEC30             ; if more than 4, then have a V30
        mov     BX, 20                  ; else we have a V20
Found_NEC30:
        mov     AX, BX                  ; get value back from BX
        jmp     Short Exit              ;
Found_186:
        mov     AX, 186                 ; we have an 80186 (Tandy 2000)
Exit:
        popf                            ; restore flags
        pop     DS                      ;
        retf                            ;
CpuID EndP


;PreFetchQueue
; On exit:  DX = length of prefetch instruction queue

PreFetchQueue Proc Near
        mov     AL, OpIncDX             ;
        mov     CX, Count               ;
        push    CX                      ;
        push    CS                      ;
        pop     ES                      ;
        mov     DI, offset PreFetchQueue_01 - 1 ;
        push    DI                      ;
        std                             ;
        rep     stosb                   ;
        mov     AL, OpNop               ;
        pop     DI                      ;
        pop     CX                      ;
        xor     DX, DX                  ;
        cli                             ;
        rep     stosb                   ;
        rept    Count                   ;
        inc     DX                      ;
        endm                            ;
PreFetchQueue_01:
        sti                             ;
        cld                             ;
        ret
PreFetchQueue EndP
Code    EndS
        End