	 PAGE	 64,132 	       ;PAGE WIDTH,LENGTH
	 .SALL
	 TITLE	 PC/AT DIAGNOSTIC - MESSAGE PRINT ROUTINE
; **********************************************************************
; *								       *
; *	MODULE NAME    HDMSG					       *
; *	AUTHOR	       JIM BRACKING				       *
; *								       *
; *	DECSRIPTION    THIS PROGRAM PERFORMS THE FOLLOWING	       *
; *		       FUNCTIONS:				       *
; *								       *
; *		       1. DECODE THE ERROR MESSAGE AND DISPLAY IT      *
; *			  IF PRINT=ON THEN PRINT THE MESSAGE	       *
; *								       *
; **********************************************************************
;
; **********************************************************************
; *			EXTERNAL PROGRAM REFERENCES		       *
; **********************************************************************
	 EXTRN	 SCRMGR:NEAR
; **********************************************************************
; *			  EXTERNAL DATA REFERENCES		       *
; **********************************************************************
	 INCLUDE HDDATA.ASM
; **********************************************************************
; *			EXTERNAL SUBROUTINE REFERENCES		       *
; **********************************************************************
	 EXTRN	 SCRMGR:NEAR,CONV_ASCII:NEAR
; **********************************************************************
; *			    PUBLIC DECLARES			       *
; **********************************************************************
	 PUBLIC  HDMSG
	 PUBLIC  D_ERROR
	 PUBLIC  PRT_MSG,LOGERR
; **********************************************************************
; *				 MACROS 			       *
; **********************************************************************
;
	 IF1
	 INCLUDE HD.MAC
	 INCLUDE \SCRMGR\SCRNWORK.MAC
	 ENDIF
; **********************************************************************
; *								       *
; *			       BEGIN				       *
; *								       *
; **********************************************************************
CSEG	 SEGMENT PARA PUBLIC 'CODE'
	 ASSUME CS:CSEG
HDMSG  PROC    NEAR
	 ASSUME  DS:CSEG	       ;DATA SEGMENT
	 JMP	 BY_ID		       ;JMP AROUND ID
	 ID	 HDMSG
	 INCLUDE \SCRMGR\SCRNWORK.ASM
;
PWORK	 DB	 80 DUP(' ')           ;PRINT AREA
; **********************************************************************
; *			     ERROR MESSAGES			       *
; **********************************************************************
ERR_MSGS LABEL	 BYTE
	 DB	 'UNKOWN ERROR             '     ;ERROR CODE 00
	 DB	 'COMMAND ABORTED BY CTLR  '     ;ERROR CODE 01
	 DB	 'ADDRESS MARK NOT FOUND   '     ;ERROR CODE 02
	 DB	 'ID NOT FOUND             '     ;ERROR CODE 03
	 DB	 'RESET FAILED             '     ;ERROR CODE 04
	 DB	 'DRIVE INITIALIZATION ERR '     ;ERROR CODE 05
	 DB	 'TRANSFER OVER 64K BOUNDRY'     ;ERROR CODE 06
	 DB	 'BAD SECTOR FLAG DETECTED '     ;ERROR CODE 07
	 DB	 'UNCORRECTABLE DATA ERROR '     ;ERROR CODE 08
	 DB	 'CORRECTABLE DATA ERROR   '     ;ERROR CODE 09
	 DB	 'CONTROLLER ERROR         '     ;ERROR CODE 10
	 DB	 'SEEK ERROR               '     ;ERROR CODE 11
	 DB	 'DRIVE TIMED OUT          '     ;ERROR CODE 12
	 DB	 'DRIVE NOT READY          '     ;ERROR CODE 13
	 DB	 'UNDEFINED ERROR          '     ;ERROR CODE 14
	 DB	 'UNKOWN ERROR             '     ;ERROR CODE 15
	 DB	 'WRITE FAULT              '     ;ERROR CODE 16
	 DB	 'SENSE ERROR              '     ;ERROR CODE 17
	 DB	 'SECTOR BUFFER ERROR      '     ;ERROR CODE 18
	 DB	 'ECC DEVICE ERROR         '     ;ERROR CODE 19
	 DB	 'CONTROL PROCESS ERROR    '     ;ERROR CODE 20
	 DB	 'DRIVE NOT CONFIGURED     '     ;ERROR CODE 21
	 DB	 'INVALID DRIVE SPECIFIED  '     ;ERROR CODE 22
	 DB	 'INVALID INTERLEAVE       '     ;ERROR CODE 23
	 DB	 'FORMAT FAILED            '     ;ERROR CODE 24
	 DB	 'FORMAT COMPLETE          '     ;ERROR CODE 25
	 DB	 'SURFACE ANALYSIS FAILED  '     ;ERROR CODE 26
	 DB	 'SURFACE ANALYSIS COMPLETE'     ;ERROR CODE 27
	 DB	 'SECTOR HAS BEEN FLAGGED  '     ;ERROR CODE 28
	 DB	 'HEAD SELECT PASSED       '     ;ERROR CODE 29
	 DB	 'HEAD SELECT FAILED       '     ;ERROR CODE 30
	 DB	 'READ/WRITE PASSED        '     ;ERROR CODE 31
	 DB	 'READ/WRITE FAILED        '     ;ERROR CODE 32
	 DB	 'SEEK TEST PASSED         '     ;ERROR CODE 33
	 DB	 'SEEK TEST FAILED         '     ;ERROR CODE 34
	 DB	 'ECC TEST PASSED          '     ;ERROR CODE 35
	 DB	 'ECC TEST FAILED          '     ;ERROR CODE 36
	 DB	 'DISK READY FOR RELOCATION'     ;ERROR CODE 37
	 DB	 '** RELOCATION FAILED **  '     ;ERROR CODE 38
	 DB	 'CYLINDER OUT OF RANGE    '     ;ERROR CODE 39
	 DB	 'HEAD OUT OF RANGE        '     ;ERROR CODE 40
	 DB	 'SECTOR OUT OF RANGE      '     ;ERROR CODE 41
	 DB	 'DEFECT SCAN FAILED       '     ;ERROR CODE 42
	 DB	 'DEFECT SCAN COMPLETE     '     ;ERROR CODE 43
	 DB	 'SHUT THE SYSTEM POWER OFF'     ;ERROR CODE 44
; **********************************************************************
; *			 EQUATES AND STRUCTURES 		       *
; **********************************************************************
	 INCLUDE HDEQU.ASM
; **********************************************************************
; *				 SCREENS			       *
; **********************************************************************
;
  SFIELD E01,E01,25,@LABEL,LO,16,02
;
  SFIELD E03,E04,,@LABEL,LO,16,02,'  CYL XXXX HEAD XX SECTOR XX - '
  SFIELD E04,E05,25,@LABEL,LO,16,33
  SFIELD E05,E06,04,@LABEL,LO,16,08
  SFIELD E06,E07,02,@LABEL,LO,16,18
  SFIELD E07,E03,02,@LABEL,LO,16,28
;
BY_ID:
HDMSG  ENDP
; *********************************************************************
; *								      *
; *			LOG THE ERROR TO HARDCOPY		      *
; *								      *
; *********************************************************************
LOGERR	 PROC
	 PUSHALL
	 CMP	 P_STAT,0FFH	       ;PRINT ON??
	 JNE	 LOG_00 	       ;YES
	 JMP	 LOG_EXIT	       ;EXIT
LOG_00:
	 LEA	 DI,PWORK	       ;OUTPUT
	 PUSH	 DS		       ;ESTABLISH
	 POP	 ES		       ;  SEGMENT
	 MOV	 CX,80		       ;LENGTH
	 CLD			       ;FORWARD DIRECTION
	 MOV	 AL,' '                ;PAD CHARACTER
	 REP	 STOSB		       ;CLEAR PWORK
	 MOV	 DX,BX		       ;SAVE FIRST ENTRY
LOG_10:
	 LEA	 SI,[BX].S_DATA        ;INPUT
	 LEA	 DI,PWORK	       ;OUTPUT
	 XOR	 CX,CX		       ;CLEAR CX
	 MOV	 CL,[BX].S_COL	       ;FETCH COLUMN
	 ADD	 DI,CX		       ;  OFFSET
	 MOV	 CL,[BX].S_LEN	       ;FETCH LENGTH
	 REP	 MOVSB		       ;MOVE IT
	 MOV	 BX,[BX].S_NEXT        ;NEXT ENTRY
	 CMP	 BX,DX		       ;ALL DONE??
	 JNE	 LOG_10 	       ;NO - PROCESS THIS ONE
	 MOV	 CX,80		       ;LENGTH
	 LEA	 SI,PWORK	       ;INPUT
LOG_20:
	 LODSB			       ;FETCH A BYTE
	 MOV	 DL,AL		       ;OUTPUT
	 MOV	 AH,05H 	       ;PRINT
	 INT	 21H		       ; THE BYTEG
	 LOOP	 LOG_20 	       ;NEXT BYTE
	 MOV	 DL,0DH 	       ;PRINT
	 MOV	 AH,05H 	       ;  ANT
	 INT	 21H		       ;  CARRIAGE
	 MOV	 DL,0AH 	       ;  RETURN
	 MOV	 AH,05H 	       ;  AND
	 INT	 21H		       ;  LINE FEED
LOG_EXIT:
	 POPALL
	 RET			       ;RETURN
LOGERR	 ENDP
; *********************************************************************
; *								      *
; *			  DISPLAY ERROR MSG			      *
; *			   AL = ERROR CODE			      *
; *								      *
; *********************************************************************
D_ERROR  PROC
	 PUSHALL
	 SCROLL  LO,4,2,16,78	       ;SCROLL
	 XOR	 AH,AH		       ;CLEAR AH
	 LEA	 SI,ERR_MSGS	       ;ERROR MSGS
	 XOR	 DX,DX		       ;CLEAR DX
	 MOV	 CX,25		       ;ENTRY SIZE
	 MUL	 CX		       ;INDEX
	 ADD	 SI,AX		       ;  INTO TABLE
	 LEA	 BX,E04 	       ;OUTPUT
	 LEA	 DI,[BX].S_DATA        ;  MESSAGE
	 PUSH	 DS		       ;ESTABLISH
	 POP	 ES		       ;  SEGMENT
	 CLD			       ;FORWARD DIRECTION
	 REP	 MOVSB		       ;MOVE ERROR MESSAGE
	 MOV	 AX,CUR_CYL	       ;FORMAT
	 LEA	 BX,E05 	       ;  CYLINDER
	 CALL	 CONV_ASCII
	 XOR	 AX,AX		       ;CLEAR AX
	 MOV	 AL,CUR_HD	       ;FORMAT
	 LEA	 BX,E06 	       ;  HEAD
	 CALL	 CONV_ASCII
	 MOV	 AL,CUR_SEC	       ;FORMAT
	 LEA	 BX,E07 	       ;  SECTOR
	 CALL	 CONV_ASCII
	 WRITE	 E03		       ;DISPLAY THE MESSAGE
	 CALL	 LOGERR 	       ;PRINT THE MESSAGE
	 POPALL
	 RET			       ;AND RETURN
D_ERROR  ENDP
; *********************************************************************
; *								      *
; *			   DISPLAY MESSAGE			      *
; *			    AL = MSG CODE			      *
; *								      *
; *********************************************************************
PRT_MSG  PROC
	 PUSHALL
	 SCROLL  LO,4,2,16,78	       ;SCROLL
	 LEA	 BX,E01 	       ;OUTPUT
	 MOV	 [BX].S_ATTR,AH        ;SET ATTRIBUTE BYTE
	 XOR	 AH,AH		       ;CLEAR AH
	 LEA	 SI,ERR_MSGS	       ;ERROR MSGS
	 XOR	 DX,DX		       ;CLEAR DX
	 MOV	 CX,25		       ;ENTRY SIZE
	 MUL	 CX		       ;INDEX
	 ADD	 SI,AX		       ;  INTO TABLE
	 LEA	 BX,E01 	       ;OUTPUT
	 LEA	 DI,[BX].S_DATA        ;  MESSAGE
	 PUSH	 DS		       ;ESTABLISH
	 POP	 ES		       ;  SEGMENT
	 CLD			       ;FORWARD DIRECTION
	 REP	 MOVSB		       ;MOVE ERROR MESSAGE
	 WRITE	 E01		       ;DISPLAY THE MESSAGE
	 CALL	 LOGERR 	       ;PRINT THE MESSAGE
	 POPALL
	 RET			       ;AND RETURN
PRT_MSG  ENDP
CSEG	 ENDS
	 END	 HDMSG
