	 PAGE	 64,132 	       ;PAGE WIDTH,LENGTH
	 .SALL
	 TITLE	 PC/AT DISK DIAGNOSTIC PROGRAM
; **********************************************************************
; *								       *
; *	DECSRIPTION    A MENU DRIVEN HARD DISK DIAGNOSTIC PROGRAM      *
; *		       FOR HARD DISKS ON A IBM PC/AT.		       *
; *								       *
; *	INPUTS	       MENU INPUT				       *
; *								       *
; *								       *
; *	OUTPUTS        CAN DESTROY DATA ON THE HARD DISK	       *
; *								       *
; *								       *
; **********************************************************************
;
	 PUBLIC  HDMAIN
;
; **********************************************************************
; *		     PROGRAMS OR ROUTINES TO BE CALLED		       *
; **********************************************************************
	 EXTRN	 SCRMGR:NEAR	       ;SCREEN MANAGER
	 EXTRN	 HDRW:NEAR	       ;WRITE/READ/VERIFY TEST
	 EXTRN	 HDSEEK:NEAR	       ;SEEK TEST
	 EXTRN	 HDHS:NEAR	       ;HEAD SELECT TEST
	 EXTRN	 HDECC:NEAR	       ;ECC TEST
	 EXTRN	 HDALL:NEAR	       ;RUN ALL TESTS
	 EXTRN	 HDSURF:NEAR	       ;SURFACE ANALYSIS
	 EXTRN	 HDTFMT:NEAR	       ;FORMAT TRACK
	 EXTRN	 HDFMT:NEAR	       ;FORMAT DRIVE
	 EXTRN	 HDMSG:NEAR	       ;MSG DISPLAY AND PRINT
	 EXTRN	 PRT_MSG:NEAR
	 EXTRN	 D_ERROR:NEAR
	 EXTRN	 HDSHIP:NEAR	       ;LAND THE HEADS
	 EXTRN	 HDFSEC:NEAR	       ;FLAG A SECTOR
	 EXTRN	 HDSCAN:NEAR	       ;QUICK DEFECT SCAN
; **********************************************************************
; *			   PUBLIC SUBROUTINES			       *
; **********************************************************************
	 PUBLIC  CONV_ASCII,BOX_IT,BEEP,TRANS_KEY,READ_PARMS
	 PUBLIC  EXEC_CMD,DECODE_ERR,NEXT_SEC,NEXT_TRK
	 PUBLIC  NEXT_CYL,CTLR_DIAG,HIDE_CUR,WRITE_CMSG
;
	 IF1
	 INCLUDE HD.MAC
	 INCLUDE \SCRMGR\SCRNWORK.MAC
	 ENDIF
; **********************************************************************
; *								       *
; *			       BEGIN				       *
; *								       *
; **********************************************************************
CSEG	 SEGMENT PARA PUBLIC 'CODE'
	 ORG	 100H
	 ASSUME  CS:CSEG
HDMAIN PROC    NEAR
	 PUSH	 CS		       ;ESTABLISH
	 POP	 DS		       ;  DATA
	 ASSUME  DS:CSEG	       ;    SEGMENT
	 LEA	 AX,STACK_SSE	       ;END OF THE STACK AREA
	 MOV	 BX,CS		       ;INITIALIZE
	 MOV	 SS,BX		       ;  STACK
	 MOV	 SP,AX		       ;    SEGMENT
	 JMP	 BY_INFO	       ;JMP AROUND COPYRIGHT
	 ID	 HDMAIN
; **********************************************************************
; *			     STACK WORK AREA			       *
; **********************************************************************
STACK_SS DB	 512 DUP(0)	       ;STACK AREA
STACK_SSE EQU	 $		       ;END OF THE STACK AREA
; **********************************************************************
; *			 EXTENDED KEY TABLE			       *
; **********************************************************************
EX_KEY	 LABEL	 BYTE
	 DB	 132 DUP(0FFH)
	 ORG	 $-132
	 ORG	 EX_KEY+13
	 DB	 00		       ;ENTER  KEY
	 ORG	 EX_KEY+27
	 DB	 41		       ;ESCAPE KEY
	 ORG	 EX_KEY+59
	 DB	 01,02,03,04,05        ;FUNCTION KEYS 1 TO 5
	 DB	 06,07,08,09,10        ;FUNCTION KEYS 6 TO 10
	 ORG	 EX_KEY+73
	 DB	 43		       ;PAGE UP
	 ORG	 EX_KEY+79
	 DB	 42		       ;END
	 ORG	 EX_KEY+81
	 DB	 44		       ;PAGE DOWN
	 ORG	 EX_KEY+84
	 DB	 11,12,13,14,15        ;FUNCTION KEYS 11 TO 15	 SHIFT
	 DB	 16,17,18,19,20        ;FUNCTION KEYS 16 TO 20	 SHIFT
	 ORG	 EX_KEY+94
	 DB	 21,22,23,24,25        ;FUNCTION KEYS 21 TO 25	 CTRL
	 DB	 26,27,28,29,30        ;FUNCTION KEYS 26 TO 30	 CTRL
	 ORG	 EX_KEY+104
	 DB	 31,32,33,34,35        ;FUNCTION KEYS 31 TO 35	 ALT
	 DB	 36,37,38,39,40        ;FUNCTION KEYS 36 TO 40	 ALT
	 DB	 0FEH		       ;CONTROL BREAK
	 ORG	 EX_KEY+132
; **********************************************************************
; *			     PUBLIC FIELDS			       *
; **********************************************************************
	 PUBLIC  MAX_HD,MAX_CYL,MAX_SEC,CUR_HD,CUR_CYL,CUR_SEC
	 PUBLIC  DR,NUM_DR,ERR_CNT,FMT_BUFF,BROW,BCOL,BHEIGHT
	 PUBLIC  BWIDTH,BATTR,BCHAR,INL_TBL,HD_CMD,NUM_SEC,ERR_CODE
	 PUBLIC  DIAG_BUF,DATA_BUF,P_STAT,ALL_SW,BAD_SEC,FUNC
	 PUBLIC  RW_X,HS_X,SEEK_X,ECC_X,PCT
; **********************************************************************
; *			     WORKAREAS				       *
; **********************************************************************
W16	 DW	 16
B16	 DB	 16
B10	 DB	 10
MAX_HD	 DB	 0		       ;MAX HEADS
MAX_CYL  DW	 0		       ;MAX CYLINDERS
MAX_SEC  DB	 17		       ;MAX SECTORS
CUR_HD	 DB	 0		       ;CURRENT HEAD
CUR_CYL  DW	 0		       ;CURRENT CYLINDER
CUR_SEC  DB	 0		       ;CURRENT SECTOR
B_CYL	 DW	 0		       ;LAST BAD SECTOR CYL
B_HD	 DB	 0		       ;LAST BAD SECTOR HEAD
NUM_SEC  DB	 0		       ;NUMBER OF SECTORS
HD_CMD	 DB	 0		       ;HARD DISK COMMAND
DR	 DB	 0		       ;DRIVE NUMBER
ERR_CODE DB	 0		       ;SAVED ERROR CODE
FUNC	 DB	 0		       ;FUNC CODE
NUM_DR	 DB	 0		       ;NUMBER OF INSTALLED DRIVES
SNUM_DR  DB	 0		       ;SAVED NUMBER OF INSTALLED DRIVES
ERR_CNT  DW	 0		       ;ERROR COUNT
RW_X	 DB	 0		       ;READ/WRITE/VERIFY FLAG
HS_X	 DB	 0		       ;HEAD SELECT FLAG
SEEK_X	 DB	 0		       ;SEEK FLAG
ECC_X	 DB	 0		       ;ECC FLAG
PC_TYPE  LABEL	 DWORD
	 DW	 000EH,0FFFFH	       ;LOCATION OF PC TYPE
AT	 EQU	 0FCH		       ;IBM AT
PCT	 DB	 0		       ;TYPE OF PC
DWORK	 DB	 16 DUP(0)	       ;WORK AREA
CUR_DIAG DW	 0		       ;CURRENT DIAGNOSTIC
SAVE_SP  DW	 0		       ;SAVED STACK POINTER
P_STAT	 DB	 0FFH		       ;PRINTER STATUS
ALL_SW	 DB	 00H		       ;RUN ALL TESTS SWITCH
BAD_SEC  DW	 0		       ;BAD SECTOR COUNT
; **********************************************************************
; *			    BOX PARAMETERS			       *
; **********************************************************************
BROW	 DB	 0		       ;STARTING ROW
BCOL	 DB	 0		       ;STARTING COLUMN
BHEIGHT  DB	 0		       ;HIGHT
BWIDTH	 DB	 0		       ;WIDTH
BATTR	 DB	 0		       ;ATTRIBUTE
BCHAR	 DB	 0		       ;CHARACTER TO WRITE
; **********************************************************************
; *			   INTERLEAVE TABLE			       *
; **********************************************************************
INL_TBL  LABEL	 BYTE
INT_1	 DB	 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17
INT_2	 DB	 1,10,2,11,3,12,4,13,5,14,6,15,7,16,8,17,9
INT_3	 DB	 1,7,13,2,8,14,3,9,15,4,10,16,5,11,17,6,12
INT_4	 DB	 1,14,10,6,2,15,11,7,3,16,12,8,4,17,13,9,5
INT_5	 DB	 1,8,15,5,12,2,9,16,6,13,3,10,17,7,14,4,11
INT_6	 DB	 1,4,7,10,13,16,2,5,8,11,14,17,3,6,9,12,15
INT_7	 DB	 1,6,11,16,4,9,14,2,7,12,17,5,10,15,3,8,13
INT_8	 DB	 1,16,14,12,10,8,6,4,2,17,15,13,11,9,7,5,3
; **********************************************************************
; *								       *
; *			      MAIN SCREEN			       *
; *								       *
; **********************************************************************
  SFIELD A00,A01,,@LABEL,RV,05,20,'TESTS THAT WILL NOT DESTROY USER DATA'
  SFIELD A01,A02,,@LABEL,LO,07,24,'F1.......WRITE/READ/VERIFY TEST'
  SFIELD A02,A03,,@LABEL,LO,08,24,'F2.......SEEK TEST'
  SFIELD A03,A04,,@LABEL,LO,09,24,'F3.......HEAD SELECT TEST'
  SFIELD A04,A05,,@LABEL,LO,10,24,'F4.......ECC TEST'
  SFIELD A05,A06,,@LABEL,LO,11,24,'F5.......RUN ALL TESTS'
  SFIELD A06,A07,,@LABEL,LO,12,24,'F6.......PREPARE FOR RELOCATION'
  SFIELD A07,A08,,@LABEL,LO,13,24,'F7.......DEFECT SCAN'
  SFIELD A08,A09,,@LABEL,RV,15,22,'TESTS THAT WILL DESTROY USER DATA'
  SFIELD A09,A10,,@LABEL,LO,17,24,'F8.......SURFACE ANALYSIS'
  SFIELD A10,A11,,@LABEL,LO,18,24,'F9.......FORMAT DISK'
  SFIELD A11,A12,,@LABEL,LO,19,24,'F10......FLAG DEFECTS'
  SFIELD A12,A13,,@LABEL,LO,20,24,'A-F1.....FORMAT TRACK'
  SFIELD A13,A14,,@LABEL,LO,22,24,'A-F9.....TOGGLE PRINTER ON/OFF'
  SFIELD A14,A00,,@LABEL,LO,23,24,'A-F10....EXIT'
;
  SFIELD D00,D00,,@EX,LO,24,81,' '    ;DUMMY INPUT
;
  SFIELD P00,P00,,@LABEL,RV,03,33,'PRINTER ON'
  SFIELD P01,P01,,@LABEL,RV,03,33,'PRINTER OFF'
; **********************************************************************
; *			     ERROR CODE TABLE			       *
; **********************************************************************
ERR_TBL  LABEL	 BYTE
	 DB	 256 DUP(0)	       ;FILL TABLE
	 ORG	 ERR_TBL+01H
	 DB	 1		       ;BAD COMMAND
	 ORG	 ERR_TBL+02H
	 DB	 2		       ;ADDRESS MARK NOT FOUND
	 ORG	 ERR_TBL+04H
	 DB	 3		       ;NO RECORD FOUND
	 ORG	 ERR_TBL+05H
	 DB	 4		       ;RESET FAILED
	 ORG	 ERR_TBL+07H
	 DB	 5		       ;DRIVE INIT FAILED
	 ORG	 ERR_TBL+09H
	 DB	 6		       ;READ/WRITE CROSSES 64K
	 ORG	 ERR_TBL+0AH
BS_FLAG  DB	 7		       ;BAD SECTOR FLAG
	 ORG	 ERR_TBL+10H
	 DB	 8		       ;UNCORRECTABLE DATA ERROR
	 ORG	 ERR_TBL+11H
	 DB	 9		       ;CORRECTABLE DATA CHECK
	 ORG	 ERR_TBL+20H
	 DB	 10		       ;CONTROLLER ERROR
	 ORG	 ERR_TBL+40H
	 DB	 11		       ;SEEK ERROR
	 ORG	 ERR_TBL+80H
	 DB	 12		       ;TIME OUT
	 ORG	 ERR_TBL+0AAH
	 DB	 13		       ;DRIVE NOT READY
	 ORG	 ERR_TBL+0BBH
	 DB	 14		       ;UNDEFINED ERROR
	 ORG	 ERR_TBL+0CCH
	 DB	 15		       ;WRITE FAULT
	 ORG	 ERR_TBL+0E0H
	 DB	 16		       ;UNKOWN ERROR
	 ORG	 ERR_TBL+0FFH
	 DB	 17		       ;SENSE ERROR
	 ORG	 ERR_TBL+81H
	 DB	 16		       ;UNKOWN ERROR
	 ORG	 ERR_TBL+82H
	 DB	 10		       ;CONTROLLER FAILED
	 ORG	 ERR_TBL+83H
	 DB	 18		       ;SECTOR BUFFER ERROR
	 ORG	 ERR_TBL+84H
	 DB	 19		       ;ECC DEVICE ERROR
	 ORG	 ERR_TBL+85H
	 DB	 20		       ;CONTROL PROCESS ERROR
	 ORG	 ERR_TBL+256
;
  SFIELD E08,E09,,@LABEL,HI,16,02,'CONTROLLER DIAGNOSTIC FAILED - THE'
  SFIELD E09,E08,,@LABEL,HI,16,37,'CONTROLLER MAY BE BAD'
;
  SFIELD EX1,EX2,,@LABEL,HI,10,20,'THE HARD DISK(S) HAVE FAILED TO RESPOND'
  SFIELD EX2,EX3,,@LABEL,HI,11,20,'CHECK THE FOLLOWING ITEMS AND TRY AGAIN'
  SFIELD EX3,EX4,,@LABEL,HI,13,32,'DRIVE CONFIGURED ?'
  SFIELD EX4,EX5,,@LABEL,HI,14,32,'DISK DRIVE POWER'
  SFIELD EX5,EX6,,@LABEL,HI,15,32,'DISK DRIVE CABLES'
  SFIELD EX6,EX7,,@LABEL,HI,16,32,'DISK DRIVE TERMINATOR'
  SFIELD EX7,EX1,,@LABEL,HI,17,32,'DISK DRIVE ADDRESS'
; **********************************************************************
; *			   COPYR1GHT MESSAGE			       *
; **********************************************************************
 SFIELD X1,X2,,@LABEL,LO,01,21,'HARD DISK DIAGNOSTIC - VERSION 2.10'
 SFIELD X2,X3,,@LABEL,RV,01,03,'  AT  '
 SFIELD X3,X1,,@LABEL,LO,02,26,'COPYRIGHT (C) JIM BRACKING'
;
	 INCLUDE \SCRMGR\SCRNWORK.ASM
	 INCLUDE HDEQU.ASM
;
;
FMT_BUFF DB	 512 DUP(0)	       ;FORMAT BUFFER
DIAG_BUF DB	 512 DUP(0)	       ;ONE SECTOR OF DATA
DATA_BUF DB	 516 DUP(0)	       ;DATA BUFFER
BY_INFO:
; **********************************************************************
; *		   ESTABLISH CONTROL BREAK INTERRUPT		       *
; **********************************************************************
	 LEA	 DX,CBREAK	       ;SET CONTROL
	 MOV	 AL,23H 	       ;  BREAK
	 MOV	 AH,25H 	       ;  INTERRUPT
	 INT	 21H		       ;  ADDRESS
; **********************************************************************
; *			  SET CONTROL BREAK ON			       *
; **********************************************************************
	 PUSH	 DS		       ;ESTABLISH EXTRA
	 POP	 ES		       ;  SEGMENT
	 MOV	 AH,33H 	       ;SET CONTROL
	 MOV	 AL,01H 	       ;  BREAK
	 MOV	 DL,01H 	       ;  ON
	 INT	 21H
;
	 MOV	 AX,HD_DATA	       ;ESTABLISH
	 MOV	 ES,AX		       ;  SEGMENT
	 MOV	 AL,ES:HD_NUM	       ;NUMBER OF INSTALLED DRIVES
	 MOV	 SNUM_DR,AL	       ;  SAVE IT
	 MOV	 ES:HD_NUM,02H	       ;SET # TO MAX
; **********************************************************************
; *	      DETERMINE THE NUMBER OF INSTALLED DRIVES		       *
; **********************************************************************
INIT_10:
	 XOR	 BX,BX		       ;CLEAR BX
	 MOV	 AX,1001H	       ;TEST DRIVE READY
	 MOV	 CX,0001H	       ;CYL 0, SECTOR 1
	 MOV	 DX,0080H	       ;HEAD 0, DRIVE 0
	 INT	 13H		       ;EXECUTE THE COMMAND
	 JNC	 INIT_20	       ;ONE DIRVE
	 JMP	 EXIT_ERR	       ;NO DRIVES INSTALLED
INIT_20:
	 INC	 BX		       ;ONE DRIVE
	 MOV	 AX,1001H	       ;TEST DRIVE READY
	 MOV	 CX,0001H	       ;CYL 0, SECTOR 1
	 MOV	 DX,0081H	       ;HEAD 0, DRIVE 1
	 INT	 13H		       ;EXECUTE THE COMMAND
	 JC	 INIT_30	       ;ONLY ONE DIRVE
	 INC	 BX		       ;TWO DRIVES INSTALLED
INIT_30:
	 MOV	 ES:HD_NUM,BL	       ;NUMBER OF INSTALLED DRIVES
	 MOV	 NUM_DR,BL	       ;NUMBER OF INSTALLED DRIVES
;
INIT_50:
	 MOV	 AX,06DB6H	       ;DATA PATTERN
	 MOV	 CX,256 	       ;NUMBER OF WORDS
	 CLD			       ;FORWARD DIRECTION
	 LEA	 DI,DIAG_BUF	       ;OUTPUT
	 PUSH	 CS		       ;ESTABLISH
	 POP	 ES		       ;  SEGMENT
	 REP	 STOSW		       ;FILE THE BUFFER
;
	 LES	 BX,CS:PC_TYPE	       ;LOCATION OF MACHINE TYPE
 CMP	 BYTE PTR ES:[BX],AT	       ;RUNNING ON A IBM AT??
	 JE	 CO_MENU	       ;YES
	 LEA	 BX,X2		       ;MSG ADDRESS
 MOV	 BYTE PTR S_DATA.[BX+2],'P'    ;MUST BE A
 MOV	 BYTE PTR S_DATA.[BX+3],'C'    ;  PC
	 MOV	 PCT,0FFH	       ;NOT AN IBM/AT
	 JMP	 CO_MENU	       ;CONTINUE
;
EXIT_ERR:
	 CLS	 LO,0,0,24,79	       ;CLEAR THE SCREEN
	 WRITE	 EX1		       ;WRITE ERROR MSG
	 MOV	 AX,4C00H	       ;RETURN WITH ZERO RETURN CODE
	 INT	 21H		       ;BYE BYE
EXIT:
	 CALL	 CTLR_DIAG	       ;RESET DRIVES
	 MOV	 AX,HD_DATA	       ;ESTABLISH
	 MOV	 ES,AX		       ;  SEGMENT
	 MOV	 AL,SNUM_DR	       ;RESTORE
	 MOV	 ES:HD_NUM,AL	       ;  DRIVE COUNT
	 CLS	 LO,0,0,24,79	       ;CLEAR THE SCREEN
	 MOV	 AX,4C00H	       ;RETURN WITH ZERO RETURN CODE
	 INT	 21H		       ;BYE BYE
HDMAIN ENDP
; *********************************************************************
; *								      *
; *			   PROCESS MAIN MENU			      *
; *								      *
; *********************************************************************
CO_MENU  PROC
	 LEA	 SI,CO_MENU	       ;SAVE
	 MOV	 CUR_DIAG,SI	       ;  CURRENT DIAGNOSTIC
	 MOV	 SAVE_SP,SP	       ;SAVE STACK POINTER
	 CALL	 WRITE_CMSG	       ;FORMAT THE SCREEM
CO_MENU_05:
	 WRITE	 A01		       ;DISPLAY THE MENU
	 READ	 D00		       ;GET THE SELECTION
	 PUSH	 AX		       ;SAVE AX
	 CLS	 LO,4,1,23,78	       ;FORMAT THE SCREEM
	 POP	 AX		       ;RESTORE AX
	 CALL	 TRANS_KEY	       ;TRANSLATE THE KEY
	 JC	 CO_MENU_10	       ;ERROR
	 CMP	 AL,A_F10	       ;EXIT??
	 JE	 EXIT		       ;YES
	 CMP	 AL,A_F9	       ;ALT_F9??
	 JNE	 CO_MENU_07	       ;NO
	 JMP	 PRINT
CO_MENU_07:
	 CMP	 AL,F1		       ;KEY
	 JB	 CO_MENU_10	       ; IN
	 CMP	 AL,F10 	       ;  RANGE??
	 JA	 CO_MENU_10
	 JMP	 CO_MENU_30	       ;CONTINUE
CO_MENU_10:
	 CMP	 AL,A_F1	       ;KEY
	 JB	 CO_MENU_20	       ; IN
	 CMP	 AL,A_F1	       ;  RANGE
	 JA	 CO_MENU_20	       ;NO
	 SUB	 AL,20		       ;ADJUST FOR ALTERNATE KEY
	 JMP	 CO_MENU_30	       ;CONTINUE
CO_MENU_20:
	 CALL	 BEEP		       ;SOUND THE MUSIC
	 JMP	 CO_MENU_05	       ;TRY AGAIN
CO_MENU_30:
	 XOR	 AH,AH		       ;CLEAR AX
	 MOV	 B_HD,0FFH	       ;RESET BAD SEC HEAD
	 MOV	 B_CYL,0FFFFH	       ;RESET BAD SEC CYL
	 DEC	 AL		       ;MAKE IT RELITIVE TO ZERO
	 SHL	 AL,1		       ;ESTABLISH
	 MOV	 SI,AX		       ;  INDEX
	 MOV	 CUR_DIAG,SI	       ;SAVE CURRENT DIAGNOSTIC
	 MOV	 SAVE_SP,SP	       ;SAVE STACK POINTER
CO_MENU_40:
 CALL	 WORD PTR CS:[SI+OFFSET SELECTION_TABLE]
	 JMP	 CO_MENU	       ;NEXT
SELECTION_TABLE LABEL BYTE
	 DW	 HDRW		       ;WRITE/READ/VERIFY TEST
	 DW	 HDSEEK 	       ;SEEK TEST
	 DW	 HDHS		       ;HEAD SELECT TEST
	 DW	 HDECC		       ;ECC TEST
	 DW	 HDALL		       ;RUN ALL TESTS
	 DW	 HDSHIP 	       ;LAND THE HEADS
	 DW	 HDSCAN 	       ;QUICK DEFECT SCAN
	 DW	 HDSURF 	       ;SURFACE ANALYSIS
	 DW	 HDFMT		       ;FORMAT DRIVE
	 DW	 HDFSEC 	       ;FLAG A BAD SECTOR
	 DW	 HDTFMT 	       ;FORMAT A TRACK
CO_MENU  ENDP
; *********************************************************************
; *								      *
; *			 CONTROL BREAK PROCESSING		      *
; *								      *
; *********************************************************************
CBREAK	 PROC
	 PUSH	 CS		       ;ESTABLISH
	 POP	 DS		       ;  DATA SEGMENT
	 MOV	 SI,CUR_DIAG	       ;CURRENT HDNOSTIC
	 CLI			       ;DISABLE INTERRUPTS
	 MOV	 SP,SAVE_SP	       ;RESTORE SP
	 STI			       ;ENABLE INTERRUPTS
	 CALL	 WRITE_CMSG	       ;FORMAT THE SCREEN
	 MOV	 ALL_SW,00H	       ;RESET SWITCH
	 JMP	 CO_MENU_40	       ;CONTINUE
CBREAK	 ENDP
; *********************************************************************
; *								      *
; *			  TOGGLE THE PRINTER			      *
; *								      *
; *********************************************************************
PRINT	 PROC
	 MOV	 AL,P_STAT	       ;FETCH PRINTER STATUS
	 OR	 AL,AL		       ;PRINTER ON??
	 JZ	 PRINT_10	       ;YES - TURN IT OFF
	 XOR	 AL,AL		       ;TURN THE PRINTER ON
	 JMP	 PRINT_20	       ;CONTINUE
PRINT_10:
	 MOV	 AL,0FFH	       ;TURN THE PRINTER OFF
PRINT_20:
	 MOV	 P_STAT,AL	       ;SET PRINTER STATUS
	 JMP	 CO_MENU	       ;START AT THE TOP
PRINT	 ENDP
; *********************************************************************
; *								      *
; *			  CONTROLLER DIAGNOSTIC 		      *
; *								      *
; *********************************************************************
CTLR_DIAG PROC
	 PUSHALL
	 MOV	 CX,5		       ;MAX RETRY
CTLR_DIAG_00:
	 MOV	 HD_CMD,RS_CMD	       ;RESET COMMAND
	 CALL	 EXEC_XCMD	       ;EXECUTE IT
	 MOV	 HD_CMD,RS_CMD	       ;RESET COMMAND
	 CALL	 EXEC_XCMD	       ;EXECUTE IT
	 JNC	 CTLR_DIAG_05	       ;SUCESSFULL
	 LOOP	 CTLR_DIAG_00	       ;TRY IT AGAIN
	 JMP	 CTLR_DIAG_ERR	       ;FAILED
CTLR_DIAG_05:
	 MOV	 CX,5		       ;MAX RETRY
CTLR_DIAG_10:
	 MOV	 HD_CMD,CTLR_CMD       ;CTLR HD COMMAND
	 CALL	 EXEC_XCMD	       ;EXECUTE IT
	 JNC	 CTLR_DIAG_15	       ;SUCESSFULL
	 LOOP	 CTLR_DIAG_10	       ;TRY IT AGAIN
	 JMP	 CTLR_DIAG_ERR	       ;FAILED
CTLR_DIAG_15:
	 MOV	 CX,5		       ;MAX RETRY
CTLR_DIAG_20:
	 MOV	 HD_CMD,RS_CMD	       ;RESET COMMAND
	 CALL	 EXEC_XCMD	       ;EXECUTE IT
	 MOV	 HD_CMD,RS_CMD	       ;RESET COMMAND
	 CALL	 EXEC_XCMD	       ;EXECUTE IT
	 JNC	 CTLR_DIAG_25	       ;SUCESSFULL
	 LOOP	 CTLR_DIAG_20	       ;TRY IT AGAIN
	 JMP	 CTLR_DIAG_ERR	       ;FAILED
CTLR_DIAG_25:
	 MOV	 CX,5		       ;MAX RETRY
CTLR_DIAG_30:
	 MOV	 HD_CMD,WRP_CMD        ;WRITE THE
	 CALL	 EXEC_XCMD	       ;  DRIVE PARMS
	 MOV	 HD_CMD,RCAL_CMD       ;RECALIBRATE COMMAND
	 CALL	 EXEC_XCMD	       ;EXECUTE IT
	 JNC	 CTLR_DIAG_35	       ;SUCESSFULL
	 LOOP	 CTLR_DIAG_30	       ;TRY IT AGAIN
	 JMP	 CTLR_DIAG_ERR	       ;FAILED
CTLR_DIAG_35:
	 MOV	 CX,1000	       ;MAX RETRY
CTLR_DIAG_40:
	 MOV	 HD_CMD,TRDY_CMD       ;TEST DRIVE READY COMMAND
	 CALL	 EXEC_XCMD	       ;EXECUTE IT
	 JNC	 CTLR_DIAG_60	       ;SUCESSFULL
	 LOOP	 CTLR_DIAG_40	       ;TRY IT AGAIN
	 JMP	 CTLR_DIAG_ERR	       ;FAILED
CTLR_DIAG_ERR:
	 WRITE	 E08		       ;DISPLAY ERROR MSG
	 STC			       ;FAILED
CTLR_DIAG_60:
	 POPALL
	 RET			       ;RETURN
CTLR_DIAG ENDP
; *********************************************************************
; *								      *
; *			EXECUTE CONTROLLER COMMANDS		      *
; *								      *
; *********************************************************************
EXEC_XCMD PROC
	 PUSHALL
	 MOV	 AH,HD_CMD	       ;FETCH COMMAND
	 MOV	 AL,01		       ;NUMBER OF SECTORS
	 MOV	 CX,0001H	       ;CURRENT CYLINDER
	 MOV	 DH,00H 	       ;SET HEAD
	 MOV	 DL,DR		       ;DRIVE
	 OR	 DL,80H 	       ;  NUMBER
	 INT	 13H		       ;ISSUE THE COMMAND
	 POPALL
	 RET			       ;RETURN
EXEC_XCMD ENDP
; *********************************************************************
; *								      *
; *			  EXECUTE THE COMMAND			      *
; *								      *
; *********************************************************************
EXEC_CMD PROC
	 PUSHALL
	 MOV	 AH,HD_CMD	       ;FETCH COMMAND
	 MOV	 AL,NUM_SEC	       ;NUMBER OF SECTORS
	 MOV	 DX,CUR_CYL	       ;CURRENT CYLINDER
	 XCHG	 DH,DL		       ;ADJUST IT
	 MOV	 CX,6		       ;SHIFT COUNT
	 SHL	 DL,CL		       ;ADJUST CYL HIGH
	 OR	 DL,CUR_SEC	       ;SET SECTOR NUMBER
	 MOV	 CX,DX		       ;CX SET
	 MOV	 DH,CUR_HD	       ;SET HEAD
	 MOV	 DL,DR		       ;DRIVE
	 OR	 DL,80H 	       ;  NUMBER
	 INT	 13H		       ;EXECUTE THE COMMAND
	 JNC	 EXEC_100	       ;SUCESSFULL
	 CMP	 AH,BSEC_ER	       ;BAD SECTOR FLAG??
	 JNE	 EXEC_00	       ;NO
EXEC_0:
	 PUSH	 AX		       ;SAVE AX
	 INC	 BAD_SEC	       ;UPDATE COUNT
	 EMSG	 7		       ;DISPLAY MSG
	 MOV	 ERR_CODE,BSEC_ER      ;LET CALLER KNOW
	 INC	 ERR_CNT	       ;UPDATE ERROR COUNT
	 POP	 AX		       ;RESTORE AX
	 STC			       ;SET CARRY
	 JMP	 EXEC_20	       ;EXIT
EXEC_00:
	 CMP	 AH,BTRK_ER	       ;BAD TRACK FLAG??
	 JE	 EXEC_0 	       ;YES
	 CMP	 HD_CMD,CTLR_CMD       ;CTLR HD??
	 JNE	 EXEC_10	       ;NO
	 MOV	 DX,HD_P1	       ;READ ERROR
	 IN	 AL,DX		       ;  PORT
	 OR	 AL,80H 	       ;FOR HD COMMAND
	 MOV	 AH,AL		       ;SAVE ERR
EXEC_10:
	 MOV	 AL,AH		       ;ERROR CODE
	 CMP	 FUNC,ECC_F	       ;ECC TEST??
	 JNE	 EXEC_15	       ;NO
	 CMP	 AL,11H 	       ;CORECTED DATA??
	 JE	 EXEC_100	       ;YES
EXEC_15:
	 PUSH	 AX		       ;SAVE AX
	 CALL	 DECODE_ERR	       ;FIND AND DISPLAY ERR MSG
	 POP	 AX		       ;RESTORE ERROR CODE
	 CMP	 AL,CTLR_ER	       ;CONTROLLER ERROR??
	 JNE	 EXEC_18	       ;NO
	 CALL	 CTLR_DIAG	       ;EXEC CTLR HD
	 JNC	 EXEC_18	       ;SUCESSFULL
	 MOV	 AL,0FFH	       ;CTLR NOT WORKING
	 JMP	 EXEC_20	       ;AND EXIT
EXEC_18:
	 MOV	 AL,ERR_CODE	       ;RESTORE ERROR CODE
EXEC_20:
	 STC			       ;INDICATE ERROR
	 POPALL
	 RET			       ;RETURN
EXEC_100:
	 CLC			       ;CLEAR CARY
	 POPALL
	 RET			       ;RETURN
EXEC_CMD ENDP
; *********************************************************************
; *								      *
; *			   DECODE THE ERROR			      *
; *			    AL = ERROR CODE			      *
; *								      *
; *********************************************************************
DECODE_ERR PROC
	 PUSHALL
	 XOR	 AH,AH		       ;CLEAR AH
	 LEA	 SI,ERR_TBL	       ;ERROR CODE TABLE
	 ADD	 SI,AX		       ;INDEX
	 MOV	 AL,[SI]	       ;FETCH TRANSLATED ERROR CODE
	 MOV	 ERR_CODE,AL	       ;SAVE ERROR CODE
	 CMP	 HD_CMD,02H	       ;CYL VALID??
	 JB	 DECODE_10	       ;NO
	 CMP	 HD_CMD,08H	       ;CYL VALID??
	 JB	 DECODE_20	       ;YES
	 CMP	 HD_CMD,0AH	       ;CYL VALID??
	 JB	 DECODE_10	       ;NO
	 CMP	 HD_CMD,10H	       ;CYL VALID??
	 JB	 DECODE_20	       ;YES
DECODE_10:
	 PMSG	 AL		       ;DISPLAY THE MESSAGE
	 JMP	 DECODE_30	       ;CONTINUE
DECODE_20:
	 EMSG	 AL		       ;DISPLAY THE MESSAGE
DECODE_30:
	 INC	 ERR_CNT	       ;ADD 1 TO ERROR COUNT
	 POPALL
	 RET			       ;RETURN
DECODE_ERR ENDP
; *********************************************************************
; *								      *
; *			  FETCH THE DRIVE PARMS 		      *
; *			      DR = DRIVE NO.			      *
; *								      *
; *********************************************************************
READ_PARMS PROC
	 PUSHALL
	 MOV	 AH,RDP_CMD	       ;READ DRIVE PARMS
	 MOV	 AL,1		       ;ONE SECTOR
	 XOR	 DX,DX		       ;CLEAR DX
	 MOV	 CX,1		       ;CYL 0 SEC 1
	 MOV	 DL,DR		       ;DRIVE NUMBER
	 OR	 DL,80H 	       ;HARD DISK REQUEST
	 INT	 13H		       ;FETCH THE DRIVE PARMS
	 MOV	 MAX_HD,DH	       ;SET MAX HEADS
	 MOV	 DX,CX		       ;SAVE CX
	 MOV	 CX,6		       ;SHIFT COUNT
	 SHR	 DL,CL		       ;ADJUST CYL HIGH
	 XCHG	 DH,DL		       ;ADJUST IT
	 INC	 DX		       ;RETRIVE THE HD CYLINDER
	 MOV	 MAX_CYL,DX	       ;SAVE IT
	 POPALL
	 RET			       ;RETURN
READ_PARMS ENDP
; *********************************************************************
; *								      *
; *			      NEXT SECTOR			      *
; *								      *
; *********************************************************************
NEXT_SEC PROC
	 MOV	 AL,CUR_SEC	       ;FETCH CURRENT SECTOR
	 INC	 AL		       ;NEXT SECTOR
	 CMP	 AL,MAX_SEC	       ;NEXT TRACK??
	 JBE	 NEXT_S10	       ;NO
	 CALL	 NEXT_TRK	       ;NEXT TRACK
	 JC	 NEXT_S20	       ;ALL DONE
	 MOV	 AL,1		       ;FIRST SECTOR
NEXT_S10:
	 MOV	 CUR_SEC,AL	       ;SET CURRENT SECTOR
	 CLC			       ;CLEAR CARRY
NEXT_S20:
	 RET			       ;AND RETURN
NEXT_SEC ENDP
; *********************************************************************
; *								      *
; *			      NEXT TRACK			      *
; *								      *
; *********************************************************************
NEXT_TRK PROC
	 MOV	 AL,CUR_HD	       ;FETCH CURRENT HEAD
	 INC	 AL		       ;NEXT HEAD
	 CMP	 AL,MAX_HD	       ;NEXT CYLINDER??
	 JBE	 NEXT_T10	       ;NO
	 CALL	 NEXT_CYL	       ;NEXT CYLINDER
	 JC	 NEXT_T20	       ;ALL DONE
	 XOR	 AX,AX		       ;HEAD 0
NEXT_T10:
	 MOV	 CUR_HD,AL	       ;SET CURRENT HEAD
	 CLC			       ;CLEAR CARRY
NEXT_T20:
	 RET			       ;AND RETURN
NEXT_TRK ENDP
; *********************************************************************
; *								      *
; *			      NEXT CYLINDER			      *
; *								      *
; *********************************************************************
NEXT_CYL PROC
	 MOV	 AX,CUR_CYL	       ;FETCH CURRENT CYLINDER
	 INC	 AX		       ;NEXT CYLINDER
	 CMP	 AX,MAX_CYL	       ;ALL DONE??
	 JBE	 NEXT_C10	       ;NO
	 STC			       ;INDICATE ALL DONE
	 RET			       ;AND RETURN
NEXT_C10:
	 MOV	 CUR_CYL,AX	       ;SET CURRENT CYLINDER
	 CLC			       ;CLEAR CARRY
	 RET			       ;AND RETURN
NEXT_CYL ENDP
; *********************************************************************
; *								      *
; *			  CONVERT TO ASCII			      *
; *			  AX = INPUT				      *
; *			  BX = OUTPUT ENTRY			      *
; *								      *
; *********************************************************************
CONV_ASCII PROC
	 PUSHALL
	 PUSH	 AX		       ;SAVE AX
	 XOR	 CX,CX		       ;CLEAR CX
	 LEA	 DI,[BX].S_DATA        ;DATA FIELD
	 MOV	 CL,[BX].S_LEN	       ;LENGTH
	 MOV	 AL,' '                ;PAD CHARACTER
	 CLD			       ;FORWARD DIRECTION
	 REP	 STOSB		       ;CLEAR THE FIELD
	 MOV	 SI,10		       ;DIVISOR
	 LEA	 DI,[BX].S_DATA        ;POINT TO
	 MOV	 CL,[BX].S_LEN	       ;  END OF
	 ADD	 DI,CX		       ;  THE DATA AREA
	 DEC	 DI		       ;LAST BYTE
	 POP	 AX		       ;RESTORE AX
CONV_10:
	 XOR	 DX,DX		       ;CLEAR DX
	 DIV	 SI		       ;DIVIDE BY 10
	 OR	 DL,30H 	       ;MAKE IT AN ASCII NUMBER
	 MOV	 [DI],DL	       ;AND SAVE IT
	 DEC	 DI		       ;NEXT BYTE
	 OR	 AX,AX		       ;LAST ONE??
	 JNZ	 CONV_10	       ;NO
	 POPALL
	 RET			       ;RETURN TO CALLER
CONV_ASCII ENDP
; *********************************************************************
; *								      *
; *			   HIDE THE CURSOR			      *
; *								      *
; *********************************************************************
HIDE_CUR PROC
	 PUSH	 BX		       ;SAVE BX
	 PUSH	 DX		       ;SAVE DX
	 MOV	 AH,2		       ;SET CURSOR
	 MOV	 DX,1951H	       ;ROW 25 COL 81
	 XOR	 BX,BX		       ;PAGE 0
	 INT	 10H		       ;HIDE THE CURSOR
	 POP	 DX		       ;RESTORE DX
	 POP	 BX		       ;RESTORE BX
	 RET			       ;RETURN
HIDE_CUR ENDP
; *********************************************************************
; *								      *
; *			   TRANSLATE THE KEY			      *
; *								      *
; *********************************************************************
TRANS_KEY PROC
	 PUSHALL
	 XOR	 AH,AH		       ;CLEAR AH
	 MOV	 SI,AX		       ;ESTABLISH INDEX
	 MOV	 AL,EX_KEY[SI]	       ;GET KEY CODE
	 CMP	 AL,ESC_KEY	       ;ESCAPE KEY??
	 JE	 TRANS_EXIT	       ;YES
	 CMP	 AL,ENT_KEY	       ;ENTER KEY??
	 JE	 TRANS_EXIT	       ;YES
	 CMP	 AL,F1		       ;FUNCTION KEY??
	 JB	 TRANS_ERR	       ;NO
	 CMP	 AL,F10 	       ;FUNCTION KEY??
	 JBE	 TRANS_EXIT	       ;YES
	 CMP	 AL,C_BRK	       ;CONTROL BREAK??
	 JE	 TRANS_EXIT	       ;YES
	 CMP	 AL,C_F1	       ;CTRL_F1??
	 JE	 TRANS_EXIT	       ;YES
	 CMP	 AL,A_F1	       ;ALT-F1??
	 JE	 TRANS_EXIT	       ;YES
	 CMP	 AL,A_F9	       ;GOOD KEY??
	 JB	 TRANS_ERR	       ;NO
	 CMP	 AL,A_F10	       ;ALT-F10??
	 JBE	 TRANS_EXIT	       ;YES
TRANS_ERR:
	 STC			       ;ERROR
	 JMP	 TRANS_RSTREGS	       ;EXIT
TRANS_EXIT:
	 CLC			       ;SUCESSFULL
TRANS_RSTREGS:
	 POPALL
	 RET			       ;AND RETURN
TRANS_KEY ENDP
; *********************************************************************
; *								      *
; *			    SOUND THE MUSIC			      *
; *								      *
; *********************************************************************
BEEP	 PROC
BEEP_00:
	 PUSHALL
	 CLI			       ;DISABLE INTERRUPTS
	 IN	 AL,61H 	       ;GET KEYBOARD/SPEAKER CTL DATA
	 PUSH	 AX		       ;AND SAVE IT
	 MOV	 BX,300 	       ;DURATION OF TONE
BEEP_05:
	 AND	 AL,0FCH	       ;TURN OFF TIMER GATE AND SPEAKER
	 OUT	 61H,AL 	       ;WRITE NEW CTL DATA
	 MOV	 CX,48H 	       ;HALF CYCLE TIME FOR TONE
BEEP_10:
	 LOOP	 BEEP_10	       ;SPEAKER OFF
	 OR	 AL,02H 	       ;TURN ON
	 OUT	 61H,AL 	       ;  SPEAKER
	 MOV	 CX,48H 	       ;HALF CYCLE TIME FOR TONE
BEEP_20:
	 LOOP	 BEEP_20	       ;LET US HEAR THE MUSIC
	 DEC	 BX		       ;TIMES GROWING SHORTER
	 JNZ	 BEEP_05	       ;DO IT AGAIN
	 POP	 AX		       ;RESTORE AX
	 OUT	 61H,AL 	       ;RESTORE KEYBOARD/SPEAKER CTL DATA
	 STI			       ;ENABLE INTERRUPTS
	 POPALL
	 RET			       ;AND RETURN
BEEP	 ENDP
; **********************************************************************
; *								       *
; *			     DRAW BOX SUBROUTINE		       *
; *								       *
; **********************************************************************
BOX_IT	 PROC
	 PUSHALL
; **********************************************************************
; *			  DISPLAY THE TOP LINE			       *
; **********************************************************************
	 MOV	 BCHAR,ULEFT	       ;LEFT CORNER
	 MOV	 BH,BROW	       ;ROW
	 MOV	 BL,BCOL	       ;COLUMN
	 MOV	 CL,1		       ;COUNT
	 CALL	 WRITE_IT	       ;WRITE UPPER LEFT CORNER
	 INC	 BL		       ;NEXT COLUMN
	 MOV	 BCHAR,HORZ	       ;HORZT CHAR
	 MOV	 CL,BWIDTH	       ;WIDTH
	 SUB	 CL,2		       ;ADJUST IT
	 JNZ	 BOX_00 	       ;CONTINUE
	 MOV	 CL,1		       ;SET COUNT TO 1
	 MOV	 BCHAR,URIGHT	       ;UPPER RIGHT CORNER
	 CALL	 WRITE_IT	       ;DISPLAY IT
	 JMP	 BOX_10 	       ;CONTINUE
BOX_00:
	 CALL	 WRITE_IT	       ;DISPLAY IT
	 ADD	 BL,BWIDTH	       ;POINT TO
	 SUB	 BL,2		       ; UPPER RIGHT CORNER
	 MOV	 BCHAR,URIGHT	       ;UPPER RIGHT CORNER
	 MOV	 CL,1		       ;LENGTH
	 CALL	 WRITE_IT	       ;DISPLAY IT
; **********************************************************************
; *		       DISPLAY THE VERTICAL LINES		       *
; **********************************************************************
BOX_10:
	 XOR	 CX,CX		       ;CLEAR CX
	 MOV	 CL,BHEIGHT	       ;VERTICAL HEIGHT
	 SUB	 CL,2		       ;ALLOW FOR TOP + BOTTOM
	 JZ	 BOX_30 	       ;NO VERTICAL LINES
	 MOV	 BCHAR,VERT	       ;VERTICAL LINE
BOX_20:
	 PUSH	 CX		       ;SAVE CX
	 INC	 BH		       ;NEXT ROW
	 MOV	 BL,BCOL	       ;COLUMN
	 MOV	 CL,1		       ;LENGTH
	 CALL	 WRITE_IT	       ;WRITE LEFT VERTICAL LINE
	 ADD	 BL,BWIDTH	       ;LEFT
	 DEC	 BL		       ;  LINE
	 CALL	 WRITE_IT	       ;WRITE IT
	 POP	 CX		       ;RESTORE CX
	 LOOP	 BOX_20 	       ;NEXT VERTICAL LINE
; **********************************************************************
; *			  DISPLAY THE BOTTOM LINE		       *
; **********************************************************************
BOX_30:
	 MOV	 BCHAR,LLEFT	       ;LOWER LEFT CORNER
	 INC	 BH		       ;NEXT ROW
	 MOV	 BL,BCOL	       ;COLUMN
	 MOV	 CL,1		       ;COUNT
	 CALL	 WRITE_IT	       ;WRITE UPPER LEFT CORNER
	 INC	 BL		       ;NEXT COLUMN
	 MOV	 BCHAR,HORZ	       ;HORZT CHAR
	 MOV	 CL,BWIDTH	       ;WIDTH
	 SUB	 CL,2		       ;ADJUST IT
	 JNZ	 BOX_40 	       ;CONTINUE
	 MOV	 CL,1		       ;SET COUNT TO 1
	 MOV	 BCHAR,LRIGHT	       ;LOWER RIGHT CORNER
	 CALL	 WRITE_IT	       ;DISPLAY IT
	 JMP	 BOX_50 	       ;CONTINUE
BOX_40:
	 CALL	 WRITE_IT	       ;DISPLAY IT
	 ADD	 BL,BWIDTH	       ;POINT TO
	 SUB	 BL,2		       ; LOWER RIGHT CORNER
	 MOV	 BCHAR,LRIGHT	       ;LOWER RIGHT CORNER
	 MOV	 CL,1		       ;LENGTH
	 CALL	 WRITE_IT	       ;DISPLAY IT
BOX_50:
	 POPALL
	 RET			       ;RETURN
BOX_IT	 ENDP
WRITE_IT PROC
	 PUSHALL
	 WRITEC  BCHAR,BATTR,BH,BL,CL
	 POPALL
	 RET			       ;RETURN
WRITE_IT ENDP
; **********************************************************************
; *								       *
; *			     FORMAT THE SCREEN			       *
; *								       *
; **********************************************************************
WRITE_CMSG PROC
	 PUSHALL
	 CLS	 LO,0,0,24,79	       ;CLEAR THE SCREEN
	 BOX	 0,0,25,80,LO	       ;OUTLINE
	 BOX	 0,0,4,80,LO	       ; THE
	 WRITEC  0CCH,LO,3,0,1	       ;  SCREEN
	 WRITEC  0B9H,LO,3,79,1
	 WRITE X1		       ;WRITE THE COPY WRIGHT MESSAGE
	 CMP	 P_STAT,00H	       ;PRINTER ON??
	 JNE	 WRITE_CMSG_00	       ;NO
	 WRITE	 P00		       ;MSG
	 WRITEC  011H,RV,3,32,1        ;LEFT ARROW
	 WRITEC  010H,RV,3,43,1        ;RIGHT ARROW
	 JMP	 WRITE_CMSG_10	       ;EXIT
WRITE_CMSG_00:
	 WRITE	 P01		       ;MSG
	 WRITEC  011H,RV,3,32,1        ;LEFT ARROW
	 WRITEC  010H,RV,3,44,1        ;RIGHT ARROW
WRITE_CMSG_10:
	 POPALL
	 RET			       ;RETURN
WRITE_CMSG ENDP
CSEG	 ENDS
	 END	 HDMAIN
