	 PAGE	 64,132 	       ;PAGE WIDTH,LENGTH
	 .SALL
	 TITLE	 PC/AT DIAGNOSTIC - SURFACE ANALYSIS
; **********************************************************************
; *								       *
; *	MODULE NAME    HDSURF					       *
; *	AUTHOR	       JIM BRACKING				       *
; *								       *
; *	DECSRIPTION    THIS PROGRAM PERFORMS THE FOLLOWING	       *
; *		       FUNCTIONS:				       *
; *								       *
; *		       1.  THIS PROGRAM WILL WRITE A DATA PATTERN      *
; *			   OF REPEATING X'6DB6' ON EVERY SECTOR        *
; *			   AND THEN READ IT BACK AND COMPARE IT.       *
; *			   FOR ANY SECTOR WITH A MISS-MATCH THE        *
; *			   ENTIRE TRACK WILL BE MARKED BAD.	       *
; *								       *
; **********************************************************************
;
; **********************************************************************
; *			EXTERNAL PROGRAM REFERENCES		       *
; **********************************************************************
	 EXTRN	 SCRMGR:NEAR
; **********************************************************************
; *			  EXTERNAL DATA REFERENCES		       *
; **********************************************************************
	 INCLUDE HDDATA.ASM
; **********************************************************************
; *			EXTERNAL SUBROUTINE REFERENCES		       *
; **********************************************************************
	 INCLUDE HDSUB.ASM
; **********************************************************************
; *			    PUBLIC DECLARES			       *
; **********************************************************************
	 PUBLIC  HDSURF
; **********************************************************************
; *				 MACROS 			       *
; **********************************************************************
	 IF1
	 INCLUDE HD.MAC
	 INCLUDE \SCRMGR\SCRNWORK.MAC
	 ENDIF
; **********************************************************************
; *								       *
; *			       BEGIN				       *
; *								       *
; **********************************************************************
CSEG	 SEGMENT PARA PUBLIC 'CODE'
	 ASSUME CS:CSEG
HDSURF PROC    NEAR
	 ASSUME  DS:CSEG	       ;DATA SEGMENT
	 JMP	 BY_ID		       ;JMP AROUND ID
	 ID	 HDSURF
	 INCLUDE \SCRMGR\SCRNWORK.ASM
; **********************************************************************
; *			 EQUATES AND STRUCTURES 		       *
; **********************************************************************
	 INCLUDE HDEQU.ASM
; **********************************************************************
; *				 SCREENS			       *
; **********************************************************************
  SFIELD FM0,FM1,,@LABEL,RV+BLINK,14,34,' WARNING '
  SFIELD FM1,FM2,,@LABEL,LO,15,18,'THIS WILL DESTROY ALL DATA ON THE HARD DISK'
  SFIELD FM2,FM3,,@LABEL,LO,16,22,'REPLY Y TO CONTINUE OR N TO STOP -'
  SFIELD FM3,FM0,,@YN+@UC+@NFULL+@REQ,LO,16,57,' '
  SFIELD T05,T05,,@LABEL,RV,17,31,'SURFACE ANALYSIS'
;
  SFIELD X00,X01,,@LABEL,RV,23,02,'CTRL-F1 TO START'
  SFIELD X01,X02,,@LABEL,RV,23,29,'ESC FOR THE MAIN MENU'
  SFIELD X02,X00,,@LABEL,RV,23,62,'CTRL-BRK TO STOP'
;
  SFIELD XI0,XI1,,@LABEL,LO,19,05,'DRIVE =>'
  SFIELD XI1,XI2,1,@EX+@NUM+@UC+@NFULL+@REQ,LO,19,14
  SFIELD XI2,XI3,,@LABEL,LO,20,05,'(1 OR 2)'
  SFIELD XI3,XI4,,@LABEL,LO,19,22,'INTERLEAVE =>'
  SFIELD XI4,XI5,1,@EX+@NUM+@NFULL+@REQ,LO,19,36
  SFIELD XI5,XI0,,@LABEL,LO,20,26,'(1-8)'
;
  SFIELD XS0,XS1,,@LABEL,LO,19,46,'STATUS =>'
  SFIELD XS1,XS0,,@LABEL,LO,19,56,'** IDLE **   '
;
  SFIELD XS2,XS3,,@LABEL,LO,19,46,'STATUS =>'
  SFIELD XS3,XS2,,@LABEL,HI,19,56,'** WORKING **'
;
  SFIELD XC0,XC1,,@LABEL,LO,20,46,'CYLINDER =>'
  SFIELD XC1,XC0,04,@LABEL,LO,20,58
;
  SFIELD XE0,XE1,,@LABEL,LO,21,46,'ERRORS =>'
  SFIELD XE1,XE0,04,@LABEL,LO,21,56
;
  SFIELD E01,E02,,@LABEL,LO,16,02,'  CYL XXXX HEAD XX HAS BEEN FLAGGED'
  SFIELD E02,E03,04,@LABEL,LO,16,08
  SFIELD E03,E01,02,@LABEL,LO,16,18
;
BY_ID:
HDSURF ENDP
; *********************************************************************
; *								      *
; *			    SURFACE ANALYSIS			      *
; *								      *
; *********************************************************************
SURFA	   PROC
	 CLS	 LO,4,1,23,78	       ;CLEAR THE SCREEN
	 BOX	 17,0,08,80,LO	       ;OUTLINE
	 WRITEC  0CCH,LO,17,0,1        ;  THE
	 WRITEC  0B9H,LO,17,79,1       ;  SCREEN
	 WRITE	 T05		       ;TYPE OF TEST
	 WRITE	 X00		       ;COMMANDS
SURFA_00:
	 WRITE	 XS0		       ;STATUS
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 [BX].S_DATA,' '       ;CLEAR DRIVE
	 LEA	 BX,XI4 	       ;INTERLEAVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 [BX].S_DATA,'3'       ;DEFAULT INTERLEAVE OF 3 (AT)
	 CMP	 PCT,00H	       ;IBM/AT??
	 JE	 SURFA_01	       ;YES
	 MOV	 [BX].S_DATA,'6'       ;DEFAULT INTERLEAVE OF 6 (PC)
SURFA_01:
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
SURFA_02:
	 READR	 BX		       ;FETCH DRIVE AND INTERLEAVE
	 CALL	 TRANS_KEY	       ;TRANSLATE THE KEY
	 JNC	 SURFA_04	       ;SUCESSFULL
SURFA_03:
	 CALL	 BEEP		       ;RING THE BELL
	 JMP	 SURFA_02	       ;TRY AGAIN
SURFA_04:
	 CMP	 AL,ESC_KEY	       ;ESCAPE KEY??
	 JNE	 SURFA_05	       ;NO
	 JMP	 EXIT		       ;RETURN
SURFA_05:
	 CMP	 AL,C_BRK	       ;CONTROL BREAK KEY??
	 JNE	 SURFA_07	       ;NO
	 JMP	 SURFA		       ;YES - START OVER
SURFA_07:
	 CMP	 AL,C_F1	       ;CTRL_F1??
	 JNE	 SURFA_03	       ;NO - INVALID KEY
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 AL,[BX].S_DATA        ;FETCH DRIVE NUMBER
	 CMP	 AL,'1'                ;VALID DRIVE??
	 JE	 SURFA_08	       ;YES
	 CMP	 AL,'2'                ;VALID DRIVE??
	 JE	 SURFA_08	       ;YES
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 22		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 JMP	 SURFA_02	       ;TRY AGAIN
SURFA_08:
	 AND	 AL,0FH 	       ;ADJUST
	 DEC	 AL		       ;  DRIVE NUMBER
	 CMP	 AL,NUM_DR	       ;DRIVE INSTALLED
	 jb	 SURFA_10	       ;YES
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 21		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 JMP	 SURFA_02	       ;TRY AGAIN
SURFA_10:
	 MOV	 DR,AL		       ;SAVE DRIVE NUMBER
	 LEA	 BX,XI4 	       ;INTERLEAVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 AL,[BX].S_DATA        ;FETCH INTERLEAVE
	 CMP	 AL,'1'                ;IN RANGE??
	 JB	 SURFA_15	       ;NO
	 CMP	 AL,'8'                ;IN RANGE??
	 JA	 SURFA_15	       ;NO
	 JMP	 SURFA_20	       ;CONTINUE
SURFA_15:
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 23		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI2		       ;DRIVE + INTERLEAVE
	 JMP	 SURFA_02	       ;TRY AGAIN
SURFA_20:
	 XOR	 AH,AH		       ;CLEAR AH
	 AND	 AL,0FH 	       ;MAKE IT A DIGIT
	 DEC	 AL		       ;RELEATIVE TO ZERO
	 XOR	 DX,DX		       ;CLEAR DX
	 MOV	 CX,17		       ;SECTORS PER TRACK
	 MUL	 CX
	 LEA	 SI,INL_TBL	       ;INTERLEAVE TABLE
	 ADD	 SI,AX		       ;TABLE INDEX
	 XOR	 AX,AX		       ;PAD CHARACTER
	 MOV	 CX,512 	       ;BUFFER SIZE
	 CLD			       ;FORWARD DIRECTION
	 LEA	 DI,FMT_BUFF	       ;FORMAT BUFFER
	 PUSH	 DS		       ;ESTABLISH
	 POP	 ES		       ;  SEGMENT
	 REP	 STOSB		       ;ZERO THE BUFFER
	 MOV	 CX,17		       ;NUMBER OF SECTORS
	 LEA	 DI,FMT_BUFF	       ;FORMAT BUFFER
SURFA_30:
	 LODSB			       ;FETCH SECTOR NUMBER
	 MOV	 AH,80H 	       ;BAD SECTOR INDICATOR
	 XCHG	 AL,AH		       ;ADJUST FOR STOSW
	 STOSW			       ;SET SECTOR NUMBER
	 LOOP	 SURFA_30	       ;COMPLETE THE BUFFER
SURFA_35:
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 LEA	 BX,XI4 	       ;INTERLEAVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 LEA	 BX,FM3 	       ;REPLY ENTRY
	 MOV	 [BX].S_DATA,' '       ;CLEAR REPLY
	 CLS	 LO,4,2,16,78	       ;CLEAR THE SCREEN
	 WRITE	 FM0		       ;DISPLAY MESSAGE
	 READ	 FM0		       ;GET REPLY
	 LEA	 BX,FM3 	       ;REPLY ENTRY
	 CMP	 [BX].S_DATA,'Y'       ;CONTINUE??
	 JE	 SURFA_40	       ;YES
	 JMP	 SURFA		       ;RESTART
SURFA_40:
	 CALL	 READ_PARMS	       ;FETCH DRIVE PARMS
	 MOV	 CUR_HD,0	       ;INITIALIZE
	 MOV	 CUR_SEC,1	       ; THE
	 MOV	 CUR_CYL,0	       ;  STARTING FIELDS
	 MOV	 ERR_CNT,0	       ;CLEAR THE ERROR COUNT
	 MOV	 NUM_SEC,17	       ;NUMBER OF SECTORS
	 CALL	 UPD_CYL	       ;DISPLAY CYLINDER NUMBER
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
	 WRITE	 XS2		       ;STATUS
	 CLS	 LO,4,2,16,78	       ;CLEAR THE SCREEN
	 CALL	 HIDE_CUR	       ;HIDE THE CURSOR
; *********************************************************************
; *			   BEGIN THE ANALYSIS			      *
; *********************************************************************
	 CALL	 CTLR_DIAG	       ;EXECUTE CTLR HDNOSTICS
	 JNC	 SURFA_50	       ;SUCESSFULL
	 PMSG	 26,HI		       ;FAILED
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
	 JMP	 SURFA_00	       ;TERMINATE FORMAT
SURFA_50:
	 PUSH	 DS		       ;ESTABLISG
	 POP	 ES		       ;  SEGMENT
SURFA_60:
	 MOV	 AH,0BH 	       ;CHECK FOR
	 INT	 21H		       ;  CONTROL BREAK
	 CALL	 UPD_CYL	       ;DISPLAY CURRENT CYLINDER
	 MOV	 CX,5		       ;NUMBER OF TIMES TO WRITE
SURFA_65:
	 MOV	 HD_CMD,WR_CMD	       ;WRITE COMMAND
	 LEA	 BX,DIAG_BUF	       ;HD BUFFERER
	 MOV	 NUM_SEC,1	       ;NUMBER OF SECTORS
	 CALL	 EXEC_CMD	       ;WRITE THE SECTOR
	 JNC	 SURFA_70	       ;SUCESSFULL
	 CMP	 AL,0FFH	       ;CTLR BROKE??
	 JNE	 SURFA_67	       ;NO
	 JMP	 SURFA_00	       ;STOP
SURFA_67:
	 PUSH	 AX		       ;SAVE AX
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
	 POP	 AX		       ;RESTORE AX
	 CMP	 AH,BSEC_ER	       ;BAD SECTOR??
	 JE	 SURFA_80	       ;YES - SKIP VERIFY
	 CMP	 AH,BTRK_ER	       ;BAD TRACK??
	 JE	 SURFA_80	       ;YES - SKIP VERIFY
	 CALL	 FLAG_TRK	       ;FLAG THE TRACK
	 MOV	 CUR_SEC,17	       ;FORCE NEXT HEAD
	 JMP	 SURFA_80	       ;SKIP VERIFY
SURFA_70:
	 MOV	 HD_CMD,VER_CMD        ;VERIFY COMMAND
	 LEA	 BX,DIAG_BUF	       ;HD BUFFERER
	 MOV	 NUM_SEC,1	       ;NUMBER OF SECTORS
	 CALL	 EXEC_CMD	       ;VERIFY THE SECTOR
	 JNC	 SURFA_75	       ;SUCESSFULL
	 CALL	 FLAG_TRK	       ;FLAG THE TRACK
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
	 MOV	 CUR_SEC,17	       ;FORCE NEXT HEAD
	 JMP	 SURFA_80	       ;CONTINUE
SURFA_75:
	 LOOP	 SURFA_70	       ;ONE MORE TIME
SURFA_80:
	 CALL	 NEXT_SEC	       ;NEXT SECTOR
	 JNC	 SURFA_60	       ;AND PROCESS IT
	 MOV	 HD_CMD,SEEK_CMD       ;LETS
	 MOV	 CUR_CYL,0	       ; BRING
	 MOV	 CUR_HD,0	       ;  THE HEADS
	 CALL	 EXEC_CMD	       ;  HOME
	 PMSG	 27,HI		       ;FORMAT COMPLETE
	 JMP	 SURFA_00	       ;NEXT
; *********************************************************************
; *				E X I T 			      *
; *********************************************************************
EXIT:
	 RET			       ;RETURN
SURFA	 ENDP
; *********************************************************************
; *			DISPLAY CURRENT CYLINDER		      *
; *********************************************************************
UPD_CYL  PROC
	 PUSHALL
	 MOV	 AX,CUR_CYL	       ;FORMAT
	 LEA	 BX,XC1 	       ; CYLINDER
	 CALL	 CONV_ASCII	       ;  DISPLAY
	 WRITE	 XC0		       ;CYLINDER
	 POPALL
	 RET			       ;RETURN
UPD_CYL  ENDP
; *********************************************************************
; *			   DISPLAY ERROR COUNT			      *
; *********************************************************************
UPD_ERR  PROC
	 PUSHALL
	 XOR	 AX,AX		       ;CLEAR AX
	 MOV	 AX,ERR_CNT	       ;FORMAT
	 LEA	 BX,XE1 	       ; ERROR COUNT
	 CALL	 CONV_ASCII	       ;  DISPLAY
	 WRITE	 XE0		       ;ERROR COUNT
	 POPALL
	 RET			       ;RETURN
UPD_ERR  ENDP
; *********************************************************************
; *			   FLAG BAD TRACK			      *
; *********************************************************************
FLAG_TRK PROC
	 PUSHALL
	 MOV	 AH,FMT_CMD	       ;FORMAT COMMAND
	 MOV	 AL,17		       ;NUMBER OF SECTORS
	 CMP	 PCT,00H	       ;IBM/AT??
	 JE	 FLAG_T00	       ;YES
	 MOV	 AH,FMD_CMD	       ;FORMAT DRIVE
	 LEA	 BX,XI4 	       ;FETCH
	 MOV	 AL,[BX].S_DATA        ;  INTERLEAVE
	 AND	 AL,0FH 	       ;MAKE IT A DIGIT
FLAG_T00:
	 MOV	 DX,CUR_CYL	       ;CURRENT CYLINDER
	 XCHG	 DH,DL		       ;ADJUST IT
	 MOV	 CX,6		       ;SHIFT COUNT
	 SHL	 DL,CL		       ;ADJUST CYL HIGH
	 OR	 DL,1		       ;SET SECTOR NUMBER
	 MOV	 CX,DX		       ;CX SET
	 MOV	 DH,CUR_HD	       ;SET HEAD
	 MOV	 DL,DR		       ;DRIVE
	 OR	 DL,80H 	       ;  NUMBER
	 LEA	 BX,FMT_BUFF	       ;FORMAT BUFFER
	 INT	 13H		       ;EXECUTE THE COMMAND
	 MOV	 AX,CUR_CYL	       ;FORMAT
	 LEA	 BX,E02 	       ;  CYLINDER
	 CALL	 CONV_ASCII
	 XOR	 AX,AX		       ;CLEAR AX
	 MOV	 AL,CUR_HD	       ;FORMAT
	 LEA	 BX,E03 	       ;  HEAD
	 CALL	 CONV_ASCII
	 SCROLL  LO,4,2,16,78	       ;SCROLL
	 WRITE	 E01		       ;DISPLAY THE MESSAGE
	 CALL	 LOGERR 	       ;PRINT THE MESSAGE
	 POPALL
	 RET			       ;RETURN
FLAG_TRK ENDP
CSEG	 ENDS
	 END	 HDSURF
