	 PAGE	 64,132 	       ;PAGE WIDTH,LENGTH
	 .SALL
	 TITLE	 PC/AT DIAGNOSTIC - QUICK SCAN FOR DEFECTS
; **********************************************************************
; *								       *
; *	MODULE NAME    HDSCAN					       *
; *	AUTHOR	       JIM BRACKING				       *
; *								       *
; *	DECSRIPTION    THIS PROGRAM PERFORMS THE FOLLOWING	       *
; *		       FUNCTIONS:				       *
; *								       *
; *		       1. THIS PROGRAM EXECUTES A VERIFY READ FOR      *
; *			  EVERY SECTOR ON THE DISK.		       *
; *								       *
; **********************************************************************
;
; **********************************************************************
; *			EXTERNAL PROGRAM REFERENCES		       *
; **********************************************************************
	 EXTRN	 SCRMGR:NEAR
; **********************************************************************
; *			  EXTERNAL DATA REFERENCES		       *
; **********************************************************************
	 INCLUDE HDDATA.ASM
; **********************************************************************
; *			EXTERNAL SUBROUTINE REFERENCES		       *
; **********************************************************************
	 INCLUDE HDSUB.ASM
; **********************************************************************
; *			    PUBLIC DECLARES			       *
; **********************************************************************
	 PUBLIC  HDSCAN
; **********************************************************************
; *				 MACROS 			       *
; **********************************************************************
	 IF1
	 INCLUDE HD.MAC
	 INCLUDE \SCRMGR\SCRNWORK.MAC
	 ENDIF
; **********************************************************************
; *								       *
; *			       BEGIN				       *
; *								       *
; **********************************************************************
CSEG	 SEGMENT PARA PUBLIC 'CODE'
	 ASSUME CS:CSEG
HDSCAN PROC    NEAR
	 ASSUME  DS:CSEG	       ;DATA SEGMENT
	 JMP	 BY_ID		       ;JMP AROUND ID
	 ID	 HDSCAN
	 INCLUDE \SCRMGR\SCRNWORK.ASM
; **********************************************************************
; *			 EQUATES AND STRUCTURES 		       *
; **********************************************************************
	 INCLUDE HDEQU.ASM
; **********************************************************************
; *				 SCREENS			       *
; **********************************************************************
  SFIELD X00,X01,,@LABEL,RV,23,02,'CTRL-F1 TO START'
  SFIELD X01,X02,,@LABEL,RV,23,29,'ESC FOR THE MAIN MENU'
  SFIELD X02,X00,,@LABEL,RV,23,62,'CTRL-BRK TO STOP'
;
  SFIELD XI0,XI1,,@LABEL,LO,19,15,'DRIVE =>'
  SFIELD XI1,XI2,1,@EX+@NUM+@UC+@NFULL+@REQ,LO,19,24
  SFIELD XI2,XI0,,@LABEL,LO,20,15,'(1 OR 2)'
;
  SFIELD XS0,XS1,,@LABEL,LO,19,46,'STATUS =>'
  SFIELD XS1,XS0,,@LABEL,LO,19,56,'** IDLE **   '
;
  SFIELD XS2,XS3,,@LABEL,LO,19,46,'STATUS =>'
  SFIELD XS3,XS2,,@LABEL,HI,19,56,'** WORKING **'
;
  SFIELD XC0,XC1,,@LABEL,LO,20,46,'CYLINDER =>'
  SFIELD XC1,XC0,04,@LABEL,LO,20,58
;
  SFIELD XE0,XE1,,@LABEL,LO,21,46,'ERRORS =>'
  SFIELD XE1,XE0,04,@LABEL,LO,21,56
;
  SFIELD T05,T05,,@LABEL,RV,17,33,'DEFECT SCAN'
;
BY_ID:
HDSCAN ENDP
; *********************************************************************
; *								      *
; *			  QUICK DEFECT SCAN			      *
; *								      *
; *********************************************************************
QDS	 PROC
	 CLS	 LO,4,1,23,78	       ;CLEAR THE SCREEN
	 BOX	 17,0,08,80,LO	       ;OUTLINE
	 WRITEC  0CCH,LO,17,0,1        ;  THE
	 WRITEC  0B9H,LO,17,79,1       ;  SCREEN
	 WRITE	 T05		       ;TYPE OF TEST
	 WRITE	 X00		       ;COMMANDS
QDS_00:
	 WRITE	 XS0		       ;STATUS
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 CMP	 ALL_SW,0FFH	       ;RUN ALL TEST??
	 JE	 QDS_01 	       ;YES
	 MOV	 [BX].S_DATA,' '       ;CLEAR DRIVE
	 JMP	 QDS_01A	       ;CONTINUE
QDS_01:
	 MOV	 AL,DR		       ;FETCH DRIVE
	 INC	 AL		       ;NUMBER
	 OR	 AL,30H 	       ;MAKE IT A NUMBER
	 MOV	 [BX].S_DATA,AL        ;SET IT IN THE MSG
	 WRITE	 XI0		       ;DRIVE
	 JMP	 QDS_15 	       ;CONTINUE
QDS_01A:
	 WRITE	 XI0		       ;DRIVE
QDS_02:
	 READR	 BX		       ;FETCH DRIVE
	 CALL	 TRANS_KEY	       ;TRANSLATE THE KEY
	 JNC	 QDS_04 	       ;SUCESSFULL
QDS_03:
	 CALL	 BEEP		       ;RING THE BELL
	 JMP	 QDS_02 	       ;TRY AGAIN
QDS_04:
	 CMP	 AL,ESC_KEY	       ;ESCAPE KEY??
	 JNE	 QDS_05 	       ;NO
	 JMP	 EXIT		       ;RETURN
QDS_05:
	 CMP	 AL,C_BRK	       ;CONTROL BREAK KEY??
	 JNE	 QDS_07 	       ;NO
	 JMP	 QDS		       ;YES - START OVER
QDS_07:
	 CMP	 AL,C_F1	       ;CTRL_F1??
	 JNE	 QDS_03 	       ;NO - INVALID KEY
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 AL,[BX].S_DATA        ;FETCH DRIVE NUMBER
	 CMP	 AL,'1'                ;VALID DRIVE??
	 JE	 QDS_08 	       ;YES
	 CMP	 AL,'2'                ;VALID DRIVE??
	 JE	 QDS_08 	       ;YES
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 22		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE
	 JMP	 QDS_02 	       ;TRY AGAIN
QDS_08:
	 AND	 AL,0FH 	       ;ADJUST
	 DEC	 AL		       ;  DRIVE NUMBER
	 CMP	 AL,NUM_DR	       ;DRIVE INSTALLED
	 jb	 QDS_10 	       ;YES
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 21		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 JMP	 QDS_02 	       ;TRY AGAIN
QDS_10:
	 MOV	 DR,AL		       ;SAVE DRIVE NUMBER
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 WRITE	 XI0		       ;DRIVE
QDS_15:
	 CALL	 READ_PARMS	       ;FETCH DRIVE PARMS
	 MOV	 CUR_HD,0	       ;INITIALIZE
	 MOV	 CUR_SEC,1	       ; THE
	 MOV	 CUR_CYL,0	       ;  STARTING FIELDS
	 MOV	 ERR_CNT,0	       ;CLEAR THE ERROR COUNT
	 MOV	 NUM_SEC,1	       ;NUMBER OF SECTORS
	 CALL	 UPD_CYL	       ;DISPLAY CYLINDER NUMBER
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
	 WRITE	 XS2		       ;STATUS
	 CLS	 LO,4,2,16,78	       ;CLEAR THE SCREEN
	 CALL	 HIDE_CUR	       ;HIDE THE CURSOR
; *********************************************************************
; *			   BEGIN THE TEST			      *
; *********************************************************************
	 CALL	 CTLR_DIAG	       ;EXECUTE CTLR HDNOSTICS
	 JNC	 QDS_30 	       ;SUCESSFULL
	 PMSG	 42,HI		       ;FAILED
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
	 JMP	 QDS_00 	       ;NEXT
QDS_30:
	 MOV	 AH,0BH 	       ;CHECK FOR
	 INT	 21H		       ;  CONTROL BREAK
	 CALL	 UPD_CYL	       ;DISPLAY CURRENT CYLINDER
	 CMP	 PCT,00H	       ;IBM/AT??
	 JE	 QDS_35 	       ;YES
	 JMP	 QDS_70 	       ;NO
; *********************************************************************
; *			   FOR THE IBM/AT			      *
; *********************************************************************
QDS_35:
	 MOV	 HD_CMD,VER_CMD        ;VERIFY COMMAND
	 MOV	 CUR_SEC,01H	       ;START AT SECTOR ONE
	 MOV	 NUM_SEC,17	       ;NUMBER OF SECTORS
QDS_45:
	 MOV	 AH,HD_CMD	       ;FETCH COMMAND
	 MOV	 AL,NUM_SEC	       ;NUMBER OF SECTORS
	 MOV	 DX,CUR_CYL	       ;CURRENT CYLINDER
	 XCHG	 DH,DL		       ;ADJUST IT
	 MOV	 CX,6		       ;SHIFT COUNT
	 SHL	 DL,CL		       ;ADJUST CYL HIGH
	 OR	 DL,CUR_SEC	       ;SET SECTOR NUMBER
	 MOV	 CX,DX		       ;CX SET
	 MOV	 DH,CUR_HD	       ;SET HEAD
	 MOV	 DL,DR		       ;DRIVE
	 OR	 DL,80H 	       ;  NUMBER
	 INT	 13H		       ;EXECUTE THE COMMAND
	 JNC	 QDS_50 	       ;SUCESSFULL
	 CMP	 AL,CTLR_ER	       ;CTLR ERROR??
	 JNE	 QDS_48 	       ;NO
	 CALL	 CTLR_DIAG	       ;CTLR HD
	 JNC	 QDS_48 	       ;SUCESSFULL
	 JMP	 QDS_00 	       ;STOP
QDS_48:
	 MOV	 BX,AX		       ;SAVE ERROR CODE
	 MOV	 DX,HD_P3	       ;SECTOR NUMBER REGISTER
	 MOV	 AH,18		       ;MAX SECTORS +1
	 IN	 AL,DX		       ;GET SECTOR IN ERROR
	 MOV	 CUR_SEC,AL	       ;SAVE SECTOR IN ERROR
	 INC	 AL		       ;PAST ERROR SECTOR
	 PUSH	 AX		       ;SAVE AX
	 MOV	 AL,BH		       ;ERROR CODE
	 CALL	 DECODE_ERR	       ;LET KNOW ABOUT THE ERROR
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
	 POP	 AX		       ;RESTORE AX
	 CMP	 AL,17		       ;NEXT HEAD??
	 JA	 QDS_50 	       ;YES
	 SUB	 AH,AL		       ;COMPUTE NUMBER OF SECTORS LEFT
	 MOV	 CUR_SEC,AL	       ;SET NEXT SECTOR
	 MOV	 NUM_SEC,AH	       ;NUMBER OF SECTORS TO READ
	 JMP	 QDS_45 	       ;FINISH THE TRACK
QDS_50:
	 CALL	 NEXT_TRK	       ;PROCESS ALL HEADS
	 JNC	 QDS_30 	       ;NEXT
QDS_60:
	 MOV	 HD_CMD,SEEK_CMD       ;LETS
	 MOV	 CUR_CYL,0	       ; BRING
	 MOV	 CUR_HD,0	       ;  THE HEADS
	 CALL	 EXEC_CMD	       ;  HOME
	 PMSG	 43,HI		       ;DONE
	 JMP	 QDS_00 	       ;NEXT
; *********************************************************************
; *			   FOR THE IBM/PC			      *
; *********************************************************************
QDS_70:
	 MOV	 HD_CMD,VER_CMD        ;VERIFY COMMAND
	 CALL	 EXEC_CMD	       ;EXECUTE THE COMMAND
	 JNC	 QDS_90 	       ;SUCESSFULL
	 CMP	 AL,CTLR_ER	       ;CTLR ERROR??
	 JNE	 QDS_80 	       ;NO
	 CALL	 CTLR_DIAG	       ;CTLR HD
	 JNC	 QDS_80 	       ;SUCESSFULL
	 JMP	 QDS_00 	       ;STOP
QDS_80:
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
QDS_90:
	 CALL	 NEXT_SEC	       ;PROCESS ALL HEADS
	 JC	 QDS_100	       ;DONE
	 JMP	 QDS_30 	       ;NEXT
QDS_100:
	 MOV	 HD_CMD,SEEK_CMD       ;LETS
	 MOV	 CUR_CYL,0	       ; BRING
	 MOV	 CUR_HD,0	       ;  THE HEADS
	 CALL	 EXEC_CMD	       ;  HOME
	 PMSG	 43,HI		       ;DONE
	 JMP	 QDS_00 	       ;NEXT
; *********************************************************************
; *				E X I T 			      *
; *********************************************************************
EXIT:
	 RET			       ;RETURN
QDS	 ENDP
; *********************************************************************
; *			DISPLAY CURRENT CYLINDER		      *
; *********************************************************************
UPD_CYL  PROC
	 PUSHALL
	 MOV	 AX,CUR_CYL	       ;FORMAT
	 LEA	 BX,XC1 	       ; CYLINDER
	 CALL	 CONV_ASCII	       ;  DISPLAY
	 WRITE	 XC0		       ;CYLINDER
	 POPALL
	 RET			       ;RETURN
UPD_CYL  ENDP
; *********************************************************************
; *			   DISPLAY ERROR COUNT			      *
; *********************************************************************
UPD_ERR  PROC
	 PUSHALL
	 XOR	 AX,AX		       ;CLEAR AX
	 MOV	 AX,ERR_CNT	       ;FORMAT
	 LEA	 BX,XE1 	       ; ERROR COUNT
	 CALL	 CONV_ASCII	       ;  DISPLAY
	 WRITE	 XE0		       ;ERROR COUNT
	 POPALL
	 RET			       ;RETURN
UPD_ERR  ENDP
CSEG	 ENDS
	 END	 HDSCAN
