;
; FPD.ASM (FindPhysicalDisk)
; C-callable subroutine to determine physical device for any
; logical disk.
;
; This subroutine requires DOS version 3.0 or later.
;
; Copyright (c) 1990, Jim Mischel
;
	Ideal			;use TASM Ideal mode
	Model small,pascal

	CodeSeg
FileSpec	db	'?:*.*',0
OldInt13	dd	?	;storage for Old BIOS disk interrupt
OldInt24	dd	?	;storage for critical error handler
Pdisk		db	?	;physical disk (updated by NewInt13)

public FindPhysicalDevice
Proc FindPhysicalDevice uses ds, Disk:Word
; Get and save BIOS disk interrupt
	push	cs
	pop	ds		;all data is in code segment
	mov	ax,3513h
	int	21h
	mov	[word ptr OldInt13],bx
	mov	[word ptr OldInt13+2],es
; Get and save critical error interrupt
	mov	ax,3524h
	int	21h
	mov	[word ptr OldInt24],bx
	mov	[word ptr OldInt24+2],es
; Install new BIOS disk interrupt
	mov	ax,2513h
	mov	dx,offset NewInt13
	int	21h
; Install new critical error interrupt
	mov	ax,2524h
	mov	dx,offset NewInt24
	int	21h
; Reset disk system.  This must be done before each call in order
; to ensure that DOS is not buffering the FAT for SUBST drives.
	mov	ah,0dh
	int	21h
	mov	[Pdisk],-1
; Execute a FindFirst call for this drive
	mov	ax,[Disk]
	mov	[FileSpec],al
	mov	ah,4eh
	mov	dx,offset FileSpec
	xor	cx,cx
	int	21h
; Restore disk interrupt
	lds	dx,[cs:OldInt13]
	mov	ax,2513h
	int	21h
; Restore critical error interrupt
	lds	dx,[cs:OldInt24]
	mov	ax,2524h
	int	21h
	mov	al,[cs:Pdisk]
	xor	ah,ah
	ret
EndP FindPhysicalDevice

;
; NewInt13 - On a read call, store the physical drive number (from DL)
; in the DriveTable entry for the current logical disk.
; This routine exits through the default BIOS disk interrupt.
;
NewInt13:
	pushf
	cmp	ah,2		;if it's not a read
	jnz	Around		;then skip it
	mov	[cs:Pdisk],dl
Around:	popf
	jmp	[cs:OldInt13]	;jump to normal routine

;
; Replacement critical error handler.  All this routine does is tell
; DOS to fail the requested system call.
;
NewInt24:
	sti
	mov	al,3		;tell DOS to fail system call
	iret
	End
