	title	"fd -- map logical drives to physical disks"
	name	finddisk
;
; FD.ASM (FindDisk)
; This program determines what physical disk all logical drives
; are located on and displays the results.
;
; This program requires DOS version 3.0 or later.
;
; Copyright (c) 1990, Jim Mischel
;
	Ideal			;use TASM Ideal mode
	Model Tiny		;create .COM file
	CodeSeg
	Org 0100h		;.COM files start at 0100H

cr	equ	0dh
lf	equ	0ah

FindDisk:
	jmp	Start		;jump around data to code section

SignOn		db	'FindDisk Version 1.0',cr,lf,'$',1ah
BadVersion	db	'Requires MS-DOS version 3.0 or later',cr,lf,'$'
OldInt13	dd	?	;storage for Old BIOS disk interrupt
Disk		db	1
FileSpec	db	'@:*.*',0
DriveTable	db	26 dup (-1)

Start:
; Display signon message
	mov	dx,offset SignOn
	mov	ah,9
	int	21h
; Check DOS version
	mov	ah,30h
	int	21h
; If version 3.0 or later, then we're OK
	cmp	al,3
	jnc	VersionOk
; Otherwise output message and exit to DOS
	mov	dx,offset BadVersion
	mov	ah,9
	int	20h
VersionOK:
; Get and save BIOS disk interrupt
	mov	ax,3513h
	int	21h
	mov	[word ptr OldInt13],bx
	mov	[word ptr OldInt13+2],es
; Install new BIOS disk interrupt
	mov	ax,2513h
	mov	dx,offset NewInt13
	int	21h
; Install new critical error interrupt
	mov	ax,2524h
	mov	dx,offset NewInt24
	int	21h
Loop1:
; For each logical disk (A-Z), attempt to do a FindFirst on the disk.
; This will cause an attempted read of the FAT on that disk.
; Reset disk system.  This must be done before each call in order
; to ensure that DOS is not buffering the FAT for SUBST drives.
	mov	ah,0dh
	int	21h
	inc	[FileSpec]	;next logical disk
; Execute a FindFirst call for this drive
	mov	ah,4eh
	mov	dx,offset FileSpec
	xor	cx,cx
	int	21h
	inc	[Disk]		;bump disk counter
	cmp	[Disk],27	;if <= Z,
	jc	Loop1		;then do it again

	jmp	OutputIt	;Jump to output routine
; Output format is:
;Logical Drive      Physical Disk        Logical Drive      Physical Disk
;-------------      -------------        -------------      -------------
;      A               Floppy1                 N                None
;     ...                ...                  ...                ...
;     ...                ...                  ...                ...

Header		db	'Logical Drive      Physical Disk'
		db	8 dup (' ')
		db	'Logical Drive      Physical Disk',cr,lf
		db	'-------------      -------------'
		db	8 dup (' ')
		db	'-------------      -------------',cr,lf,'$'

DetailLine	db	6 dup (' ')
Logical1	db	'A'
		db	15 dup (' ')
FH1		db	6 dup (' ')
Physical1	db	?
		db	17 dup (' ')
Logical2	db	'N'
		db	15 dup (' ')
FH2		db	6 dup (' ')
Physical2	db	?
		db	cr,lf,'$'
Floppy		db	'Floppy',0
Hard		db	' Hard ',0
None		db	' None '

OutputIt:			;Output results
; Display header
	mov	dx,offset Header
	mov	ah,9
	int	21h
Loop2:
; Format left column
	mov	bl,[Logical1]
	mov	di,offset FH1
	call	Format
; Format right column
	mov	bl,[Logical2]
	mov	di,offset FH2
	call	Format
; Display detail for these two drives
	mov	dx,offset DetailLine
	mov	ah,9
	int	21h
	inc	[Logical2]		;bump 2nd drive
	cmp	[Logical2],'Z'+1	;if 2nd drive > 'Z'
	jnc	Done			;then done
	inc	[Logical1]		;otherwise bump 1st drive
	jmp	short Loop2		;and do it again
Done:
; Restore BIOS disk interrupt
	mov	dx,[word ptr OldInt13]
	mov	ds,[word ptr OldInt13+2]
	mov	ax,2513h
	int	21h
; And exit to DOS
	mov	ax,4c00h
	int	21h

;
; Format the output for a given Logical drive.  The DriveTable entry
; will be -1 if the drive does not exist, 00H-19H if a diskette drive,
; or 80H-99H if a hard drive.
;
; Call with:
;   BL - logical drive letter (A-Z)
;   DI - destination address
;
Proc Format Near
; Create index into drive table in BX
	sub	bl,'A'
	xor	bh,bh
	mov	al,[bx+DriveTable]	;AL is drive table entry
	cmp	al,-1			;if drive table entry = 0ffh
	jnz	CheckHard
	mov	si,offset None		;then this logical drive
	mov	al,' '			;has no entry
	jmp	short CopyIt
CheckHard:
	test	al,80h			;if high bit is set
	jz	DoFloppy
	mov	si,offset Hard		;then it's a hard disk
	sub	al,80h-'1'
	jmp	short CopyIt
DoFloppy:
	mov	si,offset Floppy	;otherwise it's a floppy
	add	al,'1'
CopyIt:	mov	[byte ptr di+6],al	;store physical device number
	push	ds			;DS:SI is source
	pop	es			;ES:DI is destination
	mov	cx,3			;3 words -- 6 bytes
	cld				;direction = forward
	rep	movsw			;copy it
	ret
EndP Format

;
; NewInt13 - On a read call, store the physical drive number (from DL)
; in the DriveTable entry for the current logical disk.
; This routine exits through the default BIOS disk interrupt.
;
Proc NewInt13 far
	sti
	cmp	ah,2		;if it's not a read
	jnz	Around		;then skip it
	push	bx
	mov	bl,[cs:Disk]
	dec	bl
	xor	bh,bh		;build BX index into drive table
	mov	[cs:bx+DriveTable],dl	;and store the drive number there
	pop	bx
Around:	jmp	[cs:OldInt13]	;jump to normal routine
EndP NewInt13

;
; Replacement critical error handler.  All this routine does is tell
; DOS to fail the requested system call.
;
Proc NewInt24 far
	sti
	mov	al,3		;tell DOS to fail system call
	iret
EndP NewInt24
	End	FindDisk
