;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM27_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   alloc_std_pages                                         ;
;                                                                             ;
;      DESCRIPTION:   This function allocates the number of standard size     ;
;                     (16K bytes) pages that the operating system requests    ;
;                     and assigns a unique EMM handle to these pages.  The    ;
;                     EMM handle owns these pages until the application       ;
;                     deallocates them.                                       ;
;                                                                             ;
;                     This function allows you to allocate zero pages to a    ;
;                     handle, unlike the alloc_pages function.                ;
;                                                                             ;
;                     Note:                                                   ;
;                        This note affects expanded memory manager            ;
;                        implementers and operating system developers only.   ;
;                        Applications should not use the following            ;
;                        characteristic of the memory manager.  An            ;
;                        application violating this rule will be incompatible ;
;                        with future versions of Microsoft's operating        ;
;                        systems and environments.                            ;
;                                                                             ;
;                        To be compatible with this specification, an         ;
;                        expanded memory manager will provide a special       ;
;                        handle which is available to the operating system    ;
;                        only.  This handle will have a value of 0 and        ;
;                        will have a set of pages allocated to it when the    ;
;                        expanded memory manager driver installs.  The pages  ;
;                        that the memory manager will automatically allocate  ;
;                        to handle 0 are those that it has mapped into        ;
;                        conventional memory.                                 ;
;                                                                             ;
;                        An operating system won't have to invoke the         ;
;                        alloc_std_pages function to obtain this handle       ;
;                        because it can assume the handle already exists and  ;
;                        is available for use immediately after the expanded  ;
;                        memory device driver installs.  When an operating    ;
;                        system wants to use this handle, it uses the special ;
;                        handle value of 0. The operating system will be able ;
;                        to invoke any EMM function using this special handle ;
;                        value.  To allocate pages to this handle, the        ;
;                        operating system need only invoke realloc_pages      ;
;                        function.                                            ;
;                                                                             ;
;                        There are two special cases for this handle:         ;
;                        1. alloc_std_pages: when invoked, must never return  ;
;                           zero as a handle value.  Applications must always ;
;                           invoke alloc_std_pages to allocate pages and      ;
;                           obtain a handle which identifies the pages which  ;
;                           belong to it.  Since alloc_std_pages never        ;
;                           returns a handle value of zero, an application    ;
;                           will never gain access to this special handle.    ;
;                                                                             ;
;                        2. dealloc_pages: if the operating system uses it to ;
;                           deallocate the pages which are allocated to this  ;
;                           handle, the pages the handle owns will be         ;
;                           returned to the manager for use.  But the handle  ;
;                           will not be available for reassignment.  The      ;
;                           manager should treat a deallocate pages function  ;
;                           request for this handle the same as a reallocate  ;
;                           pages function request, where the number of pages ;
;                           to reallocate to this handle is zero.             ;
;                                                                             ;
;           PASSED:   std_page_count:                                         ;
;                        is the number of standard pages the operating system ;
;                        wants to allocate.                                   ;
;                                                                             ;
;                     &handle:                                                ;
;                        is a far pointer to a unique handle which the memory ;
;                        manager will assign to the block of pages allocated  ;
;                        to the operating system.                             ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     handle:                                                 ;
;                        is a unique handle which the memory manager will     ;
;                        assign to the block of pages allocated to the        ;
;                        operating system.  The operating system must use     ;
;                        this EMM handle as a parameter in any function that  ;
;                        requires it.  Up to 255 handles may be obtained.     ;
;                        The alloc_pages and alloc_std_pages functions must   ;
;                        share the same 255 handles.                          ;
;                                                                             ;
;                        For all functions using this handle, the length of   ;
;                        the physical and logical pages allocated to it are   ;
;                        standard length (that is, 16K bytes).                ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int std_page_count;                            ;
;                     unsigned int handle;                                    ;
;                                                                             ;
;                     status = alloc_std_pages (std_page_count,               ;
;                                               &handle);                     ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

alloc_std_pages		PROC                                                  \
			std_page_count:WORD,                                  \
			ptr_handle:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   allocate the number of specified STANDARD pages from EMM;     ;
	;---------------------------------------------------------------------;
	MOVE		AX, alloc_standard_pages_fcn
	MOVE		BX, std_page_count
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the handle back to the caller;                           ;
	;---------------------------------------------------------------------;
	MOVE		ES:BX, ptr_handle
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

alloc_std_pages		ENDP

END
