;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM28_H.ASM                                             ;
;                                                                             ;
; OS FUNCTION NAME:   disable_DMA_reg_set                                     ;
;                                                                             ;
;      DESCRIPTION:   This function disables DMA accesses for all DMA         ;
;                     channels which were associated with a specific          ;
;                     alternate DMA register set.                             ;
;                                                                             ;
;           PASSED:   DMA_reg_set:                                            ;
;                        is the number of the DMA register set for which all  ;
;                        operations are to be disabled.  If the DMA set       ;
;                        specified is zero, no action will be taken.          ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int DMA_reg_set;                               ;
;                                                                             ;
;                     status = disable_DMA_reg_set (DMA_reg_set);             ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

disable_DMA_reg_set	PROC	                                              \
			DMA_reg_set:WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   disable DMA into expanded memory using the DMA register set   ;
	;   .   specified by the OS;                                          ;
	;---------------------------------------------------------------------;
	MOVE		AX, disable_dma_on_alt_map_regs_fcn 
	MOVE		BX, DMA_reg_set
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

disable_DMA_reg_set		ENDP

END
