;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM28_A.ASM                                             ;
;                                                                             ;
; OS FUNCTION NAME:   get_alt_reg_set                                         ;
;                                                                             ;
;      DESCRIPTION:   This function does one of two things depending on the   ;
;                     map register set which is active at the time this       ;
;                     function is invoked:                                    ;
;                                                                             ;
;                     1. If the preceding set_alt_reg_set call was done with  ;
;                        the alt_reg_set parameter equal to zero, the         ;
;                        following points apply:                              ;
;                                                                             ;
;                        a. The context save area far pointer saved within    ;
;                           EMM by the set_alt_reg_set function is returned   ;
;                           by this call.  This far pointer is always         ;
;                           returned for boards which do not supply alternate ;
;                           mapping register sets.                            ;
;                                                                             ;
;                        b. If the context save area far pointer returned is  ;
;                           not null, this function copies the state of the   ;
;                           expanded memory mapping hardware in the system    ;
;                           into the save area specified by the far pointer.  ;
;                           The format of this save area is the same as that  ;
;                           returned by the get_context function.  This is    ;
;                           intended to simulate getting an alternate map     ;
;                           register set.  Note that the memory manager does  ;
;                           not allocate the space for the context: the       ;
;                           operating system must do so.                      ;
;                                                                             ;
;                        c. If the context save area far pointer returned is  ;
;                           null, this function does not copy the state of    ;
;                           the expanded memory hardware in the system into   ;
;                           the save area specified by the far                ;
;                           pointer.                                          ;
;                                                                             ;
;                        d. The context save area far pointer must have been  ;
;                           initialized by a previous set_alt_reg_set call.   ;
;                           Note that the value the context save area far     ;
;                           pointer saved within EMM is set to null during    ;
;                           installation of the EMM device driver.            ;
;                                                                             ;
;                        e. The context save area pointed to by the far       ;
;                           pointer to the context save area pointer must be  ;
;                           initialized by a previous get_context call.       ;
;                                                                             ;
;                     2. If the preceding set_alt_reg_set call was done with  ;
;                        the alt_reg_set parameter greater than zero, then    ;
;                        the number of the alternate map register set which   ;
;                        is in use at the time that this function is invoked  ;
;                        is returned.  The context save area pointer is not   ;
;                        returned in this case.                               ;
;                                                                             ;
;           PASSED:   &alt_reg_set:                                           ;
;                        is a far pointer to the current alternate register   ;
;                        set to be obtained.                                  ;
;                                                                             ;
;                     &far_ptr_alt_context:                                   ;
;                        is a far pointer to a far pointer to an operating    ;
;                        system supplied context save area.                   ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     alt_reg_set:                                            ;
;                        If the alt_reg_set parameter returned is not zero:   ;
;                        1. The alt_reg_set parameter contains the alternate  ;
;                           map register set which was active at the time     ;
;                           that this function was invoked.                   ;
;                        2. The far pointer far_ptr_alt_context is            ;
;                           unaffected.                                       ;
;                                                                             ;
;                        If the alt_reg_set parameter returned is zero:       ;
;                        1. The far pointer far_ptr_alt_context points to an  ;
;                           area which contains the state of all the map      ;
;                           registers on all boards in the system, and any    ;
;                           additional information necessary to restore the   ;
;                           boards to their original state, has been          ;
;                           returned.  This far pointer is always returned if ;
;                           the expanded memory hardware does not supply      ;
;                           alternate mapping register sets.                  ;
;                                                                             ;
;                     far_ptr_alt_context:                                    ;
;                        The operating system first passes this pointer to    ;
;                        the memory manager whenever it invokes a             ;
;                        set_alt_reg_set function (the description            ;
;                        follows).  If the OS/E invokes this function         ;
;                        before invoking a set_alt_reg_set function, this     ;
;                        function returns a null pointer.  The OS/E must      ;
;                        have allocated the space for the save area.          ;
;                        However, the OS must request that the memory         ;
;                        manager initialize the contents of this save area    ;
;                        before it contains any useful information.           ;
;                                                                             ;
;                        The OS/E must initialize the save area it has        ;
;                        allocated by invoking the get_context function.      ;
;                        After the OS/E has done this, the save area will     ;
;                        contain the state of all the map registers on all    ;
;                        boards in the system.  The save area will also       ;
;                        contain any additional information necessary to      ;
;                        restore the boards to their original state when      ;
;                        the operating system invokes a set_alt_reg_set       ;
;                        function.                                            ;
;                                                                             ;
; C USE CONVENTION:   unsigned int       status;                              ;
;                     unsigned int       alt_reg_set;                         ;
;                     CONTEXT_STRUCT far *far_ptr_alt_context;                ;
;                                                                             ;
;                     status = get_alt_reg_set (&alt_reg_set,                 ;
;                                               &far_ptr_alt_context);        ;
;                                                                             ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_alt_reg_set		PROC                                                  \
			USES DS SI DI,                                        \
			ptr_alt_reg_set:FAR PTR WORD,                             \
			ptr_far_ptr_alt_context:FAR PTR DWORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get the current active alternate map register set or the      ;
	;   .   current mapping context if alternate map register sets are    ;
	;   .   not supported;                                                ;
	;---------------------------------------------------------------------;
	MOVE		AX, get_alt_map_reg_set_fcn 
	MOVE		ES:DI, 0:0
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the current active altername map register set or the     ;
	;   .   current mapping context back to the caller;                   ;
	;---------------------------------------------------------------------;
	MOVE		DS:SI, ptr_alt_reg_set
	MOVE		BH, 0
	MOVE		DS:[SI], BX
	MOVE		DS:SI, ptr_far_ptr_alt_context
	MOVE		DS:[SI], ES:DI

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_alt_reg_set		ENDP

END
