;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM16_C.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_partial_context_size                                ;
;                                                                             ;
;      DESCRIPTION:   This function returns the storage requirements for the  ;
;                     structure passed by the get_partial_context and         ;
;                     set_partial_context functions.  Use this function when  ;
;                     you want to dynamically allocate this space. This       ;
;                     function doesn't require an EMM handle.                 ;
;                                                                             ;
;           PASSED:   pcl.mappable_region_count:                              ;
;                        is the number of pages in the partial map to be      ;
;                        saved by the get_partial_context &                   ;
;                        set_partial_context functions.  This number should   ;
;                        be the same as the mappable_region_count structure   ;
;                        member in the get_partial_context function.          ;
;                                                                             ;
;                     &partial_context_size:                                  ;
;                        is a far pointer to the size of the mapping context  ;
;                        structure.                                           ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     partial_context_size:                                   ;
;                        is the number of bytes that will be transferred to   ;
;                        the application's dest_context area whenever a       ;
;                        program requests the get_partial_context function.   ;
;                                                                             ;
;                        Normally, you just supply a CONTEXT_STRUCT structure ;
;                        which contains an array of the largest space         ;
;                        possible (currently 255 bytes).  However, if you     ;
;                        want to dynamically allocate the exact amount of     ;
;                        space required to save a context, use this           ;
;                        function to get the size needed (see example below). ;
;                                                                             ;
;                        The size of the dest_context depends on the expanded ;
;                        memory system configuration and the implementation   ;
;                        of the expanded memory manager.  Therefore, it will  ;
;                        vary between hardware configurations and  memory     ;
;                        manager implementations.                             ;
;                                                                             ;
; C USE CONVENTION:   unsigned int                status;                     ;
;                     unsigned int                partial_context_size;       ;
;                     PARTIAL_CONTEXT_LIST_STRUCT pcl [MAX_MAPPABLE_REGIONS]; ;
;                     void                        *context;                   ;
;                                                                             ;
;                     pcl.mappable_region_count = 2;                          ;
;                     status = get_partial_context_size                       ;
;                                               (pcl.mappable_region_count,   ;
;                                                &partial_context_size);      ;
;                     if (status == PASSED)                                   ;
;                     {                                                       ;
;                        context = malloc (partial_context_size);             ;
;                        if (context == NULL)                                 ;
;                           /* error condition (no memory to allocate) */     ;
;                        else                                                 ; 
;                        {                                                    ;
;                           status = get_partial_context                      ;
;                                               ((CONTEXT_STRUCT *) context); ;
;                           if (status == PASSED)                             ;
;                              printf ("context saved\n");                    ;
;                           else                                              ;
;                              /* error condition */                          ;
;                        }                                                    ;
;                     }                                                       ;
;                     else                                                    ;
;                        /* error condition */                                ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_partial_context_size	PROC                                          \
				context_struct_count:WORD,                    \
				ptr_context_size:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get the size of the partial map context which EMM returns;    ;
	;---------------------------------------------------------------------;
	MOVE		AX, get_size_p_page_map_array_fcn
	MOVE		BX, context_struct_count
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the size of the partial map context back to the caller;  ;
	;---------------------------------------------------------------------;
	MOVE		ES:BX, ptr_context_size
	MOVE		ES:[BX], AX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_partial_context_size	ENDP

END
