;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM28_E.ASM                                             ;
;                                                                             ;
; OS FUNCTION NAME:   dealloc_alt_reg_set                                     ;
;                                                                             ;
;      DESCRIPTION:   This function returns the alternate map register set to ;
;                     the memory manager for future use.  The memory manager  ;
;                     may then reallocate the alternate map register set when ;
;                     needed.  This function also makes the mapping context   ;
;                     of the alternate map register specified unavailable for ;
;                     reading or writing (unmapping). This protects the pages ;
;                     previously mapped in an alternate map register set by   ;
;                     making them inaccessible.  Note that the current        ;
;                     alternate map register set cannot be deallocated.  This ;
;                     makes all memory which was currently mapped into        ;
;                     conventional and expanded memory inaccessible.          ;
;                                                                             ;
;           PASSED:   alt_reg_set:                                            ;
;                        is the number of the alternate map register set to   ;
;                        deallocate.  Map register set zero cannot be         ;
;                        allocated or deallocated.  However, if alternate map ;
;                        register set zero is specified and this function is  ;
;                        invoked, no error will be returned.  The function    ;
;                        invocation is ignored in this case.                  ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int alt_reg_set;                               ;
;                                                                             ;
;                     status = dealloc_alt_reg_set (alt_reg_set);             ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

dealloc_alt_reg_set	PROC	                                              \
			alt_reg_set:WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   deallocate an alternate map register set previously           ;
	;   .   allocated from EMM;                                           ;
	;---------------------------------------------------------------------;
	MOVE		AX, deallocate_alt_map_regs_fcn
	MOVE		BX, alt_reg_set
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

dealloc_alt_reg_set		ENDP

END
