;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM21_C.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_total_handles                                       ;
;                                                                             ;
;      DESCRIPTION:   This function returns the total number of handles that  ;
;                     the memory manager supports, including the operating    ;
;                     system handle (handle value 0).                         ;
;                                                                             ;
;           PASSED:   &max_handle_count:                                      ;
;                        is a far pointer to the maximum number of handles    ;
;                        a program may request the memory manager to allocate ;
;                        memory to.  The value returned includes the          ;
;                        operating system handle (handle value 0).            ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     max_handle_count:                                       ;
;                        is the maximum number of handles a program may       ;
;                        request the memory manager to allocate memory to.    ;
;                        The value returned includes the operating system     ;
;                        handle (handle value 0).                             ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int max_handle_count;                          ;
;                                                                             ;
;                     status = get_total_handles (&max_handle_count);         ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_total_handles	PROC                                                  \
			ptr_handle:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get the MAXIMUM number of handles supported by the EMM;       ;
	;---------------------------------------------------------------------;
	MOVE		AX, get_total_handles_fcn
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the count of the MAXIMUM number of handles supported     ;
	;   .   by the EMM back to the caller;                                ;
	;---------------------------------------------------------------------;
	MOVE		DX, BX
	MOVE		ES:BX, ptr_handle
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_total_handles	ENDP

END
