;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM19_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_handle_attrib                                       ;
;                                                                             ;
;      DESCRIPTION:   This function returns the attribute associated with a   ;
;                     handle.  The attributes are volatile or non-volatile.   ;
;                                                                             ;
;                     If the handle's attribute has been set to non-volatile, ;
;                     the handle, its name (if it is assigned one), and the   ;
;                     contents of the pages allocated to the handle are all   ;
;                     maintained after a warm boot.  However, this function   ;
;                     may be disabled with a user option or may not be        ;
;                     supported by the memory board or system hardware.       ;
;                                                                             ;
;                     A volatile handle attribute instructs the memory        ;
;                     manager to deallocate both the handle and the pages     ;
;                     allocated to it after a warm boot.  If all handles      ;
;                     have the volatile attribute (the default attribute)     ;
;                     at warm boot, the handle directory will be empty and    ;
;                     all of expanded memory will be initialized to zero      ;
;                     immediately after a warm boot.                          ;
;                                                                             ;
;           PASSED:   &attrib:                                                ;
;                        is a far pointer to the open EMM handle's attribute. ;
;                                                                             ;
;                     handle:                                                 ;
;                        is an open EMM handle.                               ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     attrib:                                                 ;
;                        is an open EMM handle's attribute.  The only         ;
;                        attributes a handle may have are volatile or         ;
;                        non-volatile.  A value of zero indicates the handle  ;
;                        is volatile.  A value of one indicates that the      ;
;                        handle is non-volatile.                              ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int attrib;                                    ;
;                     unsigned int handle;                                    ;
;                                                                             ;
;                     status = get_handle_attrib (&attrib,                    ;
;                                                 handle);                    ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_handle_attrib	PROC                                                  \
			ptr_attrib:FAR PTR WORD,                                  \
			handle:WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get the current attribute of the specified handle;            ;
	;---------------------------------------------------------------------;
	MOVE		AX, get_handle_attrib_fcn
	MOVE		DX, handle
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the current handle attribute back to the caller;         ;
	;---------------------------------------------------------------------;
	MOVE		DH:DL, 0:AL
	MOVE		ES:BX, ptr_attrib
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_handle_attrib	ENDP

END
