;RM82TS8,16,24,32,40,48
; A selection of underutilized utilities
; Updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

DOSSEG
.model medium, basic
.code

; Please do not remove
Copyright       DB    13,10,'Copyright Copr. (C) 1990 Sidney J. Kelly',13,10
Copyright1      DB    'All Rights Reserved',13,10,26

;=============================================================================
; DECLARE SUB DRIVEALIAS ( ASSIGN%, APPEND%, NETWORK%, SHARE%)
; CALL DRIVEALIAS( ASSIGN%, APPEND%, NETWORK%, SHARE%)
; Purpose: To warn programmer that the logical drives may not be as they
;  	seem, so if programmer desires to do some technical manipulation
; 	he will be aware that it may not work.
;=============================================================================

EVEN
DRIVEALIAS PROC FAR BASIC \
ASSIGN:WORD, APPEND:WORD, NETWORK:WORD, SHARE:WORD

; Find if ASSIGN.EXE/ASSIGN.COM is installed
; Return -1 if yes

	Mov     AX,3000h	; check if DOS version > 2.xx
	Int     21h
	Cmp     AL,3            ; AL contains the major version
	JB      Bad_Dos_Ver     ; If less than 3.00, Error

	Mov     BX,ASSIGN       ; get address of variable
	Xor     CX,CX           ; assume that routine is not installed
	Mov	AX,0600h	; call the check function
	Clc                     ; make sure carry is clear
        Int	2fh
	JC	@f
        Cmp	AL,0FFh		; as with most other routines
	JNE	@f		; use AL = FFh to report installed
	Mov     CX,-1           ; report installed
@@:
	Mov     [BX],CX         ; store value in address

; Find if APPEND.EXE is installed
; Return -1 if yes
	Mov     BX,APPEND
	Xor     CX,CX
	Mov	AX,0B700h
	Clc
        Int	2fh
	Jc	@f
        Cmp	AL,0ffh         ; if AL = 0ffh if installed
	JNE	@f
	Mov     CX,-1
@@:
	Mov     [BX],CX

COMMENT		|*
; Find if DRIVER.SYS is installed
; Return -1 if yes,
;  Not tested for because always returns yes under DOS 3.2 +
	Mov     BX,DRIVER
	Xor     CX,CX
	Mov	AX,0800h
	CLC
	Int	2fh
	JC	@f
	Cmp	AL,0FFh
	JNE	@f
	Mov     CX,-1
@@:
	Mov     [BX],CX
		|*

; Find if NETWORK REDIRECTOR is installed
; Return -1 if yes
	Mov     BX,NETWORK
	Xor     CX,CX
	Mov	AX,1100h
	Clc
	Int	2fh
	JC	@f
	Cmp	AL,0FFh
	JNE	@f
	Mov     CX,-1
@@:
	Mov     [BX],CX

; Find if SHARE.EXE is installed
; Return -1 if yes
	Mov     BX,SHARE
	Xor     CX,CX
	Mov	AX,1000h
	Clc
	Int	2fh
	JC	@f
	Cmp	AL,0FFh
	JNE	@f
	Mov     CX,-1
@@:
	Mov     [BX],CX
Ender1:
	Ret			; quit, MASM will claim up stack

Bad_Dos_Ver:                    ; because DOS Version 2.xx
	Xor	AX,AX           ; does not initialize the
	Mov     BX,ASSIGN       ; vector to INT 2Fh
	Mov     [BX],AX         ; (unless PRINT.COM is installed)
	Mov     BX,APPEND       ; rather than crash we merely
	Mov     [BX],AX         ; report not installed
	Mov     BX,NETWORK
	Mov     [BX],AX
	Mov     BX,SHARE
	Mov     [BX],AX
        Jmp	Short Ender1
DRIVEALIAS ENDP

;=============================================================================
; DECLARE SUB SUBSTDRIVE (Drive$,ErrCode%)
; CALL SUBSTDRIVE(Drive$,ErrCode%)
;
; Input:
;       Drive$ = letter between A to Z
;       If Drive$ ="" or is outside range, assume it is a request for 
;       default drive information.
;
; Purpose: To warn programmer that the logical drives may not be as they
;       seem, so if programmer desires to do some technical manipulation
;       he will be aware that it may not work.
;
; Returns:
;       0 = o.k.
;       1 = invalid drive
;       2 = SUBST active on drive
;=============================================================================

EVEN
SUBSTDRIVE PROC FAR BASIC DRIVE:WORD, ERRCODE:WORD

	Mov     BX,DRIVE          ; get drive letter
	Mov     CX,[BX]           ; get length of string in CX
	Jcxz    Read_Default      ; if a null string, read default
	
	Mov     BX,[BX+2]         ; get actual string address
	Mov     DL,[BX]           ; read string
	Cmp	DL,'A'		  ; is it less than 'A'
	JB	Read_Default      ; if less, then read default
	Cmp	DL,'z'		  ; is it greater than 'z' 
	JA	Read_Default      ; if greater, then read default 
	And     DL,1Fh            ; allow A to Z or a to z
	Cmp     DL,0              ; is Drive$ = 0
	JE      Read_Default      ; attempt to read default, jmp & doit
	Cmp     DL,1Ah            ; final range check if 1 to 26
	JA      Read_Default      ; greater than 26 so read default
	Mov     CL,DL             ; save input in CL
	Jmp	Short Read_DPB    ; skip default drive stuff

Read_Default:
	Mov	AH,19h		  ; read default drive
	Int	21h		  ; into AL
	Inc	AL		  ; make it one biased
	Mov	CL,AL		  ; put drive letter in CL for later comparison
	Xor	DL,DL		  ; indicate want default drive block

Read_DPB:
	Push	DS		  ; save DS because Get DPB changes it
	Mov     AH,32h            ; read disk parameter block (undocumented)
	Int     21h		  ; works in DOS Ver 2.x,3.x & 4.x
	Or      AL,AL             ; AL = 0 if drive exists
	JZ      Drive_Exists
	Mov     AX,1              ; else, report drive invalid
	Jmp     Short Sub_Finis   ; and quit

Drive_Exists:
	Xor     AX,AX             ; assume no SUBST
	Mov     DL, DS:[BX]       ; get actual logical drive number
	Inc     DL                ; remove 0 bias
	Cmp     DL,CL             ; does input == output?
	JE      Sub_Finis         ; yes, report no error
	Mov     AX,2              ; else, report SUBST is installed

Sub_Finis:
	Pop     DS
	Mov     BX,ERRCODE        ; read address
	Mov     [BX],AX           ; store AX in ErrCode%
	Ret
SUBSTDRIVE      ENDP
END
