/* vesa.h */
#ifndef __VESALIB__
#define __VESALIB__

#ifndef __VIDLIB__
      unsigned int  _screen_width;
      unsigned int  _screen_length;
          char far *_screen_start;
#endif

struct	vesainfo {
	char	signature[4];   /* shoud be "VESA" */
        int     version;
	char far *OEMinfo;
	char	capabilities[4];
	unsigned int far *modeptr;
	char	Reserved[246];
};


struct	vesamodeinfo {
	int	modeattr;
	char	WindowAattr;
	char	WindowBattr;
	int	granularity;
	int	size;
	int	Asegment;
	int	Bsegment;
	void    (far *Windowsetptr)();
	int	bytesperline;

	/* optional information (when bit 1 of modeattr is set)	*/

	int	XPixels;
	int	YPixels;
	char	charwidth;
	char	charlength;
	char	planes;
	char	bits;
	char	banks;
	char	memorymodel;
	char	banksize;               /* in k bytes */
	char	Reserved[246];
};

#ifdef VESA
struct          vesainfo   Vinfo;
struct      vesamodeinfo   Vminfo;
            unsigned int   vesapage=0;
            unsigned int   Vnext_break;
            unsigned int   Vnext_break_offset;
#else
extern   struct vesainfo   Vinfo;
extern struct vesamodeinfo Vminfo;
extern        unsigned int vesapage;
extern        unsigned int Vnext_break;
extern        unsigned int Vnext_break_offset;
#endif

int              VESAmode(unsigned int mode, char *palette);
int              isVESA(void);           /* 1=VESA ok., 0=no VESA */
int              isVESAmode(int mode);   /* see if a VESA mode is valid */
struct vesainfo *getVESAinfo(int mode);

#define VESApage_offset(y,x) \
   (unsigned int)( (y-Vnext_break)*_screen_width + (x-Vnext_break_offset) - 1)
int        VESAfirst_page(int scan, int offset);
void       VESAnext_break(void);      /* used by setpages to set Vnext_break
                                         and Vnext_break_offset */
int        VESAsetpage(unsigned page);
int        VESAsetpagew(char window, unsigned page);
int        VESAsetpagewbios(char window, unsigned page);

int VESAfill256(unsigned dx, unsigned dy, unsigned sdx, unsigned sdy,
                unsigned color);
/* video to video copy */
int VESAcopy256(unsigned dx, unsigned dy,
             unsigned sx, unsigned sy,
             unsigned sdx, unsigned sdy);
int VESAcopy16(unsigned dx, unsigned dy,
            unsigned sx, unsigned sy, unsigned sdx, unsigned sdy);

/* System memory to video copy */
int VESAdisp256(unsigned dx, unsigned dy,
             char far *s, unsigned sw, unsigned sl,
             unsigned sx, unsigned sy,
             unsigned sdx, unsigned sdy, int direction);
int VESAdisp16(unsigned dx, unsigned dy,
            char far *s, unsigned sw, unsigned sl,
                     unsigned sx, unsigned sy, unsigned sdx, unsigned sdy);

/* Video to System memory copy */
int VESAcapt256(char far *d, unsigned dw, unsigned dl,
                      unsigned dx, unsigned dy,
                      unsigned sx, unsigned sy,
                      unsigned sdx, unsigned sdy, int direction);
int VESAcapt16(char far *d, unsigned dw, unsigned dl,
                     unsigned dx, unsigned dy,
                     unsigned sx, unsigned sy, unsigned sdx, unsigned sdy);



#endif