	PAGE	,132
	TITLE MNEM48 - 7 SEP 1985

; ****************************************************************
; **								**
; **		      MNEMONIC AND BYTES TABLES			**
; **								**
; ****************************************************************

; ..... MODULE CONNECTION POINTS .....

	PUBLIC	MNEM
	PUBLIC	BYTES

;
; ..... CONSTANTS .....

TAB	EQU	09H		; ASCII TAB
RS	EQU	1EH		; ASCII RECORD SEPARATOR
FS	EQU	1CH		; ASCII FIELD SEPARATOR
	PAGE
DATA	SEGMENT PUBLIC		; DATA SEGMENT

; ****************************************************************
; **								**
; **			  MNEMONIC TABLE			**
; **								**
; ** EACH ENTRY IN THIS TABLE CONTAINS AN ASCII STRING THAT IS	**
; ** TO BE USED AS A MNEMONIC FOR THE PROGRAM DASM.  TABLE EN-	**
; ** TRIES ARE SEPARATED BY AN ASCII RECORD SEPARATOR AND THE	**
; ** TABLE IS TERMINATED BY AN ASCII FIELD SEPARATOR.  THE	**
; ** TABLE IS ORGANIZED BY ASCENDING OP-CODE.  UNDEFINED	**
; ** OP-CODES ARE ASSIGNED THE MNEMONIC "DB".			**
; **								**
; ****************************************************************

MNEM	EQU	THIS BYTE
	DB	'NOP',TAB,RS		; 00
	DB	'DB',TAB,RS		; 01
	DB	'OUTL',TAB,'BUS,A',RS	; 02
	DB	'ADD',TAB,'A,#',RS	; 03
	DB	'JMP',TAB,'0',RS 	; 04
	DB	'EN',TAB,'I',RS		; 05
	DB	'DB',TAB,RS		; 06
	DB	'DEC',TAB,'A',RS 	; 07
	DB	'DB',TAB,RS		; 08
	DB	'IN',TAB,'A,P1',RS	; 09
	DB	'IN',TAB,'A,P2',RS	; 0A
	DB	'DB',TAB,RS		; 0B
	DB	'MOVD',TAB,'A,P4',RS	; 0C
	DB	'MOVD',TAB,'A,P5',RS	; 0D
	DB	'MOVD',TAB,'A,P6',RS	; 0E
	DB	'MOVD',TAB,'A,P7',RS	; 0F
	PAGE
	DB	'INC',TAB,'@R0',RS	; 10
	DB	'INC',TAB,'@R1',RS	; 11
	DB	'JB0',TAB,RS		; 12
	DB	'ADDC',TAB,'A,#',RS	; 13
	DB	'CALL',TAB,'0',RS	; 14
	DB	'DIS',TAB,'I',RS 	; 15
	DB	'JTF',TAB,RS		; 16
	DB	'INC',TAB,'A',RS 	; 17
	DB	'INC',TAB,'R0',RS	; 18
	DB	'INC',TAB,'R1',RS	; 19
	DB	'INC',TAB,'R2',RS	; 1A
	DB	'INC',TAB,'R3',RS	; 1B
	DB	'INC',TAB,'R4',RS	; 1C
	DB	'INC',TAB,'R5',RS	; 1D
	DB	'INC',TAB,'R6',RS	; 1E
	DB	'INC',TAB,'R7',RS	; 1F
	PAGE
	DB	'XCH',TAB,'A,@R0',RS	; 20
	DB	'XCH',TAB,'A,@R1',RS	; 21
	DB	'DB',TAB,RS		; 22
	DB	'MOV',TAB,'A,#',RS	; 23
	DB	'JMP',TAB,'1',RS 	; 24
	DB	'EN',TAB,'TCNTI',RS	; 25
	DB	'JNT0',TAB,RS		; 26
	DB	'CLR',TAB,'A',RS 	; 27
	DB	'XCH',TAB,'A,R0',RS	; 28
	DB	'XCH',TAB,'A,R1',RS	; 29
	DB	'XCH',TAB,'A,R2',RS	; 2A
	DB	'XCH',TAB,'A,R3',RS	; 2B
	DB	'XCH',TAB,'A,R4',RS	; 2C
	DB	'XCH',TAB,'A,R5',RS	; 2D
	DB	'XCH',TAB,'A,R6',RS	; 2E
	DB	'XCH',TAB,'A,R7',RS	; 2F
	PAGE
	DB	'XCHD',TAB,'A,@R0',RS	; 30
	DB	'XCHD',TAB,'A,@R1',RS	; 31
	DB	'JB1',TAB,RS		; 32
	DB	'DB',TAB,RS		; 33
	DB	'CALL',TAB,'1',RS	; 34
	DB	'DIS',TAB,'TCNTI',RS	; 35
	DB	'JT0',TAB,RS		; 36
	DB	'CPL',TAB,'A',RS 	; 37
	DB	'DB',TAB,RS		; 38
	DB	'OUTL',TAB,'P1,A',RS	; 39
	DB	'OUTL',TAB,'P2,A',RS	; 3A
	DB	'DB',TAB,RS		; 3B
	DB	'MOVD',TAB,'P4,A',RS	; 3C
	DB	'MOVD',TAB,'P5,A',RS	; 3D
	DB	'MOVD',TAB,'P6,A',RS	; 3E
	DB	'MOVD',TAB,'P7,A',RS	; 3F
	PAGE
	DB	'ORL',TAB,'A,@R0',RS	; 40
	DB	'ORL',TAB,'A,@R1',RS	; 41
	DB	'MOV',TAB,'A,T',RS	; 42
	DB	'ORL',TAB,'A,#',RS	; 43
	DB	'JMP',TAB,'2',RS 	; 44
	DB	'STRT',TAB,'CNT',RS	; 45
	DB	'JNT1',TAB,RS		; 46
	DB	'SWAP',TAB,'A',RS	; 47
	DB	'ORL',TAB,'A,R0',RS	; 48
	DB	'ORL',TAB,'A,R1',RS	; 49
	DB	'ORL',TAB,'A,R2',RS	; 4A
	DB	'ORL',TAB,'A,R3',RS	; 4B
	DB	'ORL',TAB,'A,R4',RS	; 4C
	DB	'ORL',TAB,'A,R5',RS	; 4D
	DB	'ORL',TAB,'A,R6',RS	; 4E
	DB	'ORL',TAB,'A,R7',RS	; 4F
	PAGE
	DB	'ANL',TAB,'A,@R0',RS	; 50
	DB	'ANL',TAB,'A,@R1',RS	; 51
	DB	'JB2',TAB,RS		; 52
	DB	'ANL',TAB,'A,#',RS	; 53
	DB	'CALL',TAB,'2',RS	; 54
	DB	'STRT',TAB,'T',RS	; 55
	DB	'JT1',TAB,RS		; 56
	DB	'DA',TAB,'A',RS		; 57
	DB	'ANL',TAB,'A,R0',RS	; 58
	DB	'ANL',TAB,'A,R1',RS	; 59
	DB	'ANL',TAB,'A,R2',RS	; 5A
	DB	'ANL',TAB,'A,R3',RS	; 5B
	DB	'ANL',TAB,'A,R4',RS	; 5C
	DB	'ANL',TAB,'A,R5',RS	; 5D
	DB	'ANL',TAB,'A,R6',RS	; 5E
	DB	'ANL',TAB,'A,R7',RS	; 5F
	PAGE
	DB	'ADD',TAB,'A,@R0',RS	; 60
	DB	'ADD',TAB,'A,@R1',RS	; 61
	DB	'MOV',TAB,'T,A',RS	; 62
	DB	'DB',TAB,RS		; 63
	DB	'JMP',TAB,'3',RS 	; 64
	DB	'STOP',TAB,'TCNT',RS	; 65
	DB	'DB',TAB,RS		; 66
	DB	'RRC',TAB,'A',RS 	; 67
	DB	'ADD',TAB,'A,R0',RS	; 68
	DB	'ADD',TAB,'A,R1',RS	; 69
	DB	'ADD',TAB,'A,R2',RS	; 6A
	DB	'ADD',TAB,'A,R3',RS	; 6B
	DB	'ADD',TAB,'A,R4',RS	; 6C
	DB	'ADD',TAB,'A,R5',RS	; 6D
	DB	'ADD',TAB,'A,R6',RS	; 6E
	DB	'ADD',TAB,'A,R7',RS	; 6F
	PAGE
	DB	'ADDC',TAB,'A,@R0',RS	; 70
	DB	'ADDC',TAB,'A,@R1',RS	; 71
	DB	'JB3',TAB,RS		; 72
	DB	'DB',TAB,RS		; 73
	DB	'CALL',TAB,'3',RS	; 74
	DB	'ENT0',TAB,'CLK',RS	; 75
	DB	'JF1',TAB,RS		; 76
	DB	'RR',TAB,'A',RS		; 77
	DB	'ADDC',TAB,'A,R0',RS	; 78
	DB	'ADDC',TAB,'A,R1',RS	; 79
	DB	'ADDC',TAB,'A,R2',RS	; 7A
	DB	'ADDC',TAB,'A,R3',RS	; 7B
	DB	'ADDC',TAB,'A,R4',RS	; 7C
	DB	'ADDC',TAB,'A,R5',RS	; 7D
	DB	'ADDC',TAB,'A,R6',RS	; 7E
	DB	'ADDC',TAB,'A,R7',RS	; 7F
	PAGE
	DB	'MOVX',TAB,'A,@R0',RS	; 80
	DB	'MOVX',TAB,'A,@R1',RS	; 81
	DB	'DB',TAB,RS		; 82
	DB	'RET',TAB,RS		; 83
	DB	'JMP',TAB,'4',RS 	; 84
	DB	'CLR',TAB,'F0',RS	; 85
	DB	'JNI',TAB,RS		; 86
	DB	'DB',TAB,RS		; 87
	DB	'ORL',TAB,'BUS,#',RS	; 88
	DB	'ORL',TAB,'P1,#',RS	; 89
	DB	'ORL',TAB,'P2,#',RS	; 8A
	DB	'DB',TAB,RS		; 8B
	DB	'ORLD',TAB,'P4,A',RS	; 8C
	DB	'ORLD',TAB,'P5,A',RS	; 8D
	DB	'ORLD',TAB,'P6,A',RS	; 8E
	DB	'ORLD',TAB,'P7,A',RS	; 8F
	PAGE
	DB	'MOVX',TAB,'@R0,A',RS	; 90
	DB	'MOVX',TAB,'@R1,A',RS	; 91
	DB	'JB4',TAB,RS		; 92
	DB	'RETR',TAB,RS		; 93
	DB	'CALL',TAB,'4',RS	; 94
	DB	'CPL',TAB,'F0',RS	; 95
	DB	'JNZ',TAB,RS		; 96
	DB	'CLR',TAB,'C',RS 	; 97
	DB	'ANL',TAB,'BUS,#',RS	; 98
	DB	'ANL',TAB,'P1,#',RS	; 99
	DB	'ANL',TAB,'P2,#',RS	; 9A
	DB	'DB',TAB,RS		; 9B
	DB	'ANLD',TAB,'P4,A',RS	; 9C
	DB	'ANLD',TAB,'P5,A',RS	; 9D
	DB	'ANLD',TAB,'P6,A',RS	; 9E
	DB	'ANLD',TAB,'P7,A',RS	; 9F
	PAGE
	DB	'MOV',TAB,'@R0,A',RS	; A0
	DB	'MOV',TAB,'@R1,A',RS	; A1
	DB	'DB',TAB,RS		; A2
	DB	'MOVP',TAB,'A,@A',RS	; A3
	DB	'JMP',TAB,'5',RS 	; A4
	DB	'CLR',TAB,'F1',RS	; A5
	DB	'DB',TAB,RS		; A6
	DB	'CPL',TAB,'C',RS 	; A7
	DB	'MOV',TAB,'R0,A',RS	; A8
	DB	'MOV',TAB,'R1,A',RS	; A9
	DB	'MOV',TAB,'R2,A',RS	; AA
	DB	'MOV',TAB,'R3,A',RS	; AB
	DB	'MOV',TAB,'R4,A',RS	; AC
	DB	'MOV',TAB,'R5,A',RS	; AD
	DB	'MOV',TAB,'R6,A',RS	; AE
	DB	'MOV',TAB,'R7,A',RS	; AF
	PAGE
	DB	'MOV',TAB,'@R0,#',RS	; B0
	DB	'MOV',TAB,'@R1,#',RS	; B1
	DB	'JB5',TAB,RS		; B2
	DB	'JMPP',TAB,'@A',RS	; B3
	DB	'CALL',TAB,'5',RS	; B4
	DB	'CPL',TAB,'F1',RS	; B5
	DB	'JF0',TAB,RS		; B6
	DB	'DB',TAB,RS		; B7
	DB	'MOV',TAB,'R0,#',RS	; B8
	DB	'MOV',TAB,'R1,#',RS	; B9
	DB	'MOV',TAB,'R2,#',RS	; BA
	DB	'MOV',TAB,'R3,#',RS	; BB
	DB	'MOV',TAB,'R4,#',RS	; BC
	DB	'MOV',TAB,'R5,#',RS	; BD
	DB	'MOV',TAB,'R6,#',RS	; BE
	DB	'MOV',TAB,'R7,#',RS	; BF
	PAGE
	DB	'DB',TAB,RS		; C0
	DB	'DB',TAB,RS		; C1
	DB	'DB',TAB,RS		; C2
	DB	'DB',TAB,RS		; C3
	DB	'JMP',TAB,'6',RS 	; C4
	DB	'SEL',TAB,'RB0',RS	; C5
	DB	'JZ',TAB,RS		; C6
	DB	'MOV',TAB,'A,PSW',RS	; C7
	DB	'DEC',TAB,'R0',RS	; C8
	DB	'DEC',TAB,'R1',RS	; C9
	DB	'DEC',TAB,'R2',RS	; CA
	DB	'DEC',TAB,'R3',RS	; CB
	DB	'DEC',TAB,'R4',RS	; CC
	DB	'DEC',TAB,'R5',RS	; CD
	DB	'DEC',TAB,'R6',RS	; CE
	DB	'DEC',TAB,'R7',RS	; CF
	PAGE
	DB	'XRL',TAB,'A,@R0',RS	; D0
	DB	'XRL',TAB,'A,@R1',RS	; D1
	DB	'JB6',TAB,RS		; D2
	DB	'XRL',TAB,'A,#',RS	; D3
	DB	'CALL',TAB,'6',RS	; D4
	DB	'SEL',TAB,'RB1',RS	; D5
	DB	'DB',TAB,RS		; D6
	DB	'MOV',TAB,'PSW,A',RS	; D7
	DB	'XRL',TAB,'A,R0',RS	; D8
	DB	'XRL',TAB,'A,R1',RS	; D9
	DB	'XRL',TAB,'A,R2',RS	; DA
	DB	'XRL',TAB,'A,R3',RS	; DB
	DB	'XRL',TAB,'A,R4',RS	; DC
	DB	'XRL',TAB,'A,R5',RS	; DD
	DB	'XRL',TAB,'A,R6',RS	; DE
	DB	'XRL',TAB,'A,R7',RS	; DF
	PAGE
	DB	'DB',TAB,RS		; E0
	DB	'DB',TAB,RS		; E1
	DB	'DB',TAB,RS		; E2
	DB	'MOVP3',TAB,'A,@A',RS	; E3
	DB	'JMP',TAB,'7',RS 	; E4
	DB	'SEL',TAB,'MB0',RS	; E5
	DB	'JNC',TAB,RS		; E6
	DB	'RL',TAB,'A',RS		; E7
	DB	'DJNZ',TAB,'R0,',RS	; E8
	DB	'DJNZ',TAB,'R1,',RS	; E9
	DB	'DJNZ',TAB,'R2,',RS	; EA
	DB	'DJNZ',TAB,'R3,',RS	; EB
	DB	'DJNZ',TAB,'R4,',RS	; EC
	DB	'DJNZ',TAB,'R5,',RS	; ED
	DB	'DJNZ',TAB,'R6,',RS	; EE
	DB	'DJNZ',TAB,'R7,',RS	; EF
	PAGE
	DB	'MOV',TAB,'A,@R0',RS	; F0
	DB	'MOV',TAB,'A,@R1',RS	; F1
	DB	'JB7',TAB,RS		; F2
	DB	'DB',TAB,RS		; F3
	DB	'CALL',TAB,'7',RS	; F4
	DB	'SEL',TAB,'MB1',RS	; F5
	DB	'JC',TAB,RS		; F6
	DB	'RLC',TAB,'A',RS 	; F7
	DB	'MOV',TAB,'A,R0',RS	; F8
	DB	'MOV',TAB,'A,R1',RS	; F9
	DB	'MOV',TAB,'A,R2',RS	; FA
	DB	'MOV',TAB,'A,R3',RS	; FB
	DB	'MOV',TAB,'A,R4',RS	; FC
	DB	'MOV',TAB,'A,R5',RS	; FD
	DB	'MOV',TAB,'A,R6',RS	; FE
	DB	'MOV',TAB,'A,R7',RS,FS	; FF
	PAGE
; ****************************************************************
; **								**
; **			   BYTES TABLE				**
; **								**
; ** EACH ENTRY IN THIS TABLE CONTAINS THE NUMBER OF BYTES RE-	**
; ** QUIRED FOR EACH 8048 INSTRUCTION.  THE TABLE IS ORGANIZED	**
; ** BY ACSENDING OP-CODE.  UNDEFINED OP-CODES ARE ASSIGNED	**
; ** ZERO BYTES.  OP-CODES FOR UNCONDITIONAL JUMPS ARE ASSIGNED	**
; ** 3 BYTES.  OP-CODES FOR CONDITIONAL JUMPS ARE ASSIGNED 4	**
; ** BYTES.							**
; **								**
; ****************************************************************

BYTES	EQU	THIS BYTE
	DB	1,0,1,2		; 00
	DB	3,1,0,1		; 04
	DB	0,1,1,0		; 08
	DB	1,1,1,1		; 0C
	DB	1,1,4,2		; 10
	DB	3,1,4,1		; 14
	DB	1,1,1,1		; 18
	DB	1,1,1,1		; 1C
	DB	1,1,0,2		; 20
	DB	3,1,4,1		; 24
	DB	1,1,1,1		; 28
	DB	1,1,1,1		; 2C
	DB	1,1,4,0		; 30
	DB	3,1,4,1		; 34
	DB	0,1,1,0		; 38
	DB	1,1,1,1		; 3C
	DB	1,1,1,2		; 40
	DB	3,1,4,1		; 44
	DB	1,1,1,1		; 48
	DB	1,1,1,1		; 4C
	DB	1,1,4,2		; 50
	DB	3,1,4,1		; 54
	DB	1,1,1,1		; 58
	DB	1,1,1,1		; 5C
	DB	1,1,1,0		; 60
	DB	3,1,0,1		; 64
	DB	1,1,1,1		; 68
	DB	1,1,1,1		; 6C
	DB	1,1,4,0		; 70
	DB	3,1,4,1		; 74
	DB	1,1,1,1		; 78
	DB	1,1,1,1		; 7C
	DB	1,1,0,1		; 80
	DB	3,1,4,0		; 84
	DB	2,2,2,0		; 88
	DB	1,1,1,1		; 8C
	DB	1,1,4,1		; 90
	DB	3,1,4,1		; 94
	DB	2,2,2,0		; 98
	DB	1,1,1,1		; 9C
	DB	1,1,0,1		; A0
	DB	3,1,0,1		; A4
	DB	1,1,1,1		; A8
	DB	1,1,1,1		; AC
	DB	2,2,4,1		; B0
	DB	3,1,4,0		; B4
	DB	2,2,2,2		; B8
	DB	2,2,2,2		; BC
	DB	0,0,0,0		; C0
	DB	3,1,4,1		; C4
	DB	1,1,1,1		; C8
	DB	1,1,1,1		; CC
	DB	1,1,4,2		; D0
	DB	3,1,0,1		; D4
	DB	1,1,1,1		; D8
	DB	1,1,1,1		; DC
	DB	0,0,0,1		; E0
	DB	3,1,4,1		; E4
	DB	4,4,4,4		; E8
	DB	4,4,4,4		; EC
	DB	1,1,4,0		; F0
	DB	3,1,4,1		; F4
	DB	1,1,1,1		; F8
	DB	1,1,1,1		; FC
	PAGE
DATA	ENDS

	END

