; COLOR.ASM
; Uses the  DOS ANSI  driver to alter fore and  background screen colors. 
;  As-is, it changes screen  colors   to white text,  on blue background.  
;  Of course other  ANSI codes  can  be used here as well. Simply replace
;  the number  preceding  the  "m"  with another  code. Keep in mind when 
;  doing so,  that you should have  one "3x" value  and one "4x" value to
;  correspond with foreground, and background, respectively. The DOS ANSI
;  driver must of course, first be loaded via the config.sys file for this 
;  to work.
; Any comments or  questions, I can be reached at: 
;                               CIS #73171,261 ............ Tim Van Dusen

stac    segment stack   'stack'         ; Definition  of "stack"  segment.
        db      0f0h dup(?)             ; Allocate space for stack.
stac    ends                            ; End of stack segment


code segment            'code'          ; Definition  of  "code"  segment.
assume cs:code, ss:stac, ds:code        ; Let assembler know what is where

;+++++++++++++++++++++++++++++++++++++++++
; The  following  are the ANSI translation
;  codes for  addressing  the  video (CON)
; To alter the colors,  simply replace the
;  code preceding the "m" with the desired
;  code, and re-compile.  Code listing  at  
;  end  of  this  program code.

blue_back       db      27,'[44m',10,0  
                db      27,'[2J',0,'$'
white_fore      db      27,'[37m',10,0
                db      27,'[2J',0,'$'
;++++++++++++++++++++++++++++++++++++++++++

start:               ; "Start" routine
push cs              ; Tell  assembler that  the Data can be found
pop  ds              ;  within the code segment.

mov  ah, 09h         ; Dos function to  write to screen, character
                     ;  string ending in "$"
mov  dx, offset blue_back       ; This is the offset that contains 
                                ;  the  ANSI  escape  sequence for 
                                ;  creating  a   blue   background
int  21h                        ; DOS services interrupt

mov  ah, 09h        ; Same as previous paragraph,  different line.
mov  dx, offset white_fore
int  21h

mov  ah,04ch         ; DOS program terminate function
int  21h             ; DOS services interrupt
code ends            ; End of code segment
end  start           ; End of "start" routine

end                  ; End, end, end, end, end,..... :)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; Here are the escape sequences for the various color combinations
; Black background      40m
; Black foreground      30m
; Red background        41m
; Red foreground        31m
; Green background      42m
; Green foreground      32m
; Orange background     43m
; Orange foreground     33m
; Blue background       44m
; Blue foreground       34m
; Magenta background    45m
; Magenta foreground    35m
; Cyan Background       46m
; Cyan Foreground       36m
; White background      47m
; White foreground      37m
;++++++++++++++++++++++++++
