******************************************************************************
*                                                                            *
*   Subject : The main demo of CLIP_CRC                                      *
*                                                                            *
*   Date    : June, 1995                                                     *
*                                                                            *
*   (C) Copyright 1995 by Eric DRU - 42 155 LENTIGNY - FRANCE                *
*                                                                            *
*----------------------------------------------------------------------------*
*                                                                            *
*   To compile :   CLIPPER demo                                              *
*                                                                            *
*   To link    :   RTLINK FI demo, clip_crc                                  *
*                                                                            *
*   To run     :   demo                                                      *
*                                                                            *
******************************************************************************


    #include "directry.ch"


    LOCAL  a_dir, a_name
    LOCAL  nChoose, nCol, nI, nRow 

    * Values 
    * ------
    nChoose :=  0
    nCol    := 10
    nRow    :=  2


    * Screen
    * ======

    CLEAR SCREEN
    FOR nI := 0  TO  MAXROW ()
         @ nI, 00  SAY  REPLICATE ( CHR ( 176 ), MAXCOL () )
    NEXT nI
    @ 00, 00  SAY  " CLIP_CRC 1.0 (June, 95) : a simple demo ...                                   "  COLOR  "N/W" 
    @ 24, 00  SAY  LEFT ( "Directory : " + UPPER ( CURDIR () ) + SPACE ( MAXCOL () ), MAXCOL () )
    

    * Loop
    * ====
    
    DO WHILE .T.

         * Create several arrays
         * ---------------------
         a_dir  := DIRECTORY ( "*.*", "DHS" )
         a_name := ARRAY ( LEN ( a_dir ) )
         AEVAL ( a_name, { | element, position | a_name [ position ] :=    ;
              LEFT ( " " + a_dir [ position, F_NAME ] + SPACE ( 15 ), 15 ) ;
              + "  " + DTOC ( a_dir [ position, F_DATE ] ) + "  " +      ;
              a_dir [ position, F_TIME ] + "  " +                         ;
              STR ( a_dir [ position, F_SIZE ], 8 ) + "  " +              ;
              a_dir [ position, F_ATTR ] + " " } ) 
    
         * Screen
         * ------
         @  nRow + 00, nCol + 00  CLEAR TO  nRow + 20, nCol + 60
         @  nRow + 00, nCol + 00  TO  nRow + 20, nCol + 60
         @  nRow + 01, nCol + 00  SAY  "                           Files                           " 
         @  nRow + 02, nCol + 00  SAY  "Ĵ"  
         @  nRow + 03, nCol + 00  SAY  "     Name          Date      Time      Size    Attrib. "  
         @  nRow + 04, nCol + 00  SAY  "Ĵ"  
         @  nRow + 18, nCol + 00  SAY  "Ĵ"  
         @  nRow + 19, nCol + 00  SAY  " Return : CRC-32  *  Escape : Quit  *  Arrows keys : Move  "  

         * Choose
         * ------
         nChoose := ACHOICE ( nRow + 05, nCol + 01, nRow + 17, nCol + 59, a_name, , , nChoose )
    
         * Escape ?
         * --------
         IF nChoose == 0
              EXIT
         ENDIF

         * Directory ?
         * -----------
         IF "D" $ a_dir [ nChoose, F_ATTR ] 
              * Yeah, it's a path
              * - - - - - - - - -
              RUN ( "CD " + a_dir [ nChoose, F_NAME ] )
              @ 24, 00  SAY  LEFT ( "Directory : " + UPPER ( CURDIR () ) + SPACE ( MAXCOL () ), MAXCOL () )
              nChoose := 0
         ELSE
              * Oh noooo, it's a file
              * - - - - - - - - - - -
              ALERT ( "CRC 32 of " + UPPER ( a_dir [ nChoose, F_NAME ] ) + " : ; ;" + clip_crc ( a_dir [ nChoose, F_NAME ] ) )
         ENDIF
    
    * End of loop
    * ===========

    ENDDO

    
    * bye, bye
    * --------
    CLEAR SCREEN


    * End of demo
    * ===========

    RETURN

