
; Butterfly Curve which is generated in polar coordinates by the equation :-

;	rho = exp(cos(theta) - 2*cos(4*theta) + sin(theta/12)**5

;	where:
;		rho is the radial distance of a point from the origin.
;		theta is the angular rotation on radians
;
;		See T.Fay American Math Monthly. 96(5): 442-443	

;	The program makes use of the Vesa Bios Extensions to provide a common
;	interface for accessing the SVGA graphics adaptors and should therefore
;	be hardware independent.  

;	O.K 258 & 260 Modes. Can't use 262/106h as there's no mode data returned
;	by the Get Mode info call 4F01h

;		Code by Ron Thomas,  CompuServe 100332,1160

.MODEL small
.STACK
.386
	EXTRN	drawline:proc,put_p16:proc,falog:proc
	EXTRN	write_string:proc,frame:proc
.DATA
INCLUDE	vesa.inc

CR	EQU	0Dh
LF	EQU	0Ah
plotadot	EQU	routine

parmblock	EQU	THIS WORD
		dw	1		; X1 Coordinate for line 
		dw	1		; Y1 	"	" 
		dw	?		; X2	"	"
		dw	?		; Y2	"	"
colour		db	2		; Green Colour for pixels
		db	0FFh		; Line fill pattern continuous
		dw	0		; Not used
		dw	0		; Not used
routine		dw	put_p16		; Plotting routine address
pixels_per_line	dw	?
bytes_per_line	dw	?
number_of_lines	dw	?
switch		dw	0		;If 0 its replace; if 2 its XOR pixel
WFP		dd	?		;4F05h Windows set function call  
				
old_mode	dw	?		;Old video mode
video_mode	dw	258		;258/102h, 260/104h

co_pro_msg	db	CR,LF,'Co_processor not found$'
not_vesa	db	CR,LF,'VBE not supported, Driver not loaded ?$'

mode_info	db	256	DUP (?)	;Buffer for SVGA mode information

kb_buffer	db	64,0		;Keyboard buffer
		db	64	DUP (?)
bytes_p_line	EQU	mode_info.BytesPerLine
pixelsperline	EQU	mode_info.XResolution
scan_lines	EQU	mode_info.YResolution
video_memory	dw	0A000h		;Address of video memory

temp		dw	?		;Temporary storage
x_offset	dw	280		;Screen offsets
y_offset	dw	290

theta		real4	0.0		;Rotation angle
incr		real4	0.01		;Increment to be used
four		real4	4.0
rep12		real4	0.08333333	;1/12
scale		real4	75.0		;Factor used to magnify image
change_base	real4	2.30258		;Factor to change to natural base
;-------------------------------------------------------------------------------
.CODE
begin:	mov	ax,DGROUP
	mov	ds,ax			;Set up the data segment
	mov	es,ax

	int	11h			;Equipment Check
	test	al,02			;Test for coprocessor
	jz	error1

	mov	ax,4F00h		;Get Super VGA infomation
	mov	di,OFFSET	mode_info
	int	10h

	cmp	al,4Fh			;Is the VESA function suported ?
	jne	error2

	mov	ax,WORD ptr mode_info
	cmp	ax,'EV'			;Check 1st 2 chars of the signature
	jne	error2

	mov	ax,WORD ptr mode_info+2
	cmp	ax,'AS'			;Check 2nd 2 chars of the signature
	jne	error2							

	mov	ax,4F03h		;Extended VGA Bios (get SVGA mode)
	int	10h
	mov	old_mode,bx		;Save old mode

	mov	ax,4F02h		;Set SVGA mode
	mov	bx,video_mode
	int	10h

	mov	ax,4F01h
	mov	cx,video_mode
	mov	di,OFFSET	mode_info
	int	10h			;Get the SVGA mode information

	mov	ax,WORD PTR mode_info+12; Set up the pointer to the FAR window
	mov	word ptr wfp,ax		; positioning function.(Equivalent to
	mov	ax,WORD PTR mode_info+14; 4F05h but much faster)
	mov	word ptr wfp+2,ax	;

	mov	ax,bytes_p_line
	mov	bytes_per_line,ax
	mov	ax,scan_lines
	mov	number_of_lines,ax	
	mov	ax,pixelsperline
	mov	pixels_per_line,ax
	
	mov	es,video_memory

	lea	si,parmblock		;Set address of plotting parameter block

	call	frame			;Draw a frame around screen limits 

;	Start of the Butterfly code

	mov	cx,15700		;Set so that total rotation is 50 Pi
					;using incements of 0.01 radians 

;	Using a larger index does not achieve anything futher as the curve loops
;	back onto itself

	fninit				;Initialise the coprocessor
	 
next:	push	cx			;Save loop index

	fld	theta
	fmul	rep12			;theta/12
	fsin				;sin(theta/12)
	fld	st
	fmul	st,st(1)		;sin(theta/12)**2
	fmul	st,st(1)		;	"	3
	fmul	st,st(1)		;	"	4
	fmul				;	"	5
	fld	theta
	fmul	four			;4*theta,sin(theta/12)**5
	fcos				;cos(4*theta),sin(theta/12)**5
	fld	st	
	fadd				;2*cos(4*theta),sin(theta/12)**5
	fsub				;sin(theta/12)**5 - 2*cos(4*theta)
	fld	theta			;theta,	"	"	"
	fcos				;cos(theta),	"	"
									
;	To evaluate required exp(cos(theta)), we make use of the relationship
;	ln(e**X)=x, therefore alog(cos(theta)) =2.303*exp(cos(theta))   
			          		
	call	falog			;Returns antilog to base 10 in st(0)

	fdiv	change_base		;Divide by 2.303

	fadd			;exp(cos(theta))+sin(theta/12)**5 - 2cos(4theta)
	fld	theta			;theta,(exp(cos(theta))... etc)
	fcos				;cos(theta),(exp(cos(theta))... etc)

;	Convert from polar to cartesian and obtain X coordinate

	fmul	st,st(1)		;cos(theta)*(exp(cos(theta))... etc),
					;(exp(cos(theta))... etc)

	fmul	scale			;Scale to fit the screen
	fistp	temp			;Get integer part of X
	mov	cx,temp
	add	cx,x_offset		;Adjust X position on screen
		
	fld	theta			;theta,(exp(cos(theta)... etc)
	fsin				;sin(theta),(exp(cos(theta))... etc)

;	Convert from polar to cartesian and obtain Y coordinate

	fmul				;sin(theta)*(exp(cos(theta))... etc)

	fmul	scale
	fistp	temp			;Get integer part of Y
	mov	dx,temp
	add	dx,Y_offset		;Ajust Y position on screen

	call	plotadot		;Plot a dot 
	
	fld	theta			;Get current angle
	fadd	incr
	fstp	theta			; increment and go round again

	pop	cx			;Restore loop index
	loop	next

	mov	ah,1			;Wait for a key press so that we can
	int	21h			; inspect the image 
 
	mov	ax,4F02h		;Set SVGA mode
	mov	bx,old_mode		;
	int	10h			;Restore old mode

fin:	mov	ah,4ch
	int	21h			;Return to DOS

error1:	lea	dx,co_pro_msg
	call	write_string		; Inform that there's no co_processor  		
	jmp	SHORT	fin	

error2:	lea	dx,not_vesa
	call	write_string		; Inform that VESA's not supported   		
	jmp	SHORT	fin	
;-------------------------------------------------------------------------------
	end	begin
