title   ASMFLOW_sample_source_file

dosseg

.model small

.code

EXTRN edit_warning             : near
EXTRN insert_blank_line        : near
EXTRN adjust_line_misspellings : near

;--------------------------------------------------------------------
; some code samples to show flow charting and
; tree diagram features of ASMFLOW
;
; NOTE: include files deleted, this file will not assemble
;--------------------------------------------------------------------

PUBLIC join_lines
join_lines PROC near

              push   cx
              push   dx
              push   si
              push   di

              mov    ax, bp
              sar    ax, 1
              cmp    ax, edit_num_lines
              jl     jl_0
              jmp    jl_x
jl_0:
              mov    dx, ds:edit_line_nc[bp]
              cmp    dx, max_line_length
              jle    jl_1
              mov    al, .ew_join_ln_max_len
              call   edit_warning
              jmp    jl_x
jl_1:
              mov    cx, ds:edit_line_nc[bp+2]
              push   cx                       ; save num chars next line
              push   ax                       ; save next line number
              mov    dx, 0
              mul    max_line_length
jl_loop_1:
              mov    edit_buffer[di], al
              inc    di
              loop   jl_loop_1

; adjust misspelling ptrs for joined line

              push   bp
              add    bp, 2
              mov    dx, ds:edit_line_nc[bp-2]
              sub    dx, eol_nc
              sub    dx, max_line_length      ; amount to add (neg so subtract)
              call   adjust_line_misspellings
              pop    bp

; delete next line

              pop    ax                       ; next line number
              call   delete_edit_line

; update number characters for joined line

              pop    cx                       ; num chars line appended
              add    cx, ds:edit_line_nc[bp]
              sub    cx, eol_nc               ; eol chars are overlayed
              mov    ds:edit_line_nc[bp], cx

; update display from joined line to last line

              sar    ax, 1
              mov    cx, edit_num_lines
              sub    cx, ax
              inc    cx
jl_loop_3:
              call   edit_line_out
              loop   jl_loop_3
jl_x:
              pop    di
              pop    si
              pop    dx
              pop    cx
              ret

join_lines ENDP


PUBLIC break_current_line
break_current_line PROC

              push   cx
              push   dx
              push   di
              push   si

              mov    dx, 0
              mov    ax, bx
              div    max_line_length
              sub    cx, dx
              cmp    cx, eol_nc
              jg     bcl_0
              mov    al, .ew_brk_line_aft_eol
              call   edit_warning
              jmp    bcl_x

bcl_0:
             push    ax
             mov     ax, edit_num_lines
             cmp     ax, edit_max_num_lines
             jl      bcl_1
             pop     ax
             mov     al, .ew_brk_line_max_ln
             call    edit_warning
             jmp     bcl_x

bcl_1:
             mov     ax, bp
             sar     ax, 1
             inc     ax
             call    insert_blank_line

             pop     ax
             push    dx
             mov     ds:edit_line_nc[bp+2], cx
             mul     max_line_length
             mov     di, ax                  ; offset to start next line
             mov     si, bx
             pop     dx
             push    ax                      ; save offset to next line
bcl_loop_1:
             mov     al, edit_buffer[si]
             mov     edit_buffer[si], ' '
             mov     edit_buffer[di], al
             inc     si
             inc     di
             loop    bcl_loop_1

;      update offsets for misspellings on new line

             mov     ax, max_line_length
             sub     ax, dx
             mov     dx, ax
             call    adjust_line_misspellings
             call    join_lines

;      add eol characters to end of current line
;      update cursor position to start of next line

             mov     cx, eol_nc
             mov     si, 0
             mov     di, bx
bcl_loop_2:
             mov     al, eol_chars[si]
             mov     edit_buffer[di], al
             inc     si
             inc     di
             loop    bcl_loop_2
             pop     bx                    ; saved offset to start next line

;  update display from current line to end of edit lines

             mov     ax, bp
             mov     cx, edit_num_lines
             sub     cx, ax
bcl_loop_3:
             call    edit_line_out
             inc     ax
             loop    bcl_loop_3
bcl_x:
             call    join_lines
             ret
             pop     si
             pop     di
             pop     dx
             pop     cx
             ret

break_current_line ENDP


; demo of more complex branching for flow charts

orphan proc near

       push cx

       mov  cx, 10
       cmp  ax, -1
top1:
       je   down1
       cmp  ax, 0
up1:
       jc   down1
       je   down2
       inc  ax
       jz   down3
       inc  ax
       jz   down1
       inc  cx
down1:
       cmp  cx, 2
       jc   down2
       je   up1
       inc  ax
       jz   down2
       jc   down3
       add  ax, bx
down2:
       jc   down4
       inc  cx
down3:
       loop top1
up2:
       ret
       ret
down4:
       jmp  up2

orphan endp

         end
