         name      argc
         title     ARGC --- return argument count
;
; ARGC.ASM: return count of command line arguments.
; Treats blanks and tabs as whitespace, carriage 
; return as terminator.
;
; (C) 1987 Ray Duncan
; 
; Call with:  ES:BX = command line
;
; Returns:    AX    = argument count (always >=1)
;             Other registers preserved
;

cr      equ     0dh             ; ASCII carriage return
lf      equ     0ah             ; ASCII line feed
tab     equ     09h             ; ASCII tab
blank   equ     20h             ; ASCII space character

_TEXT   segment word public 'CODE'

        assume  cs:_TEXT

        public  argc            ; make ARGC available to Linker

argc    proc    near            ; count command line arguments

        push    bx              ; save original BX and CX 
        push    cx              ;  for later
        mov     ax,1            ; force count >= 1

argc1:  mov     cx,-1           ; set flag = outside argument

argc2:  inc     bx              ; point to next character 
        cmp     byte ptr es:[bx],cr
        je      argc3           ; exit if carriage return
        cmp     byte ptr es:[bx],blank
        je      argc1           ; outside argument if ASCII blank
        cmp     byte ptr es:[bx],tab    
        je      argc1           ; outside argument if ASCII tab

                                ; otherwise not blank or tab,
        jcxz    argc2           ; jump if already inside argument

        inc     ax              ; else found argument, count it
        not     cx              ; set flag = inside argument
        jmp     argc2           ; and look at next character

argc3:  pop     cx              ; restore original BX and CX
        pop     bx
        ret                     ; return AX = argument count

argc    endp

_TEXT   ends

        end     
