	.xlist
comment % ===============================

              "A-MACROS"
 Control Logic Structure Macros for MASM
                Ver.2.10
    written by Hortens.endoh/ASCII Mag.
        06/Jun/1986 17/Jul/1987

-----------------------------------------

       modified by H.Yoshizaki for
     correcting conditional $_break
        and optimizing $_until.
               11/Feb/1991

======================================= %
	.list
; Using "Control Logic Structure Macros"
; Copyright (C) Jun.1986 Hortense S. Endoh
	.xlist
;
;****************************************
;* I N I T 	 			*	10/May/1986
;****************************************
$_init 	macro	$_gen,$_nf
	ifdif	<$_gen>,<GEN>
		.SALL
	else
		$_gnflg	= 1
	endif
	if1
	        $_imsg  <AMSCLS / Copyright 1986 Hortense S. Endoh >
	        $_imsg  <*** Executing pass 1. One moment Please... ***  >

	else
	        $_imsg  <*** Executing pass 2. One moment Please... ***  >
	endif
;
$_neafar = 1		; Library routine Near/Far ?
	ifidn	<$_nf>,<FAR>
$_neafar = 0
	else
		ifidn	<$_nf>,<COM>
$_neafar = 2
		else
			ifdif	<$_nf>,<NEAR>
				ifnb	<$_nf>
					$_err <Init macro (NEAR/FAR) parameter error>
				endif
			endif
		endif
	endif
endm
;
;****************************************
;* I F					*
;****************************************
$_if	macro	$_stmt,$_cnd,$_log
	if	$_contc
		$_err <Illegal use of macro sequence (1)>
	endif
	$_stmt
	$_nstlv	= $_nstlv+1
	$_trulb	= 0
	$_faulb	= 0
	$_atrf1	= ($_atrf1 shl 1)+1
	$_atrf2	= ($_atrf2 shl 1)+1
	$_atrf3	= $_atrf3 shl 1
	$_cndck	$_cnd,$_log
endm
;
;****************************************
;* E L S E 				*
;****************************************
$_else	macro
	if	$_contc
		$_err <Illegal use of macro sequence (1)>
	endif
	if	($_atrf1 mod 2)-1 or ($_atrf2 mod 2)-1
		$_err <Illegal use of macro sequence (2)>
	endif
	ife	($_atrf3 mod 2)-1
		$_err <Already have $_Else stmt in this block>
	endif
	$_curlb	= $_curlb+1
	$_genjp	j,mp,%$_curlb
	$_endlb	%$_nstlv
	$_setvb	%$_nstlv,%$_curlb
	$_atrf3	= $_atrf3+1
endm
;
;****************************************
;* E N D I F				*
;****************************************
$_endif	macro
	if	$_contc
		$_err <Illegal use of macro sequence (1)>
	endif
	if	($_atrf1 mod 2)-1 or ($_atrf1 mod 2)-1
		$_err <Illegal use of macro sequence (3)>
	endif
	$_endlb	%$_nstlv
	$_atrf1	= ($_atrf1 shr 1)
	$_atrf2	= ($_atrf2 shr 1)
	$_atrf3	= ($_atrf3 shr 1)
	$_nstlv	= $_nstlv-1
endm
;
;****************************************
;* C					*
;****************************************
$_c	macro	$_stmt,$_cnd,$_log
	ife	$_contc
		$_err <Illegal use of macro sequence (4)>
	endif
	$_stmt
	$_cndck	$_cnd,$_log
endm
;
;****************************************
;* W H I L E				*
;****************************************
$_while	macro	$_stmt,$_cnd,$_log,$_blknm
	if	$_contc
		$_err <Illegal use of macro sequence (1)>
	endif
	$_dolv	= $_dolv+1
	$_curlb	= $_curlb+1
	$_sdbvb	%$_dolv,%$_curlb
	$_genlb	%$_curlb
	$_curlb	= $_curlb+1
	$_sdevb	%$_dolv,%$_curlb,$_blknm
	$_nstlv	= $_nstlv+1
	$_trulb	= 0
	$_faulb	= 0
	$_atrf1	= $_atrf1 shl 1
	$_atrf2	= ($_atrf2 shl 1)+1
	$_atrf3	= $_atrf3 shl 1
	ifidn	<$_stmt>,<TRUE>
		$_curlb	= $_curlb+1
		$_setvb	%$_nstlv,%$_curlb
	else
		$_stmt
		$_cndck	$_cnd,$_log
	endif
endm
;
;****************************************
;* D O					*
;****************************************
$_do	macro	$_blknm
	if	$_contc
		$_err <Illegal use of macro sequence (1)>
	endif
	$_dolv	= $_dolv+1
	$_curlb	= $_curlb+1
	$_sdbvb	%$_dolv,%$_curlb
	$_genlb	%$_curlb
	$_curlb	= $_curlb+1
	$_sdevb	%$_dolv,%$_curlb,$_blknm
	$_nstlv	= $_nstlv+1
	$_atrf1	= $_atrf1 shl 1
	$_atrf2	= $_atrf2 shl 1
	$_atrf3	= $_atrf3 shl 1
endm
;
;****************************************
;* B R E A K				*
;****************************************
$_break macro   $_blknm,$_stmt,$_cnd
	if	$_contc
		$_err <Illegal use of macro sequence (1)>
	endif
	$_stmt
        ifnb    <$_blknm>
          ifnb    <$_cnd>
            $_gdenm     $_blknm,$_cnd
          else
            $_gdenm     $_blknm,mp
          endif
        else
          ifnb    <$_cnd>
            $_gdejp     %$_dolv,$_cnd
          else
            $_gdejp     %$_dolv,mp
          endif
        endif
endm
;
;****************************************
;* E N D D O				*
;****************************************
$_enddo	macro
	if	$_contc
		$_err <Illegal use of macro sequence (1)>
	endif
	ife	($_atrf1 mod 2)-1
		$_err <Illegal use of macro sequence (5)>
	endif
	$_genfr  %$_dolv						; 12/Feb/1991
	ife	($_atrf2 mod 2)-1
		$_gdbjp	j,mp,%$_dolv
		$_endlb	%$_nstlv
	endif
	$_extlb	%$_dolv
	$_atrf1	= $_atrf1 shr 1
	$_atrf2	= $_atrf2 shr 1
	$_atrf3	= $_atrf3 shr 1
	$_nstlv	= $_nstlv-1
	$_dolv	= $_dolv-1
endm
;
;****************************************
;* U N T I L				*
;****************************************
$_until	macro	$_stmt,$_cnd,$_log
	if	$_contc
		$_err <Illegal use of macro sequence (1)>
	endif
	ife	($_atrf1 mod 2)-1
		$_err <Illegal use of macro sequence (5)>
	endif
	ifb	<$_cnd>
		ifb	<$_log>
			$_gdbjp	,<$_stmt>,%$_dolv
			$_extlb	%$_dolv
			$_atrf1	= $_atrf1 shr 1
			$_atrf2	= $_atrf2 shr 1
			$_atrf3	= $_atrf3 shr 1
			$_nstlv	= $_nstlv-1
			$_dolv	= $_dolv-1
		endif
	else
		$_stmt
		$_trulb	= 0
		$_faulb	= 0
		$_cndck	$_cnd,$_log
	endif
endm
;
;****************************************
;* S W I T C H				*	10/May/1986
;****************************************
$_switch macro	$_reg,$_blknm
	if	$_contc
		$_err <Illegal use of macro sequence (1)>
	endif
	$_faulb	= 0
	$_nstlv	= $_nstlv+1
	$_dolv	= $_dolv+1
	ifnb	<$_reg>
		$_cnt	= 1
		irp	$_rgchk,<BX,BP,SI,DI,$$$>
			ifidn	<$_reg>,<$_rgchk>
				exitm
			endif
			$_cnt	= $_cnt+1
			ifidn	<$_rgchk>,<$$$>
				$_err <Illegal register description>
			endif
		endm
		shl	$_reg,1
		$_curlb	= $_curlb+1
		$_cscas	= $_cscas+1
		$_smsin	%$_dolv,%$_cnt,%$_curlb,%$_cscas
		org	$+4
		$_atrf4	= ($_atrf4 shl 1)+1
	else
		$_atrf4	= $_atrf4 shl 1
	endif
	$_curlb	= $_curlb+1
	$_sdevb %$_dolv,%$_curlb,$_blknm
	$_atrf1	= ($_atrf1 shl 1)+1
	$_atrf2	= $_atrf2 shl 1
	$_atrf3	= $_atrf3 shl 1
endm
;
;****************************************
;* C A S E				*	10/May/1986
;****************************************
$_case	macro	$_stmt,$_cnd,$_log
	if	$_contc
		$_err <Illegal use of macro sequence (1)>
	endif
	ife	($_atrf1 mod 2) or ($_atrf2 mod 2)
		$_err <Illegal use of macro sequence (6)>
	endif
	ife	($_atrf4 mod 2)-1
		$_curlb	= $_curlb+1
		$_genlb %$_curlb
		irp	$_prc,<$_stmt>
			ifnb	<$_prc>
				$_cont	= $_prc
				$_sssvb	%$_dolv,%$_curlb,%$_cont,<_>
			endif
		endm
		$_faulb	= 1
	else
		if	$_faulb
			$_endlb	%$_nstlv
			$_nstlv	= $_nstlv-1
		endif
		$_stmt
		$_nstlv	= $_nstlv+1
		$_trulb	= 0
		$_faulb	= 0
		$_cndck	$_cnd,$_log
	endif
endm
;
;****************************************
;* D E F A U L T			*	10/May/1986
;****************************************
$_default macro
	if	$_contc
		$_err <Illegal use of macro sequence (1)>
	endif
	ife	($_atrf3 mod 2)-1
		$_err <Already have $_Default stmt in this block>
	endif
	ife	($_atrf4 mod 2)-1
		$_gsnlb	%$_dolv
	else
		$_endlb	%$_nstlv
		$_curlb	= $_curlb+1
		$_setvb	%$_nstlv,%$_curlb
	endif
		$_atrf3	= $_atrf3+1
endm
;
;****************************************
;* E N D S W I T C H			*	10/May/1986
;****************************************
$_endswitch macro
	if	$_contc
		$_err <Illegal use of macro sequence (1)>
	endif
	if	($_atrf1 mod 2)-1
		$_err <Illegal use of macro sequence (7)>
	else
		ife	($_atrf2 mod 2)-1
			$_err <Illegal use of macro sequence (7)>
		endif
	endif
	if	($_atrf4 mod 2)-1
		$_endlb %$_nstlv
	else
		if	($_atrf3 mod 2)-1
			$_gsnlb %$_dolv
		endif
		$_svloc	= $
		$_gorjp	%$_dolv
		org	$_svloc
	endif
	$_extlb	%$_dolv
	$_atrf1	= $_atrf1 shr 1
	$_atrf2	= $_atrf2 shr 1
	$_atrf3	= $_atrf3 shr 1
	$_nstlv	= $_nstlv-2+($_atrf4 mod 2)
	$_atrf4	= $_atrf4 shr 1
	$_dolv	= $_dolv-1
endm
;
;****************************************
;* I F _ (near label jump)		*
;****************************************
$_if_	macro	$_stmt,$_cnd,$_log
	$_lblsn	= -1
	$_if	<$_stmt>,$_cnd,$_log
	$_lblsn	= 0
endm
;
;****************************************
;* E L S E _ (near label jump)		*
;****************************************
$_else_	macro
	$_lblsn	= -1
	$_else
	$_lblsn	= 0
endm
;
;****************************************
;* E N D I F _ (near label jump)	*
;****************************************
$_endif_ macro
	$_endif
endm
;
;****************************************
;* W H I L E _ (near label jump)	*
;****************************************
$_while_ macro	$_stmt,$_cnd,$_log
	$_lblsn	= -1
	$_while	<$_stmt>,$_cnd,$_log
	$_lblsn	= 0
endm
;
;****************************************
;* B R E A K _ (near label jump)	*
;****************************************
$_break_ macro   $_blknm,$_stmt,$_cnd
	$_lblsn	= -1
	$_break  $_blknm,<$_stmt>,$_cnd
	$_lblsn	= 0
endm
;
;****************************************
;* D O _ (near label jump)		*
;****************************************
$_do_	macro
	$_do
endm
;
;****************************************
;* E N D D O _ (near label jump)	*
;****************************************
$_enddo_ macro
	$_lblsn	= -1
	$_enddo
	$_lblsn	= 0
endm
;
;****************************************
;* U N T I L _ (near label jump)	*
;****************************************
$_until_ macro	$_stmt,$_cnd,$_log
	$_lblsn	= -1
	$_until	<$_stmt>,$_cnd,$_log
	$_lblsn	= 0
endm
;
;****************************************
;* C _ (near label jump)		*
;****************************************
$_c_	macro	$_stmt,$_cnd,$_log
	$_lblsn	= -1
	$_c	<$_stmt>,$_cnd,$_log
	$_lblsn	= 0
endm
;
;****************************************
;* S W I T C H _ (near label jump)	*
;****************************************
$_switch_ macro
	$_switch
endm
;
;****************************************
;* C A S E _ (near label jump)		*
;****************************************
$_case_	macro	$_stmt,$_cnd,$_log
	$_lblsn	= -1
	$_case	<$_stmt>,$_cnd,$_log
	$_lblsn	= 0
endm
;
;****************************************
;* D E F A U L T _ (near label jump)	*
;****************************************
$_default_ macro
	$_default
endm
;
;****************************************
;* E N D S W I T C H _ (near label jump)*
;****************************************
$_endswitch_ macro
	$_endswitch
endm
;
;
;===============
;Internal macros
;===============
;
;****************************************	Internal
;* L D P T R (Load pointer)		*	20/Dec/1986
;****************************************	OK
$_ldptr	macro	$_ldseg,$_ldoff,$_ptr1,$_ptr2
;	Check type of pointer.
	$_reg2	= 0
	$_reg1	= 0
	$_lbl	= 0
	ifnb	<$_ptr2>
;               <REG,REG> type pointer
		$_reg2	= 1
	else
		$_tmp	= 1
		irp	$_reg,<AX,BX,CX,DX,SI,DI>
			ifidn	<$_ptr1>,<$_reg>
				$_tmp	= 0
				exitm
			endif
		endm
		ife	$_tmp
;			REG type pointer
			$_reg1	= 1
		else
;			LBL type pointer
			$_lbl	= 1
		endif
	endif
;	Load pointer to register
;	LBL type pointer load
	if	$_lbl
		ife	$_neafar - 2		;COM model
			push	$_ldoff
			mov	$_ldoff,offset $_ptr1
			$_ldstak = 1
		else				;FAR or NEAR model
			push	$_ldseg
			push	$_ldoff
			mov	$_ldoff,seg $_ptr1
			mov	$_ldseg,$_ldoff
			mov	$_ldoff,offset $_ptr1
			$_ldstak = 3
		endif
	endif
;	REG type pointer load
	if	$_reg1
		ifdif	<$_ldoff>,<$_ptr1>
			push	$_ldoff
			mov	$_ldoff,$_ptr1
			$_ldstak = 1
		else
			$_ldstak = 0
		endif
	endif
;	<REG,REG> type pointer load
	if	$_reg2
		ifdif	<$_ldseg>,<$_ptr1>
			push	$_ldseg
			push	$_ptr1
			pop	$_ldseg
			$_ldstak = 2
		else
			$_ldstak = 0
		endif
		ifdif	<$_ldoff>,<$_ptr2>
			push	$_ldoff
			mov	$_ldoff,$_ptr2
			$_ldstak = $_ldstak + 1
		else
			$_ldstak = 0
		endif
	endif
endm
;
;*****************************************	Internal
;* S T P T R (Restore register for LDPTR)*	20/Dec/1986
;****************************************	OK
$_stptr	macro	$_ldseg,$_ldoff
	if	$_ldstak and 1
		pop	$_ldoff
	endif
	if	$_ldstak and 2
		pop	$_ldseg
	endif
	$_ldstak = 0
endm
;
;****************************************
;* C N D C K (internal macro)		*
;****************************************
$_cndck	macro	$_cnd,$_log
	ifidn	<$_log>,<OR>
		$_cdor	$_cnd
		$_contc	= -1
	else
		ifidn	<$_log>,<AND>
			$_cdand $_cnd
			$_contc	= -1
		else
			ifb	<$_log>
				$_contc	= 0
				if	($_atrf1 mod 2)-1 and ($_atrf2 mod 2)-1
;---	until optimization
					ife $_lblsn
						ife $_faulb
							$_setfb %$_dolv
							$_cdand $_cnd
						else
							$_cdand $_cnd
							$_equfb %$_faulb,%$_dolv
						endif
;---
					else
						$_cdor $_cnd
						$_gdbjp	j,mp,%$_dolv
						$_faulb = -1
					endif
					$_extlb	%$_dolv
					$_atrf1	= $_atrf1 shr 1
					$_atrf2	= $_atrf2 shr 1
					$_atrf3	= $_atrf3 shr 1
					$_nstlv	= $_nstlv-1
					$_dolv	= $_dolv-1
				else
					$_cdand	$_cnd
					$_setvb	%$_nstlv,%$_faulb
					if	$_lblsn
						ife	$_trulb
							$_curlb	= $_curlb+1
							$_trulb	= $_curlb
						endif
						$_genjp	j,mp,%$_trulb
						$_genlb	%$_faulb
						$_curlb	= $_curlb+1
						$_setvb	%$_nstlv,%$_curlb
						$_genjp	j,mp,%$_curlb
					endif
				endif
				if	$_trulb
					$_genlb	%$_trulb
				endif
			else
				$_err <Illegal logical operator>
			endif
		endif
	endif
endm
;
;---------------------------------------;
;  S E T F B (internal macro)		;
;---------------------------------------;
$_setfb	macro	$_lvl
	$_faulb = $_bb&$_lvl
endm
;
;---------------------------------------;
;  E Q U F B (internal macro)		;
;---------------------------------------;
$_equfb	macro	$_b, $_lvl
	$_equsb $_b,%$_bb&$_lvl
endm
;
;---------------------------------------;
;  E Q U S B (internal macro)		;
;---------------------------------------;
$_equsb	macro	$_b, $_lbl
	$_&$_b	equ	$_&$_lbl
endm

;
;****************************************
;* C D O R (internal macro)		*
;****************************************
$_cdor	macro	$_cnd
	ife	$_trulb
		$_curlb	= $_curlb+1
		$_trulb	= $_curlb
	endif
	$_genjp	j,&$_cnd,%$_trulb
	if	$_faulb
		$_genlb	%$_faulb
		$_curlb	= $_curlb+1
		$_faulb	= $_curlb
	endif
endm
;
;****************************************
;* C D A N D (internal macro)		*
;****************************************
$_cdand	macro	$_cnd
	local	$_cntc1,$_cntc2
	ife	$_faulb
		$_curlb	= $_curlb+1
		$_faulb	= $_curlb
        endif
        $_genjp ,?&$_cnd,%$_faulb       
endm
;
;****************************************
;* G E N J P (internal macro)		*
;****************************************
$_genjp	macro	$_j,$_jmp,$_lbl
	$_j&$_jmp	$_&$_lbl
endm
;
;****************************************
;* G E N L B (internal macro)		*
;****************************************
$_genlb	macro	$_lbl
$_&$_lbl:
	ife	$_gnflg
		.XCREF
		.XCREF	$_&$_lbl
		.CREF
	endif
endm
;
;****************************************
;* S E T V B (internal macro)		*
;****************************************
$_setvb	macro	$_lvl,$_lbl
	$_lb&$_lvl = $_lbl
endm
;
;****************************************
;* E N D L B (internal macro)		*
;****************************************
$_endlb	macro	$_lvl
	$_genlb %$_lb&$_lvl
endm
;
;****************************************
;* S D B V B (internal macro)		*
;****************************************
$_sdbvb	macro	$_lvl,$_lbl
$_fmx&$_lvl = 0							; 12/Feb/1991
	$_bb&$_lvl = $_lbl
endm
;
;****************************************
;* (internal macro) S D E V B		*
;****************************************
$_sdevb	macro	$_lvl,$_lbl,$_blknm
	$_eb&$_lvl	= $_lbl
	$_nm&$_blknm	= $_lbl
endm
;
;****************************************
;* G D B J P (internal macro)		*
;****************************************
$_gdbjp	macro	$_j,$_mp,$_lvl
	$_genjp	$_j,$_mp,%$_bb&$_lvl
endm
;
;****************************************
;* G D E J P (internal macro)		*
;****************************************
$_gdejp	macro	$_lvl,$_cnd
	$_genjp	j,$_cnd,%$_eb&$_lvl
endm
;
;****************************************
;* G D E N M (internal macro)		*
;****************************************
$_gdenm	macro	$_blknm,$_cnd
	$_genjp	j,$_cnd,%$_nm&$_blknm
endm
;
;****************************************
;* E X T L B (internal macro)		*
;****************************************
$_extlb	macro	$_lvl
	$_genlb	%$_eb&$_lvl
endm
;
;****************************************
;* S M S I N (internal macro)		*	10/May/1986
;****************************************
$_smsin	macro	$_lvl,$_reg,$_lbl,$_cas
	$_max&$_cas	= -1
	$_min&$_cas	= -1
	$_rgx&$_cas	= &$_reg
;
	$_st&$_cas	= $_lbl
	$_cs&$_lvl	= $_cas
	$_curlb		= $_curlb+1
	$_cd&$_cas	= $_curlb
	$_bc&$_cas	= $
	$_sssdl	$_cas,<_>,0
endm
;
;****************************************
;* S S S D L (internal macro)		*	10/May/1986
;****************************************
$_sssdl	macro	$_lvl,$_udb,$_conty
	$_ss&$_lvl&$_udb&$_conty = $_cd&$_lvl
endm
;
;****************************************
;* S S S V B (internal macro)		*	10/May/1986
;****************************************
$_sssvb	macro	$_lvl,$_lbl,$_prm,$_udb
	$_sssvbx $_lvl,$_lbl,$_prm,$_udb,%$_cs&$_lvl
endm
;
;****************************************
;* S S S V B X (internal macro)		*	10/May/1986
;****************************************
$_sssvbx macro	$_lvl,$_lbl,$_prm,$_udb,$_casx
	if	$_prm GT $_max&$_casx
		if	$_max&$_casx+1
			$_cont	= $_prm-$_max&$_casx
			$_contx	= $_max&$_casx
			rept	$_cont
				$_contx	= $_contx+1
				$_sssdl	%$_cs&$_lvl,<_>,%$_contx
			endm
		endif
		$_max&$_casx	= $_prm
	endif
;
	if	($_prm LT $_min&$_casx) OR ($_min&$_casx+1 EQ 0)
		if	$_min&$_casx+1
			$_cont	= $_min&$_casx-$_prm
			$_contx	= $_min&$_casx
			rept	$_cont
				$_contx	= $_contx-1
				$_sssdl %$_cs&$_lvl,<_>,%$_contx
			endm
		endif
		$_min&$_casx	= $_prm
	endif
;
	$_ss&$_casx&$_udb&$_prm	= $_lbl
endm
;
;****************************************
;* G S N L B (internal macro)		*	10/May/1986
;****************************************
$_gsnlb	macro	$_lvl
	$_gsnlbx %$_cs&$_lvl
endm
;
;****************************************
;* G S N L B X (internal macro)		*	10/May/1986
;****************************************
$_gsnlbx macro	$_casx
	$_genlb	%$_cd&$_casx
endm
;
;****************************************
;* G O R J P (internal macro)		*	10/May/1986
;****************************************
$_gorjp	macro	$_lvl
	$_gorjpx %$_cs&$_lvl
endm
;
;****************************************
;* G O R J P X (internal macro)		*	10/May/1986
;****************************************
$_gorjpx macro	$_casx
	org	$_bc&$_casx
;
	$_cnt	= 1
	irp	$_regx,<BX,BP,SI,DI>
		ife	$_cnt-$_rgx&$_casx
			$_gsxjp	%$_st&$_casx,%$_min&$_casx,$_regx
		endif
		$_cnt	= $_cnt+1
	endm
endm
;
;****************************************
;* G S X J P (internal macro)		*	10/May/1986
;****************************************
$_gsxjp	macro	$_lbl,$_dest,$_reg
	jmp	word ptr $_&$_lbl-$_dest*2[&$_reg]
endm
;
;****************************************
;* T A B L E (internal macro)		*	10/May/1986
;****************************************
$_table	macro
	$_csca	= 0
	rept	$_cscas
		$_csca	= $_csca+1
		$_consx	%$_csca
	endm
;
	$_cont	= 0
	rept	$_cmacr
	$_cont	= $_cont+1
		$_gen	%$_cont
	endm
endm
;
;****************************************
;* C O N S X (internal macro)		*	10/May/1986
;****************************************
$_consx	macro	$_cswkx
	$_cont	= $_min&$_cswkx
	$_gendw	%&$_cswkx,<_>,%$_cont,%$_st&$_cswkx
	rept	$_max&$_cswkx-$_min&$_cswkx
		$_cont	= $_cont+1
		$_gendw	%&$_cswkx,<_>,%$_cont
	endm
endm
;
;****************************************
;* G E N D W (internal macro)		*	10/May/1986
;****************************************
$_gendw	macro	$_lvl,$_udb,$_contx,$_lbl
	ifnb	<$_lbl>
		$_gendwx %$_ss&$_lvl&$_udb&$_contx,$_&$_lbl
	else
		$_gendwx %$_ss&$_lvl&$_udb&$_contx
	endif
endm
;
;****************************************
;* G E N D W X (internal macro)		*	10/May/1986
;****************************************
$_gendwx macro	$_lbl,$_sym
$_sym	dw	$_&$_lbl
endm
;
;****************************************
;* G E N (internal macro)		*	10/May/1986
;****************************************
$_gen	macro	$_contr
	$_mac&$_contr
endm
;
;****************************************
;* F O R   				*	27/Feb/1987
;****************************************
$_for	macro	$_stm1,$_stm2,$_stm3,$_blknm
	$_stm1
	$_while TRUE,,,$_blknm
	$_sfrvb <macro>,<endm>,%$_dolv,<$_stm3>
$_contc	= 	-1
$_cnt	=	0
	irpc  	$_rstmc,<$_stm2>
	  if      $_cnt
  	    ifidn    <$_rstmc>,<<>
	      irp	$_rstm,<$_stm2>
	        $_c     $_rstm
	      endm
	    else
	      $_c    $_stm2
	    endif
	    exitm
	  endif
$_cnt	  =	$_cnt+1
	endm
$_contc	= 	0
        endm
;
;****************************************
;* E N D F O R 		         	*	27/Feb/1987
;****************************************
$_endfor macro	
	$_genfr  %$_dolv
	$_enddo
	endm
;
;****************************************
;* F O R _ (near label jump)		*
;****************************************
$_for_	macro	$_stm1,$_stm2,$_stm3,$_blknm
	$_lblsn	= -1
	$_for	<$_stm1>,<$_stm2>,<$_stm3>,$_blknm
	$_lblsn	= 0
endm
;
;****************************************
;* E N D F O R _ (near label jump)	*
;****************************************
$_endfor_ macro
	$_lblsn	= -1
	$_endfor
	$_lblsn	= 0
endm
;
;****************************************
;* S F R V B (internal macro)  		*	27/Feb/1987
;****************************************
$_sfrvb macro   $_macro,$_endm,$_lvl,$_stmt
$_fmx&$_lvl = 1							; 12/Feb/1991
$_fmc&$_lvl $_macro 
	$_stmt
	$_endm
	endm
;
;****************************************
;* G E N F R (internal macro) 		*	27/Feb/1987
;****************************************
$_genfr macro   $_lvl
		if $_fmx&$_lvl					; 12/Feb/1991
	        $_fmc&$_lvl
		endif							; 12/Feb/1991
$_fmx&$_lvl = 0							; 12/Feb/1991
	endm
;
;****************************************
;* P U S H 				*
;****************************************
;
$_push	macro	regs, pushpopid		;push
	$_regcnt&pushpopid	= 0
	irp	reg, <regs>
		$_regcnt&pushpopid	= $_regcnt&pushpopid + 1
		push	reg
	endm
&$_pop&pushpopid &macro
	$_popadr	= $
	cnt	= 0
	irp	reg, <regs>
		cnt	= cnt + 1
		&org	$_popadr + $_regcnt&pushpopid - cnt
		pop	reg
	endm
	org	$_popadr + $_regcnt&pushpopid
	&end&m
	endm
;
;****************************************
;* P O P 				*
;****************************************
;
$_pop	macro	pushpopid			;pop
	$_pop&pushpopid
	endm
;
;****************************************
;* (internal macro) E R R		*
;****************************************
$_err	macro	$_msg
	%out	*** M a c r o *** &$_msg
$_msg *** M a c r o ***
endm
;
;****************************************
;* I M S G (internal macro) 		*
;****************************************
$_imsg	macro   $_msg
	%out	$_msg
	endm
;
;****************************************
;* I N I T (assemble symbol init.)	*
;****************************************
;
?E      EQU     JNE
?L      EQU     JNL
?GE     EQU     JNGE
?LE     EQU     JNLE
?G      EQU     JNG
?B      EQU     JNB
?BE     EQU     JNBE
?C      EQU     JNC
?Z      EQU     JNZ
?O      EQU     JNO
?S      EQU     JNS
?AE     EQU     JNAE
?A      EQU     JNA
?P      EQU     JNP
?PO     EQU     JPE
;
?NE     EQU     JE
?NL     EQU     JL
?NGE    EQU     JGE
?NLE    EQU     JLE
?NG     EQU     JG
?NB     EQU     JB
?NBE    EQU     JBE
?NC     EQU     JC
?NZ     EQU     JZ
?NO     EQU     JO
?NS     EQU     JS
?NAE    EQU     JAE
?NA     EQU     JA
?NP     EQU     JP
?PE     EQU     JPO
;
	$_neafar = 1		; Library routine Near/Far ?
;
	$_nstlv = 0		; Nesting Level
	$_curlb	= 0		; Current label Ndx
	$_dolv	= 0		; Do nest level
	$_atrf1	= 0		; Attr 1.
	$_atrf2	= 0		; Attr 2.
	$_atrf3	= 0		; Attr 3.
	$_atrf4	= 0		; Attr 4.
	$_contc	= 0		; Condision continue ?
	$_lblsn	= 0		; Nest name ndx
	$_gnflg	= 0		; GEN flag
;
	$_cscas	= 0		; case count
	$_cmacr	= 0		; assemble time macro count
;
	$_ldstak = 0		;Stack level for 'Load Pointer'
;
	.list
