;          include knight.inc

setupbase:

           mov objbase[0*4],offset headercube4
           mov objbase[1*4],offset headercube2
           mov objbase[2*4],offset headerring
           mov objbase[3*4],offset headerdiamond
           mov objbase[4*4],offset headerrubine
           mov objbase[5*4],offset headercube3
           mov objbase[6*4],offset headercube4

;          mov objbase[0*4],offset headerknight

           mov esi,0               ; from object #
           mov edi,6               ; to object #
           call set_up_all_lambert ; find and set up shading tables

           ret

; shape data can be almost as large as you need it 'till it crashes. try a cube
; 20000x20000x20000.    calculations  use  32  bit  registers  and  can  handle
; up to 16 bit locations.  keeping the object size small will  allow  a  larger
; visible space.  but larger objects will allow you to get  closer  with   more
; accuracy in the mathematics of rotations.  remember, if you make a really big
; object, set minz to the largest object on the screen so the large object wont
; mess up when you get really close to it.
;
; format for objects:
;
; thing:
; dw xx         ; number of points
; dw yy         ; number of surfaces
; dw 25 dup (?) ; 25 future use words
;
; dw xx,yy,zz   ; x,y,z of point 0
; dw xx,yy,zz   ; x,y,z of point 1
; dw xx,yy,zz   ; x,y,z of point 2
; ...
;
; dw command
; dw texture for side 1
; dw texture for side 2
; dw colour for side 1
; dw colour for side 2
; dw connection data eg (1,2,3,4,1)
; dw [?,?,?] [optional surface normal if command 128 used]
; dw more connection data...
;
; to re-cap: dw command,texture1,texture2,colour1,colour2,connection,[0,0,0]
;
; list of command bits to date: (options grouped by function:)
;
; note: "visible" = "points appear counter-clockwise"
;
; texture definitions:
;
;   0       - normal surface, no features, constant colour.
;   wavey   - steel texture for surface 0 = none,  colour  offset  determines
;             screen offset for texture.  eg 16+7 will use colour block 16-31
;             but make the sine wave texture 14 (7*2) lines down. this is  so
;             all sine wave textures do not appear on the same line.
;             windows and engines look good with this feature.
;   shade   - lambert shading bit, must have normal calculated or  at  least
;             have    free    space     for    pre_cal_lambert    to    use:
;             eg x,x,x,x,x,1,2,3,1,?,?,?<- these 3 words are surface normal!
;   inverse - inversion bit for shading option.  0=normal shading, 1=inverse
;             inversion automatically occures when other side is displayed.
;   glow    - =shade+inverse
;   last    - colour has same colour as previous surface (used when
;             you want gourad shading, but want to avoid  duplicate
;             calculations - don't set gourad bit if this  is  what
;             you use it for.) when this is used, the colour number
;             determines the new colour block to use.  the  shading
;             of this colour will be the same as the surface before
;             it, but the colour block can be different.
;
; commands:
;
;   point   - defines a single point; must be repeated! eg dw 64,col,3,3
;   line    - if used, defines a line (must be set to define a true line)
;   himap   - if set, defines a bitmap,eg: point #, bitmap #, x scale,y scale
;   lomap   - uses 1/4 scaled bitmap (every 4'th pixel is sampled), fast
;
;   iterate - generate iteration if side visible (iteration = sub-object)
;   matrix  - modify matrix when generating iteration.  matrix object
;             offset is 3rd word (6'th byte) in future use words.
;
;   both    - side is always visible no matter angle, skips counter-clowise test
;           - "both sides have same texture"
;   double  - side is always visible but other side has other colour
;             "double sided surface"
;             note: if this is used, option "both" must not be used!!
;   onscr   - test if side is on screen - don't use if all points are
;             outside clipping parameters.
;   check   - dont plot this side, just use as test points for visibility.
;             this is mostly used with iterations.
;
; there are two kinds of bitmaps and points.  those which  are  inside  objects
; and those which are seperate objects themselves. if userotate object  command
; is set to 32 or 64, then the entire object is considered to be either a point
; or bitmap.  but if userotate is not set this way, then  a  normal  object  is
; drawn and bitmaps then come from within the object definitions (below).  this
; way, bitmaps and points can be either part of a larger object,  or  they  are
; computed fast on their own. (eg explosions and bullets as  seperate  objects)
;
; note: when writing surface descriptions, try to make the  first value unique
; from any other first value.  this way, the sort routine  will  give  a  more
; accurate sorting of sides. eg 1,3,6,1  2,4,1,2  rather than 1,3,6,1  1,2,4,1
;
; to recap:
;
;        0 = constant colour, only visible from counter-clockwise side
;    wavey = sine texture
;    shade = shading - requires 3 blank words for surface normal eg dw 0,0,0
;  inverse = invert the shading direction, 0=normal, 1=sun is other way.
;     last = use intensity from previous surface (not colour, only intensity)
;
;    point = point
;     line = line
;    himap = bitmap (scalable, non-rotatable)
;    lomap = bitmap (scalable, non-rotatable)
;  iterate = generate iteration if side visible
;     both = always visible
;   double = always visible but other side has high byte colour,"double sided"
;    onscr = plot side only if all the following points are on the screen
;    check = dont plot side but use the following points as a test for visiblity
;
; what you can't mix on a single surface: "double" with "both"!!
;
; you do not have to define a point for the center of the  object.  the  point
; 0 defines the center of the object.  this is different from earlier versions
;
           align 16

headercube1 dd -1
            dd offset cube1a - offset $ - 4

cube1a     dw 8           ; how many points
           dw 6           ; how many surfaces
           dw 25 dup (?)  ; future use
           ;    x   y   z
           dw -70, 70, 70 ;1
           dw -70,-70, 70 ;2
           dw  70,-70, 70 ;3
           dw  70, 70, 70 ;4
           dw -70, 70,-70 ;5
           dw -70,-70,-70 ;6
           dw  70,-70,-70 ;7
           dw  70, 70,-70 ;8

           dw 0,?,?,16*9+12 ,? ,1,2,3,4,1 ; surface connection data, and colours
           dw 0,wavey,?,16*7+6  ,? ,8,7,6,5,8 ; end point=start point means done side
           dw 0,wavey,?,16*3+9  ,? ,4,3,7,8,4
           dw 0,shade,?,16*5+0  ,? ,5,6,2,1,5  ,?,?,? ;<-- lambert shading
           dw 0,shade,?,16*2+0  ,? ,5,1,4,8,5  ,?,?,? ;<-- normal gets shoved
           dw 0,shade,?,16*11+0 ,? ,2,6,7,3,2  ,?,?,? ;<-- here, leave blank
;

headercube2 dd -1
            dd offset cube2a - offset $ - 4

cube2a     dw 8           ; how many points
           dw 9           ; how many surfaces
           dw 25 dup (?)
           ;    x   y   z
           dw -70, 70, 70 ;1
           dw -70,-70, 70 ;2
           dw  70,-70, 70 ;3
           dw  70, 70, 70 ;4
           dw -70, 70,-70 ;5
           dw -70,-70,-70 ;6
           dw  70,-70,-70 ;7
           dw  70, 70,-70 ;8

           dw double,shade,wavey,16*3+0,16*5+8,1,2,3,4,1 ; command,txt1,txt2,col1,col2, surface connection data
           dw ?,?,? ; surface normal goes here
           dw 0,?,?,16*2+4 ,?,6,2,6   ; end point=start point means done side
           dw 0,?,?,16*1+15,?,7,3,7   ; <-- these are lines
           dw 0,?,?,16*2+12,?,8,4,8
           dw 0,?,?,16*3+0 ,?,5,1,5
           dw 0,?,?,16*4+10,?,6,7,6
           dw 0,?,?,16*8+14,?,7,8,7
           dw 0,?,?,16*7+13,?,8,5,8
           dw 0,?,?,16*5+12,?,5,6,5

headercube3 dd 6000
            dd offset cube3a - offset $ - 4
            dd -1
            dd offset cube3b - offset $ - 4

cube3a     dw 44          ; how many points
           dw 45          ; how many surfaces
           dw 25 dup (?)  ; future use
           ;    x   y   z
           dw -70, 70, 70 ;1
           dw -70, 70, 35 ;2
           dw -70, 70,  0 ;3
           dw -70, 70,-35 ;4

           dw -70,-70, 70 ;5
           dw -70,-70, 35 ;6
           dw -70,-70,  0 ;7
           dw -70,-70,-35 ;8

           dw  70,-70, 70 ;9
           dw  70,-70, 35 ;10
           dw  70,-70,  0 ;11
           dw  70,-70,-35 ;12

           dw  70, 70, 70 ;13
           dw  70, 70, 35 ;14
           dw  70, 70,  0 ;15
           dw  70, 70,-35 ;16

           dw -70, 70,-70 ;17
           dw -70, 35,-70 ;18
           dw -70,  0,-70 ;19
           dw -70,-35,-70 ;20
           dw -70,-70,-70 ;21

           dw  70, 70,-70 ;22
           dw  70, 35,-70 ;23
           dw  70,  0,-70 ;24
           dw  70,-35,-70 ;25
           dw  70,-70,-70 ;26

           dw -70, 35, 70 ;27
           dw -70,  0, 70 ;28
           dw -70,-35, 70 ;29

           dw  70, 35, 70 ;30
           dw  70,  0, 70 ;31
           dw  70,-35, 70 ;32

           dw -35,-70, 70 ;33
           dw   0,-70, 70 ;34
           dw  35,-70, 70 ;35

           dw -35,-70,-70 ;36
           dw   0,-70,-70 ;37
           dw  35,-70,-70 ;38

           dw -35, 70,-70 ;39
           dw   0, 70,-70 ;40
           dw  35, 70,-70 ;41

           dw -35, 70, 70 ;42
           dw   0, 70, 70 ;43
           dw  35, 70, 70 ;44

           dw himap,01,0,5,5 ; bitmaps have no future use bytes
           dw himap,02,0,5,5
           dw himap,03,0,5,5
           dw himap,04,0,5,5
           dw himap,05,0,5,5
           dw himap,06,0,5,5
           dw himap,07,0,5,5
           dw himap,08,0,5,5
           dw himap,09,0,5,5
           dw himap,10,0,5,5
           dw himap,11,0,5,5
           dw himap,12,0,5,5
           dw himap,13,0,5,5
           dw himap,14,0,5,5
           dw himap,15,0,5,5
           dw himap,16,0,5,5
           dw himap,17,0,5,5
           dw himap,18,0,5,5
           dw himap,19,0,5,5
           dw himap,20,0,5,5
           dw himap,21,0,5,5
           dw himap,22,0,5,5
           dw himap,23,0,5,5
           dw himap,24,0,5,5
           dw himap,25,0,5,5
           dw himap,26,0,5,5
           dw himap,27,0,5,5
           dw himap,28,0,5,5
           dw himap,29,0,5,5
           dw himap,30,0,5,5
           dw himap,31,0,5,5
           dw himap,32,0,5,5
           dw himap,33,0,5,5
           dw himap,34,0,5,5
           dw himap,35,0,5,5
           dw himap,36,0,5,5
           dw himap,37,0,5,5
           dw himap,38,0,5,5
           dw himap,39,0,5,5
           dw himap,40,0,5,5
           dw himap,41,0,5,5
           dw himap,42,0,5,5
           dw himap,43,0,5,5
           dw himap,44,0,5,5

           dw himap,0,0,30,30

cube3b     dw 44  ; this is same as above but since bitmaps can't be seen
           dw 45  ; from far, i use the same cube with points instead.
           dw 25 dup (?)  ; future use
           ;    x   y   z
           dw -70, 70, 70 ;1  ; this is an example of how to use the
           dw -70, 70, 35 ;2  ; different resolutions based on distance
           dw -70, 70,  0 ;3  ; you could get rid of half of these points
           dw -70, 70,-35 ;4  ; and still have it "look" the same because

           dw -70,-70, 70 ;5  ; of the great distance at which this will
           dw -70,-70, 35 ;6  ; be seen
           dw -70,-70,  0 ;7
           dw -70,-70,-35 ;8

           dw  70,-70, 70 ;9
           dw  70,-70, 35 ;10
           dw  70,-70,  0 ;11
           dw  70,-70,-35 ;12

           dw  70, 70, 70 ;13
           dw  70, 70, 35 ;14
           dw  70, 70,  0 ;15
           dw  70, 70,-35 ;16

           dw -70, 70,-70 ;17
           dw -70, 35,-70 ;18
           dw -70,  0,-70 ;19
           dw -70,-35,-70 ;20
           dw -70,-70,-70 ;21

           dw  70, 70,-70 ;22
           dw  70, 35,-70 ;23
           dw  70,  0,-70 ;24
           dw  70,-35,-70 ;25
           dw  70,-70,-70 ;26

           dw -70, 35, 70 ;27
           dw -70,  0, 70 ;28
           dw -70,-35, 70 ;29

           dw  70, 35, 70 ;30
           dw  70,  0, 70 ;31
           dw  70,-35, 70 ;32

           dw -35,-70, 70 ;33
           dw   0,-70, 70 ;34
           dw  35,-70, 70 ;35

           dw -35,-70,-70 ;36
           dw   0,-70,-70 ;37
           dw  35,-70,-70 ;38

           dw -35, 70,-70 ;39
           dw   0, 70,-70 ;40
           dw  35, 70,-70 ;41

           dw -35, 70, 70 ;42
           dw   0, 70, 70 ;43
           dw  35, 70, 70 ;44

           dw 0,?,?,28,?, 01,01
           dw 0,?,?,28,?, 02,02
           dw 0,?,?,28,?, 03,03
           dw 0,?,?,28,?, 04,04
           dw 0,?,?,28,?, 05,05
           dw 0,?,?,28,?, 06,06
           dw 0,?,?,28,?, 07,07
           dw 0,?,?,28,?, 08,08
           dw 0,?,?,28,?, 09,09
           dw 0,?,?,28,?, 10,10
           dw 0,?,?,28,?, 11,11
           dw 0,?,?,28,?, 12,12
           dw 0,?,?,28,?, 13,13
           dw 0,?,?,28,?, 14,14
           dw 0,?,?,28,?, 15,15
           dw 0,?,?,28,?, 16,16
           dw 0,?,?,28,?, 17,17
           dw 0,?,?,28,?, 18,18
           dw 0,?,?,28,?, 19,19
           dw 0,?,?,28,?, 20,20
           dw 0,?,?,28,?, 21,21
           dw 0,?,?,28,?, 22,22
           dw 0,?,?,28,?, 23,23
           dw 0,?,?,28,?, 24,24
           dw 0,?,?,28,?, 25,25
           dw 0,?,?,28,?, 26,26
           dw 0,?,?,28,?, 27,27
           dw 0,?,?,28,?, 28,28
           dw 0,?,?,28,?, 29,29
           dw 0,?,?,28,?, 30,30
           dw 0,?,?,28,?, 31,31
           dw 0,?,?,28,?, 32,32
           dw 0,?,?,28,?, 33,33
           dw 0,?,?,28,?, 34,34
           dw 0,?,?,28,?, 35,35
           dw 0,?,?,28,?, 36,36
           dw 0,?,?,28,?, 37,37
           dw 0,?,?,28,?, 38,38
           dw 0,?,?,28,?, 39,39
           dw 0,?,?,28,?, 40,40
           dw 0,?,?,28,?, 41,41
           dw 0,?,?,28,?, 42,42
           dw 0,?,?,28,?, 43,43
           dw 0,?,?,28,?, 44,44

           dw himap,0,0,30,30     ; 0 = center of object

headerring dd -1
           dd offset ringa - offset $ - 4

ringa      dw 32
           dw 32
           dw 25 dup (?)  ; future use
           ;    x   y   z
           dw -40, 80, 30 ; 1
           dw -80, 40, 30 ; 2
           dw -80,-40, 30 ; 3
           dw -40,-80, 30 ; 4
           dw  40,-80, 30 ; 5
           dw  80,-40, 30 ; 6
           dw  80, 40, 30 ; 7
           dw  40, 80, 30 ; 8
           dw -40, 20, 45 ; 9
           dw -40,-20, 45 ;10
           dw -20,-40, 45 ;11
           dw  20,-40, 45 ;12
           dw  40,-20, 45 ;13
           dw  40, 20, 45 ;14
           dw  20, 40, 45 ;15
           dw -20, 40, 45 ;16
           dw -40, 80,-30 ;17
           dw -80, 40,-30 ;18
           dw -80,-40,-30 ;19
           dw -40,-80,-30 ;20
           dw  40,-80,-30 ;21
           dw  80,-40,-30 ;22
           dw  80, 40,-30 ;23
           dw  40, 80,-30 ;24
           dw -40, 20,-45 ;25
           dw -40,-20,-45 ;26
           dw -20,-40,-45 ;27
           dw  20,-40,-45 ;28
           dw  40,-20,-45 ;29
           dw  40, 20,-45 ;30
           dw  20, 40,-45 ;31
           dw -20, 40,-45 ;32

           dw 0,shade,?,16*3+0,? ,2,9,16,1,2     ,?,?,? ; these  zeros   get   filled
           dw 0,shade,?,16*3+0,? ,3,10,9,2,3     ,?,?,? ; with the calculated surface
           dw 0,shade,?,16*3+0,? ,4,11,10,3,4    ,?,?,? ; normal.  we could calculate
           dw 0,shade,?,16*3+0,? ,5,12,11,4,5    ,?,?,? ; them ourselves but god, too
           dw 0,shade,?,16*3+0,? ,6,13,12,5,6    ,?,?,? ; much work.
           dw 0,shade,?,16*3+0,? ,7,14,13,6,7    ,?,?,?
           dw 0,shade,?,16*3+0,? ,8,15,14,7,8    ,?,?,? ; remember, if you remove  the
           dw 0,shade,?,16*3+0,? ,1,16,15,8,1    ,?,?,? ; shading parameter (128) then
           dw 0,shade,?,16*3+0,? ,1,17,18,2,1    ,?,?,? ; you must remove these 0's
           dw 0,shade,?,16*3+0,? ,2,18,19,3,2    ,?,?,?
           dw 0,shade,?,16*3+0,? ,3,19,20,4,3    ,?,?,?
           dw 0,shade,?,16*3+0,? ,4,20,21,5,4    ,?,?,?
           dw 0,shade,?,16*3+0,? ,5,21,22,6,5    ,?,?,?
           dw 0,shade,?,16*3+0,? ,6,22,23,7,6    ,?,?,?
           dw 0,shade,?,16*3+0,? ,7,23,24,8,7    ,?,?,?
           dw 0,shade,?,16*3+0,? ,8,24,17,1,8    ,?,?,?
           dw 0,shade,?,16*3+0,? ,10,26,25,9,10  ,?,?,?
           dw 0,shade,?,16*3+0,? ,11,27,26,10,11 ,?,?,?
           dw 0,shade,?,16*3+0,? ,12,28,27,11,12 ,?,?,?
           dw 0,shade,?,16*3+0,? ,13,29,28,12,13 ,?,?,?
           dw 0,shade,?,16*3+0,? ,14,30,29,13,14 ,?,?,?
           dw 0,shade,?,16*3+0,? ,15,31,30,14,15 ,?,?,?
           dw 0,shade,?,16*3+0,? ,15,16,32,31,15 ,?,?,?
           dw 0,shade,?,16*3+0,? ,32,16,9,25,32  ,?,?,?
           dw 0,shade,?,16*3+0,? ,18,25,26,19,18 ,?,?,?
           dw 0,shade,?,16*3+0,? ,19,26,27,20,19 ,?,?,?
           dw 0,shade,?,16*3+0,? ,20,27,28,21,20 ,?,?,?
           dw 0,shade,?,16*3+0,? ,21,28,29,22,21 ,?,?,?
           dw 0,shade,?,16*3+0,? ,22,29,30,23,22 ,?,?,?
           dw 0,shade,?,16*3+0,? ,23,30,31,24,23 ,?,?,?
           dw 0,shade,?,16*3+0,? ,24,31,32,17,24 ,?,?,?
           dw 0,shade,?,16*3+0,? ,17,32,25,18,17 ,?,?,?

headerdiamond dd -1
              dd offset diamonda - offset $ - 4

diamonda   dw 13
           dw 17
           dw 25 dup (?)  ; future use

           dw -100,  50,   0
           dw -100, -50,   0
           dw  -50,-100,   0
           dw   50,-100,   0
           dw  100, -50,   0
           dw  100,  50,   0
           dw   50, 100,   0
           dw  -50, 100,   0
           dw  -50,  50,  40
           dw  -50, -50,  40
           dw   50, -50,  40
           dw   50,  50,  40
           dw    0,   0,-120

           dw 0,shade,?,16*2+0,? ,1,2,10,9,1    ,?,?,?
           dw 0,shade,?,16*2+0,? ,10,3,4,11,10  ,?,?,?
           dw 0,shade,?,16*2+0,? ,12,11,5,6,12  ,?,?,?
           dw 0,shade,?,16*2+0,? ,8,9,12,7,8    ,?,?,?
           dw 0,shade,?,16*2+0,? ,2,3,10,2      ,?,?,?
           dw 0,shade,?,16*2+0,? ,11,4,5,11     ,?,?,?
           dw 0,shade,?,16*2+0,? ,7,12,6,7      ,?,?,?
           dw 0,shade,?,16*2+0,? ,1,9,8,1       ,?,?,?
           dw 0,shade,?,16*2+0,? ,9,10,11,12,9  ,?,?,?
           dw 0,shade,?,16*2+0,? ,8,13,1,8      ,?,?,?
           dw 0,shade,?,16*2+0,? ,1,13,2,1      ,?,?,?
           dw 0,shade,?,16*2+0,? ,2,13,3,2      ,?,?,?
           dw 0,shade,?,16*2+0,? ,3,13,4,3      ,?,?,?
           dw 0,shade,?,16*2+0,? ,4,13,5,4      ,?,?,?
           dw 0,shade,?,16*2+0,? ,5,13,6,5      ,?,?,?
           dw 0,shade,?,16*2+0,? ,6,13,7,6      ,?,?,?
           dw 0,shade,?,16*2+0,? ,7,13,8,7      ,?,?,?

headerrubine dd -1
             dd offset rubinea - offset $ - 4

rubinea    dw 16
           dw 18
           dw 25 dup (?)  ; future use

           dw -100,  50,   0 ; 1
           dw -100, -50,   0 ; 2
           dw  -50,-100,   0 ; 3
           dw   50,-100,   0 ; 4
           dw  100, -50,   0 ; 5
           dw  100,  50,   0 ; 6
           dw   50, 100,   0 ; 7
           dw  -50, 100,   0 ; 8
           dw  -50,  50,  40 ; 9
           dw  -50, -50,  40 ;10
           dw   50, -50,  40 ;11
           dw   50,  50,  40 ;12
           dw  -50,  50, -40 ;13
           dw  -50, -50, -40 ;14
           dw   50, -50, -40 ;15
           dw   50,  50, -40 ;16

           dw 0,shade,?,96+0,? ,1,2,10,9,1     ,?,?,?
           dw 0,shade,?,96+0,? ,10,3,4,11,10   ,?,?,?
           dw 0,shade,?,96+0,? ,12,11,5,6,12   ,?,?,?
           dw 0,shade,?,96+0,? ,8,9,12,7,8     ,?,?,?
           dw 0,shade,?,96+0,? ,2,3,10,2       ,?,?,?
           dw 0,shade,?,96+0,? ,11,4,5,11      ,?,?,?
           dw 0,shade,?,96+0,? ,7,12,6,7       ,?,?,?
           dw 0,shade,?,96+0,? ,1,9,8,1        ,?,?,?
           dw 0,shade,?,96+0,? ,9,10,11,12,9   ,?,?,?
           dw 0,shade,?,96+0,? ,6,5,15,16,6    ,?,?,?
           dw 0,shade,?,96+0,? ,15,4,3,14,15   ,?,?,?
           dw 0,shade,?,96+0,? ,16,15,14,13,16 ,?,?,?
           dw 0,shade,?,96+0,? ,13,14,2,1,13   ,?,?,?
           dw 0,shade,?,96+0,? ,7,16,13,8,7    ,?,?,?
           dw 0,shade,?,96+0,? ,5,4,15,5       ,?,?,?
           dw 0,shade,?,96+0,? ,14,3,2,14      ,?,?,?
           dw 0,shade,?,96+0,? ,8,13,1,8       ,?,?,?
           dw 0,shade,?,96+0,? ,6,16,7,6       ,?,?,?

; this  object  is  an  example   of   how   to   use   the   new   iterations.
; notice how  there  are  only   6 main  surfaces  and  then  5  sub  surfaces.
; if the main surface is not visible,then the sub surfaces are totally skipped.
; pre_cal_lambert calculates the code offsets in case side is not visible,  but
; I have provided a few to give you an example of what pre_cal_lambert will do.

; this demonstrates only one level of iteration, you can have as  many
; levels as you want.  notice how sub iterations are written just like
; main objects.

; concave surfaces work well when put inside iterations (saves cpu time), but
; convex surfaces don't work well. eg, insides  of  volcanos  are  great  for
; cutting cpu time, but exterior things like rooftop buildings must  be  done
; seperatly (hint - inlay the rooftop building below the edge of the roof and
; you can now have the building and all the stuff on the roof in a iteration)

; iterations save MEGA cpu time!!!

           align 16

headercube4 dd -1                        ; -1=end flag (last resolution)
            dd offset cube4a - offset $ - 4

cube4a     dw 8           ; how many points
           dw 6           ; how many surfaces
           dw 25 dup (?)  ; future use
           ;    x   y   z
           dw -70, 70, 70 ;1 ; the main cube (defines exterior for checking)
           dw -70,-70, 70 ;2
           dw  70,-70, 70 ;3
           dw  70, 70, 70 ;4
           dw -70, 70,-70 ;5
           dw -70,-70,-70 ;6
           dw  70,-70,-70 ;7
           dw  70, 70,-70 ;8

           dw check+iterate,?,?,?,?,1,2,3,1 ; test main surface, dont plot, just check dot product

               dw 4 ; 4 extra points if visible    (for this iteration, doesn't
               dw 5 ; 5 extra surfaces if visible  (include iterations of iterations)

               dw ? ; reserved for offset of new startup location if failure - directs code to next valid surface
               dw ? ; reserved for TOTAL number of points to skip if failure - ends up as 4, number of points within iteration

               dw 23 dup (?) ; for future use

               ;    x   y   z
               dw -45, 45, 70 ; 9
               dw -45,-45, 70 ;10
               dw  45,-45, 70 ;11
               dw  45, 45, 70 ;12

               ; these sides are always visible (+2) because the above  check
               ; confirmed the dot product.  setting +2 option saves time for
               ; checking each surface because the main surface was  visible.
               ; this saves 2 imuls per surface. eg: check the  main  surface
               ; for visibility and all sub surfaces must also be visible.

               dw both,glow ,?, 16*4+0,?,9,10,11,12,9, ?,?,? ; +256 is inverse gouraud shading, what the heck, lets get creative...
               dw both,shade,?, 16*3+0,?,1,2,10,9,1  ,?,?,?
               dw both,last ,?, 16*3+0,?,2,3,11,10,2        ; last = use previous colour (uses gourad)
               dw both,last ,?, 16*3+0,?,3,4,12,11,3        ; previous surface must always
               dw both,last ,?, 16*3+0,?,4,1,9,12,4         ; be visible if this is used

           dw check+iterate,?,?,?,? ,8,7,6,8 ; testing visibility only requires a triangle, not whole surface

               dw 4 ; same as above but different points used...
               dw 5

               dw 25 dup (?)

               ;    x   y   z
               dw -45, 45,-70 ;13
               dw -45,-45,-70 ;14
               dw  45,-45,-70 ;15
               dw  45, 45,-70 ;16

               dw both,glow ,?,16*2+0,?,13,16,15,14,13, ?,?,?
               dw both,shade,?,16*7+0,?,5,13,14,6,5   , ?,?,?
               dw both,last ,?,16*7+0,?,6,14,15,7,6
               dw both,last ,?,16*7+0,?,7,15,16,8,7
               dw both,last ,?,16*7+0,?,8,16,13,5,8

           dw check+iterate+onscr,?,?,?,? ,4,3,7,4

               dw 4 ; concave side, notice how I use the commands below because
               dw 5 ; we know this side is concave.

               dw 25 dup (?)

               ;    x   y   z
               dw  30, 45, 45 ;17 - make x=70 and plane will be flat
               dw  30,-45, 45 ;18
               dw  30,-45,-45 ;19
               dw  30, 45,-45 ;20

               dw both,shade,?,16*6+0,? ,17,18,19,20,17, ?,?,?
               dw 0,   shade,?,16*9+0,? ,4,3,18,17,4,  ?,?,? ; <-commands here, i have removed
               dw 0,   shade,?,16*9+0,? ,3,7,19,18,3,  ?,?,? ; the +2, 'cause these sides are not
               dw 0,   shade,?,16*9+0,? ,8,20,19,7,8,  ?,?,? ; on the same plane as the original
               dw 0,   shade,?,16*9+0,? ,8,4,17,20,8,  ?,?,? ; iteration check

           dw check+iterate,?,?,?,? ,5,6,2,5

               dw 4 ; another concave side
               dw 5

               dw 25 dup (?)

               ;    x   y   z
               dw -30, 45, 45 ;21 ; points are accumulated from original.
               dw -30,-45, 45 ;22 ; eg: <-this point will always be point #22
               dw -30,-45,-45 ;23 ; regardless of whether the above iterations
               dw -30, 45,-45 ;24 ; were processed.

               dw both,shade,?, 16* 2+0,?,21,24,23,22,21, ?,?,?
               dw 0   ,shade,?, 16*11+0,?,1,21,22,2,1,  ?,?,?
               dw 0   ,shade,?, 16*11+0,?,5,24,21,1,5,  ?,?,?
               dw 0   ,shade,?, 16*11+0,?,6,23,24,5,6,  ?,?,?
               dw 0   ,shade,?, 16*11+0,?,6,2,22,23,6,  ?,?,?

           dw check+iterate,?,?,?,? ,5,1,4,5

               dw 4
               dw 5

               dw 25 dup (?)

               ;    x   y   z
               dw -45, 70,-45 ;25
               dw -45, 70, 45 ;26
               dw  45, 70, 45 ;27
               dw  45, 70,-45 ;28

               dw both,glow    ,?, 16*2+0,?,25,26,27,28,25, ?,?,?
               dw both,shade   ,?, 16*3+0,?,5,1,26,25,5,    ?,?,?
               dw both,last    ,?, 16*3+0,?,1,4,27,26,1
               dw both,last    ,?, 16*3+0,?,4,8,28,27,4
               dw both,last    ,?, 16*3+0,?,8,5,25,28,8

           dw check+iterate,?,?,?,? ,2,6,7,2

               dw 4
               dw 5

               dw 25 dup (?)

               ;    x   y   z
               dw -45,-70,-45 ;29
               dw -45,-70, 45 ;30
               dw  45,-70, 45 ;31
               dw  45,-70,-45 ;32

               dw both,glow ,?,16*5 +0,?,29,32,31,30,29, ?,?,?
               dw both,shade,?,16*13+0,?,6,29,30,2,6,    ?,?,?
               dw both,last ,?,16*13+0,?,2,30,31,3,2
               dw both,last ,?,16*13+0,?,3,31,32,7,3
               dw both,last ,?,16*13+0,?,7,32,29,6,7

