           .386p
           jumps

code32     segment para public use32
           assume cs:code32, ds:code32

; define externals

           include pmode.inc       ; protected mode externals
           include xmouse.inc      ; xmode mouse externals
           include xmode.inc       ; xmode externals by matt pritchard
           include 3d.inc
           include irq.inc
           include stars.inc
           include font.inc
           include file.inc

           include macros.inc
           include equ.inc

           include sphere.inc
           include icon.inc
           include gamecolr.inc    ; dac palette

           include objects.inc     ; table of shapes/colours
           include stuff.inc       ; ending screen stuff

           public _main

_main:
           sti

           push offset defpal
           call fadeoffpalette

           call setup_env          ; set up file envirionment (eg c:\temp\thisprog.exe )

           pushw xmode
           pushw xactual
           pushw yactual
           pushw pages
           call set_vga_modex
           cmp ax,-1               ; test for error in setting videomode
           jne getout

           call wipeoffpalette

;          call set_pmirq          ; select irq:use one or the other
           call set_rmirq

;          push offset gamecolr
;          pushw 0
;          pushw 255
;          pushw 1
;          call load_dac_registers

           call setupbase
           call initpages
           call initfont
           call show_mouse

          ;block 0,0,319,399,14
          ;call flip_page
          ;block 0,0,319,399,14

comment $
           call flip_page    ; example of how to draw a single polygon

           p1x equ -50
           p1y equ -50
           p2x equ -90
           p2y equ 70
           p3x equ 60
           p3y equ 80

           mov x1,p1x
           mov y1,p1y
           mov x2,p2x
           mov y2,p2y
           call fakeline

           mov x1,p2x
           mov y1,p2y
           mov x2,p3x
           mov y2,p3y
           call fakeline

           mov x1,p3x
           mov y1,p3y
           mov x2,p1x
           mov y2,p1y
           call fakeline

           mov colq,7
           mov steel,-1
           call poly_fill

           call flip_page
$
           mov esi,o runscreen ; this uses the new font/screen setup routines
           call tstring
           mov esi,o runtext
           call tstring

           push o gamecolr
           call fadeonpalette

           mov si,cameraobject  ; set the camera position
           mov bx,0             ; camera angle
           mov cx,0
           mov bp,0
           call set_angle
           mov ebx,100000       ; camera position
           mov ecx,25000
           mov ebp,-315000
           call put_object

           mov si,1             ; now place 1st object
           mov ebx,-26000       ; to this position (x,y,z)=ebx,ecx,ebp
           mov ecx,65000        ; locations are 32 bit
           mov ebp,0
           call put_object      ; plop..
           mov bx,0             ; angles are 16 bit
           mov cx,0
           mov bp,0
           call set_angle       ; duhhh...i wonder what this call does...
           call set_object_on   ; turn object si on (make visible)
           mov userotate[esi],0 ; full rotations for this object (0)
           mov ax,0
           call set_shape       ; set object si to shape ax
           mov ebx,000245100h   ; x,y,z angular velocities
           mov ecx,000591500h   ; high word = number of turns/revolutions
           mov ebp,000742300h   ; lo word = final angle (position)
           mov di,28000         ; di = time to twist there (total frames)
           call twist_si        ; set angular velocity
           call set_finala      ; set final anglular position (pre-calculation)
           mov ebx,o nullpalette  ; set cross referencing palette (null)
           call set_xref_palette

           mov si,2
           mov ebx,130000
           mov ecx,0
           mov ebp,50000
           call put_object
           mov bx,0
           mov cx,1000
           mov bp,7000
           call set_angle
           call set_object_on
           mov userotate[esi],0
           mov ax,1
           call set_shape
           mov ebx,000342000h
           mov ecx,000624000h
           mov ebp,000130000h
           mov di,44000
           call twist_si
           call set_finala
           mov ebx,o nullpalette
           call set_xref_palette

           mov si,3
           mov ebx,50000
           mov ecx,70000
           mov ebp,20000
           call put_object
           mov bx,0
           mov cx,0
           mov bp,0
           call set_angle
           call set_object_on
           mov userotate[esi],0
           mov ax,2
           call set_shape
           mov ebx,000310124h
           mov ecx,0ffbc2340h
           mov ebp,000530100h
           mov di,16000
           call twist_si
           call set_finala
           mov ebx,o nullpalette
           call set_xref_palette

           mov si,4
           mov ebx,50000
           mov ecx,-50000
           mov ebp,-20000
           call put_object
           mov bx,0
           mov cx,0
           mov bp,0
           call set_angle
           call set_object_on
           mov userotate[esi],0
           mov ax,3
           call set_shape
           mov ebx,000600000h
           mov ecx,0fff23400h
           mov ebp,000100000h
           mov di,11000
           call twist_si
           call set_finala
           mov ebx,o nullpalette
           call set_xref_palette

           mov si,5
           mov ebx,-70000
           mov ecx,30000
           mov ebp,-40000
           call put_object
           mov bx,0
           mov cx,0
           mov bp,0
           call set_angle
           call set_object_on
           mov userotate[esi],0
           mov ax,4
           call set_shape
           mov ebx,000200000h
           mov ecx,000100000h
           mov ebp,0ffa00000h
           mov di,12000
           call twist_si
           call set_finala
           mov ebx,o nullpalette
           call set_xref_palette

           mov si,6             ; this next object is the bitmaped
           mov ebx,-50000       ; cube, remove this and see the speed of
           mov ecx,-30000       ; only vectors
           mov ebp,10000
           call put_object      ; note: the bitmaps take a lot of cpu time
           mov bx,0
           mov cx,0
           mov bp,0
           call set_angle
           call set_object_on
           mov userotate[esi],0
           mov ax,5
           call set_shape
           mov ebx,000300000h
           mov ecx,000700000h
           mov ebp,000500000h
           mov di,13000
           call twist_si
           call set_finala

           mov si,7             ; stand alone bitmap - good for smoke or
           mov ebx,-5000        ; explosions
           mov ecx,5000
           mov ebp,25000
           call put_object      ; set location
           call set_object_on   ; turn it on
           mov ax,0             ; zeroth bitmap is shape
           call set_shape       ; will load from bitbase[0]
           mov vxs[esi*2],50    ; bitmap scaling (gets added to bitx and bity)
           mov vys[esi*2],50    ; bitmap scaling
           mov userotate[esi],himap  ; it's a bitmap (32)

           mov ebx,eyexq
           mov ecx,eyeyq
           mov ebp,eyezq
           mov di,eyetime
           mov esi,cameraobject
           call move_si
           call set_finall

           mov si,1             ; follow first object
           mov di,55            ; 55 frames to get there
           call newfollow

           mov bitx+4*0,15          ; base bitmap scaling
           mov bity+4*0,15
           mov bitbase+4*0,o sphere
           mov bitx+4*1,15          ; base bitmap scaling
           mov bity+4*1,15
           mov bitbase+4*1,o icon

;          mov eyezadds,50      ; make the camera rotate along it's z axis (just for fun)
;          mov esi,cameraobject
;          call set_finala

           call reset_raster_count   ; done before any animation loop!!!
           call init_tables          ; initialize 3d vector stuff

;          mov si,5                  ; an example of how to use point_time
;          mov ebx,-10000            ; si = obj, bx,cx,bp = location, di = time
;          mov ecx,-30000
;          mov ebp,90000
;          mov di,150
;          call point_time

; the main loop...

ieox:
;          mov si,6                  ; try uncommenting this!, this will point
;          mov di,cameraobject       ; the bitmapped cube at the camera. also
;          call point_it             ; uncomment it below, at ieox3:

;          mov eax,your_problem      ; debugging tool!!!!
;          mov number_eax,eax
;          call put_at_top

;          add y_angle_of_sun,150    ; watch the red ring carefully! the sun will move around the room!

           mov si,6                  ; move cube around...si - object
           mov ebp,15000             ; ebp = speed (make it faster!)
           mov di,600                ; di = total time (not in calculation)
           call set_speed            ; move object in direction it is pointing
           call set_finall           ; then calculate final position (not important as long as it keeps moving)

           call look_at_it           ; make camera look at selected object
           call setsincose           ; set rotation multipliers for eye
           call show_stars           ; plot background stars
           call makeobjs             ; plot all objects in sides table

           cmp eyelcount,0
           jnz dontmoveeye
           inc w eyeloc
           and w eyeloc,3
           movzx esi,w eyeloc
           mov ebx,eyexq[esi*4]
           mov ecx,eyeyq[esi*4]
           mov ebp,eyezq[esi*4]
           mov di,eyetime[esi*2]
           mov esi,cameraobject
           call move_si
           call set_finall
dontmoveeye:
;          call instant_mouse        ; plot mouse on screen
           call flip_page            ; flip video pages
           call clear_fill           ; clear video memory (last screen)
           call resetupd             ; reset borders

          ;mov ax,traces_past        ; show number of traces past per re-draw
          ;mov number_eax,eax
          ;call put_at_top

           call updvectors           ; move objects around, rotate them

           in al,60h                 ; test keyboard
           cmp al,1
           jne ieox
ieox2:
           in al,60h                 ; test keyboard
           cmp al,1
           je ieox2

           mov ax,w temp
           cmp ax,6
           jge ieox4

           inc w temp
           inc ax
           mov si,ax     ; ax = object
           mov di,55     ; di = time to get there (# of frames)
           call newfollow

           call reset_raster_count   ; done because esc key pressed!!!
           jmp ieox

; this is the part where the cube speeds away from you...and the program ends

ieox4:
           call reset_raster_count   ; done before any animation loop!!!

           mov zadds[6*4],-12000     ; make cube move!
           mov lcount[6*2],220       ; set counter 12000*220 = distance
ieox3:
;          mov si,6                  ; try this!!
;          mov di,cameraobject
;          call point_it

           mov wherelook,6           ; force to look at sphered cube
           call look_at_it
           call setsincose
           call show_stars           ; plot background stars
           call makeobjs

           call flip_page
           call clear_fill
           call resetupd
           call updvectors

           in al,60h                 ; test keyboard
           cmp al,1
           je getout

           mov ax,lcount[6*2]        ; check end counter (done flag)
           cmp ax,0
           jne ieox3
getout:
           call reset_rmirq  ; use one or the other, could use both if
;          call reset_pmirq  ; needed but delete inc traces_past from pmode

           jmp endpage       ; jump to stuff.inc for ending

temp       dw 1              ; next object to look at, for this demo only
eyeloc     dw 0              ; indexer for camera (this demo only)
eyexq      dd 195000,180000,-240000,-280000
eyeyq      dd -30000,25000,-35000,30000
eyezq      dd -270000,310000,240000,-220000
eyetime    dw 220,254,220,180

           public objbase    ; make sure these are here even if you don't
           public bitbase    ; use them.  tlink will fail if not present.!
           public bitx
           public bity

numberofobjects equ 32       ; number of 3d objects to allocate space for
numberofbitmaps equ 32       ; number of 3d bitmaps to allocate space for

           align 4

objbase    dd numberofobjects*4 dup (0) ; memory locations of shapes (offsets)
bitbase    dd numberofbitmaps dup (0)   ; memory locations of bitmaps
bitx       dd numberofbitmaps dup (0)   ; x base size of bitmaps (for 3d)
bity       dd numberofbitmaps dup (0)   ; y base size of bitmaps

code32     ends
           end
