page 66,132
;
; Assembly Language Support for fast3d
; in Turbo Pascal 5.0.  Gene Ressler
;
                .MODEL TPASCAL

N_PIX_X         equ     640
N_PIX_Y         equ     192
BUF_SIZE        equ     16384

                .DATA
                ALIGN 2
x0              dw      ?
y0              dw      ?
oldVec          dw      N_PIX_X dup (?)
newVec          dw      N_PIX_X dup (?)
minUpdtPtr      dw      ?
maxUpdtPtr      dw      ?
scrBuf          db      BUF_SIZE dup (?)

                .CODE
VIDEO           equ     10h
SELECT_MODE     equ      0
PALLETTE        equ     11
SET_BACKGROUND  equ      0
SET_PALLETTE    equ      1
SCREEN_SEG      equ     0B800h

SetVideo        PROC NEAR mode: BYTE
                PUBLIC SetVideo
                mov     ah, SELECT_MODE
                mov     al, mode
                int     VIDEO
                ret
SetVideo        ENDP

SetPallette     PROC NEAR pal: BYTE
                PUBLIC SetPallette
                mov     ah, PALLETTE
                mov     bh, SET_PALLETTE
                mov     bl, pal
                and     bl, SET_PALLETTE
                int     VIDEO
                ret
SetPallette     ENDP

SetBackground   PROC NEAR pal: BYTE
                PUBLIC SetBackground
                mov     ah, PALLETTE
                mov     bh, SET_BACKGROUND
                mov     bl, pal
                and     bl, 0Fh
                int     VIDEO
                ret
SetBackground   ENDP

ClearScreen     PROC NEAR
                PUBLIC ClearScreen
                mov    ax, SCREEN_SEG
                mov    es, ax
                xor    ax, ax
                xor    di, di
                mov    cx, BUF_SIZE/2
                cld
                rep stosw
                ret
ClearScreen     ENDP

InitCloud      PROC   NEAR
               PUBLIC InitCloud
               mov    ax, ds
               mov    es, ax
               mov    cx, N_PIX_X
               mov    dx, cx
               mov    ax, -1
               mov    di, offset oldVec
               cld
               rep stosw
               mov    cx, dx
               mov    di, offset newVec
               rep stosw
               mov    minUpdtPtr, offset newVec + 2*(N_PIX_X-1)
               mov    maxUpdtPtr, offset newVec
               ret
InitCloud      ENDP

UpdateCloud    PROC NEAR
               PUBLIC UpdateCloud
               mov    si, minUpdtPtr
               mov    cx, maxUpdtPtr
               sub    cx, si
               jb     noUpdateNeeded
               shr    cx, 1
               inc    cx
               mov    di, si
               add    di, offset oldVec - offset newVec
               mov    ax, ds
               mov    es, ax
               cld
               rep movsw
               mov    minUpdtPtr, offset newVec + 2*(N_PIX_X-1)
               mov    maxUpdtPtr, offset newVec
       noUpdateNeeded:
               ret
UpdateCloud    ENDP

ClearImage     PROC NEAR
               PUBLIC ClearImage
               mov    ax, ds
               mov    es, ax
               xor    ax, ax
               mov    cx, BUF_SIZE/2
               mov    di, offset scrBuf
               cld
               rep stosw
               ret
ClearImage     ENDP

; Show image buffer on CGA.

ShowImage      PROC NEAR
               PUBLIC ShowImage
               mov    ax, SCREEN_SEG
               mov    es, ax
               mov    bx, N_PIX_Y/2
               mov    si, offset scrBuf
               xor    di, di
               mov    dx, 40
               cld
        showLoop:
               mov    cx, dx
               rep movsw          ; Shoot 80 bytes to even buffer.
               add    di, 8192-80
               mov    cx, dx
               rep movsw          ; Now 80 bytes to odd buffer
               sub    di, 8192    ; Get ready for next even buffer row.
               dec    bx
               jnz    showLoop
               ret
ShowImage      ENDP

MovePen        PROC NEAR x: word, y: word
               PUBLIC MovePen
               mov ax, x
               mov x0, ax
               mov ax, y
               mov y0, ax
               ret
MovePen        ENDP

;
; drawLine -- Draw a line from current pen to x, y
;             and update the current pen.
;             Consider and update cloud.

DrawLine       PROC NEAR x1:word, y1:word
               PUBLIC DrawLine
               LOCAL  c1:word, c2:word, p:word
               LOCAL  newVecPtr:word, oldVecPtr: word
               LOCAL  yInc:word, xInc:word

               jmp     overProcs

               IFDEF PROFILE
               PUBLIC initX
               PUBLIC initY
               PUBLIC initXinc
               PUBLIC initYinc
               PUBLIC plot
               ENDIF

initX          PROC NEAR
               mov     ax, cx
               pop     si
               pop     di
               mov     bx, offset oldVec
               add     bx, di              ; ptr := base+x*2
               add     bx, di
               mov     oldVecPtr, bx
               mov     bx, offset newVec
               add     bx, di
               add     bx, di
               mov     newVecPtr, bx
               mov     cx, di
               shr     di, 1
               shr     di, 1
               shr     di, 1
               add     di, offset scrBuf
               and     cl, 7
               mov     bl, 080h
               shr     bl, cl
               mov     cx, ax
               jmp     si
initX          ENDP

initY          PROC NEAR
               pop     si
               pop     ax
               shl     ax, 1
               shl     ax, 1
               shl     ax, 1
               shl     ax, 1
               add     di, ax
               shl     ax, 1
               shl     ax, 1
               add     di, ax
               jmp     si
initY          ENDP

initXinc       PROC NEAR
               pop    si
               pop    ax
               pop    dx
               cmp    dx, ax
               jle    negXinc
               mov    xInc, 0
               jmp    si
       negXinc:
               mov    xInc, 1
               jmp    si
initXinc       ENDP

initYinc       PROC NEAR
               pop     si
               pop     ax
               pop     dx
               cmp     dx, ax
               jle     negYinc
               mov     yInc, 80
               jmp     si
       negYinc:
               mov     yInc, -80
               jmp     si
initYinc       ENDP

plot           PROC NEAR
               push   bx
               mov    bx, newVecPtr
               cmp    di, [bx]
               jae    notNewMin
               mov    [bx], di

               cmp    bx, minUpdtPtr
               jae    okOnLeft
               mov    minUpdtPtr, bx
       okOnLeft:
               cmp    bx, maxUpdtPtr
               jbe    okOnRight
               mov    maxUpdtPtr, bx
       okOnRight:

       notNewMin:
               mov    bx, oldVecPtr
               cmp    di, [bx]
               pop    bx
               jae    notVis
               or     [di], bl
       notVis:
               ret
plot           ENDP

       overProcs:
               mov    cx, x1
               sub    cx, x0
               jge    dxNotNeg
               neg    cx
       dxNotNeg:
               mov    dx, y1
               sub    dx, y0
               jge    dyNotNeg
               neg    dx
       dyNotNeg:
               cmp    cx, dx
               jg     dxGTdy
               jmp    dxLEdy
       dxGTdy:
               mov    ax, dx
               add    ax, ax
               mov    c1, ax
               sub    ax, cx
               mov    p, ax
               mov    ax, dx
               sub    ax, cx
               add    ax, ax
               mov    c2, ax
               mov    cx, x0
               mov    dx, x1
               cmp    cx, dx
               jle    x0LEx1
               push   dx
               call   initX
               push   y1
               call   inity
               sub    cx, dx ; form loop count
               push   y0
               push   y1
               call   inityinc
               jmp    short xplot1stpt
           x0lex1:
               push   cx
               call   initx
               push   y0
               call   inity
               sub    dx, cx ; form loop count
               mov    cx, dx
               push   y1
               push   y0
               call   inityinc
       xplot1stpt:
               call   plot
               mov    si, p
               jcxz   skipXpixLoop
      xPixLoop:
               add    newVecPtr, 2
               add    oldVecPtr, 2
               ror    bl, 1
               adc    di, 0
               or     si, si
               jge    xpge0
               add    si, c1
               call   plot
               loop   xpixloop
               jmp    done
       xpge0:
               add    si, c2
               add    di, yInc
               call   plot
               loop   xpixloop
       skipXpixLoop:
               jmp    done
       dxLEdy:
               mov    ax, cx
               add    ax, ax
               mov    c1, ax
               sub    ax, dx
               mov    p, ax
               mov    ax, cx
               sub    ax, dx
               add    ax, ax
               mov    c2, ax
               mov    cx, y0
               mov    dx, y1
               cmp    cx, dx
               jle    y0ley1
               push   x1
               call   initx
               push   dx
               call   inity
               sub    cx, dx
               push   x0
               push   x1
               call   initxinc
               jmp    short yplot1stpt
       y0ley1:
               push   x0
               call   initx
               push   cx
               call   inity
               sub    dx, cx
               mov    cx, dx
               push   x1
               push   x0
               call   initxinc
       yplot1stpt:
               call   plot
               mov    si, p
               jcxz   done
       ypixloop:
               add    di, 80
               or     si, si
               jge    ypge0
               add    si, c1
               call   plot
               loop   ypixloop
               jmp    short done
       ypge0:
               add    si, c2
               cmp    xinc, 0
               jne    decx
               add    newVecPtr, 2
               add    oldVecPtr, 2
               ror    bl, 1
               adc    di, 0
               call   plot
               loop   ypixloop
               jmp    short done
       decx:
               sub    newVecPtr, 2
               sub    oldVecPtr, 2
               rol    bl, 1
               sbb    di, 0
               call   plot
               loop   ypixloop
       done:
               mov    ax, x1
               mov    x0, ax
               mov    ax, y1
               mov    y0, ax
               ret
DrawLine       ENDP

               END