Declare Function GetWindowsDirectory Lib "kernel" (ByVal P$, ByVal S%) As Integer
Declare Function GetModuleHandle Lib "kernel" (ByVal FileName$) As Integer
Declare Function GetModuleFileName Lib "kernel" (ByVal hModule%, ByVal FilName$, ByVal nSize%) As Integer
Global PianoPath As String

' MIDI Functions Windows 3.1
Declare Function MidiOutOpen Lib "mmsystem.dll" (hMidiOut As Long, ByVal DeviceId As Integer, ByVal C As Long, ByVal I As Long, ByVal F As Long) As Integer
Declare Function MidiOutShortMsg Lib "mmsystem.dll" (ByVal hMidiOut As Integer, ByVal MidiMessage As Long) As Integer
Declare Function MidiOutGetNumDevs Lib "mmsystem.dll" () As Integer
Declare Function MidiOutClose Lib "mmsystem.dll" (ByVal hMidiOut As Integer) As Integer

Global MidiEventOut, MidiNoteOut, MidiVelOut As Long

Global hMidiOut As Long
Global hMidiOutCopy As Integer
Global MidiOpenError As String

Global Const MODAL = 1

Global Const ShiftKey = 1

Declare Function GetProfileString Lib "kernel" (ByVal Sname$, ByVal Kname$, ByVal Def$, ByVal Ret$, ByVal Size%) As Integer
Declare Function WriteProfileString Lib "kernel" (ByVal Sname$, ByVal Kname$, ByVal Set1$) As Integer
Declare Function GetPrivateProfileString Lib "kernel" (ByVal Sname$, ByVal Kname$, ByVal Def$, ByVal Ret$, ByVal Size%, ByVal Fname$) As Integer
Declare Function WritePrivateProfileString Lib "kernel" (ByVal Sname$, ByVal Kname$, ByVal Set1$, ByVal Fname$) As Integer

' The Patch number array used for current patch for each midi channel
' Then Volume array used for each channels volume setting
' TrackChannel is array for the current midi channel that that Track on the mixi is set to.
Global MidiPatch(16), MidiVolume(16), TrackChannel(16), MidiPan(16), Octave(16) As Integer

' The current Midi Channel out set on Piano form
Global MidiChannelOut As Integer

' The Velocity (Volume) of notes for current midi channel
Global MidiVelocity As Integer

'Boolean for it CapsLock has been pressed or not
Global CapsLock As Integer

' NoteRepeat used to stop the same key from repeating.  CapsLock detects if it is down.
Global NoteRepeat As Integer

' Play wave sounds
Declare Function sndPlaySound Lib "mmsystem" (ByVal lpsSound As String, ByVal wFlag As Integer) As Integer

Sub MidiOutOpenPort ()
    'Open Midi Out while song is not playing
    MidiOpenError = Str$(MidiOutOpen(hMidiOut, -1, 0, 0, 0))
    hMidiOutCopy = hMidiOut
End Sub

Sub ReadPatch ()
    Dim Sname As String, Ret As String, Ext As String
    Ret = String$(255, 0)
    Default1$ = Ret
    Sname = "General MIDI"
    Ext = Str$(MidiPatch(MidiChannelOut))
    FileName$ = "PATCH.INI"
    nSize = GetPrivateProfileString(Sname, Ext, Default1$, Ret, Len(Ret), FileName$)
    Piano.PatchLabel.Caption = Ret
End Sub

Sub SendMidiOut ()
    Dim MidiMessage As Long
    Dim lowint As Long
    Dim highint As Long
    
    lowint = (MidiNoteOut * 256) + MidiEventOut
    highint = (MidiVelOut * 256) * 256

    MidiMessage = lowint + highint
    X% = MidiOutShortMsg(hMidiOutCopy, MidiMessage)
End Sub

