VERSION 2.00
Begin Form Form1 
   Caption         =   "WM_NCPAINT Demo"
   ClientHeight    =   3435
   ClientLeft      =   2115
   ClientTop       =   2325
   ClientWidth     =   6420
   Height          =   3840
   Left            =   2055
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3435
   ScaleWidth      =   6420
   Top             =   1980
   Width           =   6540
   Begin VBMsg VBMsg1 
      Height          =   420
      Left            =   5970
      MessageCount    =   NCFORM.FRX:0000
      MessageList     =   NCFORM.FRX:0002
      MessageTypes    =   0  'Selected Messages
      PostDefault     =   0   'False
      Top             =   2970
      Width           =   420
   End
   Begin PictureBox picSysMenu 
      AutoSize        =   -1  'True
      Height          =   300
      Left            =   5580
      Picture         =   NCFORM.FRX:0200
      ScaleHeight     =   270
      ScaleWidth      =   270
      TabIndex        =   0
      Top             =   3060
      Visible         =   0   'False
      Width           =   300
   End
   Begin Label Label1 
      Caption         =   "Notice the new System Menu bitmap.  Using VB Messenger, you can trap non-client area messages to change the look of Windows itself.  This sample traps WM_NCPAINT and WM_NCACTIVATE to detect when to draw the system menu bitmap.  Also, VB Messenger is used to change the behavior of the system menu.  By trapping the WM_NCLBUTTONDOWN message, you can allow the user to close a window simply by clicking the system menu once instead of twice."
      Height          =   2025
      Left            =   510
      TabIndex        =   1
      Top             =   660
      Width           =   5355
   End
End
Option Explicit

Sub DrawBitmapNCArea (hWindow As Integer, hbmp As Integer, cxLeft As Integer, cyTop As Integer)

    Dim hdc%, hdcMem%
    Dim bmp As BITMAP
    Dim hbmpOld%
    Dim lprect As RECT
    Dim hinst%
    Dim rc&
    
    hinst = GetWindowWord(hWindow, GWW_HINSTANCE)
    hdc = GetWindowDC(hWindow)
    hdcMem = CreateCompatibleDC(hdc)
    
    rc = APIGetObject(hbmp, Len(bmp), bmp)
    hbmpOld = SelectObject(hdcMem, hbmp)
    rc = BitBlt(hdc, cxLeft, cyTop, bmp.bmWidth, bmp.bmHeight, hdcMem, 0, 0, SRCCOPY)
    rc = SelectObject(hdcMem, hbmpOld)
    
    rc = DeleteDC(hdcMem)
    rc = ReleaseDC(hWnd, hdc)

End Sub

Sub Form_Load ()

    VBMsg1.SubClasshWnd = Form1.hWnd

End Sub

Sub VBMsg1_WindowMessage (hWindow As Integer, Msg As Integer, wParam As Integer, lParam As Long, RetVal As Long, CallDefProc As Integer)

    'VB Messenger is setup to trap WM_NCPAINT, WM_NCACTIVATE and WM_NCLBUTTONDOWN
    
    Select Case Msg
        
        Case WM_NCPAINT
        
            RetVal = DefWindowProc(hWindow, Msg, wParam, lParam)
            
            DrawBitmapNCArea hWindow, (picSysMenu.Picture), GetSystemMetrics(SM_CXFRAME), GetSystemMetrics(SM_CYFRAME)

            CallDefProc = False
        
        Case WM_NCACTIVATE

            If wParam = False Then
                RetVal = True
            Else
                RetVal = DefWindowProc(hWindow, Msg, wParam, lParam)
            End If
            
            DrawBitmapNCArea hWindow, (picSysMenu.Picture), GetSystemMetrics(SM_CXFRAME), GetSystemMetrics(SM_CYFRAME)
            
            CallDefProc = False

        Case WM_NCLBUTTONDOWN
        
            If wParam = HTSYSMENU Then
                VBMsg1.wParam = 0
                VBMsg1.lParam = 0
                VBMsg1.PostMessage = WM_CLOSE
                CallDefProc = False
                Exit Sub
            End If
        
    End Select

End Sub

