
'This routine is called after each file is closed and
'all processing for that file is finished.
Sub AfterAFile ()
End Sub

'This routine is called at the very end of the program,
'after all files have been processed.
Sub AfterAllFiles ()
End Sub

'The return value of BeforeAFile is usually True, which
'indicates that the current file is to be processed
'normally.  By returning False, you can skip processing
'the current file.
Function BeforeAFile ()
    BeforeAFile = True
End Function

'This routine is executed at the very beginning of the
'application, before any files are opened or any
'processing has taken place.  It normally returns True;
'if it returns False, the program terminates immediately
'without processing any files.
Function BeforeAllFiles () As Integer
    BeforeAllFiles = True
End Function

'This routine called over and over, each time being
'passed a succeeding line of the file being
'processed.  Or, in binary mode, this routine is passed
'a chunk of bytes as long as RECLEN, except for the
'final chunk which may be smaller than RECLEN.
Function DoALine (TheLine As String) As Integer
    DoALine = True
End Function

