
'====================================================================================
'TaskList.Bas - Copyright 1994 michiel de bruijn, Rotterdam, The Netherlands
' Released for public use 16/08/1994. See TASKLIST.WRI for licensing details
'====================================================================================

DefInt A-Z

'TOOLHELP TaskEntry type declaration
Type TASKENTRY
    dwSize As Long              'Size of the TASKENTRY structure, in bytes
    hTask As Integer            'Task handle for the stack
    hTaskParent As Integer      'Parent of the task
    hInstance As Integer        'Instance handle of the task
    hModule As Integer          'Module containg the currently executing function
    wSS As Integer              'Value in the SS register
    wSP As Integer              'Value in the SP register
    wStackTop As Integer        'Top of the stack (lowest address on stack)
    wStackMinimum As Integer    'Lowest segment number of stack during execution of the task
    wStackBottom As Integer     'Bottom of the stack (highest address on stack)
    wcEvents As Integer         'Number of pending events
    hQueue As Integer           'Task Queue
    szModule As String * 10     'Module name (length as per Windows 3.1 toolhelp.h)
    wPSPOffset As Integer       'Offset from the PSP to the beginning of the code segment
    hNext As Integer            'Next entry in task list (Windows internal use only)
End Type

'TOOLHELP ModuleEntry type declaration
Type MODULEENTRY
    dwSize As Long              'Size of the MODULEENTRY structure, in bytes
    szModule As String * 10     'Module name
    hModule As Integer          'Module handle
    wcUsage As Integer          'Reference count of the module
    szExePath As String * 256   'Fully-qualified executable path for the module
    wNext As Integer            'Next entry in module list (Windows internal use only)
End Type

'TOOLHELP ClassEntry type declaration
Type CLASSENTRY
    dwSize As Long              'Size of the CLASSENTRY structure, in bytes
    hInst As Integer            'Identifies the instance handle of the task (module!) that owns the class
    szClassName As String * 256 'Class name
    wNext As Integer            'Next entry in class list (Windows internal use only)
End Type

'Windows API window class type declaration
Type WNDCLASS
    Style As Integer            'Class style
    WndProc As Long             'Pointer to the window procedure
    cbClsExtra As Integer       'Number of extra bytes after the window-class structure
    cbWndExtra As Integer       'Number of extra bytes after the window instance
    hInstance As Integer        'Instance that the window procedure of this class is within
    hIcon As Integer            'Handle to the class icon
    hCursor As Integer          'Handle to the class cursor
    hbrBackGround As Integer    'Handle to the class background brush
    lpszMenuName As Long        'Pointer to the resource name of the class menu (not used by GetClassInfo)
    lpszClassName As Long       'Pointer to the window class name or an atom that identifies such string (not used by GetClassInfo)
End Type
    
'Windows RECTangle type declaration
Type RECT
  left As Integer
  top As Integer
  right As Integer
  bottom As Integer
End Type

'VBASM function declaration
Declare Function vbGetLongPtr Lib "VBASM.DLL" (nVariable As Any) As Long

'TOOLHELP function declarations
Declare Function TaskFirst Lib "toolhelp" (te As TASKENTRY) As Integer
Declare Function TaskNext Lib "toolhelp" (te As TASKENTRY) As Integer
Declare Function ModuleFirst Lib "toolhelp" (mo As MODULEENTRY) As Integer
Declare Function ModuleNext Lib "toolhelp" (mo As MODULEENTRY) As Integer
Declare Function ModuleFindName Lib "toolhelp" (mo As MODULEENTRY, ByVal lpszName As String) As Integer
Declare Sub TerminateApp Lib "toolhelp" (ByVal hTask As Integer, ByVal wFlags As Integer)
Declare Function ClassFirst Lib "toolhelp" (ce As CLASSENTRY) As Integer
Declare Function ClassNext Lib "toolhelp" (ce As CLASSENTRY) As Integer

'CTL3D function declarations (use Lib "CTL3DV2" if you've got that DLL)
Declare Function GetModuleHandle Lib "Kernel" (ByVal lpModuleName As String) As Integer
Declare Function Ctl3dRegister Lib "CTL3D.DLL" (ByVal hInstance As Integer) As Integer
Declare Function Ctl3dAutoSubClass Lib "CTL3D.DLL" (ByVal hInstance As Integer) As Integer
Declare Function Ctl3dUnregister Lib "CTL3D.DLL" (ByVal hInstance As Integer) As Integer

'Windows API function declarations
Declare Function SetWindowPos% Lib "User" (ByVal win%, ByVal awin%, ByVal xp%, ByVal yp%, ByVal xs%, ByVal ys%, ByVal flags%)
Declare Function GetSysColor Lib "User" (ByVal nIndex As Integer) As Long
Declare Function GetSystemMetrics Lib "User" (ByVal nIndex As Integer) As Integer

Declare Function AppendMenu Lib "User" (ByVal hMenu As Integer, ByVal wFlags As Integer, ByVal wIDNewItem As Integer, ByVal lpNewItem As Any) As Integer
Declare Function CreatePopupMenu Lib "User" () As Integer
Declare Function ModifyMenu Lib "User" (ByVal hMenu%, ByVal nPosition%, ByVal wFlags%, ByVal wIDNewItem%, ByVal lpNewItem As Any) As Integer
Declare Function SendMessage Lib "User" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, lParam As Any) As Long
Declare Function TrackPopupMenu Lib "User" (ByVal hMenu As Integer, ByVal wFlags As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal nReserved As Integer, ByVal hWnd As Integer, lpReserved As Any) As Integer

Declare Function GetWindow Lib "User" (ByVal hWnd As Integer, ByVal wCmd As Integer) As Integer
Declare Function GetWindowTask Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function GetWindowWord% Lib "user" (ByVal hWnd As Integer, ByVal nOffset As Integer)
Declare Function GetWindowText Lib "User" (ByVal hWnd As Integer, ByVal lpString As String, ByVal aint As Integer) As Integer
Declare Function IsWindowVisible Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function IsIconic Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function IsZoomed Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function ArrangeIconicWindows Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function GetDeskTopWindow Lib "User" () As Integer
Declare Function GetClassInfo Lib "User" (ByVal hInst As Integer, ByVal lpszClassName As String, lpwc As Long) As Integer

Declare Function DrawIcon Lib "User" (ByVal hDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal hIcon As Integer) As Integer
Declare Function DestroyIcon% Lib "User" (ByVal hIcon As Integer)
Declare Function ExtractIcon% Lib "Shell" (ByVal hInst As Integer, ByVal lpszFileName As String, ByVal nIconIndex As Integer)

Declare Function PostAppMessage Lib "User" (ByVal hTask As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, lParam As Any) As Integer
Declare Function PostMessage Lib "User" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, lParam As Any) As Integer

Declare Function GetKeyState Lib "User" (ByVal nVirtKey As Integer) As Integer

Declare Sub FreeModule Lib "Kernel" (ByVal hModule As Integer)

'Undocumented Windows API functions -- use at your own risk
Declare Sub SwitchToThisWindow Lib "User" Alias "#172" (ByVal hWnd As Integer, ByVal bRestore As Integer)
Declare Sub CascadeChildWindows Lib "User" Alias "#198" (ByVal hParent As Integer, ByVal wAction As Integer)
Declare Sub TileChildWindows Lib "User" Alias "#199" (ByVal hParent As Integer, ByVal wAction As Integer)
Declare Function IsWinOldApTask Lib "Kernel" Alias "#158" (ByVal hTask As Integer) As Integer

'Window messages
Global Const WM_COMMAND = &H111
Global Const WM_NCACTIVATE = &H86
Global Const WM_NCHITTEST = &H84
Global Const WM_NCLBUTTONDBLCLK = &HA3
Global Const WM_NCLBUTTONDOWN = &HA1
Global Const WM_SYSCOMMAND = &H112
Global Const WM_QUIT = &H12
'Undocumented/unreliable Windows messages (test only)
Global Const WM_OTHERWINDOWCREATED = &H42
Global Const WM_OTHERWINDOWDESTROYED = &H43

'wParam values for WM_SYSCOMMAND
Global Const SC_MOVE = &HF010
Global Const SC_CLOSE = &HF060

'Menu function values
Global Const MF_ENABLED = 0
Global Const MF_STRING = 0
Global Const MF_CHECKED = &H8
Global Const MF_BYPOSITION = &H400
Global Const MF_SEPARATOR = &H800

'Menu ID's
Global Const IDM_SYSMOVE = 101
Global Const IDM_SYSCLOSE = 102
Global Const IDM_FLOAT = 103

'Windows system color constants
Global Const COLOR_ACTIVECAPTION = 2
Global Const COLOR_INACTIVECAPTION = 3

'System metrics constant
Global Const SM_CYMENU = 15

'Message Blaster VBX constants
Global Const PREPROCESS = -1
Global Const EATMESSAGE = 0
Global Const POSTPROCESS = 1

'WM_NCHITTEST return values
Global Const HTCLIENT = 1
Global Const HTCAPTION = 2
Global Const HTSYSMENU = 3

'GetWindow constants
Global Const GW_HWNDFIRST = 0
Global Const GW_HWNDNEXT = 2
Global Const GW_OWNER = 4

'GetWindowWord constants
Global Const GWW_HINSTANCE = -6
Global Const GWW_HWNDPARENT = -8

'MDI Tile constants
Global Const MDITILE_HORIZONTAL = 0
Global Const MDITILE_VERTICAL = 1

'Virtual key code
Global Const VK_SHIFT = &H10

'Global variables ... <shiver>
Global hInst%

Static Sub DoEnd ()

'DoEnd: gracefully terminate our app

' Get our instance handle again
hInstance% = GetWindowWord(forms(0).hWnd, GWW_HINSTANCE)
' And unregister from the CTL3D library
res% = Ctl3dUnregister(hInstance%)

End

End Sub

Static Function Hex4$ (value%)

'Hex4$: convert integer into 4-digit hex number
Hex4$ = Right$("0000" & Hex$(value%), 4)

End Function

Sub main ()

' Get the instance handle to our application by calling GetWindowWord
' with the GWW_HINSTANCE parameter (get instance handle of the module that owns this window)
hInstance% = GetWindowWord(TaskList.hWnd, GWW_HINSTANCE)
' And register the app with the CTL3D library
res% = Ctl3dRegister(hInstance%)
res% = Ctl3dAutoSubClass(hInstance%)

'Start the show!
TaskList.Show 1

End Sub

Static Function ZTrim$ (lin$)

'ZTrim: Like Trim$, but works (only) for NULL-terminated
' (C-style) strings.
ZTrim$ = Trim$(Left$(lin$, InStr(lin$, Chr$(0)) - 1))

End Function

