'used to figure out if it was a text box control passed to the function
Declare Function GetClassName Lib "User" (ByVal hWnd As Integer, ByVal lpClassName As String, ByVal nMaxCount As Integer) As Integer
'used to create a temporary text file that can be opened in our Excel object
Declare Function GetTempFileName Lib "Kernel" (ByVal cDriveLetter As Integer, ByVal lpPrefixString As String, ByVal wUnique As Integer, ByVal lpTempFileName As String) As Integer

'the class type of a VB Text Box
Global Const TEXT_BOX = "ThunderTextBox"

'the Excel object type
Global Const EXCEL_OBJECT = "EXCEL.APPLICATION"

Function FixText (MyText As String) As String

Dim StartPos As Integer
Dim FoundPos As Integer

'get rid of the tab characters
StartPos = 1
FoundPos = InStr(StartPos, MyText, Chr$(9))

While FoundPos > 0
  Mid$(MyText, FoundPos, 1) = Chr$(32)
  StartPos = FoundPos + 1
  FoundPos = InStr(StartPos, MyText, Chr$(9))
Wend

'put the comma's back in
StartPos = 1
FoundPos = InStr(StartPos, MyText, Chr$(186))

While FoundPos > 0
  Mid$(MyText, FoundPos, 2) = Chr$(44)
  StartPos = FoundPos + 1
  FoundPos = InStr(StartPos, MyText, Chr$(186))
Wend

FixText = MyText

End Function

Function GetTempFile () As String

Dim FileName As String
Dim RetVal As Integer

'clear out the variable
FileName = String$(256, 0)

'get a temporary file name
RetVal = GetTempFileName(0, "", 0, FileName)

'trim out the blanks
FileName = Left$(FileName, RetVal)

'return the results
GetTempFile = FileName

End Function

Function PrepText (MyText As String) As String

'this function is necessary to remove the commas from the text.  We need to do so
'because when Excel saves the file back to text, it will put quotes around any
'word that has a comma following it.  So, we're taking a chance and saying that we
'don't think anyone is going to use ANSI character #186 in any of the text we're
'checking.  If it is in there, it will be changed to a comma when it comes back
'(in the FixText function).

Dim StartPos As Integer
Dim FoundPos As Integer

StartPos = 1
FoundPos = InStr(StartPos, MyText, Chr$(44))

While FoundPos > 0
  Mid$(MyText, FoundPos, 1) = Chr$(186)
  StartPos = FoundPos + 1
  FoundPos = InStr(StartPos, MyText, Chr$(44))
Wend

PrepText = MyText

End Function

Function SpellCheck (MyControl As Control) As Integer

Dim ClassName As String
Dim RetVal As Integer
Dim xlApp As Object
Dim xlWorkBook As Object
Dim xlWorkSheet As Object
Dim FileName As String
Dim FileName2 As String
Dim MyText As String
Dim FileNum As Integer

Const xlTextPrinter = 36
Const xlWindows = 2
Const xlDelimited = 1
Const xlNone = -4142
Const xlText = -4158
Const xlTextWindows = 20

On Error GoTo SpellCheckError

SpellCheck = False  'set initial value

'clear out variable
ClassName = String$(256, 0)

'get the class name of the control to make sure that it's a VB Text Box
RetVal = GetClassName(MyControl.hWnd, ClassName, 255)

ClassName = Left$(ClassName, RetVal)

If ClassName <> TEXT_BOX Then  'if we haven't been passed a text box as a control
  MsgBox "The control you are checking is not a text box; the spell check will not work.", 16, ProgTitle
  Exit Function
End If

'turn the pointer to an hourglass
Screen.MousePointer = 11

'put the text into a variable
MyText = MyControl.Text

'change out all the commas because Excel saves them back with quotes around them
MyText = PrepText(MyText)

'get a temporary file name
FileName = GetTempFile()

'get a free file num
FileNum = FreeFile

'open the file and stick out text to be checked into it
Open FileName For Binary As #FileNum

'put the variable into the file
Put #FileNum, , MyText

'close the file
Close #FileNum

'create the Excel application object to do the spell check for us
Set xlApp = CreateObject(EXCEL_OBJECT)
'open our text file
xlApp.Workbooks.OpenText FileName, xlWindows, 1, xlDelimited, xlNone, True, False, False, False, True, False, ""
'get the active sheet
Set xlWorkSheet = xlApp.ActiveSheet
'get the current workbook
Set xlWorkBook = xlApp.ActiveWorkbook

'check the spelling
xlWorkSheet.CheckSpelling

'bring on the hourglass
Screen.MousePointer = 11

'get a second file name
FileName2 = GetTempFile()

'remove it from the system...
Kill FileName2

'...but still use the name - save the worksheet
xlWorkSheet.SaveAs FileName2, xlTextWindows

'set the Saved property so Excel won't prompt us to save it in Excel 5.0 format
xlWorkBook.Saved = True

'quit Excel
xlApp.Quit

'get a free file number
FileNum = FreeFile

'open the file back up
Open FileName2 For Binary As #FileNum

'read the data in
MyText = Input$(LOF(FileNum), #FileNum)

'close the file up again
Close #FileNum

'get rid of the tab characters and put the commas back in
MyText = FixText(MyText)

'put the text back in the text box
MyControl.Text = MyText

'remove the object from memory
Set xlApp = Nothing

'get rid of our temporary files
Kill FileName
Kill FileName2

'let user know we're done
MsgBox "Spelling check is complete.", 64, ProgTitle

SpellCheck = True

SpellCheckResume:
Screen.MousePointer = 0
Exit Function

SpellCheckError:
'figure out what error occurred
Select Case Err
  Case 429
    MsgBox "Unable to create OLE Automation object with Excel; make sure Excel 5.0 has been properly installed.", 16, ProgTitle
  Case Else
    MsgBox "Error #" + Trim$(Str$(Err)) + " - " + Error + " - has occurred.", 16, ProgTitle
End Select

Resume SpellCheckResume

End Function

