VERSION 2.00
Begin Form frmAccMove 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Accurate Move"
   ClientHeight    =   5790
   ClientLeft      =   2445
   ClientTop       =   1485
   ClientWidth     =   7365
   ControlBox      =   0   'False
   Height          =   6195
   Left            =   2385
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5790
   ScaleWidth      =   7365
   Top             =   1140
   Width           =   7485
   Begin Frame FrameFill 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Fill Pattern"
      Height          =   1095
      Left            =   4440
      TabIndex        =   3
      Top             =   3360
      Width           =   2775
      Begin OptionButton Empty 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Transparent"
         Height          =   255
         Left            =   240
         TabIndex        =   5
         Top             =   360
         Width           =   2295
      End
      Begin OptionButton Filled 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Graduated Fill"
         Height          =   255
         Left            =   240
         TabIndex        =   4
         Top             =   720
         Value           =   -1  'True
         Width           =   2415
      End
   End
   Begin Frame FrameSelect 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Select By"
      Height          =   1095
      Left            =   4440
      TabIndex        =   0
      Top             =   4560
      Width           =   2775
      Begin OptionButton ByRect 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Rectangular Area"
         Height          =   255
         Left            =   240
         TabIndex        =   2
         Top             =   720
         Width           =   2415
      End
      Begin OptionButton ByInk 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Ink"
         Height          =   255
         Left            =   240
         TabIndex        =   1
         Top             =   360
         Value           =   -1  'True
         Width           =   1095
      End
   End
   Begin Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "Try dragging the pentagon with different fill and selection options."
      ForeColor       =   &H00FF0000&
      Height          =   615
      Left            =   4440
      TabIndex        =   6
      Top             =   2640
      Width           =   2775
      WordWrap        =   -1  'True
   End
   Begin SCGraphic pentagon 
      AngleEnd        =   45
      AngleStart      =   -90
      ArrowSize       =   2  'Small
      ArrowType       =   0  'None
      DrawInside      =   0   'False
      FillColor       =   &H00FF00FF&
      FillColor2      =   &H0000FFFF&
      FillPattern     =   16  'Graduated Vertical
      Height          =   2415
      InhibitEraseOnRedraw=   0   'False
      Left            =   480
      LineColor       =   &H00FF0000&
      LinePattern     =   0  'Solid
      LineWidth       =   50
      MouseEvents     =   -1  'True
      NumPoints       =   5
      PaletteSteps    =   50
      RoundRadius     =   0
      SelectByInk     =   -1  'True
      ShadowColor     =   &H00000000&
      ShadowDepthX    =   0
      ShadowDepthY    =   0
      Shape           =   6  'Ngon
      ShowOutlineOnly =   0   'False
      Top             =   1560
      Use256Palette   =   -1  'True
      Width           =   3375
   End
End
Option Explicit
Dim WereMoving As Integer     ' record MouseDown/Up events
Dim StartX, StartY As Single  ' mouse location at the start of a move

Sub ByInk_Click ()
    pentagon.SelectByInk = True
End Sub

Sub ByRect_Click ()
    pentagon.SelectByInk = False
End Sub

Sub Empty_Click ()
    pentagon.FillPattern = 1   ' Clear fill pattern
End Sub

Sub Filled_Click ()
    pentagon.FillPattern = 16  ' graduated vertical
End Sub

Sub Form_Load ()
    WereMoving = False   ' the mouse is up to begin with
End Sub

Sub pentagon_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    ' record the MouseDown so MouseMove updates the shape
    WereMoving = True
    ' record the starting mouse position so we can move relative to that spot
    ' this is described in the VB3 manual on p. 283
    StartX = X
    StartY = Y
    ' use transparent shapes for faster redraw during mouse move
    ' we'll turn gradfills back on in MouseUp
    pentagon.ShowOutlineOnly = True
End Sub

Sub pentagon_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    ' a MouseDown event sets the WereMoving flag
    If WereMoving Then
        ' redraw the shape at the current mouse position
        pentagon.Move pentagon.Left + X - StartX, pentagon.Top + Y - StartY
    End If
End Sub

Sub pentagon_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
    ' we finished a move so turn fills back on
    pentagon.ShowOutlineOnly = False
    ' we aren't moving until we get another MouseDown
    WereMoving = False
End Sub

