Option Explicit

' Simple function to add a new index to an openeded database
' ---------------------------------------------------------
Function db_addindex% (db As Database, tablename$, ixn$, ixf$, ixu%, ixp%)
    Dim nindx As New Index
    On Error Resume Next
    Err = False
    If Len(ixn) = 0 Or Len(ixf) = 0 Then
       db_addindex = True
       Exit Function
    End If
    nindx.Name = ixn
    nindx.Fields = ixf
    nindx.Primary = ixp
    nindx.Unique = ixu
    
    db.TableDefs(tablename).Indexes.Append nindx
    
    If Err Then
       MsgBox Error$ & Chr$(13) & "Table: " & tablename & Chr$(13) & "Index: " & ixn, 48
    Else
       db_addindex = True
    End If
End Function

' --------------------------------------------------------
' dbf_compactdatabase dBName$
' --------------------------------------------------------
' Compacts an entire xBase database (dBase IV/FoxPro 2.5)
'
' Arguments:
'           dBName  - Name/Directory of the database
'           dBC     - Connect (dBase IV or FoxPro 2.5)
'
' Returns:
'           Bool    - True if successful
'
'
' ==> Make sure that the database can be opened for exlusive
'     usage!!!
'
Function dbf_compactDatabase% (dbName$, dbc$)
    Dim db As Database
    Dim tn$, i%

    On Error Resume Next
    Err = False
    
    For i = 0 To 10000
        Err = False
        Set db = OpenDatabase(dbName$, True, False, dbc)
        If Err Then
           MsgBox Error$, 48
           Exit For
        End If
        If i + 1 > db.TableDefs.Count Then Exit For
        tn = db.TableDefs(i).Name
        db.Close
        If dbf_compactTable(dbName, dbc, tn) = False Then Exit Function
    Next
    dbf_compactDatabase = True
End Function

' --------------------------------------------------------
' dbf_compactTable dBName$, tableName$
' --------------------------------------------------------
' Compacts a xBase table (dBase IV/FoxPro 2.5)
'
' Arguments:
'           dBName      - Name/Directory of the database
'           dBC         - Connect (dBase IV or FoxPro 2.5)
'           tableName   - Name of the table
'
' Returns:
'           Bool    - True if successful
'
'
' ==> Make sure that the database can be opened for exlusive
'     usage!!!
'
Function dbf_compactTable% (ByVal dbPath$, dbc$, tablename$)
    Dim db As Database, iSuf$, mSuf$
    Dim ox As Indexes, oxc%, i%
    
    On Error Resume Next
    Err = False
    Set db = OpenDatabase(dbPath, True, False, dbc)
    If Err Then
       MsgBox Error$, 48
       Exit Function
    End If
    If LCase$(dbc) = "dbase iv;" Then
       iSuf = ".MDX"
       mSuf = ".DBT"
    Else
       iSuf = ".CDX"
       mSuf = ".FPT"
    End If
    
    If Right$(dbPath, 1) <> "\" Then dbPath = dbPath & "\"
    GoSub dbComp_killTemp
    
    screen.MousePointer = 11
    db.Execute ("SELECT * INTO temptbl0 from " & tablename)
    If Err Then
       MsgBox Error$, 48
       GoTo dbComp_exit
    End If

    Set ox = db.TableDefs(tablename).Indexes
    oxc = ox.Count - 1
    For i = 0 To oxc
        If db_addindex(db, "temptbl0", CStr(ox(i).Name), CStr(ox(i).Fields), CInt(ox(i).Unique), CInt(ox(i).Primary)) = False Then
           GoTo dbComp_exit
        End If
    Next
    If Err = False Then
       Kill dbPath & tablename & ".DBF"
       Kill dbPath & tablename & mSuf
       Kill dbPath & tablename & iSuf
       Name dbPath & "temptbl0" & iSuf As dbPath & tablename & iSuf
       Name dbPath & "temptbl0.dbf" As dbPath & tablename & ".DBF"
       Name dbPath & "temptbl0" & mSuf As dbPath & tablename & mSuf
       GoSub dbComp_killTemp
    End If

    dbf_compactTable = True

dbComp_exit:
    db.Close
    screen.MousePointer = 0
    Exit Function

dbComp_killTemp:
    Kill dbPath & "temptbl0.dbf"
    Kill dbPath & "temptbl0" & mSuf
    Kill dbPath & "temptbl0" & iSuf
    Err = False
    Return

End Function

