VERSION 2.00
Begin Form NumWin_Form 
   Caption         =   "NumWin  Test"
   ClientHeight    =   5145
   ClientLeft      =   1215
   ClientTop       =   1860
   ClientWidth     =   5010
   Height          =   5835
   Left            =   1155
   LinkTopic       =   "Form1"
   ScaleHeight     =   5145
   ScaleWidth      =   5010
   Top             =   1230
   Width           =   5130
   Begin Numwin NumWin1 
      Prop9           =   ""
      Left            =   600
      Top             =   120
   End
   Begin CommandButton BTN_Exit 
      Caption         =   "Exit"
      Height          =   375
      Left            =   3720
      TabIndex        =   2
      Top             =   240
      Width           =   1215
   End
   Begin TextBox Text2 
      Height          =   4215
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   1
      Top             =   840
      Width           =   4815
   End
   Begin CommandButton Btn_Refresh 
      Caption         =   "Refresh"
      Height          =   375
      Left            =   2400
      TabIndex        =   0
      Top             =   240
      Width           =   1215
   End
   Begin Menu nmu_File 
      Caption         =   "&File"
      Begin Menu mnu_Exit 
         Caption         =   "&Exit"
      End
   End
   Begin Menu mnu_Edit 
      Caption         =   "&Edit"
      Begin Menu mnu_Cut 
         Caption         =   "Cu&t"
      End
      Begin Menu mnu_Copy 
         Caption         =   "&Copy"
      End
      Begin Menu mnu_Paste 
         Caption         =   "&Paste"
      End
      Begin Menu mnu_submenu 
         Caption         =   "SubMenu"
         Begin Menu mnu_submenu1 
            Caption         =   "SubMenu 1"
         End
         Begin Menu mnu_submenu2 
            Caption         =   "SubMenu 2"
         End
      End
   End
End
Option Explicit

' The Action parameter
Const NUMWIN_REFRESH = 10

''
'' some of the APIs which might be useful
Declare Function GetClassName Lib "User" (ByVal hWnd As Integer, ByVal lpClassName As String, ByVal nMaxCount As Integer) As Integer

'' a constant for use with GetWindowWord and GetModuleFileName
Const GWW_HINSTANCE = (-6)
Declare Function GetWindowWord Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer) As Integer
Declare Function GetModuleFileName Lib "Kernel" (ByVal hModule As Integer, ByVal lpFilename As String, ByVal nSize As Integer) As Integer

Sub BTN_Exit_Click ()
    mnu_Exit_Click
End Sub

Sub Btn_Refresh_Click ()
' PURPOSE: Fill the array with current values
'''''''''''''''''''''''''''''''''''''''''''''''''
    
    Text2.Text = ""
    NumWin1.Action = NUMWIN_REFRESH '10

End Sub

Sub Form_Load ()
' PURPOSE: Just load
''''''''''''''''''''''''''''''''''
    If Me.windowstate = 0 Then
        top = 0
        Left = 0
    End If

End Sub

Sub Form_Resize ()
    If Me.windowstate = 0 Then
        Me.Height = 5815
        Me.Width = 5175
    End If
End Sub

Sub mnu_Exit_Click ()
    End
End Sub

Sub NumWin1_NumWinClick (Count As Integer)
' PURPOSE: Put all the window handles and window text in the text box
' COMMENTS: Three arrays are passed back from NUMWIN.VBX
'           They are;
'           1. HwndArray the hwnds of all windows.
'           2. HwndParArray the parent hwnds.
'               if zero then hwnd is a top level window.
'           3. WinTextArray the window text appearing in
'               the window bar or control caption.
'           The variable Count returned is the total window count
'
'           Shows some of the things that can be done with APIs.
'           Declares are in this module.
'
'           This test print out is somewhat long and in much more detail
'           than is normally needed. Choose the data appropiate for your
'           program.
'
' IMPORTANT ... IMPORTANT ... IMPORTANT
'
'   DATA IN THE ARRAYS IS ONLY VALID IN THIS SUB ROUTINE.
'
'   ALWAYS USE THE NUMWINx.REFRESH COMMAND IMMEDIATELY BEFORE ACCESSING DATA.
'   WINDOWS CAN UPDATE THE SCREEN AT ANY TIME AND DESTROY OR CREATE NEW WINDOWS.
'   CAUTION IS ADVISED WHEN USING THIS DATA. IT IS PRUDENT PROGRAMMING PRACTICE TO
'   ALWAYS TEST FOR VALIDITY BEFORE USE TO PREVENT PROBLEMS FROM OCCURRING.
'   THE WINDOWS API IsWindow() CAN PERFORM A HWND VALIDITY TEST.
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim Msg As String
Dim CRLF As String
Dim ndex As Integer
Dim cbBuf As String * 64
Dim cbCount As Integer
Dim hInstance As Integer

    '' inits
    CRLF = Chr$(13) + Chr$(10)
    Msg = ""
    '' go through all the hWnds
    For ndex = 1 To Count
        ''
        '' the hWnd
        Msg = Msg + "hWnd = " + Str$(NumWin1.HwndArray(ndex)) + CRLF
        ''
        '' parent of window
        '' if hwnd parent = 0 then it is a top level window
        '' use this technique to find all top level windows
        If NumWin1.HwndParArray(ndex) = 0 Then
            Msg = Msg + "Parent = " + "[TOPLEVEL WINDOW]" + CRLF
            ''
            '' this is for top level windows only
            hInstance = GetWindowWord(NumWin1.HwndArray(ndex), GWW_HINSTANCE)
            cbCount = GetModuleFileName(hInstance, cbBuf, 64)
            cbBuf = Left$(cbBuf, cbCount)
            Msg = Msg + "ModuleName = " + cbBuf + CRLF
        Else
            Msg = Msg + "Parent = " + Str$(NumWin1.HwndParArray(ndex)) + CRLF
        End If
        ''
        '' the class name contains additional information about the window
        '' use the API call to get the ClassName
        cbCount = GetClassName(NumWin1.HwndArray(ndex), cbBuf, 64)
        cbBuf = Left$(cbBuf, cbCount)
        Msg = Msg + "Class Name = " + cbBuf + CRLF
        ''
        '' window text
        If Len(NumWin1.WinTextArray(ndex)) <> "0" Then
            Msg = Msg + "Text = " + NumWin1.WinTextArray(ndex) + CRLF + CRLF
        Else
            Msg = Msg + "Text = <NONE>" + CRLF + CRLF
        End If
    Next ndex

    Text2.Text = "Number of Windows = " + Str$(Count) + CRLF + CRLF + Msg

End Sub

