'NWDIR.BAS  NetWare Directory Services Interface for Visual Basic For Windows
'Version 1.0
'Novell Systems Research Department, Novell, Inc.
'Copyright (c) 1993, Novell, Inc.
'This interface is not supported through Novell's regular
'support channels.  See README.TXT for more information.

'Modify flags for SetEntry
Global Const M_MODIFY_NAME = 1
Global Const M_FILE_ATTRIBUTES = 2
Global Const M_CREATE_DATE = 4
Global Const M_CREATE_TIME = 8
Global Const M_OWNER_ID = 16
Global Const M_LAST_ARCHIVED_DATE = 32
Global Const M_LAST_ARCHIVED_TIME = 64
Global Const M_LAST_ARCHIVED_ID = 128
Global Const M_LAST_UPDATED_DATE = 256
Global Const M_LAST_UPDATED_TIME = 512
Global Const M_LAST_UPDATED_ID = 1024
Global Const M_LAST_ACCESSED_DATE = 2048
Global Const M_INHERITED_RIGHTS_MASK = 4096
Global Const M_MAXIMUM_SPACE = 8192
Global Const M_MAC_MODIFY_NAME = 1
Global Const M_MAC_FINDER_INFO = 2
Global Const M_MAC_PRODOS_INFO = 4

Global Const NWMAX_VOL_NAME = 48
Global Const NCP_MAX_BUFFER = 512

'Drive constants
Global Const NO_BASE_DRIVE = &HFF
Global Const TEMPORARY_DRIVE = 0
Global Const PERMANENT_DRIVE = 1
Global Const TEMP_DRIVE = 26
Global Const TEMP_DRIVE1 = 27
Global Const TEMP_DRIVE2 = 28
Global Const TEMP_DRIVE3 = 29

'Search drive flags
Global Const DRIVE_ADD = 1
Global Const DRIVE_INSERT = 2
Global Const DRIVE_DELETE = 3
Global Const MAX_NETWARE_SEARCH_DRIVES = 16

'Drive flags
Global Const DRIVE_LOCAL = &H80
Global Const DRIVE_PERMANENT = 1
Global Const DRIVE_TEMPORARY = 2
Global Const DRIVE_NETWORK = 3

'Trustee rights for v2.x
Global Const TA_NONE = &H0
Global Const TA_READ = &H1
Global Const TA_WRITE = &H2
Global Const TA_OPEN = &H4
Global Const TA_CREATE = &H8
Global Const TA_DELETE = &H10
Global Const TA_OWNERSHIP = &H20
Global Const TA_SEARCH = &H40
Global Const TA_MODIFY = &H80
Global Const TA_ALL = &HFF

'Trustee rights for v3.x/4.x
Global Const TR_NONE = &H0
Global Const TR_READ = &H1
Global Const TR_WRITE = &H2
Global Const TR_CREATE = &H8
Global Const TR_ERASE = &H10
Global Const TR_ACCESS = &H20
Global Const TR_FILE = &H40
Global Const TR_MODIFY = &H80
Global Const TR_SUPERVISOR = &H100
Global Const TR_NORMAL = &HFF
Global Const TR_ALL = &H1FF

'Set numTrusteeEntries to the number of trustees that the
'  ScanEntryForTrustees function is to return data for.
'  Used in the TRUSTEE_BUFFER_3X type below
Global Const numTrusteeEntries = 4

Type NWDIR_ENTRY
     sequence As Long
     reserved1 As Long
     attributes As Long
     reserved2 As Integer
     NSType As String * 1
     nameLength As String * 1
     name As String * 12
     creationDate As Integer
     creationTime As Integer
     ownerID As Long
     lastArchivedDate As Integer
     lastArchivedTime As Integer
     lastArchiverID As Long
     modifyDate As Integer
     modifyTime As Integer
     reserved3 As String * 56
     inheritedRightsMask As Integer
     reserved4 As String * 26
End Type

Type NWFILE_ENTRY
     sequence As Long
     reserved1 As Long
     attributes As Long
     reserved2 As Integer
     NSType As String * 1
     nameLength As String * 1
     name As String * 12
     creationDate As Integer
     creationTime As Integer
     ownerID As Long
     lastArchivedDate As Integer
     lastArchivedTime As Integer
     lastArchiverID As Long
     modifyDate As Integer
     modifyTime As Integer
     lastModifierID As Long
     dataForkSize As Long
     reserved3 As String * 44
     inheritedRightsMask As Integer
     lastAccessDate As Integer
     reserved4 As String * 28
End Type

Type NWDIR_INFO
     totalBlocks As Long
     freeBlocks As Long
     totalDirEntries As Long
     availDirEntries As Long
     flags As Long              'currently unused
     sectorsPerBlock As String * 1
     volumeName As String * NWMAX_VOL_NAME
End Type

Type DRIVE_VECTOR
     vector As String * 17
End Type

Type VOLUME_STATS
     systemElapsedTime As Long
     volumeNumber As String * 1
     logicalDriveNumber As String * 1
     sectorsPerBlock As Integer
     startingBlock As Integer
     totalBlocks As Integer
     availableBlocks As Integer
     totalDirectorySlots As Integer
     availableDirectorySlots As Integer
     maxDirectorySlotsUsed As Integer
     isHashing As String * 1
     isCaching As String * 1
     isRemovable As String * 1
     isMounted As String * 1
     volumeName As String * 16
End Type

Type NWVOL_USAGE
     totalBlocks As Long
     freeBlocks As Long
     purgableBlocks As Long
     notYetPurgableBlocks As Long
     totalDirEntries As Long
     availDirEntries As Long
     maxDirEntriesUsed As Long
     unused As String * 4
     blockSize As Integer
     isHashing As String * 1
     isRemovable As String * 1
     volName As String * NWMAX_VOL_NAME
End Type

Type NWBUFFER
    buffer As String * NCP_MAX_BUFFER
End Type

Type TRUSTEE_BUFFER_2X
    dirName As String * 16
    created As String * 4
    ownerID As Long
    oID(5) As Long
    rights(5) As String * 1
End Type

Type TRUSTEE_BUFFER_3X
    numEntriesReturned As String * 1
    oID(numTrusteeEntries) As Long
    rights(numTrusteeEntries) As Integer
End Type

Declare Function AddTrusteeToDirectory Lib "NWNETAPI.DLL" (ByVal dirHandle%, ByVal dirPath$, ByVal trusteeObjectID&, ByVal trusteeRightsMask%) As Integer
Declare Function AllocPermanentDirectoryHandle Lib "NWNETAPI.DLL" (ByVal dirHandle%, ByVal dirPath$, ByVal driveLetter%, newDirHandle%, effectiveRightsMask%) As Integer
Declare Function AllocTemporaryDirectoryHandle Lib "NWNETAPI.DLL" (ByVal dirHandle%, ByVal dirPath$, ByVal driveLetter%, newDirHandle%, effectiveRightsMask%) As Integer
Declare Function ClearVolRestrictions Lib "NWNETAPI.DLL" (ByVal serverConnID%, ByVal volNumber%, ByVal objectID&) As Integer
Declare Function CreateDirectory Lib "NWNETAPI.DLL" (ByVal dirHandle%, ByVal dirPath$, ByVal maximumRightsMask%) As Integer
Declare Function DeallocateDirectoryHandle Lib "NWNETAPI.DLL" (ByVal dirHandle%) As Integer
Declare Function DeleteDirectory Lib "NWNETAPI.DLL" (ByVal dirHandle%, ByVal dirPath$) As Integer
Declare Function DeleteTrustee Lib "NWNETAPI.DLL" (ByVal serverConnID%, ByVal dirHandle%, ByVal path$, ByVal objectID&) As Integer      '3.x/4.x only
Declare Function DeleteTrusteeFromDirectory Lib "NWNETAPI.DLL" (ByVal dirHandle%, ByVal dirPath$, ByVal trusteeObjectID&) As Integer
Declare Function GetCurrentDirectory Lib "NWNETAPI.DLL" (ByVal driveNumber%, ByVal directory$) As Integer
Declare Function GetDirectoryHandle Lib "NWNETAPI.DLL" (ByVal driveNumber%) As Integer
'dirPath$ must be initialized to 255 bytes
Declare Function GetDirectoryPath Lib "NWNETAPI.DLL" (ByVal dirHandle%, ByVal dirPath$) As Integer
Declare Function GetDirEntry Lib "NWNETAPI.DLL" (ByVal serverConnID%, ByVal dirHandle%, dirEntry As NWDIR_ENTRY) As Integer     '3.x/4.x only
Declare Function GetDirInfo Lib "NWNETAPI.DLL" (ByVal serverConnID%, ByVal dirHandle%, dirInfo As NWDIR_INFO) As Integer        '3.x/4.x only
Declare Function GetDriveInformation Lib "NWNETAPI.DLL" (ByVal driveNumber%, connectionID%, dirHandle%) As Integer
Declare Function GetEffectiveDirectoryRights Lib "NWNETAPI.DLL" (ByVal dirHandle%, ByVal dirPath$, effectiveRightsMask%) As Integer
Declare Function GetEffectiveRights Lib "NWNETAPI.DLL" (ByVal serverConnID%, ByVal dirHandle%, ByVal path$, rights%) As Integer '3.x/4.x only
Declare Function GetObjectDiskRestrictions Lib "NWNETAPI.DLL" (ByVal serverConnID%, ByVal volNumber%, ByVal objectID&, volRestrictions&, blocksInUse&) As Integer   '3.x/4.x only
'vectorBuffer must be initialized to 17 bytes
Declare Function GetSearchDriveVector Lib "NWNETAPI.DLL" (vectorBuffer As DRIVE_VECTOR) As Integer
Declare Function GetVolumeInformation Lib "NWNETAPI.DLL" (ByVal connectionID%, ByVal volumeNumber%, ByVal structSize%, volStats As VOLUME_STATS) As Integer
'volumeName must be initialized to 16 bytes
Declare Function GetVolumeInfoWithHandle Lib "NWNETAPI.DLL" (ByVal dirHandle%, ByVal volumeName$, totalBlocks%, sectorsPerBlock%, availableBlocks%, totalDirectorySlots%, availableDirectorySlots%, volumeIsRemovable%) As Integer
'volumeName must be initialized to 16 bytes
Declare Function GetVolumeInfoWithNumber Lib "NWNETAPI.DLL" (ByVal volNumber%, ByVal volumeName$, totalBlocks%, sectorsPerBlock%, availableBlocks%, totalDirectorySlots%, availableDirectorySlots%, volumeIsRemovable%) As Integer
'volumeName must be initialized to 16 bytes
Declare Function GetVolumeName Lib "NWNETAPI.DLL" (ByVal volumeNumber%, ByVal volumeName$) As Integer
Declare Function GetVolumeNumber Lib "NWNETAPI.DLL" (ByVal volumeName$, volumeNumber%) As Integer
Declare Function GetVolUsage Lib "NWNETAPI.DLL" (ByVal serverConnID%, ByVal volNumber%, volUsage As NWVOL_USAGE) As Integer     '3.x/4.x only
Declare Function IsSearchDrive Lib "NWNETAPI.DLL" (ByVal driveLetter%) As Integer
Declare Function MapDrive Lib "NWNETAPI.DLL" (ByVal connectionID%, ByVal baseDriveNumber%, ByVal directoryPath$, ByVal searchFlag%, ByVal searchOrder%, ByVal driveLetter$) As Integer
Declare Function MapDriveUsingString Lib "NWNETAPI.DLL" (ByVal mapType$, ByVal drive$, ByVal mapString$) As Integer
Declare Function MapV2TrusteeRightsToV3 Lib "NWNETAPI.DLL" (ByVal trusteeRightsV2%) As Long     '3.x/4.x only
Declare Function MapV3TrusteeRightsToV2 Lib "NWNETAPI.DLL" (ByVal trusteeRightsV3&) As Integer  '3.x/4.x only
Declare Function ModifyMaximumRightsMask Lib "NWNETAPI.DLL" (ByVal directoryHandle%, ByVal directoryPath$, ByVal revokeRightsMask%, ByVal grantRightsMask%) As Integer
Declare Function MoveEntry Lib "NWNETAPI.DLL" (ByVal serverConnID%, ByVal sourceAttributes%, ByVal sourceDirHandle%, ByVal sourcePath$, ByVal destDirHandle%, ByVal destPath$) As Integer   '3.x/4.x only
Declare Function RenameDirectory Lib "NWNETAPI.DLL" (ByVal directoryHandle%, ByVal directoryPath$, ByVal newDirectoryName$) As Integer
Declare Function RestoreDirectoryHandle Lib "NWNETAPI.DLL" (ByVal saveBuffer$, newDirectoryHandle%, effectiveRightsMask%) As Integer    '2.x only
'saveBuffer must be initialized to 14 characters
Declare Function SaveDirectoryHandle Lib "NWNETAPI.DLL" (ByVal directoryHandle%, ByVal saveBuffer$) As Integer      '2.x only
'trusteePathName must be initialized to 255 characters
Declare Function ScanBinderyObjectTrusteePaths Lib "NWNETAPI.DLL" (ByVal objectID&, ByVal volumeNumber%, sequenceNumber%, trusteeAccessMask%, ByVal trusteePathName$) As Integer
'directoryName must be initialized to 16 bytes
'trusteeIDs is an array of 5 Longs
'trusteeRights must be initialized to 5 bytes
Declare Function ScanDirectoryForTrustees Lib "NWNETAPI.DLL" (ByVal directoryHandle%, ByVal directoryPath$, sequenceNumber%, ByVal directoryName$, creationDateAndTime&, ownerID&, trusteeIDs&, trusteeRights$) As Integer  '2.x only
'directoryName must be initialized to 16 bytes
Declare Function ScanDirectoryInformation Lib "NWNETAPI.DLL" (ByVal directoryHandle%, ByVal searchDirectoryPath$, sequenceNumber%, ByVal directoryName$, creationDateAndTime&, ownerObjectID&, maximumRightsMask%) As Integer
Declare Function ScanDirEntry Lib "NWNETAPI.DLL" (ByVal serverConnID%, ByVal dirHandle%, ByVal searchPath$, ByVal searchAttributes%, sequence%, dirEntry As NWDIR_ENTRY) As Integer
'buffer must be initialized to ((numberOfStructures * 9) + 1) bytes
Declare Function ScanDirRestrictions Lib "NWNETAPI.DLL" (ByVal serverConnID%, ByVal dirHandle%, ByVal buffer$, ByVal numberOfStructures%) As Integer    '3.x/4.x only
'pass a structure of type TRUSTEE_BUFFER_2X in trusteeBuffer parameter for NetWare 2.x,
'TRUSTEE_BUFFER_3X for NetWare 3.x/4.x
Declare Function ScanEntryForTrustees Lib "NWNETAPI.DLL" (ByVal serverConnID%, ByVal directoryHandle%, ByVal directoryPath$, trusteeBuffer As Any, ByVal trusteeSetNumber%, ByVal trusteeGroupsToReturn%) As Integer
Declare Function ScanVolForRestrictions Lib "NWNETAPI.DLL" (ByVal serverConnID%, ByVal volumeNumber%, sequence%, buffer As NWBUFFER) As Integer     '3.x/4.x only
Declare Function SetDirectoryHandle Lib "NWNETAPI.DLL" (ByVal sourceDirectoryHandle%, ByVal sourceDirectoryPath$, ByVal targetDirectoryHandle%) As Integer
Declare Function SetDirectoryInformation Lib "NWNETAPI.DLL" (ByVal directoryHandle%, ByVal directoryPath$, ByVal newCreationDateAndTime&, ByVal newOwnerObjectID&, ByVal newRightsMask%) As Integer
Declare Function SetDirRestriction Lib "NWNETAPI.DLL" (ByVal serverConnID%, ByVal dirHandle%, ByVal restriction&) As Integer    '3.x/4.x only
Declare Function SetDrivePath Lib "NWNETAPI.DLL" (ByVal driveNumber%, ByVal baseDriveNumber%, ByVal path$, ByVal permanentFlag%) As Integer
'entry can be a pointer to a NWDIR_ENTRY or NWFILE_ENTRY structure
Declare Function SetEntry Lib "NWNETAPI.DLL" (ByVal serverConnID%, ByVal dirHandle%, ByVal searchAttributes%, ByVal entryID&, ByVal changeBits&, entry As Any) As Integer   '3.x/4.x only
Declare Function SetSearchDriveVector Lib "NWNETAPI.DLL" (ByVal vectorBuffer$) As Integer
Declare Function SetTrustee Lib "NWNETAPI.DLL" (ByVal serverConnID%, ByVal dirHandle%, ByVal dirPath$, ByVal trusteeObjectID&, ByVal trusteeRightsMask&) As Integer     '3.x/4.x only
Declare Function SetVolRestriction Lib "NWNETAPI.DLL" (ByVal serverConnID%, ByVal volNumber%, ByVal objectID&, ByVal restriction&) As Integer       '3.x/4.x only

