VERSION 2.00
Begin Form frmMsgSpyDemo 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Message Spy Custom Control Demo"
   ClientHeight    =   4725
   ClientLeft      =   495
   ClientTop       =   1590
   ClientWidth     =   5370
   Height          =   5160
   Icon            =   SPYDEMO.FRX:0000
   Left            =   420
   LinkTopic       =   "Form2"
   ScaleHeight     =   315
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   358
   Tag             =   "This is the main form."
   Top             =   1230
   Width           =   5520
   Begin CommandButton Command1 
      Caption         =   "Command btn"
      Height          =   375
      Left            =   540
      TabIndex        =   1
      Tag             =   "This is a command button."
      Top             =   540
      Width           =   1635
   End
   Begin Frame fraStatusArea 
      BackColor       =   &H00C0C0C0&
      Height          =   1572
      Left            =   120
      TabIndex        =   10
      Tag             =   "This is the status area frame."
      Top             =   3000
      Width           =   5112
      Begin CheckBox chkSpyingEnabled 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Spying Enabled"
         Height          =   252
         Left            =   240
         TabIndex        =   11
         Tag             =   "Check to enable spying."
         Top             =   240
         Value           =   1  'Checked
         Width           =   1752
      End
      Begin Label lblControlTag 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   252
         Left            =   240
         TabIndex        =   12
         Top             =   660
         Width           =   4572
      End
      Begin Label lblMessage 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   252
         Left            =   240
         TabIndex        =   13
         Top             =   1080
         Width           =   2652
      End
      Begin Label lblXPos 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   252
         Left            =   3120
         TabIndex        =   14
         Top             =   1080
         Width           =   732
      End
      Begin Label lblYPos 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   252
         Left            =   4080
         TabIndex        =   15
         Top             =   1080
         Width           =   732
      End
   End
   Begin Frame Frame1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Frame"
      Height          =   2772
      Left            =   2700
      TabIndex        =   9
      Tag             =   "This is a frame."
      Top             =   120
      Width           =   2052
      Begin CheckBox Check1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Check Box"
         Height          =   312
         Left            =   300
         TabIndex        =   5
         Tag             =   "This is the first check box."
         Top             =   360
         Width           =   1572
      End
      Begin CheckBox Check2 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Check Box"
         Height          =   312
         Left            =   300
         TabIndex        =   6
         Tag             =   "This is the second check box."
         Top             =   960
         Width           =   1572
      End
      Begin OptionButton Option4 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Radio button"
         Height          =   375
         Left            =   300
         TabIndex        =   8
         Tag             =   "This is the second radio button in the frame."
         Top             =   2220
         Width           =   1455
      End
      Begin OptionButton Option3 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Radio button"
         Height          =   375
         Left            =   300
         TabIndex        =   7
         Tag             =   "This is the first radio button in the frame."
         Top             =   1560
         Value           =   -1  'True
         Width           =   1455
      End
   End
   Begin MsgSpy MsgSpy1 
      Left            =   2160
      MessageNumber   =   1024
      SpyMode         =   0  'All Messages
      Tag             =   "This is a Message Spy control!"
      Top             =   1440
   End
   Begin OptionButton Option2 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Radio button"
      Height          =   375
      Left            =   540
      TabIndex        =   3
      Tag             =   "This is the second radio button."
      Top             =   1620
      Width           =   1455
   End
   Begin TextBox Text1 
      Height          =   285
      Left            =   540
      TabIndex        =   0
      Tag             =   "This is a text box."
      Text            =   "Text box"
      Top             =   120
      Width           =   1635
   End
   Begin ListBox List1 
      Height          =   810
      Left            =   540
      TabIndex        =   4
      Tag             =   "This is a list box."
      Top             =   2160
      Width           =   1635
   End
   Begin OptionButton Option1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Radio button"
      Height          =   375
      Left            =   540
      TabIndex        =   2
      Tag             =   "This is the first radio button."
      Top             =   1080
      Value           =   -1  'True
      Width           =   1455
   End
End
'-------------------------------------------------
'
' SpyDemo - a Message Spy Custom Control demo
'
' Note the possible uses of the following
' properties within the MsgReceieved event:
'
'   MessageName - the name of the message
'   IsControl   - whether message is for a control
'   Control     - the actual subclassed control!!!
'   ControlName - the subclassed control's name
'   IsForm      - whether message is for a form
'   Form        - the actual subclassed form!!!
'   FormName    - the subclassed form's name
'   HIWORD      - like HIWORD(LParam) in C/C++
'   LOWORD      - like LOWORD(LParam) in C/C++
'
' Copyright (c) 1992-1994 Anton Software Limited.
'
'-------------------------------------------------

Option Explicit

' Const WM_SETFOCUS = &H7
' Const WM_MOUSEMOVE = &H200
'
' These constants are not needed, as the message
' name is provided directly. Nevertheless, for
' production code, or if performance is a major
' issue, it would be better to use them instead.
'
' e.g.
'
'   If (Msg = WM_SETFOCUS) Then
'
'   instead of
'
'   If (MsgSpy1.MessageName = "WM_SETFOCUS") Then

Sub chkSpyingEnabled_Click ()

    ' Enable/disable the Message Spy control.
    MsgSpy1.Enabled = chkSpyingEnabled.Value

End Sub

Sub Form_Load ()

    ' Handle controls without hWnd properties.
    On Error GoTo Handler

    ' Subclass ALL the other controls on the form.
    Dim i As Integer
    For i = 0 To controls.Count - 1
        MsgSpy1 = controls(i).hWnd
    Next i

    ' Subclass the form itself.
    MsgSpy1 = frmMsgSpyDemo.hWnd

    Exit Sub

Handler:

    ' Labels (etc.) don't have window handles!
    Resume Next

End Sub

Sub MsgSpy1_MsgReceived (hWnd As Integer, Msg As Integer, WParam As Integer, LParam As Long)

    ' The control or form name and tag.
    Dim WindowName As String
    Dim WindowTag  As String

    ' Save the message name.
    Dim MessageName As String
    MessageName = MsgSpy1.MessageName

    ' If the message is for a control...
    If MsgSpy1.IsControl Then

        ' Save the control's name.
        WindowName = MsgSpy1.ControlName

        ' Process the message...
        Select Case MessageName

            Case "WM_SETFOCUS"
                ' Got focus message.
                SetLabel lblMessage, WindowName & " got focus"

            Case "WM_MOUSEMOVE"
                ' Save the control's tag.
                WindowTag = MsgSpy1.Control.Tag

        End Select

    Else ' MsgSpy1.IsForm = True

        ' Save the form's name and tag.
        WindowName = MsgSpy1.FormName
        WindowTag = MsgSpy1.Form.Tag

    End If
    
    ' If the mouse is over the control/form...
    If (MessageName = "WM_MOUSEMOVE") Then

        ' Display the control's/form's name and the
        ' mouse coordinates.
        SetLabel lblMessage, "Mouse is over " & WindowName
        SetLabel lblXPos, Str$(MsgSpy1.LOWORD)
        SetLabel lblYPos, Str$(MsgSpy1.HIWORD)

        ' Display the control's/form's tag.
        SetLabel lblControlTag, WindowTag

    End If

End Sub

Sub SetLabel (LabelControl As Label, ByVal LabelCaption As String)

    If (LabelControl.Caption <> LabelCaption) Then
        LabelControl.Caption = LabelCaption
    End If

End Sub

