VERSION 2.00
Begin Form LOSTFOCUS 
   BackColor       =   &H00C0C0C0&
   Caption         =   "LostFocus Solution / Field Validation Example"
   ClientHeight    =   2415
   ClientLeft      =   975
   ClientTop       =   1530
   ClientWidth     =   6525
   Height          =   2790
   Left            =   930
   LinkTopic       =   "Form1"
   ScaleHeight     =   2415
   ScaleWidth      =   6525
   Top             =   1200
   Width           =   6615
   Begin CommandButton Cmd_Save 
      Caption         =   "&Save"
      Default         =   -1  'True
      Height          =   510
      Left            =   4635
      TabIndex        =   7
      Top             =   270
      Width           =   1050
   End
   Begin CommandButton Cmd_Cancel 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   510
      Left            =   4635
      TabIndex        =   6
      Top             =   945
      Width           =   1050
   End
   Begin ComboBox Cbo_Title 
      Height          =   300
      Left            =   1530
      Sorted          =   -1  'True
      TabIndex        =   2
      Top             =   1575
      Width           =   1770
   End
   Begin TextBox Txt_Forename 
      Height          =   375
      Left            =   1530
      TabIndex        =   1
      Top             =   945
      Width           =   1770
   End
   Begin TextBox Txt_Surname 
      Height          =   375
      Left            =   1530
      TabIndex        =   0
      Top             =   270
      Width           =   1770
   End
   Begin Label Lbl_Forename 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Forename"
      Height          =   195
      Left            =   270
      TabIndex        =   5
      Top             =   1035
      Width           =   1005
   End
   Begin Label Lbl_Surname 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Surname"
      Height          =   195
      Left            =   270
      TabIndex        =   4
      Top             =   360
      Width           =   1005
   End
   Begin Label Lbl_Title 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Title"
      Height          =   195
      Left            =   270
      TabIndex        =   3
      Top             =   1620
      Width           =   1005
   End
End
Option Explicit

'---------------------------------------------------------------------------
'This example form was uploaded by Nigel Price 100063,3363 for anyone to view
'and use/modify etc. It shows a method for validating fields using the LostFocus
'event. This has been the cause of a lot of problems and discussion on MSBASIC.

'This solution allows a Cancel button to work either by clicking, pressing
'the default Esc key, or by using the Alt-C accelerator key. The validation routine
'is very basic just to demonstrate the technique. The user is able to move
'from field to field if the field validation is ok. If it is not the user
'is shown a message and then they are returned to that field. The user can
'choose to Cancel at any time using the Cancel button. I have tested the
'technique with many different controls including 3rd party ones. I hope it
'helps anyone trying to do field level validation. I have extended this basic
'technique to include a form level validation routine which calls this for
'each field and builds up a 'List of Field problems' which the user can view.
'They can then deal with each problem. Basically that Form level validation loops
'through the Controls collection and calls this (or rather a modified version!)
'procedure. I have not uploaded that version because it requires the use of
'the CtlName() function which comes with Jonathan Zucks VBZ Electronic magazine

'If anyone has any comments (constructive ones!) or problems feel free to
'send me a message.
'---------------------------------------------------------------------------

Dim sm_LostFocus_Control As String   'Holds name of Current Control which has a validation error

Sub Cbo_Title_LostFocus ()

Field_LostFocus Cbo_Title, "Cbo_Title"

End Sub

Sub Cmd_Cancel_Click ()

Unload Me

End Sub

Sub Cmd_Save_Click ()

MsgBox "Save the Record Here"

End Sub

Sub Field_LostFocus (Current_Control As Control, Control_Name As String)
'Note : If you subscribe to VBZ an Electronic magazine for VB there is a function
'       called CtlName() which can save having to pass the Control_Name parameter.
'       You can then use CtlName(Current_Control) to get the name of the current
'       control. This saves one parameter.

If LOSTFOCUS.ActiveControl <> LOSTFOCUS!Cmd_Cancel Then     'User clicked on a control other than the Cmd_Cancel button
    Control_Name = UCase$(Control_Name)                     'Upper case the Control Name which called this Sub

    If Control_Name = UCase$(sm_LostFocus_Control) Or sm_LostFocus_Control = "" Then   'Is a LostFocus Validation already occuring?
        Select Case Control_Name
            Case "TXT_SURNAME"      'Validate Txt_Surname Here

                If LOSTFOCUS!Txt_Surname.Text = "" Then
                    sm_LostFocus_Control = Control_Name
                    MsgBox "The Surname cannot be Blank, Please re-enter it"
                    Current_Control.SetFocus
                Else                    'All Validation OK for Txt_Surname
                    sm_LostFocus_Control = ""
                End If

            Case "TXT_FORENAME"     'Validate Txt_Forename Here

                If LOSTFOCUS!Txt_Forename.Text = "" Then
                    sm_LostFocus_Control = Control_Name
                    MsgBox "The Forename cannot be Blank, Please re-enter it"
                    Current_Control.SetFocus
                Else                    'All Validation OK for Txt_Forename
                    sm_LostFocus_Control = ""
                End If

            Case "CBO_TITLE"
            
                If LOSTFOCUS!Cbo_Title.Text = "" Then
                    sm_LostFocus_Control = Control_Name
                    MsgBox "The Title must be entered / selected from Combo Box List"
                    Current_Control.SetFocus
                Else                    'All Validation OK for Cbo_Title
                    sm_LostFocus_Control = ""
                End If

        End Select
    End If
Else
    sm_LostFocus_Control = ""           'Clear the LostFocus Control Name as were Cancelling
End If

End Sub

Sub Form_Load ()

sm_LostFocus_Control = ""

End Sub

Sub Txt_Forename_LostFocus ()

Field_LostFocus Txt_Forename, "Txt_Forename"

End Sub

Sub Txt_Surname_LostFocus ()

Field_LostFocus Txt_Surname, "Txt_Surname"

End Sub

