

    'clock1.bas  - a clock program for Liberty BASIC 1.0

    WindowWidth = 120
    WindowHeight = 144
    nomainwin
    open "Clock" for graphics_nsb_nf as #clock
    print #clock, "trapclose [exit]"

    for angle = 0 to 330 step 30
        print #clock, "up ; home ; north ; turn "; angle
        print #clock, "go 40 ; down ; go 5"
    next x

    print #clock, "flush"

[timeLoop]

    while TrapClose <> "true"
        time$ = time$()
        hours = val(time$)
        if hours > 12 then hours = hours - 12
        minutes = val(mid$(time$, 4, 2))
        seconds = val(right$(time$, 2))
        ' if seconds has changed, then redraw the hands
        if seconds <> oldSeconds then gosub [display]
    wend
    TrapClose = ""
    goto [exit]

[display]  ' call this only when seconds has changed

    ' delete the last drawn segment, if there is one
    if segId > 2 then print #clock, "delsegment "; segId - 1

    ' center the turtle
    print #clock, "up ; home ; down ; north"

    ' erase each hand if its position has changed
    if oldHours <> hours then print #clock, "size 2 ; color white ; turn "; oldHours * 30 + int(oldMinutes/2) ; " ; go 19 ; home ; color black ; north" : oldHours = hours
    if oldMinutes <> minutes then print #clock, "size 2 ; color white ; turn "; oldMinutes * 6 ; " ; go 38 ; home ; color black ; north" : oldMinutes = minutes
    if oldSeconds <> seconds then print #clock, "size 1 ; color white ; turn "; oldSeconds * 6 ; " ; go 38 ; home ; color black ; north" : oldSeconds = seconds

    ' redraw all three hands, second hand first
    print #clock, "size 1 ; turn "; seconds * 6 ; " ; go 38"
    print #clock, "size 2 ; home ; north ; turn "; hours * 30 + int(minutes/2); " ; go 19"
    print #clock, "home ; north ; turn "; minutes * 6 ; " ; go 38"

    ' flush to end segment, then get the next segment id #
    print #clock, "flush"
    print #clock, "segment"
    input #clock, segId

    return

[exit]

    confirm "Quit Clock?"; q$
    if q$ = "no" then [timeLoop]
    close #clock
    end
