Option Explicit

' Drawing states for Kalendar_DrawDay
Global Const KAL_STATE_NOT_SELECTED = 0         ' Day not selected
Global Const KAL_STATE_SELECTED_WITH = 1        ' Day selected, Kalendar has focus
Global Const KAL_STATE_SELECTED_WITHOUT = 2     ' Day selected, Kalendar does not have focus
Global Const KAL_STATE_OTHERMONTH = 3           ' Day is not from this month.

Global Const KAL_PRINT_PORTRAIT = 1             ' Print Kalendar full page in portrait mode.
Global Const KAL_PRINT_LANDSCAPE = 2            ' Print Kalendar landscape full page
Global Const KAL_PRINT_USER = 3                 ' Print Kalendar as specified by user.

'--- For combo months.
Dim updatingCombos As Integer

Sub KalDrawDay (Kal As Control, hdc As Integer, STATE As Integer, theDay As Long, dLeft As Single, dTop As Single, dRight As Single, dBottom As Single)
Dim x As Integer
Dim oldPen As Integer
Dim txtDay As String
Dim r As Rect
Dim oldBrush
Dim oldColor, oldTextColor
Dim lx As Long
Dim strTmp As String

Dim linePen As Integer
Dim oldFont As Integer, theFont As Integer

    txtDay = Format(theDay, "d")

    KalWindowAPIRect dLeft, dTop, dRight, dBottom, r

    linePen = CreatePen(PS_SOLID, 1, Kal.LineColor)
    theFont = KalMakeFont(hdc, Kal)

    oldPen = SelectObject(hdc, linePen)
    oldFont = SelectObject(hdc, theFont)

    Select Case STATE
	Case KAL_STATE_SELECTED_WITHOUT:
	    oldBrush = SelectObject(hdc, GetStockObject(LTGRAY_BRUSH))
	    oldColor = SetBkColor(hdc, RGB(192, 192, 192))
	    oldTextColor = SetTextColor(hdc, 0)
	Case KAL_STATE_SELECTED_WITH:
	    oldBrush = SelectObject(hdc, GetStockObject(LTGRAY_BRUSH))
	    oldColor = SetBkColor(hdc, RGB(192, 192, 192))
	    oldTextColor = SetTextColor(hdc, RGB(255, 0, 0))
	Case KAL_STATE_NOT_SELECTED:
	    oldBrush = SelectObject(hdc, GetStockObject(WHITE_BRUSH))
	    oldColor = SetBkColor(hdc, RGB(255, 255, 255))
	    oldTextColor = SetTextColor(hdc, 0)
    End Select
    
    x = Rectangle(hdc, r.left, r.top, r.right, r.bottom)
    
    ' Draw the day number
    InflateRect r, -1, -1
    x = DrawText(hdc, txtDay, Len(txtDay), r, DT_LEFT Or DT_SINGLELINE)

    x = SelectObject(hdc, oldPen)
    x = SelectObject(hdc, oldFont)
    x = DeleteObject(linePen)
    x = DeleteObject(theFont)

    x = SelectObject(hdc, oldBrush)
    lx = SetBkColor(hdc, oldColor)
    lx = SetTextColor(hdc, oldTextColor)
End Sub

' This function creates a font that is described by the font properties for a calendar.
' (It would probably work for any control that has fonts)
Function KalMakeFont (hdc As Integer, Kal As Control) As Integer
Dim FWBold As Integer

    If Kal.FontBold Then
	FWBold = FW_BOLD
    Else
	FWBold = FW_NORMAL
    End If

    KalMakeFont = CreateFont(-(Kal.FontSize * GetDeviceCaps(hdc, LOGPIXELSY) / 72), 0, 0, 0, FWBold, Kal.FontItalic, Kal.FontUnderline, Kal.FontStrikethru, 0, 0, 0, 0, DEFAULT_PITCH Or FF_DONTCARE, Kal.FontName)

End Function

Sub KalSetMonth (Kal As Control, newMonth As Integer, newDay As Integer, newYear As Integer)
    If Not updatingCombos Then
	Kal.Text = newMonth & "/" & newDay & "/" & newYear
    End If
End Sub

' Converts rectangular twip coordinates into a Windows API Rectangle Structure
Sub KalWindowAPIRect (dLeft As Single, dTop As Single, dRight As Single, dBottom As Single, rct As Rect)
    rct.left = dLeft / Screen.TwipsPerPixelX
    rct.top = dTop / Screen.TwipsPerPixelY
    rct.right = dRight / Screen.TwipsPerPixelX
    rct.bottom = dBottom / Screen.TwipsPerPixelY
End Sub

Sub UpdateCombos (Kal As Control, cmbMonth As Control, cmbYear As Control)
Dim i As Integer
    updatingCombos = True
    cmbMonth.ListIndex = Val(Format(Kal.Text, "m")) - 1

    For i = 0 To cmbYear.ListCount - 1
	If cmbYear.List(i) = Format(Kal.Text, "yyyy") Then
	    cmbYear.ListIndex = i
	    Exit For
	End If
    Next

    updatingCombos = False

End Sub

