// ================
// Copyrights & CYA
// ================
//
// App Shell is freeware with the following intent:
//
// -  You are free to incorporate App Shell into your code that will be
//    distributed in executable form.
// -  You are free to distribute App Shell source or incorporate App Shell
//    source into your source code assuming no charge is required and this
//    copyright is maintained and acknowledged.
// -  You are free to distribute App Shell source as shareware assuming
//    you are an approved vendor and associate member of the Association
//    of Shareware Professionals (ASP).  No registration fee is required
//    but this copyright must be maintained and acknowledged.
// -  All other distribution rights are maintained by the author.
// -  The author makes NO warranties, express or implied, oral or written,
//    including any implied warranties of merchantability or fitness for
//    a particular purpose.  In no event shall the author be liable for
//    any damages whatsoever arising out of the use of the software.
//
// If you find any bugs, anomalies, or have any questions or suggestions,
// please send them to Jim Presley (CIS ID - 73417,2674).  Enjoy!
//
//
#include <windows.h>
#include <drivinit.h>

int far PASCAL _export AppShellPrSetup(HANDLE hWnd, LPSTR pPN, LPSTR pPD, LPSTR pPP )
{
  FARPROC lpfnExtDeviceMode;
  FARPROC lpfnDeviceMode;
  HANDLE  hDriver;
  int     rc;

  rc = 0;
  hDriver = LoadLibrary( pPD );
  lpfnExtDeviceMode = GetProcAddress( hDriver, "ExtDeviceMode" );

  if ( lpfnExtDeviceMode != NULL )
  {
    (*lpfnExtDeviceMode)(
       (HWND)   hWnd,
       (HANDLE) hDriver,
       NULL,
       (LPSTR)  pPN,
       (LPSTR)  pPP,
       NULL,
       NULL,
       DM_IN_PROMPT);
    rc = -1;
  }
  else
  {
    lpfnDeviceMode = GetProcAddress( hDriver, "DeviceMode" );

    if ( lpfnDeviceMode != NULL )
    {
      (*lpfnDeviceMode)(
	      (HWND)    hWnd,
	      (HANDLE)  hDriver,
	      (LPSTR)   pPN,
	      (LPSTR)   pPP );
      rc = -1;
    }
}

  FreeLibrary( hDriver );
  return rc;

}

int FAR PASCAL LibMain( HANDLE hInstance, WORD wDataSet, WORD cbHeapSize, LPSTR lpszCmdLine)
{
  return(1);
}
