Option Explicit

' Types of arrays to create
Global Const Sorted_ArrayType = 1         ' Arrays are monotonically increassing. A(n) = A(n-1) + 1
Global Const ReverseSorted_ArrayType = 2  ' Arrays are monotonically decreassing. A(n) = A(n-1) - 1
Global Const RandomSorted_ArrayType = 3   ' Arrays contain random elements
Global Const AllConst_ArrayType = 4       ' All elements in the arrays are the same

Global arrayType    As Long               ' The number of arrays to create (1=sorted, 2=revsort, 3=random)
Global previousType As Long               ' If the desired type is the same as the previous, then no new values are generated

Global arraySize    As Long               ' The number of elements in the arrays
Global previousSize As Long               ' If the desired size is the same as the previous, then no new values are generated
Global arrayBase    As Long               ' Base of the array (lBound)
Global previousBase As Long               ' If the desired base is the same as the previous, then no new values are generated

Global Const Not_userSetMinMaxElement = 0       ' User has not set
Global Const HasSet_userSetMinMaxElement = 1    ' User has set new min and max
Global Const PrevSet_userSetMinMaxElement = 2   ' User has previous set min and max, so just copy arrays
Global userSetMinMaxElement As Integer
Global minElement As Integer
Global maxElement As Integer


Global Index() As Integer                 ' Used for index sorts
Global v()     As Variant                 ' Used for regression testing


Global Const IntegerElements = 1
Global Const LongElements = 2
Global Const SingleElements = 3
Global Const DoubleElements = 4
Global Const StringElements = 5
Global Const FixedString15Elements = 6
Global Const CurrencyElements = 7
'
' Example arrays.
'     Arrays without the 'p' postfix are the arrays sorted.
'     Array with the postfix contain the original elements. This are used for
'     testing and for quickly recreating the arrays.
'
Global i()     As Integer
Global ip()    As Integer
Global L()     As Long
Global Lp()    As Long
Global s()     As Single
Global sp()    As Single
Global d()     As Double
Global dp()    As Double
Global st()    As String
Global stp()   As String
Global fx15()  As String * 15
Global fx15p() As String * 15
Global c()     As Currency
Global cp()    As Currency

Global ut() As test

'
' These constants are used when creating the test arrays to make a spead of values
'
Global Const minInt = -32768
Global Const maxInt = 32767
Global Const minLong = -2147483648#
Global Const maxLong = 2147483647
Global Const minSingle = -3.402823E+38
Global Const maxSingle = 3.402823E+38
Global Const minDble = -1.79769313486231E+308
Global Const maxDble = 1.79769313486231E+308
Global Const minCur = -922337203685477.5807@
Global Const maxCur = 922337203685477.5807@
Global Const minStr = 0
Global Const maxStr = 26
Global Const minFixStr13 = 0
Global Const maxFixStr13 = 13
Global Const minChar = 60
Global Const maxChar = 255

Sub arrayGetArrayParams ()

   Do
      arrayType = Val(InputBox$("Array Type (1=Sorted, 2=Reverse Sorted, 3=Random, 4=Constant", , Str$(arrayType)))
      If (1 <= arrayType) And (arrayType <= 4) Then Exit Do
   Loop

   arrayBase = Val(InputBox$("Array Base", , Str$(arrayBase)))
   
   Do
      arraySize = Val(InputBox$("Array Size", , Str$(arraySize)))
      If 1 <= arraySize Then Exit Do
      MsgBox "Array Size must be at least one"
   Loop


End Sub

Sub arraysCopyCurrent ()

   On Error GoTo arraysCopyCurrentError
   Dim allowcateStrings_b As Integer
   allowcateStrings_b = True

   Dim ii As Integer
   For ii = LBound(i) To UBound(i)
      ip(ii) = i(ii)
      Lp(ii) = L(ii)
      sp(ii) = s(ii)
      dp(ii) = d(ii)
      If allowcateStrings_b Then stp(ii) = st(ii)
      fx15p(ii) = fx15(ii)
      cp(ii) = c(ii)
   Next ii

   Exit Sub
'----------------------------------------------------------------------------------
' Error Handler
'----------------------------------------------------------------------------------
arraysCopyCurrentError:
   
   'Out of string space error
   If Err = 14 Then
      allowcateStrings_b = False
      Resume Next
   Else
      Error Err
   End If


End Sub

Sub arraysCopyPrevious ()
   
   On Error GoTo arraysCopyPreviousError
   Dim allowcateStrings_b As Integer
   allowcateStrings_b = True

   Dim ii As Integer
   For ii = LBound(i) To UBound(i)
      Index(ii) = ii
      i(ii) = ip(ii)
      L(ii) = Lp(ii)
      s(ii) = sp(ii)
      d(ii) = dp(ii)
      If allowcateStrings_b Then st(ii) = stp(ii)
      fx15(ii) = fx15p(ii)
      c(ii) = cp(ii)
   Next ii

   Exit Sub
'----------------------------------------------------------------------------------
' Error Handler
'----------------------------------------------------------------------------------
arraysCopyPreviousError:

   'Out of string space error
   If Err = 14 Then
      allowcateStrings_b = False
      Resume Next
   Else
      Error Err
   End If


End Sub

Sub arraysMakeConstant ()

   Dim allowcateStrings_b As Integer   ' Flag do decide when not to add more strings to the string array ST()
   allowcateStrings_b = True
   
   On Error GoTo arraysMakeConstantError

   Dim ii  As Integer
   For ii = LBound(i) To UBound(i)
      Index(ii) = ii
      
      i(ii) = 1
      L(ii) = 2
      s(ii) = 3.3
      d(ii) = 4.4
      c(ii) = 5.555555555
      If allowcateStrings_b Then st(ii) = "666666"
      fx15(ii) = "7777777"
     
     ' Setup user define type array
      ut(ii).l2 = L(ii)
'     If allowcateStrings_b Then ut(ii).s = st(ii)
      ut(ii).i = i(ii)
      ut(ii).L = L(ii)
      ut(ii).c = c(ii)
      ut(ii).fs = Left$(fx15(ii), 5)

   Next ii

   arraysCopyCurrent

   Exit Sub
'----------------------------------------------------------------------------------
' Error Handler
'----------------------------------------------------------------------------------
arraysMakeConstantError:
   
   'Out of string space error
   If Err = 14 Then
      allowcateStrings_b = False
      Resume Next
   Else
      Error Err
   End If

End Sub

Sub arraysMakeRandom ()

   Dim r    As Double                  ' Temp for current random number
   Dim rStr As String                  ' Temp for current random number as a string

   Dim allowcateStrings_b As Integer   ' Flag do decide when not to add more strings to the string array ST()
   allowcateStrings_b = True
   
   
   On Error GoTo arraysMakeRandomError

   Dim ii  As Integer
   For ii = LBound(i) To UBound(i)
      Index(ii) = ii
      
      If userSetMinMaxElement = PrevSet_userSetMinMaxElement Then
	 r = Rnd
	 i(ii) = Int((maxElement * r + (minElement)) - (minElement) * r - r)
	 r = Rnd
	 L(ii) = (maxElement * r + (minElement)) - (minElement) * r - r
	 r = Rnd
	 s(ii) = (maxElement * r + (minElement)) - (minElement) * r - r
	 r = Rnd
	 d(ii) = (maxElement * r + (minElement)) - (minElement) * r - r
	 r = Rnd
	 c(ii) = (maxElement * r + (minElement)) - (minElement) * r - r
      Else
	 r = Rnd
	 i(ii) = Int((maxInt * r + (minInt)) - (minInt) * r - r)
	 r = Rnd
	 L(ii) = (maxLong * r + (minLong)) - (minLong) * r - r
	 r = Rnd
	 s(ii) = (maxSingle * r + (minSingle)) - (minSingle) * r - r
	 r = Rnd
	 d(ii) = (maxDble * r + (minDble)) - (minDble) * r - r
	 r = Rnd
	 c(ii) = (maxCur * r + (minCur)) - (minCur) * r - r
      End If
      
      rStr = Format$(c(ii), "0.00000000")
      If allowcateStrings_b Then
	 r = Rnd
	 st(ii) = Left$(rStr, ((maxStr * r + (minStr)) - (minStr) * r - r))
      End If

      r = Rnd
      fx15(ii) = Left$(rStr, ((maxFixStr13 * r + (minFixStr13)) - (minFixStr13) * r - r))
     
     ' Setup user define type array
      ut(ii).l2 = L(ii)
'     If allowcateStrings_b Then ut(ii).s = st(ii)
      ut(ii).i = i(ii)
      ut(ii).L = L(ii)
      ut(ii).c = c(ii)
      ut(ii).fs = Left$(fx15(ii), 5)

   Next ii

   arraysCopyCurrent

   Exit Sub
'----------------------------------------------------------------------------------
' Error Handler
'----------------------------------------------------------------------------------
arraysMakeRandomError:
   
   'Out of string space error
   If Err = 14 Then
      allowcateStrings_b = False
      Resume Next
   Else
      Error Err
   End If
 
End Sub

Sub arraysMakeSorted (ByVal direction As Integer)
' Created arrays already sorted.
' if direction = 1 then arrays are in increassing order
' if direction <> 1 then arrays are in decreassing order
   Dim r    As Double                  ' Temp for current INDEX
   Dim Elements As Double              ' Number of elements in array
   Dim rStr As String                  ' Temp for current random number as a string

   Dim allowcateStrings_b As Integer   ' Flag do decide when not to add more strings to the string array ST()
   allowcateStrings_b = True
   
   Elements = UBound(i) - LBound(i) + 1
   On Error GoTo arraysMakeSortedError

   Dim ii  As Integer
   For ii = LBound(i) To UBound(i)
      Index(ii) = ii
      
      If direction = 1 Then
	 ' Sort increassing order
	 r = (ii - LBound(i)) / Elements
      Else
	 ' Sort descreassing order
	 r = (UBound(i) - ii) / Elements
      End If

      If userSetMinMaxElement = PrevSet_userSetMinMaxElement Then
	 i(ii) = Int(((maxElement * r + (minElement)) - (minElement) * r - r) + .5)
	 L(ii) = ((maxElement * r + (minElement)) - (minElement) * r - r)
	 s(ii) = ((maxElement * r + (minElement)) - (minElement) * r - r)
	 d(ii) = ((maxElement * r + (minElement)) - (minElement) * r - r)
	 c(ii) = ((maxElement * r + (minElement)) - (minElement) * r - r)
      Else
	 i(ii) = Int((maxInt * r + (minInt)) - (minInt) * r - r)
	 L(ii) = (maxLong * r + (minLong)) - (minLong) * r - r
	 s(ii) = (maxSingle * r + (minSingle)) - (minSingle) * r - r
	 d(ii) = (maxDble * r + (minDble)) - (minDble) * r - r
	 c(ii) = (maxCur * r + (minCur)) - (minCur) * r - r
      End If

      rStr = Format$(c(ii), "0.00000000")
      If allowcateStrings_b Then st(ii) = String$(((maxStr * r + (minStr)) - (minStr) * r - r), rStr)
      fx15(ii) = String$(((maxFixStr13 * r + (minFixStr13)) - (minFixStr13) * r - r), rStr)
   
      
     ' Setup user define type array
      ut(ii).l2 = L(ii)
'     If allowcateStrings_b Then ut(ii).s = st(ii)
      ut(ii).i = i(ii)
      ut(ii).L = L(ii)
      ut(ii).c = c(ii)
      ut(ii).fs = Left$(fx15(ii), 5)

   Next ii

   arraysCopyCurrent
   Exit Sub
'----------------------------------------------------------------------------------
' Error Handler
'----------------------------------------------------------------------------------
arraysMakeSortedError:
   
   'Out of string space error
   If Err = 14 Then
      allowcateStrings_b = False
      Resume Next
   Else
      Error Err
   End If
 

End Sub

Sub arraysResize ()
   
   Dim arrayFrom  As Integer
   arrayFrom = arrayBase
   Dim arrayTo  As Integer
   arrayTo = arraySize + arrayBase - 1

   ReDim Index(arrayFrom To arrayTo)
   ReDim v(arrayFrom To arrayTo)

   ReDim i(arrayFrom To arrayTo)
   ReDim ip(arrayFrom To arrayTo)
   ReDim L(arrayFrom To arrayTo)
   ReDim Lp(arrayFrom To arrayTo)
   ReDim s(arrayFrom To arrayTo)
   ReDim sp(arrayFrom To arrayTo)
   ReDim d(arrayFrom To arrayTo)
   ReDim dp(arrayFrom To arrayTo)
   ReDim st(arrayFrom To arrayTo)
   ReDim stp(arrayFrom To arrayTo)
   ReDim fx15(arrayFrom To arrayTo)
   ReDim fx15p(arrayFrom To arrayTo)
   ReDim c(arrayFrom To arrayTo)
   ReDim cp(arrayFrom To arrayTo)
   ReDim ut(arrayFrom To arrayTo)

End Sub

Sub arrayUpdateArrays (f As Form)
   
   If (arrayType = previousType) And (arraySize = previousSize) And (arrayBase = previousBase) And (userSetMinMaxElement <> HasSet_userSetMinMaxElement) Then
      f.Print , "Copying Previous Arrays"
      arraysCopyPrevious
   Else
      arraysResize
      
      previousType = arrayType
      previousSize = arraySize
      previousBase = arrayBase
      userSetMinMaxElement = PrevSet_userSetMinMaxElement
      
      Select Case arrayType
      Case Sorted_ArrayType
	 f.Print , "Making Sorted Arrays"
	 DoEvents
	 arraysMakeSorted 1
      Case ReverseSorted_ArrayType
	 f.Print , "Making Reverse Sorted Arrays"
	 DoEvents
	 arraysMakeSorted 0
      Case RandomSorted_ArrayType
	 f.Print , "Making Random Arrays"
	 DoEvents
	 arraysMakeRandom
      Case AllConst_ArrayType
	 f.Print , "Making Constant Element Arrays"
	 DoEvents
	 arraysMakeConstant
      End Select
      
   End If

End Sub

