TYPE NetAddr                                    'GetInternetAddress
	  ConnectNum AS INTEGER
	  AxAsm AS INTEGER
	  returnstr AS STRING * 12
END TYPE


TYPE Hex2asc                                  'Hex2asc
	  Beginstr AS STRING * 12
	  NetAddr AS STRING * 24
END TYPE


TYPE ConInfo                                    'GetConnectionInfo
	  ConnectNum AS INTEGER
	  ReturnCode AS INTEGER
	  ObjectType AS INTEGER
	  ObjectName AS STRING * 48
END TYPE


TYPE ConNum                                     'GetConnectionNumber
	  ConnectionNumber AS INTEGER
END TYPE


TYPE ShellI                                     'GetShellInfo
	majorVersion AS INTEGER
	MinorVersion AS INTEGER
	revnum AS INTEGER
	OsType AS STRING * 10
	OsVersion AS STRING * 10
	hardwareType AS STRING * 10
END TYPE


TYPE LDrives                                    'GetNumberOfLocalDrives
	  Drives AS INTEGER
END TYPE


TYPE SConinfo                                   'ServerConnectionInfo
	  conID1 AS INTEGER
	  conID2 AS INTEGER
	  conID3 AS INTEGER
	  conID4 AS INTEGER
	  conID5 AS INTEGER
	  conID6 AS INTEGER
	  conID7 AS INTEGER
	  conID8 AS INTEGER
	  server1 AS STRING * 50
	  server2 AS STRING * 50
	  server3 AS STRING * 50
	  server4 AS STRING * 50
	  server5 AS STRING * 50
	  server6 AS STRING * 50
	  server7 AS STRING * 50
	  server8 AS STRING * 50
END TYPE


TYPE LogTime                                    'GetLoginTime
	  ConnectNum AS INTEGER
	  ReturnCode AS INTEGER
	  year AS INTEGER
	  month AS INTEGER
	  daydate AS INTEGER
	  hour AS INTEGER
	  minute AS INTEGER
	  second AS INTEGER
	  day AS INTEGER
END TYPE


TYPE ObInfo                                     'GetObjectInfo
	  ReturnCode AS INTEGER
	  ObjectType AS INTEGER
	  ObjectName AS STRING * 47
	  ObjectID   AS STRING * 4
END TYPE

TYPE Obid
	strin AS STRING * 4
	strout AS STRING * 8
END TYPE

TYPE ClCon                                      'ClearConnection
	  ConnectNum AS INTEGER
	  ReturnCode AS INTEGER
END TYPE


TYPE CapStat                                    'GetLPTCaptureStatus
	  ReturnCode AS INTEGER
	  ConnID AS INTEGER
END TYPE


TYPE PFlags                                     'GetPrintFlag
	Flags AS INTEGER                        'SetPrintFlag
	TabSize AS INTEGER
	Copies AS INTEGER
	BannerText AS STRING * 13
	LPTNum AS INTEGER
	Timeout AS INTEGER
	ReturnCode AS INTEGER
END TYPE

TYPE GDLP                                       'GetDefaultLocalPrinter
	  LPTNum AS INTEGER
END TYPE

TYPE QUEUE                                      'SetCapturePrintQueue
	  LPTNum AS INTEGER
	  queueID AS STRING * 8
	  ReturnCode AS INTEGER
END TYPE


TYPE CAPTURE                                       'StartLPTCapture
	  LPTNum AS INTEGER                         'CancelSpecificLPTCapture
	  ReturnCode AS INTEGER                     'SetDefaultLocalPrinter
END TYPE


TYPE OCBindery                                  'OpenBindery
	ReturnCode AS INTEGER                   'CloseBindery
END TYPE

TYPE GST                                        'GetServerTime  
      year AS INTEGER
      month AS INTEGER
      daydate AS INTEGER
      hour AS INTEGER
      minute AS INTEGER
      second AS INTEGER
      day AS INTEGER
END TYPE

TYPE SST                                        'SetServerTime
	  year AS INTEGER
	  month AS INTEGER
	  day AS INTEGER
	  hour AS INTEGER
	  minute AS INTEGER
	  second AS INTEGER
	  ReturnCode AS INTEGER
END TYPE


TYPE SCMESS                                     'SendMsgToConsole
	  ReturnCode AS INTEGER
	  Message AS STRING * 60
END TYPE


TYPE SBMESS                                     'SendBroadcastMsg
	  ConID AS INTEGER
	  ReturnCode AS INTEGER
	  Message AS STRING * 55
END TYPE


TYPE SBMODE                                     'SetBroadcastMode
	  Mode AS INTEGER
END TYPE

TYPE DefServ                    'GetDefaultConnectionID
	 DefConnectionID AS INTEGER
END TYPE


' DECLARE STATMENTS

DECLARE SUB GetIntenetAddress (Addr AS NetAddr)
DECLARE SUB Hex2asc (hex2Ascii AS Hex2asc)
DECLARE SUB GetConnectionInfo (Info AS ConInfo)
DECLARE SUB GetConnectionNumber (Con AS ConNum)
DECLARE SUB Getshellinfo (Wshell AS ShellI)
DECLARE SUB GetNumberOfLocalDrives (Drives AS LDrives)
DECLARE SUB GetServerConnectionInfo (Serv AS SConinfo)
DECLARE SUB GetLoginTime (Logintime AS LogTime)
DECLARE SUB GetObjectInfo (ObjectInfo AS ObInfo)
DECLARE SUB ConvertObjectID (ID AS Obid)
DECLARE SUB ClearConnection (ClearCon1 AS ClCon)
DECLARE SUB GetLPTCaptureStatus (CaptureStats AS CapStat)
DECLARE SUB GetPrintFlag (GPFlags AS PFlags)
DECLARE SUB SetPrintFlag (SPFlags AS PFlags)
DECLARE SUB SetDefaultLocalPrinter (SDefPrinter AS CAPTURE)
DECLARE SUB GetDefaultLocalPrinter (GDefPrinter AS GDLP)
DECLARE SUB SetCapturePrintQueue (SetQueue AS QUEUE)
DECLARE SUB StartLPTCapture (StartCapture AS CAPTURE)
DECLARE SUB EndSpecificLPTCapture (ECap AS CAPTURE)
DECLARE SUB CloseBindery (CloseBind AS OCBindery)
DECLARE SUB OpenBindery (OpenBind AS OCBindery)
DECLARE SUB GetServerTime (GetServTime AS GST)
DECLARE SUB SetServerTime (SetServTime AS SST)
DECLARE SUB SendMsgToConsole (SendC AS SCMESS)
DECLARE SUB SendBroadcastMsg (SendB AS SBMESS)
DECLARE SUB SetBroadcastMode (SetMode1 AS SBMODE)
DECLARE SUB GetDefaultConnectionID (Defserver AS DefServ)

