'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
'%  (C) 1987 HUMBLEWARE Custom Programming    Author: Lawrence A. Westhaver  %
'%        247 Paul Martin Drive,  Baltimore MD  21227  (301) 799-1975        %
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
'%                                                                           %
'%     FILENAME: FNCUP$.FUN                      LAST UPDATE: 06/12/1987     %
'%                                                                           %
'%  DESCRIPTION: Moves the cursor to a specified vertical and horizontal     %
'%               position.                                                   %
'%                                                                           %
'%        USAGE: PRINT #1, FNCUP$(V%;H%);                                    %
'%                                                                           %
'%       INPUTS: V% = Vertical position of cursor (1-25).                    %
'%                                                                           %
'%               H% = Horizontal position of cursor (1-40) or (1-80)         %
'%                    as appropriate for the current screen width.           %
'%                                                                           %
'%      RETURNS: ANSI.SYS compatible CUP string.                             %
'%                                                                           %
'%         NOTE: The ANSI.SYS device driver must be installed on your        %
'%               computer before this function can be used.                  %
'%                                                                           %
'%               This routine assumes that you have opened a disk file,      %
'%               communications port or the console prior to printing        %
'%               the ANSI control string returned by this function.          %
'%                                                                           %
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


DEF FNCUP$(V%,H%)


'build ANSI CUP string

	FNCUP$=CHR$(27)+"["+MID$(STR$(V%),2)+";"+MID$(STR$(H%),2)+"H"


END DEF 'fncup$
