'$INCLUDE: 'dbhdr.bi'

'=================================
'Add a new blank DBF record FUNCTION
'       Input:   dbChn = channel number
'                 Hdr1 = DBF header record
'
'     Returns: new record number if success
'
'=================================
FUNCTION dbAddRec (dbChn, Hdr1 AS dbHdr1)

   Hdr1.NumRecs = Hdr1.NumRecs + 1
   NulRec$ = SPACE$(Hdr1.RecLen)                 'Create new blank rec

   SEEK #dbChn, Hdr1.HdrOffset + (Hdr1.RecLen * (Hdr1.NumRecs - 1) - 1)
   PUT #dbChn, , NulRec$                         'Write a blank record

   'Date of last update - set to today's date
   dte$ = DATE$
   mm$ = LEFT$(dte$, 2): dd$ = MID$(dte$, 4, 2): yy$ = RIGHT$(dte$, 2)
   dte1$ = CHR$(VAL(yy$)) + CHR$(VAL(mm$)) + CHR$(VAL(dd$))
   SEEK #dbChn, 2
   PUT #dbChn, , dte1$                           'Update date of last upd

   SEEK #dbChn, 5                                'Set file pointer
   PUT #dbChn, , Hdr1.NumRecs                    'Update the NumRecs

   dbAddRec = Hdr1.NumRecs

   IF debug THEN
      PRINT "HDR AFTER ALLOCATION:"
      PRINT STRING$(36, "-")
      PRINT USING "\          \  ##########"; "# recs   :"; Hdr1.NumRecs
      PRINT USING "\          \  ##########"; "# fields :"; Hdr1.NumFields
      PRINT USING "\          \  ##########"; "Hdr len  :"; Hdr1.HdrLen
      PRINT USING "\          \  ##########"; "Rec len  :"; Hdr1.RecLen
      PRINT USING "\          \            "; "Last upd :"; Hdr1.LastUpd
      PRINT USING "\          \  ##########"; "HdrOffset:"; Hdr1.HdrOffset
      PRINT
   END IF

END FUNCTION

'=================================
' dbBottom FUNCTION
'       Input: dbChn = I/O channel number
'               Hdr1 = DBF header record type
'
'     Returns: Record number of last record if success
'             -1 if failure
'
'=================================
FUNCTION dbBottom (dbChn, Hdr1 AS dbHdr1)

   IF Hdr1.NumRecs > 0 THEN
      SEEK #dbChn, Hdr1.HdrOffset + (Hdr1.RecLen * (Hdr1.NumRecs - 1) - 1)
      dbBottom = Hdr1.NumRecs
   ELSE
      dbBottom = -1
   END IF

   IF debug THEN
      PRINT "Bottom Record #: "; Hdr1.NumRecs
   END IF

END FUNCTION

'=================================
'dbCpyFil FUNCTION
'       Input: dbChn = I/O channel number
'               Hdr1 = DBF header record type
'             dbNme$ = name of new file
'
'     Returns: Number of records in new file if success
'
'
'=================================
FUNCTION dbCpyFil (dbChn, Hdr1 AS dbHdr1, dbNme$)

   NewRec = 0

   SEEK #dbChn, 1
   TmpHdr$ = STRING$(Hdr1.HdrLen + 1, " ")
   GET #dbChn, , TmpHdr$                          'Read header

   'Date of last update - set to today's date
   dte$ = DATE$
   mm$ = LEFT$(dte$, 2): dd$ = MID$(dte$, 4, 2): yy$ = RIGHT$(dte$, 2)
   dte1$ = CHR$(VAL(yy$)) + CHR$(VAL(mm$)) + CHR$(VAL(dd$)) + CHR$(0)

   MID$(TmpHdr$, 2, 4) = dte1$                    'Set date of last update

   dbNewChn = FREEFILE                            'Channel num for new file
   OPEN dbNme$ FOR BINARY AS #dbNewChn            'Binary file I/O
   SEEK #dbNewChn, 1
   PUT #dbNewChn, , TmpHdr$                       'Write the new header

   FOR ii = 1 TO Hdr1.NumRecs
      SEEK #dbChn, Hdr1.HdrOffset + (Hdr1.RecLen * (ii - 1) - 1)
      dbRecord$ = STRING$(Hdr1.RecLen, " ")       'Record variable
      GET #dbChn, , dbRecord$                     'Read in the record

      IF LEFT$(dbRecord$, 1) <> "*" THEN
         NewRec = NewRec + 1
         SEEK #dbNewChn, Hdr1.HdrOffset + (Hdr1.RecLen * (NewRec - 1) - 1)
         PUT #dbNewChn, , dbRecord$               'Write the record
      END IF
   NEXT ii

   SEEK #dbNewChn, 5
   PUT #dbNewChn, , NewRec                        'Set the NumRecs
   CLOSE #dbNewChn
   dbCpyFil = NewRec

END FUNCTION

'=================================
'dbCpyStr FUNCTION - copy the dbf structure
'       Input: dbChn = I/O channel number
'               Hdr1 = DBF header record type
'             dbNme$ = name of file to copy to
'
'     Returns: 1 if success
'
'
'=================================
FUNCTION dbCpyStr (dbChn, Hdr1 AS dbHdr1, dbNme$)

   SEEK #dbChn, 1
   TmpHdr$ = STRING$(Hdr1.HdrLen + 1, " ")
   GET #dbChn, , TmpHdr$                          'Read header

   'Date of last update - set to today's date
   dte$ = DATE$
   mm$ = LEFT$(dte$, 2): dd$ = MID$(dte$, 4, 2): yy$ = RIGHT$(dte$, 2)
   dte1$ = CHR$(VAL(yy$)) + CHR$(VAL(mm$)) + CHR$(VAL(dd$)) + CHR$(0)

   MID$(TmpHdr$, 2, 4) = dte1$                    'Set dateof last update &
                                                  'NumRecs to 0

   dbNewChn = FREEFILE                            'Channel num for new file
   OPEN dbNme$ FOR BINARY AS #dbNewChn            'Binary file I/O
   SEEK #dbNewChn, 1
   PUT #dbNewChn, , TmpHdr$                       'Write the new header
   CLOSE #dbNewChn
 
   dbCpyStr = 1
END FUNCTION

'=================================
'dbDeletd FUNCTION - number of deleted records
'       Input: dbChn = I/O channel number
'               Hdr1 = DBF header record type
'
'     Returns: Number of deleted records in file if success
'
'
'=================================
FUNCTION dbDeletd (dbChn, Hdr1 AS dbHdr1)

   DelRec = 0

   FOR ii = 1 TO Hdr1.NumRecs
      SEEK #dbChn, Hdr1.HdrOffset + (Hdr1.RecLen * (ii - 1) - 1)
      dbRecord$ = STRING$(Hdr1.RecLen, " ")       'Record variable
      GET #dbChn, , dbRecord$                     'Read in the record

      IF LEFT$(dbRecord$, 1) = "*" THEN
         DelRec = DelRec + 1
      END IF
   NEXT ii

   dbDeletd = DelRec

END FUNCTION

'=================================
'Delete/Undelete DBF record FUNCTION
'       Input:   dbChn = channel number
'                dbRec = record number
'                 Hdr1 = DBF header record
'                DelSw = 1 if delete, 0 if undelete
'
'     Returns:  1 if success
'
'=================================
FUNCTION dbDelRec (dbChn, dbRec, Hdr1 AS dbHdr1, DelSw)

   IF DelSw = 1 THEN
      DelRec$ = CHR$(&H2A)
   ELSE
      DelRec$ = CHR$(&H20)
   END IF

   SEEK #dbChn, Hdr1.HdrOffset + (Hdr1.RecLen * (dbRec - 1) - 1)
   PUT #dbChn, , DelRec$                          'Write the record
   dbDelRec = 1

END FUNCTION

'=================================
'Delete range of DBF records FUNCTION
'       Input:   dbChn = channel number
'               BegRec = begining record number
'               EndRec = ending record number
'                 Hdr1 = header record
'
'     Returns:  Number of records deleted if success
'
'=================================
FUNCTION dbDelRng (dbChn, BegRec, EndRec, Hdr1 AS dbHdr1)

   DelRec$ = CHR$(&H2A)

   FOR ii = BegRec TO EndRec
      SEEK #dbChn, Hdr1.HdrOffset + (Hdr1.RecLen * (ii - 1) - 1)
      PUT #dbChn, , DelRec$                          'Write the record
      NuDel = NuDel + 1
   NEXT ii
   dbDelRng = NuDel

END FUNCTION

'=================================
'dbGetDbfHdr FUNCTION
'       Input: dbChn = I/O channel number
'               Hdr1 = DBF header record type
'
'     Returns: 1 if success
'
'
'=================================
FUNCTION dbGetDbfHdr (dbChn, Hdr1 AS dbHdr1)

   SEEK #dbChn, 1
   GET #dbChn, , Hdr1                            'Read 32 byte header

   'Date of last update
   year = ASC(MID$(Hdr1.LastUpd, 1, 1))
   month = ASC(MID$(Hdr1.LastUpd, 2, 1))
   day = ASC(MID$(Hdr1.LastUpd, 3, 1))

   Hdr1.LstUpdate = LTRIM$(STR$(month)) + "/" + LTRIM$(STR$(day)) + "/" + LTRIM$(STR$(year))
   Hdr1.NumFields = Hdr1.HdrLen \ 32 - 1
   Hdr1.HdrOffset = Hdr1.HdrLen + 2

   IF debug THEN
      CLS
      PRINT "Structure for database"
      PRINT STRING$(36, "-")
      PRINT USING "\          \  ##########"; "# recs   :"; Hdr1.NumRecs
      PRINT USING "\          \  ##########"; "# fields :"; Hdr1.NumFields
      PRINT USING "\          \  ##########"; "Hdr len  :"; Hdr1.HdrLen
      PRINT USING "\          \  ##########"; "Rec len  :"; Hdr1.RecLen
      PRINT USING "\          \            "; "Last upd :"; Hdr1.LstUpdate
      PRINT USING "\          \  ##########"; "HdrOffset:"; Hdr1.HdrOffset
      PRINT
      INPUT "DBG>", dbg$
   END IF

   dbGetDbfHdr = 1

END FUNCTION

'=================================
'dbGetDsc FUNCTION
'       Input: dbChn = I/O channel number
'              InFld = DBF descriptor record type
'               Fld1 = Array of descriptor records
'              nFlds = number of fields
'
'     Returns: # of fields read if success
'
'
'=================================
FUNCTION dbGetDsc (dbChn, InFld AS FldDsc, Fld1() AS FldDsc, nFlds)

   OffCalc = 2                                   'Offset for deleted rec flg
   SEEK #dbChn, 32

   FOR ii = 1 TO nFlds
      GET #dbChn, (32 * ii) + 1, InFld           'Looping thru Flds by 32 bytes

   'Fix Clipper format files
      tmp = INSTR(InFld.FldName, CHR$(0))
      tmp$ = LEFT$(MID$(InFld.FldName, 1, tmp) + SPACE$(11), 11)
      Fld1(ii).FldName = tmp$
      Fld1(ii).FldType = InFld.FldType
      Fld1(ii).DataAddr = InFld.DataAddr
      Fld1(ii).length = INT(ASC(InFld.RLen))
      Fld1(ii).Decimal = INT(ASC(InFld.RDec))
      Fld1(ii).Offset = INT(OffCalc)
      OffCalc = OffCalc + INT(ASC(InFld.RLen))   'Calculate field offset
      dbGetDsc = ii
   NEXT ii

   IF debug THEN
      CLS
      PRINT "Field  Field Name    Type   Width  Dec  Offset"
      PRINT STRING$(50, "-")
      FOR dbg = 1 TO nFlds
         PRINT USING "#####  \          \  \ \     ###  ###"; ii; Fld1(dbg).FldName; Fld1(dbg).FldType; Fld1(dbg).length; Fld1(dbg).Decimal; Fld1(dbg).Offset
      NEXT dbg
   INPUT "DBG>", dbg$
   END IF

END FUNCTION

'=================================
'dbGetField FUNCTION
'       Input:   dbRec$ = full DBF record
'                DscRec = descriptor record
'                 FldNo = field number to get
'
'     Returns: field data as string if success
'
'=================================
FUNCTION dbGetField$ (dbRec$, DscRec AS FldDsc, FldNo)

   Wrk$ = ""

   Wrk$ = MID$(dbRec$, DscRec.Offset, DscRec.length)

   SELECT CASE DscRec.FldType                    'Now assign the field type
      CASE "D"                                   'Date
         Wrk$ = MID$(Wrk$, 5, 2) + "/" + MID$(Wrk$, 7, 2) + "/" + MID$(Wrk$, 3, 2)
         dbGetField$ = Wrk$
      CASE "C", "N", "M"
         dbGetField$ = Wrk$
      CASE "L"
         IF Wrk$ <> "T" THEN
            dbGetField$ = "F"
         ELSE
            dbGetField$ = Wrk$
         END IF
      CASE "M"
         dbGetField$ = Wrk$
      CASE ELSE
         dbGetFld$ = "INVALID FIELD TYPE"
   END SELECT

END FUNCTION

'=================================
'Get a memo record FUNCTION
'       Input:   dmChn = channel number
'               dbPtr& = memo record number
'
'     Returns: memo record if success
'
'=================================
FUNCTION dbGetMem$ (dmChn, dbPtr&)

   memo$ = SPACE$(512)
   IF dbPtr& > 0 THEN
'read in 512 bytes offset 512 * pointer + 1
   GET #dmChn, (dbPtr& * 512 + 1), memo$

   Wrk1$ = memo$
   Escape = INSTR(Wrk1$, CHR$(&H1A))             'each .DBT rec ends with &H1A
                                      
   IF Escape THEN                                'stop reading the record
      Wrk1$ = LEFT$(Wrk1$, Escape - 1)
      CALL utStrChr(Wrk1$)
      Wrk2$ = Wrk1$
   ELSE
      Done = FALSE
      CALL utStrChr(Wrk1$)
      Wrk2$ = Wrk1$
      dbPtr& = dbPtr& + 1
      DO
         GET #dmChn, (dbPtr& * 512 + 1), memo$
         Wrk1$ = memo$
         Escape = INSTR(Wrk1$, CHR$(&H1A))
         IF Escape THEN
            Done = TRUE
            Wrk1$ = LEFT$(Wrk1$, Escape - 1)
            CALL utStrChr(Wrk1$)
            Wrk2$ = Wrk2$ + Wrk1$
         ELSE
            CALL utStrChr(Wrk1$)
            Wrk2$ = Wrk2$ + Wrk1$
            IF LEN(Wrk2$) > 4000 THEN Done = TRUE
            dbPtr& = dbPtr& + 1
         END IF
      LOOP UNTIL Done
   END IF

   dbGetMem$ = Wrk2$
   ELSE
      dbGetMem$ = "NO MEMO ON FILE"
   END IF

END FUNCTION

'=================================
'dbGetMemHdr FUNCTION
'       Input: dmChn = I/O channel number
'               Hdr1 = memo header record type
'
'     Returns: 1 if success
'
'
'=================================
FUNCTION dbGetMemHdr (dmChn, Hdr1 AS dbMemHdr1)

   SEEK #dmChn, 1
   GET #dmChn, , Hdr1
   dbGetMemHdr = 1

   IF debug THEN
      CLS
      PRINT "Structure for memo file"
      PRINT STRING$(36, "-")
      PRINT USING "\          \  ##########"; "# segs   :"; Hdr1.NumSegs
      PRINT
      INPUT "DBG>", dbg$
   END IF

END FUNCTION

'=================================
'dbGetNdxHdr FUNCTION
'       Input: dnChn = I/O channel number
'               Hdr1 = index header record type
'
'     Returns: 1 if success
'
'
'=================================
FUNCTION dbGetNdxHdr (dnChn, Hdr1 AS dbNdxHdr1)

   SEEK #dnChn, 1
   GET #dnChn, , Hdr1
   dbGetNdxHdr = 1

   IF debug THEN
      CLS
      PRINT
      PRINT "Structure for index header:"
      PRINT STRING$(36, "-")
      PRINT "Root      : "; Hdr1.Root
      PRINT "Pages     : "; Hdr1.Pages
      PRINT "Fill1     : "; Hdr1.Fill1
      PRINT "KeySize   : "; Hdr1.KeySiz
      PRINT "KeyPerPage: "; Hdr1.KeysPg
      PRINT "KeyType   : "; Hdr1.KeyTyp
      PRINT "RecSize   : "; Hdr1.RecSiz
      PRINT "Fill2     : "; Hdr1.Fill2
      PRINT "Unique    : "; Hdr1.Unique
      PRINT "KeyExpr   : "; Hdr1.KeyExp
      PRINT "Version   : "; Hdr1.Ver
      PRINT
      INPUT "DBG>", dbg$
   END IF

END FUNCTION

'=================================
'Get DBF record FUNCTION
'       Input:   dbChn = channel number
'                dbRec = record number
'                 Hdr1 = DBF header record
'
'     Returns: Record read if success
'
'=================================
FUNCTION dbGetRec$ (dbChn, dbRec, Hdr1 AS dbHdr1)

   IF dbRec > 0 THEN
      SEEK #dbChn, Hdr1.HdrOffset + (Hdr1.RecLen * (dbRec - 1) - 1)
      dbRecord$ = STRING$(Hdr1.RecLen, " ")         'Create a record variable
      GET #dbChn, , dbRecord$                       'Read in the record
      dbGetRec = dbRecord$
   ELSE
      dbGetRec$ = "-1"
   END IF

   IF debug THEN
      PRINT "Record length: "; LEN(dbRecord$)
      PRINT "         data: "; LEFT$(dbRecord$, 25)
   END IF

END FUNCTION

'=================================
'dbMemLen FUNCTION
'       Input: dbMemPtr$ = pointer to memo record
'                  dmChn = memo file channel
'
'     Returns: length of memo field
'             -1 if failure
'
'=================================
FUNCTION dbMemLen (dbMemPtr$, dmChn)

   memo$ = SPACE$(513)
   a& = VAL(dbMemPtr$)
   IF a& <= 0 THEN
      dbMemLen = -1
      EXIT FUNCTION
   END IF

   GET #dmChn, (a& * 512 + 1), memo$
   a$ = memo$
   Escape = INSTR(a$, CHR$(&H1A))
   IF Escape THEN                     'stop reading in the record if &H1A
      a$ = LEFT$(a$, Escape - 1)
      b$ = a$
   ELSE                                           'else keep reading
      Done = FALSE
      b$ = a$
      a& = a& + 1
      DO
         GET #dmChn, (a& * 512 + 1), memo$
         a$ = memo$
         Escape = INSTR(a$, CHR$(&H1A))
         IF Escape THEN
            Done = TRUE
            a$ = LEFT$(a$, Escape - 1)
            b$ = b$ + a$
         ELSE
            b$ = b$ + a$
            IF LEN(b$) > 4000 THEN Done = TRUE
               a& = a& + 1
         END IF
      LOOP UNTIL Done
      END IF

   dbMemLen = LEN(b$)

END FUNCTION

'=================================
'Open DBF FUNCTION
'       Input:   dbNme$ = data file name
'
'     Returns: channel number if success
'
'=================================
FUNCTION dbOpnDbf (dbNme$)

   dbChn = FREEFILE                              'I/O Channel number
   IF UCASE$(RIGHT$(dbNme$,4)) <> ".DBF" THEN
      Name$ = dbNme$ + ".dbf"                    'Add dBase extension
   ELSE
      Name$ = dbNme$
   END IF

   IF LEN(DIR$(Name$)) = 0 THEN
      dbOpnDbf = -1
   ELSE
      OPEN Name$ FOR BINARY AS #dbChn            'Binary file I/O
      dbOpnDbf = dbChn
   END IF

END FUNCTION

'=================================
'Open Memo File FUNCTION
'       Input:   dbMem$ = memo file name
'
'     Returns: channel number if success
'              -1 if failure
'=================================
FUNCTION dbOpnMem (dbMem$)

   dbChn = FREEFILE                              'I/O Channel number
   IF UCASE$(RIGHT$(dbMem$,4)) <> ".DBT" THEN
      Name$ = dbMem$ + ".dbt"                    'Add dBase extension
   ELSE
      Name$ = dbMem$
   END IF

   IF LEN(DIR$(Name$)) = 0 THEN
      dbOpnMem = -1
   ELSE
      OPEN Name$ FOR BINARY AS #dbChn            'Binary file I/O
      dbOpnMem = dbChn
   END IF

END FUNCTION

'=================================
'Open Index File FUNCTION
'       Input:   dbNdx$ = index file name
'
'     Returns: channel number if success
'              -1 if failure
'=================================
FUNCTION dbOpnNdx (dbNdx$)

   dnChn = FREEFILE                              'I/O Channel number
   IF UCASE$(RIGHT$(dbNdx$,4)) <> ".NDX" THEN
      Name$ = dbNdx$ + ".ndx"                    'Add dBase extension
   ELSE
      Name$ = dbNdx$
   END IF


   IF LEN(DIR$(Name$)) = 0 THEN
      dbOpnNdx = -1
   ELSE
      OPEN Name$ FOR BINARY AS #dnChn            'Binary file I/O
      dbOpnNdx = dnChn
   END IF

END FUNCTION

'=================================
'dbPck FUNCTION
'       Input: dbChn = I/O channel number
'               Hdr1 = DBF header record type
'             dbNme$ = name of file to pack
'
'     Returns: Number of records in new file if success
'
'
'=================================
FUNCTION dbPck (dbChn, Hdr1 AS dbHdr1, dbNme$)

   NewRec = 0

   SEEK #dbChn, 1
   TmpHdr$ = STRING$(Hdr1.HdrLen + 1, " ")
   GET #dbChn, , TmpHdr$                          'Read header

   'Date of last update - set to today's date
   dte$ = DATE$
   mm$ = LEFT$(dte$, 2): dd$ = MID$(dte$, 4, 2): yy$ = RIGHT$(dte$, 2)
   dte1$ = CHR$(VAL(yy$)) + CHR$(VAL(mm$)) + CHR$(VAL(dd$)) + CHR$(0)

   MID$(TmpHdr$, 2, 4) = dte1$                    'Set date of last update

   dbNewChn = FREEFILE                            'Channel num for new file
   OPEN "Tmp.Dbf" FOR BINARY AS #dbNewChn         'Binary file I/O
   SEEK #dbNewChn, 1
   PUT #dbNewChn, , TmpHdr$                       'Write the new header

   FOR ii = 1 TO Hdr1.NumRecs
      SEEK #dbChn, Hdr1.HdrOffset + (Hdr1.RecLen * (ii - 1) - 1)
      dbRecord$ = STRING$(Hdr1.RecLen, " ")       'Record variable
      GET #dbChn, , dbRecord$                     'Read in the record

      IF LEFT$(dbRecord$, 1) <> "*" THEN
         NewRec = NewRec + 1
         SEEK #dbNewChn, Hdr1.HdrOffset + (Hdr1.RecLen * (NewRec - 1) - 1)
         PUT #dbNewChn, , dbRecord$               'Write the record
      END IF
   NEXT ii

   SEEK #dbNewChn, 5
   PUT #dbNewChn, , NewRec                        'Set the NumRecs
   CLOSE #dbNewChn
   CLOSE #dbChn

   KILL dbNme$
   NAME "Tmp.Dbf" AS dbNme$
   OPEN dbNme$ FOR BINARY AS #dbChn               'Reopen file for binary I/O

   dbPck = NewRec

END FUNCTION

'=================================
'dbPutField FUNCTION
'       Input:   dbRec$ = full DBF record
'                DscRec = descriptor record
'                 FldNo = field number to insert
'               FldDat$ = new field data
'
'     Returns: record as string if success
'
'=================================
FUNCTION dbPutField$ (dbRec$, DscRec AS FldDsc, FldNo, FldDat$)

   Wrk$ = ""

   SELECT CASE DscRec.FldType            'Assign fields the correct type
      CASE "D"                                 'Date
         IF LEN(FldDat$) < 6 THEN
            FldDat$ = "00/00/00"
         END IF
         a1 = INSTR(FldDat$, "/")
         IF a1 = 0 THEN
            Wrk$ = "19" + MID$(FldDat$, 5, 2) + MID$(FldDat$, 1, 2) + MID$(FldDat$, 3, 2)
         ELSE
            a2 = INSTR(a1 + 1, FldDat$, "/")
            Wrk$ = "19" + MID$(FldDat$, a2 + 1, 2) + RIGHT$("0" + MID$(FldDat$, 1, a1 - 1), 2) + RIGHT$("0" + MID$(FldDat$, a1 + 1, a2 - a1 - 1), 2)
         END IF
      CASE "C"                                 'Character
         Wrk$ = LEFT$(FldDat$ + SPACE$(DscRec.length), (DscRec.length))
      CASE "N"                                 'Numeric
         IF DscRec.Decimal <> 0 THEN  'Decimal type
             a = INSTR(FldDat$, ".")
            IF a <= 0 THEN
               FldDat$ = "0." + STRING$(DscRec.Decimal, "0")
               a = 2
            END IF
            ip$ = RIGHT$(LTRIM$(STR$(FIX(VAL(FldDat$)))), DscRec.length + DscRec.Decimal + 1)
            dp$ = MID$(FldDat$ + STRING$(DscRec.Decimal, "0"), a, DscRec.Decimal + 1)
            Wrk$ = ip$ + dp$
         ELSE
            Wrk$ = RIGHT$(SPACE$(DscRec.length) + STR$(FIX(VAL(FldDat$))), DscRec.length)
         END IF
      CASE "L"                                 'logical
         IF UCASE$(FldDat$) = "T" OR UCASE$(FldDat$) = "Y" THEN
            Wrk$ = "T"
         ELSE
            Wrk$ = " "
         END IF
      CASE "M"
         'Wrk$ = RIGHT$(SPACE$(ASC(DscRec.Length)) + STR$(FIX(VAL(FldDat$))), DscRec.Length)
         ' Memo field not implemented yet
   END SELECT

      dbPutField$ = LEFT$(dbRec$, DscRec.Offset - 1) + Wrk$ + RIGHT$(dbRec$, LEN(dbRec$) - ((DscRec.Offset - 1) + DscRec.length))

END FUNCTION

'=================================
'Write DBF record FUNCTION
'       Input:   dbChn = channel number
'                dbRec = record number
'                 Hdr1 = DBF header record
'               dbRec$ = the record to write
'
'     Returns: # bytes written if success
'
'=================================
FUNCTION dbPutRec (dbChn, dbRec, Hdr1 AS dbHdr1, dbRec$)

   SEEK #dbChn, Hdr1.HdrOffset + (Hdr1.RecLen * (dbRec - 1) - 1)
   PUT #dbChn, , dbRec$                          'Write the record
   dbPutRec = LEN(dbRec$)

   'Date of last update - set to today's date
   dte$ = DATE$
   mm$ = LEFT$(dte$, 2): dd$ = MID$(dte$, 4, 2): yy$ = RIGHT$(dte$, 2)
   dte1$ = CHR$(VAL(yy$)) + CHR$(VAL(mm$)) + CHR$(VAL(dd$))
   SEEK #dbChn, 2
   PUT #dbChn, , dte1$                           'Update date of last upd

   IF debug THEN
      PRINT "Record length: "; LEN(dbRec$)
      PRINT "      partial: "; LEFT$(dbRec$, 15)
   END IF

END FUNCTION

'=================================
' dbTop FUNCTION
'       Input: dbChn = I/O channel number
'               Hdr1 = DBF header record type
'
'     Returns: 1 if success
'             -1 if failure
'
'=================================
FUNCTION dbTop (dbChn, Hdr1 AS dbHdr1)

   IF Hdr1.NumRecs > 0 THEN
      SEEK #dbChn, Hdr1.HdrOffset + (Hdr1.RecLen - 1)
      dbTop = 1
   ELSE
      dbTop = -1
   END IF

   IF debug THEN
      PRINT "Top Record #: "; Hdr1.NumRecs
   END IF

END FUNCTION

'=================================
'dbZap FUNCTION
'       Input: dbChn = I/O channel number
'               Hdr1 = DBF header record type
'             dbNme$ = name of file to zap
'
'     Returns: 1 if success
'
'
'=================================
FUNCTION dbZap (dbChn, Hdr1 AS dbHdr1, dbNme$)

   SEEK #dbChn, 1
   TmpHdr$ = STRING$(Hdr1.HdrLen + 1, " ")
   GET #dbChn, , TmpHdr$                          'Read header

   'Date of last update - set to today's date
   dte$ = DATE$
   mm$ = LEFT$(dte$, 2): dd$ = MID$(dte$, 4, 2): yy$ = RIGHT$(dte$, 2)
   dte1$ = CHR$(VAL(yy$)) + CHR$(VAL(mm$)) + CHR$(VAL(dd$)) + CHR$(0)

   MID$(TmpHdr$, 2, 4) = dte1$                    'Set dateof last update &
                                                  'NumRecs to 0

   dbNewChn = FREEFILE                            'Channel num for new file
   Name$ = "Dbf.Tmp"                              'Open temp file
   OPEN Name$ FOR BINARY AS #dbNewChn             'Binary file I/O
   SEEK #dbNewChn, 1
   PUT #dbNewChn, , TmpHdr$                       'Write the new header
   CLOSE #dbNewChn
 
   CLOSE #dbChn                                   'Close the old file and
   KILL dbNme$
   NAME "Dbf.Tmp" AS dbNme$
   OPEN dbNme$ FOR BINARY AS #dbChn               'Reopen file for binary I/O

   dbZap = 1
END FUNCTION

'=================================
'Draw a window box SUBROUTINE
'       Input: row1, col1 = start row, column
'              row2, col2 = ending row, column
'              fore, back = foreground and background colors
'                  border = border type
'                fillFlag = fill character
'
'     Returns: nothing
'
'=================================
SUB utBox (row1, col1, row2, col2, fore, back, border, fillFlag) STATIC

    IF border < 9 THEN
        t$ = "Ŀ "
    END IF

    SELECT CASE border
        CASE 1
            t$ = "           ST"
        CASE 2
            t$ = "=           ST"
        CASE 3
            t$ = "=          ST"
        CASE 4
            t$ = "        +   ST"
        CASE 5
            t$ = "       +   ST"
        CASE 6
            t$ = "=       +   ST"
        CASE 7
            t$ = "=      +   ST"
        CASE 8
            t$ = "Ŀ ĴST"
        CASE 9
            t$ = "ڰ ĴST"
        CASE 10
            t$ = "=Ŀ ĴST"
        CASE 11
            t$ = "= ĴST"
        CASE 12
            t$ = "Ŀ +ĴST"
        CASE 13
            t$ = "ڰ +ĴST"
        CASE 14
            t$ = "=Ŀ +ĴST"
        CASE 15
            t$ = "= +ĴST"
        CASE 16
            t$ = "ͻ ͼ͹ST"
        CASE 17
            t$ = "ɰ ͼ͹ST"
        CASE 18
            t$ = "=ͻ ͼ͹ST"
        CASE 19
            t$ = "= ͼ͹ST"
        CASE 20
            t$ = "ͻ +͹ST"
        CASE 21
            t$ = "ɰ +͹ST"
        CASE 22
            t$ = "=ͻ +͹ST"
        CASE 23
            t$ = "= +͹ST"

        ' ===================================================================
        ' Put any custom-designed border styles after this point and before
        ' the CASE ELSE statement.
        ' ===================================================================

        CASE ELSE
            t$ = "            ST"
       END SELECT

    ' =======================================================================
    ' Check coordinates for validity, then draw box
    ' =======================================================================

   IF col1 <= (col2 - 2) AND row1 <= (row2 - 2) THEN
        BoxWidth = col2 - col1 + 1
        BoxHeight = row2 - row1 + 1
        LOCATE row1, col1
        COLOR fore, back
        PRINT LEFT$(t$, 1); STRING$(BoxWidth - 2, MID$(t$, 2, 1)); MID$(t$, 3, 1)
        LOCATE row2, col1
        PRINT MID$(t$, 7, 1); STRING$(BoxWidth - 2, MID$(t$, 8, 1)); MID$(t$, 9, 1);

        FOR a = row1 + 1 TO row1 + BoxHeight - 2
            LOCATE a, col1
            PRINT MID$(t$, 4, 1);

            IF fillFlag THEN
                PRINT STRING$(BoxWidth - 2, MID$(t$, 5, 1));
            ELSE
                LOCATE a, col1 + BoxWidth - 1
            END IF

            PRINT MID$(t$, 6, 1);
        NEXT a
        LOCATE row1 + 1, col1 + 1
    END IF

END SUB

'=================================
'utScroll SUBROUTINE
'       Input: row1, col1 = start row, column
'              row2, col2 = ending row and column
'                   Lines = number of lines to scroll
'                    attr = color for newly created blank lines
'
'     Returns: nothing
'
'=================================
SUB utScroll (row1, col1, row2, col2, Lines, attr)

' Make sure coordinates are in proper order
    IF row1 > row2 THEN
        SWAP row1, row2
    END IF
   
    IF col1 > col2 THEN
        SWAP col1, col2
    END IF

        DIM regs AS RegType

        IF Lines < 0 THEN
            regs.ax = 256 * 7 + (-Lines)
            regs.bx = 256 * attr
            regs.cx = 256 * (row1 - 1) + (col1 - 1)
            regs.dx = 256 * (row2 - 1) + (col2 - 1)
        ELSE
            regs.ax = 256 * 6 + Lines
            regs.bx = 256 * (attr MOD 8) * 16
            regs.cx = 256 * (row1 - 1) + (col1 - 1)
            regs.dx = 256 * (row2 - 1) + (col2 - 1)
        END IF

        INTERRUPT 16, regs, regs

END SUB

'=================================
'Strip LF and soft CR/LF SUBROUTINE
'       Input: InStr$ = string to process
'
'     Returns: nothing
'
'=================================
SUB utStrChr (InStr$)

   ii = INSTR(InStr$, CHR$(&HA))                 'LF char
   DO WHILE ii
      temp$ = LEFT$(InStr$, ii - 2)
      temp1$ = RIGHT$(InStr$, LEN(InStr$) - ii)
      InStr$ = temp$ + temp1$
     ii = INSTR(InStr$, CHR$(&HA))
   LOOP

   ii = INSTR(InStr$, CHR$(&H8D))                'Soft CR/LF
   DO WHILE ii
      temp$ = LEFT$(InStr$, ii - 2)
      temp1$ = RIGHT$(InStr$, LEN(InStr$) - ii)
      InStr$ = temp$ + CHR$(&HD) + temp1$
      ii = INSTR(InStr$, CHR$(&H8D))
   LOOP

END SUB

'=================================
'utWrpPrn SUBROUTINE
'Print text w/word wrapping
'       Input: row1, col1 = start row, column
'              row2, col2 = ending row and column
'                   text$ = string to print
'
'     Returns: nothing
'
'=================================
SUB utWrpPrn (text$, row1, col1, row2, col2)
   WindowCols = col2 - col1 + 1
   WindowRows = row2 - row1 + 1
   cursorRow = 1: cursorCol = 1
      
      tmp$ = ""
      a$ = text$
      WHILE LEN(a$) > 0
          length = WindowCols - cursorCol + 1
          LOCATE row1 + cursorRow - 1, col1 + cursorCol - 1

          IF length < LEN(a$) THEN
    x = length + 1
    b$ = " " + a$
    WHILE MID$(b$, x, 1) <> " "
        x = x - 1
    WEND
    x = x - 1

    IF x = 0 THEN
        PRINT LEFT$(a$, length);
        tmp$ = tmp$ + LEFT$(LEFT$(a$, length) + SPACE$(128), WindowCols)
        a$ = RIGHT$(a$, LEN(a$) - length)
    ELSE
        PRINT LEFT$(a$, x);
        tmp$ = tmp$ + LEFT$(LEFT$(a$, x) + SPACE$(128), WindowCols - 1)
        a$ = RIGHT$(a$, LEN(a$) - x)
    END IF

    x = 1
    b$ = a$ + " "
    WHILE MID$(b$, x, 1) = " "
        x = x + 1
    WEND

    IF x = LEN(b$) THEN
        a$ = ""
    ELSEIF x > 1 THEN
        a$ = RIGHT$(a$, LEN(a$) - x + 1)
        tmp$ = tmp$ + a$
    END IF
       
    cursorRow = cursorRow + 1
    cursorCol = 1
    IF cursorRow > WindowRows THEN
        CALL utScroll(row1, col1, row2, col2, 1, 0)
        cursorRow = WindowRows
    END IF
          ELSE

          PRINT LEFT$(a$, length);
          tmp$ = tmp$ + LEFT$(a$, length)

    IF printMode < 0 THEN
        cursorCol = cursorCol + LEN(a$)
        IF cursorCol > WindowCols THEN
            cursorCol = WindowCols + 1
        END IF
    ELSE
        cursorRow = cursorRow + 1
        cursorCol = cursorCol
        IF cursorRow > WindowRows THEN
            CALL utScroll(row1, col1, row2, col2, 1, 0)
            cursorRow = WindowRows
        END IF
    END IF
    a$ = ""
          END IF
      WEND
    text$ = tmp$
END SUB

