'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Binary Coded Decimal (BCD) functions.
'

 DEFINT A-Z

 DECLARE FUNCTION BCDtoNum& (BCD$)
 DECLARE FUNCTION NumToBCD$ (Num&)

FUNCTION BCDtoNum& (BCD$)

  'Converts up to a 4 character Binary Coded Decimal (BCD)
  'string into a number. The maximum number is 4,294,967,295.

  '--- process string into bytes
  IF LEN(BCD$) THEN Byte1# = ASC(MID$(BCD$, 1, 1))
  IF LEN(BCD$) > 1 THEN byte2# = ASC(MID$(BCD$, 2, 1))
  IF LEN(BCD$) > 2 THEN byte3# = ASC(MID$(BCD$, 3, 1))
  IF LEN(BCD$) > 3 THEN byte4# = ASC(MID$(BCD$, 4, 1))

  '--- add 'em up
  Num& = (byte4# * 16777216) + (byte3# * 65536) + (byte2# * 256) + Byte1#

  '--- assign the function
  BCDtoNum = Num&
 
END FUNCTION

FUNCTION NumToBCD$ (Num&)
 
   'Given four characters, the highest number possible is
   '4,294,967,295 - more than 4 BILLION! If you need more, then
   'add a Byte5# etc.
 
   '--- if number too big exit
   IF Num& > 4294967295# * 256# THEN
     NumToBCD = "overflow"
     EXIT FUNCTION
   END IF
 
   '--- process number
   BCDNum& = Num&
   byte4# = INT(BCDNum& / 16777216)
   BCDNum& = BCDNum& - byte4# * 16777216
   byte3# = INT(BCDNum& / 65536)
   BCDNum& = BCDNum& - byte3# * 65536
   byte2# = INT(BCDNum& / 256)
   BCDNum& = BCDNum& - byte2# * 256
   Byte1# = BCDNum&
 
   'set size of field
   IF byte4# > 0 THEN Size = 1
   IF byte3# > 0 THEN Size = Size + 1
   IF byte2# > 0 THEN Size = Size + 1
   IF Byte1# > 0 THEN Size = Size + 1
 
   'setup a buffer to use
   type$ = STRING$(Size, 0)

   'convert to ascii
   IF Byte1# > 0 THEN MID$(type$, 1, 1) = CHR$(Byte1#)
   IF byte2# > 0 THEN MID$(type$, 2, 1) = CHR$(byte2#)
   IF byte3# > 0 THEN MID$(type$, 3, 1) = CHR$(byte3#)
   IF byte4# > 0 THEN MID$(type$, 4, 1) = CHR$(byte4#)

   'assign function
   NumToBCD = type$
 
END FUNCTION

