'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'QuickBASIC 4.X and PDS 7.X compatible dBASE file manipulation routines.
'
'NOTE: BASIC COMPILER 7.X users -- change VARSEG to SSEG.
'      QuickBASIC 4.X users     -- no modifications needed.
'
'
'LICENSE AGREEMENT
'-----------------
'You cannot sell or distribute this source code as raw source code or
'object code. You may sell programs which contain compiled routines which
'use these routines.
'
'
'INTRODUCTION
'------------
'DBASFUNC contains routines which let you read, write, create and manage
'dBASE III, III+ and IV database files.
'
'
'BASIC 7.X USERS
'---------------
'DBASFUNC fully supports BASIC COMPILER 7.X and the use of FAR STRINGS
'as well as QuickBASIC 4.X and the use of NEAR STRINGS. To make this
'library compatiable with BASIC 7.X, a modification is needed of some
'CALL Interrupt routines. You will need to change all occurances of
'Regs.?? = VARSEG(item$) Regs.?? = SSEG(Item$). Regs.?? is usually
'Regs.DS but may be something else; Item$ is any string being processed.
'QuickBASIC 4.X users require no modification. Search for VARSEG
'
'
'REVISION & REVISION HISTORY
'---------------------------
'DBASFUNC.BAS, version 1.0, written 8/90.
'DBASFUNC.BAS, version 2.0, updated 03/30/91.
'
' 02/02/91, added auto-dimension for Flds() type, ver. 1.1
' 03/01/91, added DeleteREC & UndeleteREC, ver. 1.2
' 03/02/91, fixed loss of Fld() info bug, ver. 1.3
' 03/30/91, rewrite to use DOS vs. BASIC calls, ver. 2.0
' 03/32/91, added support for MBError(), ver. 2.1
' 04/06/91, added support for QBX & BASIC 7.X, ver. 2.2
'
'
'WHATS NEW IN VERSION 2.X
'------------------------
'A lot! All routines have been re-written using MAXBASIC FILEFUNC routines
'which eliminate then need for BASIC ON ERROR & won't crash if file number
'is bad. Use of FILFUNC also makes programs smaller & faster than BASIC.
'I also re-wrote all the disk access routines and optimized them for speed
'and they are now much faster than before. I also added the ability to
'support more than one open DBF at a time. Finally, by using MAXBASIC
'FILFUNC routines, I leave open the possibility of Local Area Network
'functionality. MAXBASIC LANFUNC routines also use FILEFUNC calls...so
'porting DBASFUNC to operate in a LAN is a straight-forware process. Simply
'change all SeekWrite calls to SeekWriteLAN, SeekRead to SeekReadLAN,
'SeekFile to SeekLAN, WriteFile to WriteLAN, ReadFile to ReadLAN and then
'LINK to the LANFUNC routines and you now have a LAN capable dBASE
'engine! DBASFUNC routines now set the MBError() routine so you can use
'the MAXBASIC error handler routines. Lastly, all MAXBASIC routines have
'been modified to support BASIC COMPILER 7.X and the QBX environment.
'All in all, modifictions worthy of a new release!
'
'To get the LAN library mentioned, contact Marquis Computing.
'
'
'NOTES & COMMENTS
'----------------
'There are many subs and functions included in this MAXBASIC library. Many
'of them are not really meant to be called by you or your programs directly
'even though you may indeed call them. The rest are pretty special and you
'probably don't need them. However, other DBASFUNC LIB routines call them
'often in the pursuit of thier operations so DO NOT modify anything! All
'are commented so you can see how they work.
'
'NOTE: This version does not support index or memo files. It only
'      supports creating, reading and writing DBF files. I have included
'      some general purpose DBF record and field searching routines to
'      help in place of using index files.
'
'NOTE: This version (2.X) more than one DBF may be open at a time.
'      To do this I added a CheckFields call at the top of every routine
'      to load this DBF definition. This makes each call a bit slower
'      but does support multiple DBFs in QB. I almost used PDS TYPE
'      with an array element (illegal in QB but OK in PDS), but then
'      decided to go this way for QB users. This makes the routines
'      a bit slower -- you can disable this feature by REMing out all
'      of the CheckFields calls in all the modules except the OpenDBF
'      call if you plan to use only one DBF at a time.
'
'NOTE: This version supports dBASE III, III+ and IV -- as long as NO
'      specific functions of dBASE IV are used (like the floating point
'      record type, for example).
'

DEFINT A-Z

'--- open, create, check & load definition
DECLARE SUB OpenDBF (File$, FileNum)    'opens a DBF file for processing
DECLARE SUB CloseDBF (FileNum)          'closes a DBF
DECLARE SUB CheckFields (File)          'returns a DBFs definition
DECLARE SUB CreateDBF (DBFName$, Mode)  'creates a new DBF
DECLARE FUNCTION DBFVer$ (File)         'returns the DBF version number

'--- manage DBF records and fields
DECLARE SUB PutRec (File, Record&, Record$)     'writes a record to DBF
DECLARE SUB PutField (File, Rec$, Fld, FData$)  'writes a field to a record
DECLARE SUB GetRec (File, Record&, Record$)     'gets a record from DBF
DECLARE SUB GetField (File, Recd$, Fld, FData$) 'gets a field from a record
DECLARE SUB FldInfo (File, FldNum, FldName$)    'returns info about a field
DECLARE SUB PackDBF (filename$)                 'removes deleted records
DECLARE SUB ZAP (filename$)                     'erases all records
DECLARE SUB DeleteREC (File, Record&)           'marks a record deleted
DECLARE SUB UnDeleteREC (File, Record&)         'marks a record as normal

'--- used to find specific data in DBF
DECLARE SUB SearchDBF (F, D$, Rec&, SRec$)       'searches DBF for a string
DECLARE SUB SearchFLD (F, D$, Fld, Rec&, FData$) 'searches field for a string

'--- seldom called routines (usually)
DECLARE SUB GetUpdate (File, update$, dbdate$)  'gets date from header
DECLARE SUB GetNumrecs (File, TotalRecs&)       'gets record count from DBF

'--- you probably won't use these, but the program does!
DECLARE SUB GetMemoPtr (File, Ptr)       'if this DBF has a DBT
DECLARE SUB GetRecSize (File, RecSize)   'record size for DBF
DECLARE SUB GetHeadSize (File, HeadSize) 'header size of DBF
DECLARE SUB StampRecord (File, Records&) 'sets record count into header
DECLARE SUB StampDate (File)             'sets date into header

'-- general routines
DECLARE FUNCTION Exist (filename$)

   '--- DBF type & declarations
   'NOTE: You need to include this include file in EVERY module (or program)
   '      that will use these routines!
   '$INCLUDE: 'DBFUNC.BI'
 
   '--- init Fld
   DIM Fld(0 TO 1) AS FldInfo
 
   '--- create a dbf
   CLS
  
   PRINT "This is a demo of CreateDBF. Press enter to make a dBIII+ database file."
   DBFName$ = "DBASFUNC.DBF"
   PRINT "Enter DBF file name [" + DBFName$ + "] :"
   LOCATE 2, 23 + LEN(DBFName$) + 3
   LINE INPUT DBF$
   IF DBF$ = "" THEN DBF$ = DBFName$ ELSE DBFName$ = DBF$

   IF Exist(DBFName$) THEN
     PRINT "Warning! "; DBFName$; " already exists!"
     PRINT "Do you want to OVERWRITE it? (y/n)"
     YN$ = UCASE$(INPUT$(1))
   END IF

     IF YN$ = "Y" OR NOT Exist(DBFName$) THEN
      
        'create mode 1 = overwrite, 0=don't
        Mode = 1

        'set number of total fields to 4
        REDIM Fld(4) AS FldInfo

        'define 4 fields for our database
        Fld(1).FName = "customer"
        Fld(1).FType = "C"
        Fld(1).FLen = 20

        Fld(2).FName = "Firstname"
        Fld(2).FType = "C"
        Fld(2).FLen = 20

        Fld(3).FName = "Age"         'this one is a numeric field
        Fld(3).FType = "N"           'use N for Numeric
        Fld(3).FLen = 3              'width (0 to 999)
        Fld(3).Decimal = 0           'no decimal places but < Len-2

        Fld(4).FName = "Product"
        Fld(4).FType = "C"
        Fld(4).FLen = 15
        
        '---make a DBF
        CreateDBF DBFName$, Mode     'do it

     END IF
  
 
   '-------------------------------------------------------
   ' open up a dbf
   DO
   
     PRINT "This is a demo of OpenDBF. Press enter the open the database just entered."
     PRINT "Enter DBF file name [" + DBFName$ + "] :"
     LOCATE CSRLIN - 1, 23 + LEN(DBFName$) + 3
     LINE INPUT DBF$
     IF DBF$ = "" THEN DBF$ = DBFName$

     DBF$ = UCASE$(DBF$)
     IF INSTR(DBF$, ".DBF") THEN
       'open the DBF file
       OpenDBF DBF$, FileNum
     END IF
    
     IF FileNum < 1 THEN
       PRINT "File not found. Press a key to continue..."
       BEEP
       SLEEP
     END IF
  
   LOOP UNTIL FileNum > 0
  
   '-------------------------------------------------
   PRINT "This is a demo of CheckDBF...there are";
   PRINT Fld(0).Decimal; "fields in this DBF"
   PRINT "Number  Name     Type   Length"
   PRINT "------------------------------"
   N$ = SPACE$(3)
 
   FOR X = 1 TO Fld(0).Decimal
     LSET N$ = STR$(X)
     PRINT N$; "   "; Fld(X).FName; Fld(X).FType; "     "; Fld(X).FLen
     IF X = 20 THEN
        PRINT "Press a key to continue...";
        PRINT
        PRINT "Number  Name     Type   Length"
        PRINT "----------------------------"
     END IF
   NEXT
 
   PRINT "Add data to records? (y/n)";
   YN$ = UCASE$(INPUT$(1))
   IF YN$ = "Y" THEN  'if opened as new file

     '---------------------------------------------------------
     'to WRITE to dbf
     PRINT
     PRINT "This is a demo of PutREC and PutFLD."
     PRINT "(appending 10 blank records and adding some field data...)"
     GetRecSize FileNum, RecSize
     Record$ = SPACE$(RecSize)                 'make a 'blank' record
   
     '---jam out 10 records
     FOR X = 1 TO 10
       PutRec FileNum, 0, Record$
     NEXT

     '---add new records to the end of the DBF. set Record&=0 to
     '   add a new record.
     Record& = 0                               '0 means append as new record
     Fld = 1                                   'field number
     FldData$ = "Appended Record"              'data for field
     PutField FileNum, Record$, Fld, FldData$  'save field into record
     PutRec FileNum, Record&, Record$          'save record into DBF

     '---edit existing records in the DBF. Set Record&=any record you
     '   wish to modify or work on.
     Record& = 1
     GetRec FileNum, Record&, Record$           'get record 1
   
     Fld = 1                                    'field number
     FldData$ = "Marquis"                       'data for field
     PutField FileNum, Record$, Fld, FldData$   'do it
   
     Fld = 2                                    'field number
     FldData$ = "Hank"                          'data for field
     PutField FileNum, Record$, Fld, FldData$   'do it
   
     Fld = 3                                    'field number
     FldData$ = "31"                            'data for field
     PutField FileNum, Record$, Fld, FldData$   'do it
   
     Fld = 4                                    'field number
     FldData$ = "soap"                          'data for field
     PutField FileNum, Record$, Fld, FldData$   'do it
 
     '---un rem these to save any changes to the DBF
     '   save record (and field)
     PutRec FileNum, Record&, Record$
 
   END IF
 
   '-------------------------------------------------
   PRINT
   PRINT "This is a demo of FldInfo...";
   FldNum = 2
   FldName$ = ""
   FldInfo FileNum, FldNum, FldName$
   PRINT "Field"; FldNum; "is named "; FldName$
 
   PRINT "This is a demo of FldInfo...";
   FldNum = 0
   FldName$ = "product"
   FldInfo FileNum, FldNum, FldName$
   PRINT "Field name "; FldName$; " is field"; FldNum
  
   '-------------------------------------------------
   'if created a database then do this
   PRINT "This is a demo of SearchDBF...";
   SearchData$ = "soap"
   SearchDBF FileNum, SearchData$, Record&, Record$
   PRINT "record"; Record&; "holds ["; SearchData$; "] "
 
   '-------------------------------------------------
   'if created a database then do this
   PRINT "This is a demo of SearchFLD...";
   SearchData$ = "31"
   FldNum = 2
   SearchFLD FileNum, SearchData$, FldNum, RecNum&, FldData$
   PRINT "record"; RecNum&; "field"; FldNum; "holds ["; SearchData$; "]"
 
   '-------------------------------------------------
   PRINT "This is a demo of GetField...";
 
   '--get 1st record
   Record& = 1
   GetRec FileNum, Record&, Record$
  
   '---get contents of field #3
   Fld = 2
   GetField FileNum, Record$, Fld, FldData$
   PRINT "Field no."; Fld; "of record no."; Record&; "is ["; FldData$; "]"
   
     '-------------------------------------------------------
     ver$ = DBFVer$(FileNum)
     PRINT "This is a demo of DBFVer$...";
     SELECT CASE ver$
     CASE "UNK"
       PRINT "WARNING : File is of undeterminable type."
       BEEP
     CASE ELSE
       PRINT "File is a dBASE "; ver$; " type."
     END SELECT
  
     '-------------------------------------------------------
     PRINT "This is a demo of GetMemoPtr...";

     GetMemoPtr FileNum, DBT
    
     SELECT CASE DBT
     CASE 0
       PRINT "Header shows no memo file."
     CASE 1
       PRINT "Header shows memo file."
     CASE ELSE
       PRINT "WARNING : File has invalid DBT pointer."
       BEEP
     END SELECT
   
     '-------------------------------------------------------
     PRINT "This is a demo of GetUpdate...";
     GetUpdate FileNum, update$, dbdate$
     PRINT "Header shows last update as "; dbdate$; "."
   
     '-------------------------------------------------------
     PRINT "This is a demo of GetRecSize...";
     GetRecSize FileNum, RecSize
     PRINT "Header shows record size of"; STR$(RecSize); "."

     '-------------------------------------------------------
     PRINT "This is a demo of GetNumRecs...";
     GetNumrecs FileNum, HRecs&
     PRINT "Header shows"; HRecs&; "records."
  
     '-------------------------------------------------------
     PRINT "This is a demo of GetHeadSize...";
     GetHeadSize FileNum, HeadSize
     PRINT "Header shows header size of"; STR$(HeadSize); "."
  
     '-------------------------------------------------------
     PRINT "This is a demo of CheckFields...";
     CheckFields FileNum
   
     IF Fld(0).Decimal = -1 THEN
       PRINT "WARNING : File has invalid field descriptor(s)."
     ELSE
       PRINT "Header shows"; Fld(0).Decimal; "fields."
     END IF
   
     '-------------------------------------------------------
     PRINT
     PRINT "This is a demo of GetRec"

     Record& = 1        'first
     GetRec FileNum, Record&, Record$
     PRINT TAB(5); "First record : "; LEFT$(Record$, 50)
   
     Record& = HRecs&  'last
     GetRec FileNum, Record&, Record$
     PRINT TAB(5); "Last record  : "; LEFT$(Record$, 50)
 
     '-----------------------
     'This shows using DeleteREC
     PRINT
     PRINT "Delete record #1? (y/n)"
     YN$ = UCASE$(INPUT$(1))
     IF YN$ = "Y" THEN
       PRINT : PRINT "This is a demo of DeleteRec . . . marking record 1 as deleted"
       DeleteREC FileNum, 1         'unlike PackDBF, you can ONLY delete
       DeleteREC FileNum, 2         'records from an OPEN DBF.
       Record& = 1        'first
       GetRec FileNum, Record&, Record$
       PRINT TAB(5); "First record : "; LEFT$(Record$, 50)
     END IF
   
     '-----------------------
     'This shows using UnDeleteREC
     PRINT
     PRINT "Un-Delete record#1? (y/n)";
     YN$ = UCASE$(INPUT$(1))
     IF YN$ = "Y" THEN
       PRINT "This is a demo of UnDeleteRec . . . marking record 1 as un-deleted"
       UnDeleteREC FileNum, 1         'unlike PackDBF, you can ONLY delete
       Record& = 1        'first
       GetRec FileNum, Record&, Record$
       PRINT TAB(5); "First record : "; LEFT$(Record$, 50)
     END IF
   
     '-----------------------
     'This shows using PackDBF
     PRINT
     PRINT "Pack "; DBFName$; "(y/n)";
     YN$ = UCASE$(INPUT$(1))
     IF YN$ = "Y" THEN
       PRINT : PRINT "This is a demo of PackDBF . . . packing "; DBFName$
       CloseDBF FileNum            'the database to PACK must be CLOSED first
       PackDBF DBFName$            'call pack
     END IF
   
     '---------------------------------------------------------
     'button up the DBF & exit
     CloseDBF FileNum

