'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Renames a file using DOS calls: replaces QuickBASIC NAME AS routine.
'
'NOTE: BASIC COMPILER 7.X users -- change VARSEG to SSEG.
'      QuickBASIC 4.X users     -- no modifications needed.
'

DEFINT A-Z

TYPE RegTypeX
  AX AS INTEGER
  BX AS INTEGER
  CX AS INTEGER
  DX AS INTEGER
  BP AS INTEGER
  SI AS INTEGER
  DI AS INTEGER
  Flags AS INTEGER
  DS AS INTEGER
  ES AS INTEGER
END TYPE

DECLARE SUB InterruptX (IntNum, InRegsX AS RegTypeX, OutRegsX AS RegTypeX)
DECLARE SUB SetMAXError (ErrNum)
DECLARE SUB NameFile (OldName$, NewName$)
DECLARE FUNCTION CheckDrive (Drive$)
       
        'NameFile "BROWSE.EXE", "HANK.EXE"

SUB NameFile (OldName$, NewName$)
  
   '
   'Renames OldName$ to NewName$. Can also move a file to another
   'directory. Cannot move across disks -- use MoveFile to move across
   'disks. Functional equivalent to BASIC NAME function. But, as uses
   'DOS, does not crash BASIC thus allowing use of MAXBASIC error handler
   'instead of ON ERROR.
   '
   'Sets MAXError to error if error occurs.
   '
   '--- check drive first
   Drive1 = CheckDrive(NewName$)                     'check drive 1
   Drive2 = CheckDrive(OldName$)                     'check drive 2
  
   IF Drive1 AND Drive2 THEN                         'if both ok
       
        Status = 0                                   'assume sucess
       
        '--- DOS type
        DIM Regs  AS RegTypeX                        'DOS type
       
        '--- fixup file names
        NF$ = NewName$ + CHR$(0)                     'ASCIIZ new file
        OF$ = OldName$ + CHR$(0)                     'ASCIIZ old file
       
        '--- if open file do it
        Regs.AX = &H5600                             'DOS rename file
        Regs.DX = SADD(OF$)                          'offset old file name
        Regs.DS = VARSEG(OF$)                        'segment old file name
        Regs.DI = SADD(NF$)                          'offset new file name
        Regs.ES = VARSEG(NF$)                        'segment new file name
        InterruptX &H21, Regs, Regs                  'rename file
       
        '--- error handler
        IF Regs.Flags AND 1 THEN Status = Regs.AX    'errors?
   ELSE
        Status = &H15                                'drive not ready
   END IF
  
   '--- error handler
   SetMAXError Status                           'set error

END SUB

