'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Creates a file using DOS calls.
'
'NOTE: BASIC COMPILER 7.X users -- change VARSEG to SSEG.
'      QuickBASIC 4.X users     -- no modifications needed.
'

DEFINT A-Z

TYPE RegTypeX
  AX AS INTEGER
  BX AS INTEGER
  CX AS INTEGER
  DX AS INTEGER
  BP AS INTEGER
  SI AS INTEGER
  DI AS INTEGER
  Flags AS INTEGER
  DS AS INTEGER
  ES AS INTEGER
END TYPE

DECLARE SUB InterruptX (IntNum, InRegsX AS RegTypeX, OutRegsX AS RegTypeX)
DECLARE SUB SetMAXError (ErrNum)
DECLARE FUNCTION CheckDrive (Drive$)

SUB CreateFile (filename$, FileHandle)

        '
        'Creates and opens the file 'filename$' returning filehandle which
        'must be used on ALL subsequent access to this file. Uses
        'CheckDrive() function to insure drive is ready.
        '
          
        '--- make sure drive is ready so DOS dosen't hang
        IF NOT CheckDrive(filename$) THEN EXIT SUB
       
        '--- DOS type
        DIM Regs  AS RegTypeX
        Status = 0                   'assume sucess
  
        '--- ASCIIZ file name
        F$ = filename$ + CHR$(0)     'ASCIIZ file name

        '--- create & open file
        Regs.AX = &H3C00             'Create file function
        Regs.CX = 0                  'open normal
        Regs.DX = SADD(F$)           'offset of file
        Regs.DS = VARSEG(F$)         'segment of file
        InterruptX &H21, Regs, Regs  'create & open file
       
        '--- assign handle
        IF Regs.Flags AND 1 THEN      'error occured
           Status = Regs.AX           'set error code
           FileHandle = 0             'handle=0
        ELSE                          'no errors
           FileHandle = Regs.AX       'assign handle  
           Status = 0                 'no error
        END IF
       
        '--- assign error
        SetMAXError Status           'set error

END SUB

