'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Error handler: small code segment; returns english message.
'

DEFINT A-Z

COMMON SHARED /MAXBASICERRORHANDLER/ ErrorStatus

DECLARE FUNCTION MAXErrorMsg$ ()

FUNCTION MAXErrorMsg$
      
        '
        'This function returns an english error message based on the
        'last call to SetMAXError. This take about 8K of string space
        'away from you as well as add about 8K of size to your EXE. You
        'don't need to use this to get an error, you can just use _SMALLER
        'and MBError() which add only about 800 bytes and use no string
        'memory.
        '
        'The MBError() function sets the error status value, call it FIRST
        'to determine if an error has occured, THEN call this function to
        'get an english description of the last error.
        '
        'NOTE: This is NOT for BASIC errors - in fact, it is for errors
        '      returned from using the Interrupt &H21 ONLY (which is most
        '      of the advanced MAXBASIC routines) or Errors set using the
        '      SetMAXError routine.
        '
        'NOTE: DO NOT REMOVE ANY OF THESE THREE ROUTINES -- THEY CALL
        '      EACH OTHER. KEEP THEM IN THE SAME MODULE.
        '
        'NOTE: You may edit the result codes, adding or deleting them as
        '      your programs need.
       
        '---see what error occured

        'General failure messages from all MAXBASIC routines which support
        'MBError() -- which is all of them starting with version 2.X
        'routines and some of them from version 1.X routines.
       
        SELECT CASE ErrorStatus
          CASE &H1
            ErrMsg$ = "invalid function"
          CASE &H2
            ErrMsg$ = "file not found"
          CASE &H3
            ErrMsg$ = "path not found"
          CASE &H4
            ErrMsg$ = "too many open files"
          CASE &H8
            ErrMsg$ = "insufficient memory"
          CASE &HF
            ErrMsg$ = "disk drive invalid"
          CASE &H10
            ErrMsg$ = "can't remove current directory"
          CASE &H12
            ErrMsg$ = "no more files"
          CASE &H13
            ErrMsg$ = "disk is write protected"
          CASE &H15
            ErrMsg$ = "disk not ready"
          CASE &H19
            ErrMsg$ = "seek error"
          CASE &H1A
            ErrMsg$ = "unknown media type"
          CASE &H1B
            ErrMsg$ = "sector not found"
          CASE &H1C
            ErrMsg$ = "printer out of paper"
          CASE &H1D
            ErrMsg$ = "write fault"
          CASE &H1E
            ErrMsg$ = "read fault"
          CASE &H1F
            ErrMsg$ = "general failure"
          CASE &H50
            ErrMsg$ = "file already exists"
          CASE &H52
            ErrMsg$ = "can't make subdirectory"
          CASE 100
            ErrMsg$ = "invalid file handle"    'added by HM
       
        'LAN errors, these are returned only under DOS 3.3 & greater and
        'then only with share loaded. Use the ShareLoaded routine to
        'make sure that SHARE is loaded before using the LANFUNC routines.
        'REM these out if you do not have the MAXBASIC LANFUNC.BAS Local
        'Area Network library.

          CASE &H5
            ErrMsg$ = "access denied"
          CASE &H20
            ErrMsg$ = "sharing violation"
          CASE &H21
            ErrMsg$ = "lock violation"
          CASE &H24
            ErrMsg$ = "sharing buffer exceeded"
          CASE &H32
            ErrMsg$ = "unsupported network request"
          CASE &H33
            ErrMsg$ = "remote machine not listening"
          CASE &H34
            ErrMsg$ = "duplicate name on network"
          CASE &H35
            ErrMsg$ = "network name not found"
          CASE &H36
            ErrMsg$ = "network busy"
          CASE &H37
            ErrMsg$ = "device no longer exists on network"
          CASE &H38
            ErrMsg$ = "netBIOS command limit exceeded"
          CASE &H39
            ErrMsg$ = "error in network adapter hardware"
          CASE &H3A
            ErrMsg$ = "incorrect response from network"
          CASE &H3B
            ErrMsg$ = "unexpected network error"
          CASE &H3C
            ErrMsg$ = "remote adapter incompatible"
          CASE &H40
            ErrMsg$ = "network name deleted"
          CASE &H41
            ErrMsg$ = "network access denied"
          CASE &H42
            ErrMsg$ = "incorrect network device type"
          CASE &H43
            ErrMsg$ = "network name not found"
          CASE &H44
            ErrMsg$ = "network name limit exceeded"
          CASE &H45
            ErrMsg$ = "netBIOS session limit exceeded"
          CASE &H46
            ErrMsg$ = "file sharing temporarily paused"
          CASE &H47
            ErrMsg$ = "network request not accepted"
          CASE &H48
            ErrMsg$ = "print or disk redirection paused"
          CASE &H54
            ErrMsg$ = "to many redirections"
          CASE &H55
            ErrMsg$ = "duplicate redirection"
          CASE &H56
            ErrMsg$ = "invalid password"
          CASE &H57
            ErrMsg$ = "invalid paramater"
          CASE &H58
            ErrMsg$ = "network device fault"
          CASE &H59
            ErrMsg$ = "function not supported by network"
          CASE &H5A
            ErrMsg$ = "required system component not installed"
          CASE 999
            ErrMsg$ = "SHARE not loaded"    'added by HM

       'Start of user defined error events. Add YOUR error numbers and
       'english description here. Start at 1000. This allows you to have
       'a custom error handler of your own.

          '---your program error messages
          CASE 1000 TO 2000
            ErrMsg$ = "user defined error"
      
       'Start of DBASFUNC error messages. REM them out if you do not have
       'DBASFUNC modules.

          '---DBASFUNC LIB error messages
          CASE 3000
            ErrMsg$ = "end of database file"
          CASE 3001
            ErrMsg$ = "invalid database size"
          CASE 3002
            ErrMsg$ = "file is not a valid DBF file"
          CASE 3003
            ErrMsg$ = "invalid record size"
        
       'Any other error not trapped above. Simply returns unknown error
       'and the error number.
      
         CASE IS <> 0
            ErrMsg$ = "error :" + LTRIM$(STR$(ErrorStatus)) + ", unknown error."

        END SELECT
      
        '--- assign function
        MAXErrorMsg$ = ErrMsg$

END FUNCTION

